/*     */ package org.jboss.aop;
/*     */ 
/*     */ import java.io.Serializable;
/*     */ import java.lang.ref.WeakReference;
/*     */ import java.util.ArrayList;
/*     */ import java.util.Arrays;
/*     */ import java.util.Iterator;
/*     */ import java.util.Map;
/*     */ import org.jboss.aop.advice.AdviceStack;
/*     */ import org.jboss.aop.advice.AdviceType;
/*     */ import org.jboss.aop.advice.AspectDefinition;
/*     */ import org.jboss.aop.advice.GeneratedAdvisorInterceptor;
/*     */ import org.jboss.aop.advice.Interceptor;
/*     */ import org.jboss.aop.advice.InterceptorFactory;
/*     */ import org.jboss.aop.joinpoint.Joinpoint;
/*     */ import org.jboss.aop.metadata.SimpleMetaData;
/*     */ 
/*     */ public class GeneratedInstanceAdvisorMixin
/*     */   implements InstanceAdvisor, Serializable
/*     */ {
/*     */   static final long serialVersionUID = -3057976129116723527L;
/*  49 */   protected ArrayList insertedInterceptors = null;
/*  50 */   protected ArrayList appendedInterceptors = null;
/*     */   protected WeakReference instanceRef;
/*  52 */   public boolean hasInstanceAspects = false;
/*     */   private InterceptorChainObserver interceptorChainObserver;
/*     */   InstanceAdvisorDelegate delegate;
/*     */ 
/*     */   public GeneratedInstanceAdvisorMixin()
/*     */   {
/*     */   }
/*     */ 
/*     */   public GeneratedInstanceAdvisorMixin(Object instance, GeneratedClassAdvisor genadvisor)
/*     */   {
/*  62 */     this.instanceRef = new WeakReference(instance);
/*  63 */     this.delegate = new InstanceAdvisorDelegate(genadvisor, this);
/*  64 */     this.delegate.initialize();
/*  65 */     this.interceptorChainObserver = genadvisor.getInterceptorChainObserver();
/*     */   }
/*     */ 
/*     */   public boolean hasInterceptors()
/*     */   {
/*  70 */     return (this.appendedInterceptors != null) || (this.insertedInterceptors != null);
/*     */   }
/*     */ 
/*     */   public Object getPerInstanceAspect(String def)
/*     */   {
/*  75 */     return this.delegate.getPerInstanceAspect(def);
/*     */   }
/*     */ 
/*     */   public Object getPerInstanceAspect(AspectDefinition def)
/*     */   {
/*  80 */     return this.delegate.getPerInstanceAspect(def);
/*     */   }
/*     */ 
/*     */   public Object getPerInstanceJoinpointAspect(Joinpoint joinpoint, AspectDefinition def)
/*     */   {
/*  85 */     return this.delegate.getPerInstanceJoinpointAspect(joinpoint, def);
/*     */   }
/*     */ 
/*     */   public SimpleMetaData getMetaData()
/*     */   {
/*  90 */     return this.delegate.getMetaData();
/*     */   }
/*     */ 
/*     */   public Interceptor[] getInterceptors()
/*     */   {
/*  95 */     ArrayList newlist = new ArrayList();
/*     */     Iterator it;
/*  96 */     if (this.insertedInterceptors != null)
/*     */     {
/*  98 */       for (it = this.insertedInterceptors.iterator(); it.hasNext(); )
/*     */       {
/* 100 */         newlist.add(((GeneratedAdvisorInterceptor)it.next()).create(null, null));
/*     */       }
/*     */     }
/*     */     Iterator it;
/* 103 */     if (this.appendedInterceptors != null)
/*     */     {
/* 105 */       for (it = this.appendedInterceptors.iterator(); it.hasNext(); )
/*     */       {
/* 107 */         newlist.add(((GeneratedAdvisorInterceptor)it.next()).create(null, null));
/*     */       }
/*     */     }
/* 110 */     return (Interceptor[])(Interceptor[])newlist.toArray(new Interceptor[newlist.size()]);
/*     */   }
/*     */ 
/*     */   public Interceptor[] getInterceptors(Interceptor[] advisorChain)
/*     */   {
/* 118 */     if ((this.insertedInterceptors == null) && (this.appendedInterceptors == null)) return advisorChain;
/* 119 */     ArrayList newlist = new ArrayList();
/*     */     Iterator it;
/* 120 */     if (this.insertedInterceptors != null)
/*     */     {
/* 122 */       for (it = this.insertedInterceptors.iterator(); it.hasNext(); )
/*     */       {
/* 124 */         newlist.add(((GeneratedAdvisorInterceptor)it.next()).create(null, null));
/*     */       }
/*     */     }
/* 127 */     if (advisorChain != null)
/*     */     {
/* 129 */       newlist.addAll(Arrays.asList(advisorChain));
/*     */     }
/*     */     Iterator it;
/* 131 */     if (this.appendedInterceptors != null)
/*     */     {
/* 133 */       for (it = this.appendedInterceptors.iterator(); it.hasNext(); )
/*     */       {
/* 135 */         newlist.add(((GeneratedAdvisorInterceptor)it.next()).create(null, null));
/*     */       }
/*     */     }
/* 138 */     return (Interceptor[])(Interceptor[])newlist.toArray(new Interceptor[newlist.size()]);
/*     */   }
/*     */ 
/*     */   public GeneratedAdvisorInterceptor[] getWrappers()
/*     */   {
/* 143 */     ArrayList newlist = new ArrayList();
/* 144 */     if (this.insertedInterceptors != null) newlist.addAll(this.insertedInterceptors);
/* 145 */     if (this.appendedInterceptors != null) newlist.addAll(this.appendedInterceptors);
/* 146 */     return (GeneratedAdvisorInterceptor[])(GeneratedAdvisorInterceptor[])newlist.toArray(new GeneratedAdvisorInterceptor[newlist.size()]);
/*     */   }
/*     */ 
/*     */   public Interceptor[] getWrappers(Interceptor[] advisorChain)
/*     */   {
/* 156 */     if ((this.insertedInterceptors == null) && (this.appendedInterceptors == null)) return advisorChain;
/* 157 */     ArrayList newlist = new ArrayList();
/* 158 */     if (this.insertedInterceptors != null) newlist.addAll(this.insertedInterceptors);
/* 159 */     if (advisorChain != null)
/*     */     {
/* 161 */       newlist.addAll(Arrays.asList(advisorChain));
/*     */     }
/* 163 */     if (this.appendedInterceptors != null) newlist.addAll(this.appendedInterceptors);
/* 164 */     return (GeneratedAdvisorInterceptor[])(GeneratedAdvisorInterceptor[])newlist.toArray(new GeneratedAdvisorInterceptor[newlist.size()]);
/*     */   }
/*     */ 
/*     */   public void insertInterceptor(int index, Interceptor interceptor)
/*     */   {
/* 169 */     ArrayList newList = new ArrayList();
/* 170 */     if (this.insertedInterceptors != null)
/*     */     {
/* 172 */       newList.addAll(this.insertedInterceptors);
/*     */     }
/* 174 */     newList.add(index, createWrapper(interceptor));
/* 175 */     this.insertedInterceptors = newList;
/* 176 */     this.hasInstanceAspects = true;
/* 177 */     if (this.interceptorChainObserver != null)
/*     */     {
/* 179 */       this.interceptorChainObserver.instanceInterceptorAdded(this);
/*     */     }
/*     */   }
/*     */ 
/*     */   public void insertInterceptor(Interceptor interceptor)
/*     */   {
/* 185 */     ArrayList newList = new ArrayList();
/* 186 */     if (this.insertedInterceptors != null)
/*     */     {
/* 188 */       newList.addAll(this.insertedInterceptors);
/*     */     }
/* 190 */     newList.add(createWrapper(interceptor));
/* 191 */     this.insertedInterceptors = newList;
/* 192 */     this.hasInstanceAspects = true;
/* 193 */     if (this.interceptorChainObserver != null)
/*     */     {
/* 195 */       this.interceptorChainObserver.instanceInterceptorAdded(this);
/*     */     }
/*     */   }
/*     */ 
/*     */   public void appendInterceptor(Interceptor interceptor)
/*     */   {
/* 201 */     ArrayList newList = new ArrayList();
/* 202 */     if (this.appendedInterceptors != null)
/*     */     {
/* 204 */       newList.addAll(this.appendedInterceptors);
/*     */     }
/* 206 */     newList.add(createWrapper(interceptor));
/* 207 */     this.appendedInterceptors = newList;
/* 208 */     this.hasInstanceAspects = true;
/* 209 */     if (this.interceptorChainObserver != null)
/*     */     {
/* 211 */       this.interceptorChainObserver.instanceInterceptorAdded(this);
/*     */     }
/*     */   }
/*     */ 
/*     */   public void appendInterceptor(int index, Interceptor interceptor)
/*     */   {
/* 217 */     ArrayList newList = new ArrayList();
/* 218 */     if (this.appendedInterceptors != null)
/*     */     {
/* 220 */       newList.addAll(this.appendedInterceptors);
/*     */     }
/* 222 */     newList.add(index, createWrapper(interceptor));
/* 223 */     this.appendedInterceptors = newList;
/* 224 */     this.hasInstanceAspects = true;
/* 225 */     if (this.interceptorChainObserver != null)
/*     */     {
/* 227 */       this.interceptorChainObserver.instanceInterceptorAdded(this);
/*     */     }
/*     */   }
/*     */ 
/*     */   public void removeInterceptor(String name)
/*     */   {
/* 236 */     int interceptorsRemoved = internalRemoveInterceptor(name);
/* 237 */     if (this.interceptorChainObserver != null)
/*     */     {
/* 239 */       this.interceptorChainObserver.instanceInterceptorsRemoved(this, interceptorsRemoved);
/*     */     }
/*     */   }
/*     */ 
/*     */   private int internalRemoveInterceptor(String name)
/*     */   {
/* 249 */     int interceptorsRemoved = 0;
/* 250 */     if (this.insertedInterceptors != null)
/*     */     {
/* 252 */       for (int i = 0; i < this.insertedInterceptors.size(); i++)
/*     */       {
/* 254 */         GeneratedAdvisorInterceptor interceptor = (GeneratedAdvisorInterceptor)this.insertedInterceptors.get(i);
/* 255 */         if (!interceptor.getName().equals(name))
/*     */           continue;
/* 257 */         ArrayList newList = new ArrayList();
/* 258 */         newList.addAll(this.insertedInterceptors);
/* 259 */         newList.remove(i);
/* 260 */         this.insertedInterceptors = newList;
/* 261 */         interceptorsRemoved++;
/*     */       }
/*     */     }
/*     */ 
/* 265 */     if (this.appendedInterceptors != null)
/*     */     {
/* 267 */       for (int i = 0; i < this.appendedInterceptors.size(); i++)
/*     */       {
/* 269 */         GeneratedAdvisorInterceptor interceptor = (GeneratedAdvisorInterceptor)this.appendedInterceptors.get(i);
/* 270 */         if (!interceptor.getName().equals(name))
/*     */           continue;
/* 272 */         ArrayList newList = new ArrayList();
/* 273 */         newList.addAll(this.appendedInterceptors);
/* 274 */         newList.remove(i);
/* 275 */         this.appendedInterceptors = newList;
/* 276 */         interceptorsRemoved++;
/*     */       }
/*     */     }
/*     */ 
/* 280 */     this.hasInstanceAspects = (((this.insertedInterceptors != null) && (this.insertedInterceptors.size() > 0)) || ((this.appendedInterceptors != null) && (this.appendedInterceptors.size() > 0)));
/*     */ 
/* 282 */     return interceptorsRemoved;
/*     */   }
/*     */ 
/*     */   public final boolean hasAspects()
/*     */   {
/* 287 */     return this.hasInstanceAspects;
/*     */   }
/*     */ 
/*     */   public void insertInterceptorStack(String stackName)
/*     */   {
/* 292 */     AdviceStack stack = AspectManager.instance().getAdviceStack(stackName);
/* 293 */     if (stack == null) throw new RuntimeException("Stack " + stackName + " not found.");
/*     */ 
/* 295 */     ClassAdvisor classAdvisor = null;
/* 296 */     Object inst = getInstance();
/* 297 */     if ((inst instanceof Advised))
/*     */     {
/* 299 */       Advised advised = (Advised)inst;
/* 300 */       classAdvisor = (ClassAdvisor)advised._getAdvisor();
/*     */     }
/* 302 */     int interceptorsAdded = 0;
/* 303 */     Iterator it = stack.getInterceptorFactories().iterator();
/* 304 */     while (it.hasNext())
/*     */     {
/* 306 */       InterceptorFactory factory = (InterceptorFactory)it.next();
/* 307 */       if (factory.isDeployed()) {
/* 308 */         Interceptor interceptor = factory.create(classAdvisor, null);
/* 309 */         insertInterceptor(interceptor);
/* 310 */         interceptorsAdded++;
/*     */       }
/*     */     }
/* 312 */     if (this.interceptorChainObserver != null)
/*     */     {
/* 314 */       this.interceptorChainObserver.instanceInterceptorsAdded(this, interceptorsAdded);
/*     */     }
/*     */   }
/*     */ 
/*     */   public void appendInterceptorStack(String stackName)
/*     */   {
/* 320 */     AdviceStack stack = AspectManager.instance().getAdviceStack(stackName);
/* 321 */     if (stack == null) throw new RuntimeException("Stack " + stackName + " not found.");
/*     */ 
/* 323 */     ClassAdvisor classAdvisor = null;
/* 324 */     Object inst = getInstance();
/* 325 */     if ((inst instanceof Advised))
/*     */     {
/* 327 */       Advised advised = (Advised)inst;
/* 328 */       classAdvisor = (ClassAdvisor)advised._getAdvisor();
/*     */     }
/* 330 */     int interceptorsAdded = 0;
/* 331 */     Iterator it = stack.getInterceptorFactories().iterator();
/* 332 */     while (it.hasNext())
/*     */     {
/* 334 */       InterceptorFactory factory = (InterceptorFactory)it.next();
/* 335 */       if (factory.isDeployed()) {
/* 336 */         Interceptor interceptor = factory.create(classAdvisor, null);
/* 337 */         appendInterceptor(interceptor);
/* 338 */         interceptorsAdded++;
/*     */       }
/*     */     }
/* 340 */     if (this.interceptorChainObserver != null)
/*     */     {
/* 342 */       this.interceptorChainObserver.instanceInterceptorsAdded(this, interceptorsAdded);
/*     */     }
/*     */   }
/*     */ 
/*     */   public void removeInterceptorStack(String stackName)
/*     */   {
/* 348 */     AdviceStack stack = AspectManager.instance().getAdviceStack(stackName);
/* 349 */     if (stack == null) throw new RuntimeException("Stack " + stackName + " not found.");
/*     */ 
/* 351 */     ClassAdvisor classAdvisor = null;
/* 352 */     Object inst = getInstance();
/* 353 */     if ((inst instanceof Advised))
/*     */     {
/* 355 */       Advised advised = (Advised)inst;
/* 356 */       classAdvisor = (ClassAdvisor)advised._getAdvisor();
/*     */     }
/* 358 */     int interceptorsRemoved = 0;
/* 359 */     Iterator it = stack.getInterceptorFactories().iterator();
/* 360 */     while (it.hasNext())
/*     */     {
/* 362 */       InterceptorFactory factory = (InterceptorFactory)it.next();
/* 363 */       if (factory.isDeployed()) {
/* 364 */         Interceptor interceptor = factory.create(classAdvisor, null);
/* 365 */         interceptorsRemoved += internalRemoveInterceptor(interceptor.getName());
/*     */       }
/*     */     }
/* 367 */     if (this.interceptorChainObserver != null)
/*     */     {
/* 369 */       this.interceptorChainObserver.instanceInterceptorsRemoved(this, interceptorsRemoved);
/*     */     }
/*     */   }
/*     */ 
/*     */   public Domain getDomain()
/*     */   {
/* 375 */     throw new RuntimeException("Should be handled by generated advisors");
/*     */   }
/*     */ 
/*     */   protected void finalize()
/*     */   {
/* 383 */     ClassLoader classLoader = this.delegate.getAdvisor().getClazz().getClassLoader();
/* 384 */     if (this.interceptorChainObserver != null) { this.delegate.getAdvisor().getManager(); if (AspectManager.getRegisteredCLs().containsKey(classLoader)); } else { return;
/*     */     }
/* 388 */     this.interceptorChainObserver.allInstanceInterceptorsRemoved(this);
/*     */   }
/*     */ 
/*     */   private GeneratedAdvisorInterceptor createWrapper(Interceptor interceptor)
/*     */   {
/* 393 */     return new GeneratedAdvisorInterceptor(new InstanceInterceptorFactory(interceptor, null), null, null);
/*     */   }
/*     */ 
/*     */   public Object getInstance()
/*     */   {
/* 398 */     if (this.instanceRef != null)
/*     */     {
/* 400 */       Object instance = this.instanceRef.get();
/* 401 */       return instance;
/*     */     }
/* 403 */     return null;
/*     */   }
/*     */ 
/*     */   public class InstanceInterceptorFactory implements InterceptorFactory
/*     */   {
/*     */     private Interceptor interceptor;
/*     */ 
/*     */     private InstanceInterceptorFactory(Interceptor interceptor) {
/* 412 */       this.interceptor = interceptor;
/*     */     }
/*     */ 
/*     */     public Interceptor create(Advisor advisor, Joinpoint joinpoint)
/*     */     {
/* 417 */       return this.interceptor;
/*     */     }
/*     */ 
/*     */     public String getClassName()
/*     */     {
/* 422 */       return this.interceptor.getClass().getName();
/*     */     }
/*     */ 
/*     */     public String getAdvice()
/*     */     {
/* 427 */       return "invoke";
/*     */     }
/*     */ 
/*     */     public AspectDefinition getAspect()
/*     */     {
/* 432 */       return null;
/*     */     }
/*     */ 
/*     */     public String getName()
/*     */     {
/* 437 */       return this.interceptor.getName();
/*     */     }
/*     */ 
/*     */     public boolean isDeployed()
/*     */     {
/* 442 */       return true;
/*     */     }
/*     */ 
/*     */     public AdviceType getType()
/*     */     {
/* 447 */       return AdviceType.AROUND;
/*     */     }
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.aop.GeneratedInstanceAdvisorMixin
 * JD-Core Version:    0.6.0
 */