/*     */ package org.jboss.aop;
/*     */ 
/*     */ import java.lang.reflect.Field;
/*     */ import java.lang.reflect.Method;
/*     */ import java.security.AccessController;
/*     */ import java.security.PrivilegedActionException;
/*     */ import java.security.PrivilegedExceptionAction;
/*     */ import org.jboss.aop.joinpoint.FieldAccess;
/*     */ import org.jboss.aop.joinpoint.FieldJoinpoint;
/*     */ import org.jboss.aop.joinpoint.Joinpoint;
/*     */ import org.jboss.aop.util.MethodHashing;
/*     */ 
/*     */ public class FieldInfo extends JoinPointInfo
/*     */   implements FieldAccess
/*     */ {
/*     */   private int index;
/*     */   private Field advisedField;
/*     */   private Method wrapper;
/*     */   private boolean read;
/*     */ 
/*     */   public FieldInfo()
/*     */   {
/*     */   }
/*     */ 
/*     */   public FieldInfo(Advisor advisor, boolean read)
/*     */   {
/*  55 */     super(advisor, null);
/*  56 */     this.read = read;
/*     */   }
/*     */ 
/*     */   public FieldInfo(Class clazz, int index, String fieldName, long wrapperHash, Advisor advisor, boolean read)
/*     */   {
/*  61 */     super(advisor, clazz);
/*     */     try
/*     */     {
/*  65 */       this.index = index;
/*  66 */       this.advisedField = (System.getSecurityManager() == null ? GetDeclaredFieldAction.NON_PRIVILEGED.get(this, clazz, fieldName) : GetDeclaredFieldAction.PRIVILEGED.get(this, clazz, fieldName));
/*     */ 
/*  69 */       this.wrapper = MethodHashing.findMethodByHash(clazz, wrapperHash);
/*  70 */       setAdvisor(advisor);
/*  71 */       this.read = read;
/*     */     }
/*     */     catch (Exception e)
/*     */     {
/*  75 */       throw new RuntimeException(e);
/*     */     }
/*     */   }
/*     */ 
/*     */   private FieldInfo(FieldInfo other)
/*     */   {
/*  84 */     super(other);
/*  85 */     this.index = other.index;
/*  86 */     this.advisedField = other.advisedField;
/*  87 */     this.wrapper = other.wrapper;
/*  88 */     this.read = other.read;
/*     */   }
/*     */ 
/*     */   protected Joinpoint internalGetJoinpoint()
/*     */   {
/*  93 */     return new FieldJoinpoint(this.advisedField);
/*     */   }
/*     */ 
/*     */   public JoinPointInfo copy()
/*     */   {
/*  98 */     return new FieldInfo(this);
/*     */   }
/*     */ 
/*     */   public String toString()
/*     */   {
/* 103 */     StringBuffer sb = new StringBuffer("Field ");
/* 104 */     sb.append(this.read ? " Read" : "Write");
/* 105 */     sb.append("[");
/* 106 */     sb.append("field=" + this.advisedField);
/* 107 */     sb.append("]");
/* 108 */     return sb.toString();
/*     */   }
/*     */ 
/*     */   public void setIndex(int index)
/*     */   {
/* 113 */     this.index = index;
/*     */   }
/*     */ 
/*     */   public int getIndex()
/*     */   {
/* 118 */     return this.index;
/*     */   }
/*     */ 
/*     */   public void setAdvisedField(Field advisedField)
/*     */   {
/* 123 */     this.advisedField = advisedField;
/*     */   }
/*     */ 
/*     */   @Deprecated
/*     */   public Field getAdvisedField()
/*     */   {
/* 130 */     return this.advisedField;
/*     */   }
/*     */ 
/*     */   public Field getField()
/*     */   {
/* 135 */     return this.advisedField;
/*     */   }
/*     */ 
/*     */   public void setWrapper(Method wrapper)
/*     */   {
/* 140 */     this.wrapper = wrapper;
/*     */   }
/*     */ 
/*     */   public Method getWrapper()
/*     */   {
/* 145 */     return this.wrapper;
/*     */   }
/*     */ 
/*     */   public void setRead(boolean read)
/*     */   {
/* 150 */     this.read = read;
/*     */   }
/*     */ 
/*     */   public boolean isRead()
/*     */   {
/* 155 */     return this.read;
/*     */   }
/*     */ 
/*     */   public Object resolveAnnotation(Class annotation)
/*     */   {
/* 160 */     Object val = super.resolveAnnotation(annotation);
/* 161 */     if (val != null) return val;
/*     */ 
/* 163 */     if (getAdvisor() != null)
/*     */     {
/* 165 */       val = getAdvisor().resolveAnnotation(this.advisedField, annotation);
/* 166 */       if (val != null) return val;
/*     */     }
/*     */ 
/* 169 */     return null;
/*     */   }
/*     */ 
/*     */   private Field doGet(Class clazz, String name) throws NoSuchFieldException
/*     */   {
/* 174 */     Field field = null;
/* 175 */     Class superClass = clazz;
/* 176 */     while (superClass != null)
/*     */     {
/*     */       try
/*     */       {
/* 180 */         field = superClass.getDeclaredField(name);
/*     */       }
/*     */       catch (NoSuchFieldException e)
/*     */       {
/*     */       }
/*     */ 
/* 187 */       superClass = superClass.getSuperclass();
/*     */     }
/*     */ 
/* 190 */     if (field == null)
/*     */     {
/* 192 */       throw new NoSuchFieldException("Cannot find field in " + clazz.getName() + " or any of its superclasses");
/*     */     }
/* 194 */     return field;
/*     */   }
/*     */ 
/*     */   static abstract interface GetDeclaredFieldAction
/*     */   {
/* 201 */     public static final GetDeclaredFieldAction PRIVILEGED = new GetDeclaredFieldAction()
/*     */     {
/*     */       public Field get(FieldInfo target, Class clazz, String name) throws NoSuchFieldException {
/*     */         Exception ex;
/*     */         try {
/* 207 */           return (Field)AccessController.doPrivileged(new PrivilegedExceptionAction(target, clazz, name)
/*     */           {
/*     */             public Object run() throws Exception
/*     */             {
/* 211 */               return this.val$target.doGet(this.val$clazz, this.val$name);
/*     */             }
/*     */           });
/*     */         }
/*     */         catch (PrivilegedActionException e) {
/* 217 */           ex = e.getException();
/* 218 */           if ((ex instanceof NoSuchFieldException))
/*     */           {
/* 220 */             throw ((NoSuchFieldException)ex);
/*     */           }
/*     */         }
/* 222 */         throw new RuntimeException(ex);
/*     */       }
/* 201 */     };
/*     */ 
/* 227 */     public static final GetDeclaredFieldAction NON_PRIVILEGED = new GetDeclaredFieldAction()
/*     */     {
/*     */       public Field get(FieldInfo target, Class clazz, String name) throws NoSuchFieldException
/*     */       {
/* 231 */         return target.doGet(clazz, name);
/*     */       }
/* 227 */     };
/*     */ 
/*     */     public abstract Field get(FieldInfo paramFieldInfo, Class paramClass, String paramString)
/*     */       throws NoSuchFieldException;
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.aop.FieldInfo
 * JD-Core Version:    0.6.0
 */