/*      */ package org.jboss.aop;
/*      */ 
/*      */ import java.security.AccessController;
/*      */ import java.security.PrivilegedAction;
/*      */ import java.util.ArrayList;
/*      */ import java.util.HashMap;
/*      */ import java.util.LinkedHashMap;
/*      */ import java.util.List;
/*      */ import java.util.Map;
/*      */ import org.jboss.aop.advice.AdviceBinding;
/*      */ import org.jboss.aop.advice.AdviceStack;
/*      */ import org.jboss.aop.advice.AspectDefinition;
/*      */ import org.jboss.aop.advice.InterceptorFactory;
/*      */ import org.jboss.aop.advice.PrecedenceDef;
/*      */ import org.jboss.aop.introduction.AnnotationIntroduction;
/*      */ import org.jboss.aop.introduction.InterfaceIntroduction;
/*      */ import org.jboss.aop.metadata.ClassMetaDataBinding;
/*      */ import org.jboss.aop.metadata.ClassMetaDataLoader;
/*      */ import org.jboss.aop.microcontainer.lifecycle.LifecycleCallbackBinding;
/*      */ import org.jboss.aop.pointcut.CFlowStack;
/*      */ import org.jboss.aop.pointcut.DynamicCFlow;
/*      */ import org.jboss.aop.pointcut.Pointcut;
/*      */ import org.jboss.aop.pointcut.PointcutStats;
/*      */ import org.jboss.aop.pointcut.Typedef;
/*      */ import org.jboss.aop.pointcut.ast.ClassExpression;
/*      */ 
/*      */ public class Domain extends AspectManager
/*      */ {
/*      */   String name;
/*      */   protected AspectManager parent;
/*      */   protected boolean parentFirst;
/*   61 */   protected boolean inheritsDeclarations = true;
/*   62 */   protected boolean inheritsBindings = false;
/*      */   protected boolean hasOwnPointcuts;
/*      */   protected boolean hasOwnBindings;
/*      */   protected boolean hasOwnAnnotationIntroductions;
/*      */   protected boolean hasOwnAnnotationOverrides;
/*      */   protected boolean hasOwnInterfaceIntroductions;
/*      */   protected boolean hasOwnTypedefs;
/*      */   protected boolean hasOwnPrecedenceDefs;
/*      */   protected boolean hasOwnClassMetaData;
/*      */   private static int sequenceNumber;
/*      */ 
/*      */   public Domain(AspectManager manager, String name, boolean parentFirst)
/*      */   {
/*   78 */     this.parent = manager;
/*   79 */     this.parentFirst = parentFirst;
/*   80 */     this.name = name;
/*   81 */     manager.addSubDomainByName(this);
/*      */   }
/*      */ 
/*      */   public boolean isValid()
/*      */   {
/*   87 */     return true;
/*      */   }
/*      */ 
/*      */   public String getDomainName()
/*      */   {
/*   92 */     return this.name;
/*      */   }
/*      */ 
/*      */   public String getManagerFQN()
/*      */   {
/*   97 */     return this.parent.getManagerFQN() + this.name + "/";
/*      */   }
/*      */ 
/*      */   public static String getDomainName(Class clazz, boolean forInstance)
/*      */   {
/*  102 */     String name = (String)AccessController.doPrivileged(new PrivilegedAction(clazz, forInstance)
/*      */     {
/*      */       public Object run()
/*      */       {
/*  106 */         StringBuffer sb = new StringBuffer();
/*  107 */         sb.append(this.val$clazz.getName());
/*  108 */         sb.append("_");
/*  109 */         sb.append(System.identityHashCode(this.val$clazz.getClassLoader()));
/*      */ 
/*  111 */         if (this.val$forInstance)
/*      */         {
/*  113 */           sb.append("_");
/*  114 */           sb.append(Domain.access$000());
/*      */         }
/*  116 */         return sb.toString();
/*      */       }
/*      */     });
/*  119 */     return name;
/*      */   }
/*      */ 
/*      */   private static synchronized int getNextSequenceNumber()
/*      */   {
/*  124 */     return sequenceNumber++;
/*      */   }
/*      */ 
/*      */   public void setInheritsDeclarations(boolean inheritsDeclarations)
/*      */   {
/*  133 */     this.inheritsDeclarations = inheritsDeclarations;
/*      */   }
/*      */ 
/*      */   public void setInheritsBindings(boolean inheritBindings)
/*      */   {
/*  138 */     this.inheritsBindings = inheritBindings;
/*  139 */     if (this.inheritsBindings)
/*      */     {
/*  141 */       this.parent.subscribeSubDomain(this);
/*      */     }
/*      */     else
/*      */     {
/*  145 */       this.parent.unsubscribeSubDomain(this);
/*      */     }
/*      */   }
/*      */ 
/*      */   public LinkedHashMap getBindings()
/*      */   {
/*  152 */     if (this.inheritsBindings)
/*      */     {
/*  154 */       if (!this.parentFirst)
/*      */       {
/*  157 */         LinkedHashMap parentBindings = this.parent.getBindings();
/*  158 */         LinkedHashMap map = null;
/*  159 */         synchronized (this.parent.getBindings())
/*      */         {
/*  161 */           map = new LinkedHashMap(this.parent.getBindings());
/*  162 */           map.putAll(this.bindings);
/*      */         }
/*  164 */         return map;
/*      */       }
/*      */ 
/*  168 */       LinkedHashMap bindings = this.bindings;
/*  169 */       LinkedHashMap parentBindings = this.parent.getBindings();
/*  170 */       LinkedHashMap map = null;
/*  171 */       synchronized (bindings) {
/*  172 */         map = new LinkedHashMap(bindings);
/*  173 */         map.putAll(parentBindings);
/*      */       }
/*  175 */       return map;
/*      */     }
/*      */ 
/*  178 */     return (LinkedHashMap)super.getBindings();
/*      */   }
/*      */ 
/*      */   public boolean hasOwnBindings()
/*      */   {
/*  183 */     return this.hasOwnBindings;
/*      */   }
/*      */ 
/*      */   public synchronized void addBinding(AdviceBinding binding)
/*      */   {
/*  189 */     this.hasOwnPointcuts = true;
/*  190 */     this.hasOwnBindings = true;
/*  191 */     super.addBinding(binding);
/*      */   }
/*      */ 
/*      */   public synchronized void removeBinding(String name)
/*      */   {
/*  197 */     super.removeBinding(name);
/*  198 */     this.hasOwnBindings = (this.bindings.size() > 0);
/*      */   }
/*      */ 
/*      */   public synchronized void removeBindings(ArrayList binds)
/*      */   {
/*  204 */     super.removeBindings(binds);
/*  205 */     this.hasOwnBindings = (this.bindings.size() > 0);
/*  206 */     this.hasOwnPointcuts = (this.bindings.size() > 0);
/*      */   }
/*      */ 
/*      */   public LinkedHashMap getPointcuts()
/*      */   {
/*  211 */     if (this.inheritsBindings)
/*      */     {
/*  213 */       if (!this.parentFirst)
/*      */       {
/*  216 */         LinkedHashMap map = new LinkedHashMap(this.parent.getPointcuts());
/*  217 */         map.putAll(this.pointcuts);
/*  218 */         return map;
/*      */       }
/*      */ 
/*  222 */       LinkedHashMap map = new LinkedHashMap(this.pointcuts);
/*  223 */       map.putAll(this.parent.getPointcuts());
/*  224 */       return map;
/*      */     }
/*      */ 
/*  227 */     return super.getPointcuts();
/*      */   }
/*      */ 
/*      */   public boolean hasOwnPointcuts()
/*      */   {
/*  232 */     return this.hasOwnPointcuts;
/*      */   }
/*      */ 
/*      */   public synchronized void addPointcut(Pointcut pointcut)
/*      */   {
/*  238 */     this.hasOwnPointcuts = true;
/*  239 */     super.addPointcut(pointcut);
/*      */   }
/*      */ 
/*      */   public void removePointcut(String name)
/*      */   {
/*  245 */     super.removePointcut(name);
/*  246 */     this.hasOwnPointcuts = (this.pointcuts.size() > 0);
/*      */   }
/*      */ 
/*      */   public LinkedHashMap getPointcutInfos()
/*      */   {
/*  252 */     if (this.inheritsBindings)
/*      */     {
/*  254 */       if (!this.parentFirst)
/*      */       {
/*  257 */         LinkedHashMap map = new LinkedHashMap(this.parent.getPointcutInfos());
/*  258 */         map.putAll(this.pointcutInfos);
/*  259 */         return map;
/*      */       }
/*      */ 
/*  263 */       LinkedHashMap map = new LinkedHashMap(this.pointcutInfos);
/*  264 */       map.putAll(this.parent.getPointcutInfos());
/*  265 */       return map;
/*      */     }
/*      */ 
/*  268 */     return super.getPointcutInfos();
/*      */   }
/*      */ 
/*      */   public List getAnnotationIntroductions()
/*      */   {
/*  275 */     if (this.inheritsBindings)
/*      */     {
/*  277 */       List result = new ArrayList();
/*  278 */       if (!this.parentFirst)
/*      */       {
/*  281 */         result.addAll(this.parent.getAnnotationIntroductions());
/*  282 */         synchronized (this.annotationIntroductions)
/*      */         {
/*  284 */           result = new ArrayList(this.annotationIntroductions.values());
/*      */         }
/*  286 */         return result;
/*      */       }
/*      */ 
/*  290 */       synchronized (this.annotationIntroductions)
/*      */       {
/*  292 */         result = new ArrayList(this.annotationIntroductions.values());
/*      */       }
/*  294 */       result.addAll(this.parent.getAnnotationIntroductions());
/*  295 */       return result;
/*      */     }
/*      */ 
/*  299 */     return super.getAnnotationIntroductions();
/*      */   }
/*      */ 
/*      */   public Map getArrayReplacements()
/*      */   {
/*  304 */     if (this.inheritsBindings)
/*      */     {
/*  306 */       HashMap map = new HashMap();
/*  307 */       if (!this.parentFirst)
/*      */       {
/*  310 */         map.putAll(this.parent.getArrayReplacements());
/*  311 */         synchronized (this.arrayReplacements)
/*      */         {
/*  313 */           map.putAll(this.arrayReplacements);
/*      */         }
/*  315 */         return map;
/*      */       }
/*      */ 
/*  319 */       synchronized (this.arrayReplacements)
/*      */       {
/*  321 */         map.putAll(this.arrayReplacements);
/*      */       }
/*  323 */       map.putAll(this.parent.getArrayReplacements());
/*  324 */       return map;
/*      */     }
/*      */ 
/*  327 */     return super.getArrayReplacements();
/*      */   }
/*      */ 
/*      */   public boolean hasOwnAnnotationIntroductions()
/*      */   {
/*  333 */     return this.hasOwnAnnotationIntroductions;
/*      */   }
/*      */ 
/*      */   public synchronized void addAnnotationIntroduction(AnnotationIntroduction pointcut)
/*      */   {
/*  339 */     this.hasOwnAnnotationIntroductions = true;
/*  340 */     super.addAnnotationIntroduction(pointcut);
/*      */   }
/*      */ 
/*      */   public void removeAnnotationIntroduction(AnnotationIntroduction pointcut)
/*      */   {
/*  346 */     super.removeAnnotationIntroduction(pointcut);
/*  347 */     this.hasOwnAnnotationIntroductions = (this.annotationIntroductions.size() > 0);
/*      */   }
/*      */ 
/*      */   public List getAnnotationOverrides()
/*      */   {
/*  353 */     if (this.inheritsBindings)
/*      */     {
/*  355 */       ArrayList list = new ArrayList();
/*  356 */       if (!this.parentFirst)
/*      */       {
/*  359 */         list.addAll(this.parent.getAnnotationOverrides());
/*  360 */         synchronized (this.annotationOverrides)
/*      */         {
/*  362 */           list.addAll(this.annotationOverrides.values());
/*      */         }
/*  364 */         return list;
/*      */       }
/*      */ 
/*  368 */       synchronized (this.annotationOverrides)
/*      */       {
/*  370 */         list.addAll(this.annotationOverrides.values());
/*      */       }
/*  372 */       list.addAll(this.parent.getAnnotationOverrides());
/*  373 */       return list;
/*      */     }
/*      */ 
/*  376 */     return super.getAnnotationOverrides();
/*      */   }
/*      */ 
/*      */   public boolean hasOwnAnnotationOverrides()
/*      */   {
/*  381 */     return this.hasOwnAnnotationOverrides;
/*      */   }
/*      */ 
/*      */   public synchronized void addAnnotationOverride(AnnotationIntroduction pointcut)
/*      */   {
/*  387 */     this.hasOwnAnnotationOverrides = true;
/*  388 */     super.addAnnotationOverride(pointcut);
/*      */   }
/*      */ 
/*      */   public void removeAnnotationOverride(AnnotationIntroduction pointcut)
/*      */   {
/*  394 */     super.removeAnnotationOverride(pointcut);
/*  395 */     this.hasOwnAnnotationOverrides = (this.annotationOverrides.size() > 0);
/*      */   }
/*      */ 
/*      */   public Map getInterfaceIntroductions()
/*      */   {
/*  401 */     if (this.inheritsBindings)
/*      */     {
/*  403 */       HashMap map = new HashMap();
/*  404 */       if (!this.parentFirst)
/*      */       {
/*  407 */         map.putAll(this.parent.getInterfaceIntroductions());
/*  408 */         synchronized (this.interfaceIntroductions)
/*      */         {
/*  410 */           map.putAll(this.interfaceIntroductions);
/*      */         }
/*  412 */         return map;
/*      */       }
/*      */ 
/*  416 */       synchronized (this.interfaceIntroductions)
/*      */       {
/*  418 */         map.putAll(this.interfaceIntroductions);
/*      */       }
/*  420 */       map.putAll(this.parent.getInterfaceIntroductions());
/*  421 */       return map;
/*      */     }
/*      */ 
/*  424 */     return super.getInterfaceIntroductions();
/*      */   }
/*      */ 
/*      */   public boolean hasOwnInterfaceIntroductions()
/*      */   {
/*  429 */     return this.hasOwnInterfaceIntroductions;
/*      */   }
/*      */ 
/*      */   public synchronized void addInterfaceIntroduction(InterfaceIntroduction pointcut)
/*      */   {
/*  435 */     this.hasOwnInterfaceIntroductions = true;
/*  436 */     super.addInterfaceIntroduction(pointcut);
/*      */   }
/*      */ 
/*      */   public void removeInterfaceIntroduction(String name)
/*      */   {
/*  442 */     super.removeInterfaceIntroduction(name);
/*  443 */     this.hasOwnInterfaceIntroductions = (this.interfaceIntroductions.size() > 0);
/*      */   }
/*      */ 
/*      */   public Map getTypedefs()
/*      */   {
/*  449 */     if (this.inheritsBindings)
/*      */     {
/*  451 */       HashMap map = new HashMap();
/*  452 */       if (!this.parentFirst)
/*      */       {
/*  455 */         map.putAll(this.parent.getTypedefs());
/*  456 */         synchronized (this.typedefs)
/*      */         {
/*  458 */           map.putAll(this.typedefs);
/*      */         }
/*  460 */         return map;
/*      */       }
/*      */ 
/*  464 */       synchronized (this.typedefs)
/*      */       {
/*  466 */         map.putAll(this.typedefs);
/*      */       }
/*  468 */       map.putAll(this.parent.getTypedefs());
/*  469 */       return map;
/*      */     }
/*      */ 
/*  472 */     return super.getTypedefs();
/*      */   }
/*      */ 
/*      */   public boolean hasOwnTypedefs()
/*      */   {
/*  478 */     return this.hasOwnTypedefs;
/*      */   }
/*      */ 
/*      */   public synchronized void addTypedef(Typedef def)
/*      */     throws Exception
/*      */   {
/*  484 */     this.hasOwnTypedefs = true;
/*  485 */     super.addTypedef(def);
/*      */   }
/*      */ 
/*      */   public void removeTypedef(String name)
/*      */   {
/*  491 */     super.removeTypedef(name);
/*  492 */     this.hasOwnTypedefs = (this.typedefs.size() > 0);
/*      */   }
/*      */ 
/*      */   public Map getInterceptorStacks()
/*      */   {
/*  497 */     if (this.inheritsBindings)
/*      */     {
/*  499 */       HashMap map = new HashMap();
/*  500 */       if (!this.parentFirst)
/*      */       {
/*  503 */         map.putAll(this.parent.getInterceptorStacks());
/*  504 */         synchronized (this.interceptorStacks)
/*      */         {
/*  506 */           map.putAll(this.interceptorStacks);
/*      */         }
/*  508 */         return map;
/*      */       }
/*      */ 
/*  512 */       synchronized (this.interceptorStacks)
/*      */       {
/*  514 */         map.putAll(this.interceptorStacks);
/*      */       }
/*  516 */       map.putAll(this.parent.getInterceptorStacks());
/*  517 */       return map;
/*      */     }
/*      */ 
/*  520 */     return super.getInterceptorStacks();
/*      */   }
/*      */ 
/*      */   public Map getClassMetaDataLoaders()
/*      */   {
/*  525 */     if (this.inheritsBindings)
/*      */     {
/*  527 */       HashMap map = new HashMap();
/*  528 */       if (!this.parentFirst)
/*      */       {
/*  531 */         map.putAll(this.parent.getClassMetaDataLoaders());
/*  532 */         synchronized (this.classMetaDataLoaders)
/*      */         {
/*  534 */           map.putAll(this.classMetaDataLoaders);
/*      */         }
/*  536 */         return map;
/*      */       }
/*      */ 
/*  540 */       synchronized (this.classMetaDataLoaders)
/*      */       {
/*  542 */         map.putAll(this.classMetaDataLoaders);
/*      */       }
/*  544 */       map.putAll(this.parent.getClassMetaDataLoaders());
/*  545 */       return map;
/*      */     }
/*      */ 
/*  548 */     return super.getClassMetaDataLoaders();
/*      */   }
/*      */ 
/*      */   public Map getCflowStacks()
/*      */   {
/*  553 */     if (this.inheritsBindings)
/*      */     {
/*  555 */       HashMap map = new HashMap();
/*  556 */       if (!this.parentFirst)
/*      */       {
/*  559 */         map.putAll(this.parent.getCflowStacks());
/*  560 */         synchronized (this.cflowStacks)
/*      */         {
/*  562 */           map.putAll(this.cflowStacks);
/*      */         }
/*  564 */         return map;
/*      */       }
/*      */ 
/*  568 */       synchronized (this.cflowStacks)
/*      */       {
/*  570 */         map.putAll(this.cflowStacks);
/*      */       }
/*  572 */       map.putAll(this.parent.getCflowStacks());
/*  573 */       return map;
/*      */     }
/*      */ 
/*  576 */     return super.getCflowStacks();
/*      */   }
/*      */ 
/*      */   public Map getDynamicCFlows()
/*      */   {
/*  581 */     if (this.inheritsBindings)
/*      */     {
/*  583 */       HashMap map = new HashMap();
/*  584 */       if (!this.parentFirst)
/*      */       {
/*  587 */         map.putAll(this.parent.getDynamicCFlows());
/*  588 */         synchronized (this.dynamicCFlows)
/*      */         {
/*  590 */           map.putAll(this.dynamicCFlows);
/*      */         }
/*  592 */         return map;
/*      */       }
/*      */ 
/*  596 */       synchronized (this.dynamicCFlows)
/*      */       {
/*  598 */         map.putAll(this.dynamicCFlows);
/*      */       }
/*  600 */       map.putAll(this.parent.getDynamicCFlows());
/*  601 */       return map;
/*      */     }
/*      */ 
/*  604 */     return super.getDynamicCFlows();
/*      */   }
/*      */ 
/*      */   public Map getPerVMAspects()
/*      */   {
/*  609 */     if (this.inheritsBindings)
/*      */     {
/*  611 */       HashMap map = new HashMap();
/*  612 */       if (!this.parentFirst)
/*      */       {
/*  615 */         map.putAll(this.parent.getPerVMAspects());
/*  616 */         synchronized (this.perVMAspects)
/*      */         {
/*  618 */           map.putAll(this.perVMAspects);
/*      */         }
/*  620 */         return map;
/*      */       }
/*      */ 
/*  624 */       synchronized (this.perVMAspects)
/*      */       {
/*  626 */         map.putAll(this.perVMAspects);
/*      */       }
/*  628 */       map.putAll(this.parent.getPerVMAspects());
/*  629 */       return map;
/*      */     }
/*      */ 
/*  632 */     return super.getPerVMAspects();
/*      */   }
/*      */ 
/*      */   public LinkedHashMap getPrecedenceDefs()
/*      */   {
/*  638 */     if (this.inheritsDeclarations)
/*      */     {
/*  640 */       if (!this.parentFirst)
/*      */       {
/*  643 */         LinkedHashMap map = new LinkedHashMap(this.parent.getPrecedenceDefs());
/*  644 */         map.putAll(this.precedenceDefs);
/*  645 */         return map;
/*      */       }
/*      */ 
/*  649 */       LinkedHashMap map = new LinkedHashMap(this.precedenceDefs);
/*  650 */       map.putAll(this.parent.getPrecedenceDefs());
/*  651 */       return map;
/*      */     }
/*      */ 
/*  654 */     return super.getPrecedenceDefs();
/*      */   }
/*      */ 
/*      */   public boolean hasOwnPrecedenceDefs()
/*      */   {
/*  659 */     return this.hasOwnPrecedenceDefs;
/*      */   }
/*      */ 
/*      */   public void addPrecedence(PrecedenceDef precedenceDef)
/*      */   {
/*  665 */     this.hasOwnPrecedenceDefs = true;
/*  666 */     super.addPrecedence(precedenceDef);
/*      */   }
/*      */ 
/*      */   public void removePrecedence(String name)
/*      */   {
/*  672 */     super.removePrecedence(name);
/*  673 */     this.hasOwnPrecedenceDefs = (this.precedenceDefs.size() > 0);
/*      */   }
/*      */ 
/*      */   public Map getClassMetaData()
/*      */   {
/*  679 */     if (this.inheritsBindings)
/*      */     {
/*  681 */       HashMap map = new HashMap();
/*  682 */       if (!this.parentFirst)
/*      */       {
/*  685 */         map.putAll(this.parent.getClassMetaData());
/*  686 */         synchronized (this.classMetaData)
/*      */         {
/*  688 */           map.putAll(this.classMetaData);
/*      */         }
/*  690 */         return map;
/*      */       }
/*      */ 
/*  694 */       synchronized (this.classMetaData)
/*      */       {
/*  696 */         map.putAll(this.classMetaData);
/*      */       }
/*  698 */       map.putAll(this.parent.getClassMetaData());
/*  699 */       return map;
/*      */     }
/*      */ 
/*  702 */     return super.getClassMetaData();
/*      */   }
/*      */ 
/*      */   public boolean hasOwnClassMetaData()
/*      */   {
/*  707 */     return this.hasOwnClassMetaData;
/*      */   }
/*      */ 
/*      */   public void removeClassMetaData(String name)
/*      */   {
/*  713 */     super.removeClassMetaData(name);
/*  714 */     this.hasOwnClassMetaData = (this.classMetaData.size() > 0);
/*      */   }
/*      */ 
/*      */   public void addClassMetaData(ClassMetaDataBinding meta)
/*      */   {
/*  720 */     this.hasOwnClassMetaData = true;
/*  721 */     super.addClassMetaData(meta);
/*      */   }
/*      */ 
/*      */   public boolean hasOwnDataWithEffectOnAdvices()
/*      */   {
/*  726 */     return (this.hasOwnBindings) || (this.hasOwnPointcuts) || (this.hasOwnAnnotationIntroductions) || (this.hasOwnAnnotationOverrides) || (this.hasOwnInterfaceIntroductions) || (this.hasOwnTypedefs) || (this.hasOwnPrecedenceDefs) || (this.hasOwnClassMetaData);
/*      */   }
/*      */ 
/*      */   public InterceptorFactory getInterceptorFactory(String name)
/*      */   {
/*  738 */     InterceptorFactory factory = null;
/*  739 */     if (this.parentFirst)
/*      */     {
/*  741 */       factory = this.parent.getInterceptorFactory(name);
/*  742 */       if (factory != null) return factory;
/*      */     }
/*  744 */     factory = super.getInterceptorFactory(name);
/*      */ 
/*  746 */     if (factory != null) return factory;
/*  747 */     return this.parent.getInterceptorFactory(name);
/*      */   }
/*      */ 
/*      */   public AdviceStack getAdviceStack(String name)
/*      */   {
/*  752 */     AdviceStack factory = null;
/*  753 */     if (this.parentFirst)
/*      */     {
/*  755 */       factory = this.parent.getAdviceStack(name);
/*  756 */       if (factory != null) return factory;
/*      */     }
/*  758 */     factory = super.getAdviceStack(name);
/*      */ 
/*  760 */     if (factory != null) return factory;
/*  761 */     return this.parent.getAdviceStack(name);
/*      */   }
/*      */ 
/*      */   public Object getPerVMAspect(AspectDefinition def)
/*      */   {
/*  766 */     return getPerVMAspect(def.getName());
/*      */   }
/*      */ 
/*      */   public Object getPerVMAspect(String def)
/*      */   {
/*  771 */     Object factory = null;
/*  772 */     if (this.parentFirst)
/*      */     {
/*  774 */       factory = this.parent.getPerVMAspect(def);
/*  775 */       if (factory != null) return factory;
/*      */     }
/*  777 */     factory = super.getPerVMAspect(def);
/*      */ 
/*  779 */     if (factory != null) return factory;
/*  780 */     return this.parent.getPerVMAspect(def);
/*      */   }
/*      */ 
/*      */   public AspectDefinition getAspectDefinition(String name)
/*      */   {
/*  785 */     AspectDefinition factory = null;
/*  786 */     if (this.parentFirst)
/*      */     {
/*  788 */       factory = this.parent.getAspectDefinition(name);
/*  789 */       if (factory != null) return factory;
/*      */     }
/*  791 */     factory = super.getAspectDefinition(name);
/*      */ 
/*  793 */     if (factory != null) return factory;
/*  794 */     return this.parent.getAspectDefinition(name);
/*      */   }
/*      */ 
/*      */   public Typedef getTypedef(String name)
/*      */   {
/*  799 */     Typedef factory = null;
/*  800 */     if (this.parentFirst)
/*      */     {
/*  802 */       factory = this.parent.getTypedef(name);
/*  803 */       if (factory != null) return factory;
/*      */     }
/*  805 */     factory = super.getTypedef(name);
/*      */ 
/*  807 */     if (factory != null) return factory;
/*  808 */     return this.parent.getTypedef(name);
/*      */   }
/*      */ 
/*      */   public DomainDefinition getContainer(String name)
/*      */   {
/*  813 */     DomainDefinition container = null;
/*  814 */     if (this.parentFirst)
/*      */     {
/*  816 */       container = this.parent.getContainer(name);
/*  817 */       if (container != null) return container;
/*      */     }
/*  819 */     container = super.getContainer(name);
/*  820 */     if (container != null) return container;
/*  821 */     return this.parent.getContainer(name);
/*      */   }
/*      */ 
/*      */   public Pointcut getPointcut(String name)
/*      */   {
/*  831 */     Pointcut pointcut = null;
/*      */ 
/*  833 */     if (this.parentFirst)
/*      */     {
/*  835 */       pointcut = this.parent.getPointcut(name);
/*  836 */       if (pointcut != null) return pointcut;
/*      */     }
/*  838 */     pointcut = super.getPointcut(name);
/*  839 */     if (pointcut != null) return pointcut;
/*  840 */     return this.parent.getPointcut(name);
/*      */   }
/*      */ 
/*      */   public void attachMetaData(Advisor advisor, Class clazz)
/*      */   {
/*  846 */     if (this.inheritsBindings)
/*      */     {
/*  848 */       if (!this.parentFirst)
/*      */       {
/*  851 */         this.parent.attachMetaData(advisor, clazz);
/*  852 */         super.attachMetaData(advisor, clazz);
/*      */       }
/*      */       else
/*      */       {
/*  856 */         super.attachMetaData(advisor, clazz);
/*  857 */         this.parent.attachMetaData(advisor, clazz);
/*      */       }
/*      */     }
/*      */     else
/*      */     {
/*  862 */       super.attachMetaData(advisor, clazz);
/*      */     }
/*      */   }
/*      */ 
/*      */   public CFlowStack getCFlowStack(String name)
/*      */   {
/*  868 */     if (this.inheritsDeclarations)
/*      */     {
/*  870 */       if (!this.parentFirst)
/*      */       {
/*  872 */         CFlowStack cflow = super.getCFlowStack(name);
/*  873 */         if (cflow == null)
/*      */         {
/*  875 */           cflow = this.parent.getCFlowStack(name);
/*      */         }
/*  877 */         return cflow;
/*      */       }
/*      */ 
/*  881 */       CFlowStack cflow = this.parent.getCFlowStack(name);
/*  882 */       if (cflow == null)
/*      */       {
/*  884 */         cflow = super.getCFlowStack(name);
/*      */       }
/*  886 */       return cflow;
/*      */     }
/*      */ 
/*  891 */     return super.getCFlowStack(name);
/*      */   }
/*      */ 
/*      */   public DynamicCFlow getDynamicCFlow(String name)
/*      */   {
/*  898 */     if (this.inheritsBindings)
/*      */     {
/*  900 */       if (!this.parentFirst)
/*      */       {
/*  902 */         DynamicCFlow cflow = super.getDynamicCFlow(name);
/*  903 */         if (cflow == null)
/*      */         {
/*  905 */           cflow = this.parent.getDynamicCFlow(name);
/*      */         }
/*  907 */         return cflow;
/*      */       }
/*      */ 
/*  911 */       DynamicCFlow cflow = this.parent.getDynamicCFlow(name);
/*  912 */       if (cflow == null)
/*      */       {
/*  914 */         cflow = super.getDynamicCFlow(name);
/*      */       }
/*  916 */       return cflow;
/*      */     }
/*      */ 
/*  921 */     return super.getDynamicCFlow(name);
/*      */   }
/*      */ 
/*      */   public ClassMetaDataLoader findClassMetaDataLoader(String group)
/*      */   {
/*  927 */     if (this.inheritsDeclarations)
/*      */     {
/*  929 */       if (!this.parentFirst)
/*      */       {
/*  931 */         ClassMetaDataLoader loader = super.findClassMetaDataLoader(group);
/*  932 */         if (loader == null)
/*      */         {
/*  934 */           loader = this.parent.findClassMetaDataLoader(group);
/*      */         }
/*  936 */         return loader;
/*      */       }
/*      */ 
/*  940 */       ClassMetaDataLoader loader = this.parent.findClassMetaDataLoader(group);
/*  941 */       if (loader == null)
/*      */       {
/*  943 */         loader = super.findClassMetaDataLoader(group);
/*      */       }
/*  945 */       return loader;
/*      */     }
/*      */ 
/*  949 */     return super.findClassMetaDataLoader(group);
/*      */   }
/*      */ 
/*      */   public Map<String, LifecycleCallbackBinding> getLifecycleBindings()
/*      */   {
/*  954 */     if (this.inheritsBindings)
/*      */     {
/*  956 */       if (!this.parentFirst)
/*      */       {
/*  959 */         LinkedHashMap map = new LinkedHashMap(this.parent.getLifecycleBindings());
/*  960 */         map.putAll(super.getLifecycleBindings());
/*  961 */         return map;
/*      */       }
/*      */ 
/*  965 */       LinkedHashMap map = new LinkedHashMap(super.getLifecycleBindings());
/*  966 */       map.putAll(this.parent.getLifecycleBindings());
/*  967 */       return map;
/*      */     }
/*      */ 
/*  970 */     return super.getLifecycleBindings();
/*      */   }
/*      */ 
/*      */   public InterceptionMarkers getInterceptionMarkers()
/*      */   {
/*  980 */     return this.parent.getInterceptionMarkers();
/*      */   }
/*      */ 
/*      */   protected Map getSubDomainsPerClass()
/*      */   {
/*  986 */     return this.parent.getSubDomainsPerClass();
/*      */   }
/*      */ 
/*      */   public ArrayList getExclude()
/*      */   {
/*  992 */     return this.parent.getExclude();
/*      */   }
/*      */ 
/*      */   public ArrayList getInclude()
/*      */   {
/*  998 */     return this.parent.getInclude();
/*      */   }
/*      */ 
/*      */   public ArrayList getIgnore()
/*      */   {
/* 1004 */     return this.parent.getIgnore();
/*      */   }
/*      */ 
/*      */   public ClassExpression[] getIgnoreExpressions()
/*      */   {
/* 1010 */     return this.parent.getIgnoreExpressions();
/*      */   }
/*      */ 
/*      */   public DynamicAOPStrategy getDynamicAOPStrategy()
/*      */   {
/* 1015 */     return this.parent.getDynamicAOPStrategy();
/*      */   }
/*      */ 
/*      */   public void setDynamicAOPStrategy(DynamicAOPStrategy strategy)
/*      */   {
/* 1020 */     this.parent.setDynamicAOPStrategy(strategy);
/*      */   }
/*      */ 
/*      */   protected void updatePointcutStats(Pointcut pointcut)
/*      */   {
/* 1025 */     this.parent.updatePointcutStats(pointcut);
/*      */   }
/*      */ 
/*      */   protected void updateStats(PointcutStats stats)
/*      */   {
/* 1030 */     this.parent.updateStats(stats);
/*      */   }
/*      */ 
/*      */   public boolean isExecution()
/*      */   {
/* 1035 */     return this.parent.isExecution();
/*      */   }
/*      */ 
/*      */   public boolean isConstruction()
/*      */   {
/* 1040 */     return this.parent.isConstruction();
/*      */   }
/*      */ 
/*      */   public boolean isCall()
/*      */   {
/* 1045 */     return this.parent.isCall();
/*      */   }
/*      */ 
/*      */   public boolean isWithin()
/*      */   {
/* 1050 */     return this.parent.isWithin();
/*      */   }
/*      */ 
/*      */   public boolean isWithincode()
/*      */   {
/* 1055 */     return this.parent.isWithincode();
/*      */   }
/*      */ 
/*      */   public boolean isGet()
/*      */   {
/* 1060 */     return this.parent.isGet();
/*      */   }
/*      */ 
/*      */   public boolean isSet()
/*      */   {
/* 1065 */     return this.parent.isSet();
/*      */   }
/*      */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.aop.Domain
 * JD-Core Version:    0.6.0
 */