/*     */ package org.jboss.aop;
/*     */ 
/*     */ import java.lang.reflect.Constructor;
/*     */ import org.jboss.aop.joinpoint.Construction;
/*     */ import org.jboss.aop.joinpoint.ConstructorJoinpoint;
/*     */ import org.jboss.aop.joinpoint.Joinpoint;
/*     */ import org.jboss.aop.util.MethodHashing;
/*     */ 
/*     */ public class ConstructionInfo extends JoinPointInfo
/*     */   implements Construction
/*     */ {
/*     */   private Constructor constructor;
/*     */   private int index;
/*     */ 
/*     */   public ConstructionInfo()
/*     */   {
/*     */   }
/*     */ 
/*     */   public ConstructionInfo(Class clazz, int index, long constructorHash, Advisor advisor)
/*     */   {
/*  49 */     super(advisor, clazz);
/*     */     try
/*     */     {
/*  52 */       this.index = index;
/*  53 */       this.constructor = MethodHashing.findConstructorByHash(clazz, constructorHash);
/*  54 */       setAdvisor(advisor);
/*     */     }
/*     */     catch (Exception e)
/*     */     {
/*  58 */       throw new RuntimeException(e);
/*     */     }
/*     */   }
/*     */ 
/*     */   private ConstructionInfo(ConstructionInfo other)
/*     */   {
/*  67 */     super(other);
/*  68 */     this.constructor = other.constructor;
/*  69 */     this.index = other.index;
/*     */   }
/*     */ 
/*     */   protected Joinpoint internalGetJoinpoint()
/*     */   {
/*  74 */     return new ConstructorJoinpoint(this.constructor);
/*     */   }
/*     */ 
/*     */   public JoinPointInfo copy()
/*     */   {
/*  79 */     return new ConstructionInfo(this);
/*     */   }
/*     */ 
/*     */   public String toString()
/*     */   {
/*  84 */     StringBuffer sb = new StringBuffer("Construction");
/*  85 */     sb.append("[");
/*  86 */     sb.append("constructor=" + this.constructor);
/*  87 */     sb.append("]");
/*  88 */     return sb.toString();
/*     */   }
/*     */ 
/*     */   public void setConstructor(Constructor constructor)
/*     */   {
/*  93 */     this.constructor = constructor;
/*     */   }
/*     */ 
/*     */   public Constructor getConstructor()
/*     */   {
/*  98 */     return this.constructor;
/*     */   }
/*     */ 
/*     */   public void setIndex(int index)
/*     */   {
/* 103 */     this.index = index;
/*     */   }
/*     */ 
/*     */   public int getIndex()
/*     */   {
/* 108 */     return this.index;
/*     */   }
/*     */ 
/*     */   public Object resolveAnnotation(Class annotation)
/*     */   {
/* 113 */     Object val = super.resolveAnnotation(annotation);
/* 114 */     if (val != null) return val;
/*     */ 
/* 116 */     if (getAdvisor() != null)
/*     */     {
/* 118 */       val = getAdvisor().resolveAnnotation(this.constructor, annotation);
/* 119 */       if (val != null) return val;
/*     */     }
/*     */ 
/* 122 */     return null;
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.aop.ConstructionInfo
 * JD-Core Version:    0.6.0
 */