/*    */ package org.jboss.aop;
/*    */ 
/*    */ import java.lang.reflect.Constructor;
/*    */ import java.lang.reflect.Method;
/*    */ import org.jboss.aop.advice.Interceptor;
/*    */ import org.jboss.aop.joinpoint.ConstructorCallByMethod;
/*    */ import org.jboss.aop.joinpoint.ConstructorCalledByMethodJoinpoint;
/*    */ import org.jboss.aop.joinpoint.Joinpoint;
/*    */ 
/*    */ public class ConByMethodInfo extends CallerConstructorInfo
/*    */   implements ConstructorCallByMethod
/*    */ {
/*    */   private final long callingMethodHash;
/*    */   private final Method callingMethod;
/*    */ 
/*    */   public ConByMethodInfo(Advisor advisor, Class calledClass, Method callingMethod, long callingMethodHash, Constructor c, long calledConHash, Method wrappingMethod, Interceptor[] in)
/*    */   {
/* 52 */     super(advisor, calledClass, c, calledConHash, wrappingMethod, in, callingMethod.getDeclaringClass());
/* 53 */     this.callingMethodHash = callingMethodHash;
/* 54 */     this.callingMethod = callingMethod;
/*    */   }
/*    */ 
/*    */   protected ConByMethodInfo(ConByMethodInfo other)
/*    */   {
/* 62 */     super(other);
/* 63 */     this.callingMethodHash = other.callingMethodHash;
/* 64 */     this.callingMethod = other.callingMethod;
/*    */   }
/*    */ 
/*    */   protected Joinpoint internalGetJoinpoint()
/*    */   {
/* 69 */     return new ConstructorCalledByMethodJoinpoint(this.callingMethod, getConstructor());
/*    */   }
/*    */ 
/*    */   public JoinPointInfo copy()
/*    */   {
/* 74 */     return new ConByMethodInfo(this);
/*    */   }
/*    */ 
/*    */   public String toString()
/*    */   {
/* 79 */     StringBuffer sb = new StringBuffer("Constructor called by Method");
/* 80 */     sb.append("[");
/* 81 */     sb.append("calling=" + this.callingMethod);
/* 82 */     sb.append(",called=" + getConstructor());
/* 83 */     sb.append("]");
/* 84 */     return sb.toString();
/*    */   }
/*    */ 
/*    */   public long getCallingMethodHash()
/*    */   {
/* 89 */     return this.callingMethodHash;
/*    */   }
/*    */ 
/*    */   public Method getCallingMethod()
/*    */   {
/* 94 */     return this.callingMethod;
/*    */   }
/*    */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.aop.ConByMethodInfo
 * JD-Core Version:    0.6.0
 */