/*    */ package org.jboss.aop;
/*    */ 
/*    */ import java.lang.reflect.Constructor;
/*    */ import java.lang.reflect.Method;
/*    */ import org.jboss.aop.advice.Interceptor;
/*    */ import org.jboss.aop.joinpoint.ConstructorCall;
/*    */ 
/*    */ public abstract class CallerConstructorInfo extends JoinPointInfo
/*    */   implements ConstructorCall
/*    */ {
/*    */   private final Constructor constructor;
/*    */   private final Class callingClass;
/*    */   private final Method wrappingMethod;
/*    */   private final long calledConHash;
/*    */   private final Class calledClass;
/*    */ 
/*    */   public CallerConstructorInfo(Advisor advisor, Class calledClass, Constructor called, long calledConHash, Method wrappingMethod, Interceptor[] in, Class clazz)
/*    */   {
/* 47 */     super(advisor, clazz);
/* 48 */     this.calledClass = calledClass;
/* 49 */     super.setInterceptors(in);
/* 50 */     this.constructor = called;
/* 51 */     this.calledConHash = calledConHash;
/* 52 */     this.callingClass = advisor.getClazz();
/* 53 */     this.wrappingMethod = wrappingMethod;
/*    */   }
/*    */ 
/*    */   protected CallerConstructorInfo(CallerConstructorInfo other)
/*    */   {
/* 61 */     super(other);
/* 62 */     this.constructor = other.constructor;
/* 63 */     this.callingClass = other.callingClass;
/* 64 */     this.wrappingMethod = other.wrappingMethod;
/* 65 */     this.calledConHash = other.getCalledConHash();
/* 66 */     this.calledClass = other.calledClass;
/*    */   }
/*    */ 
/*    */   public Constructor getConstructor()
/*    */   {
/* 71 */     return this.constructor;
/*    */   }
/*    */ 
/*    */   public Class getCallingClass()
/*    */   {
/* 76 */     return this.callingClass;
/*    */   }
/*    */ 
/*    */   public Method getWrappingMethod()
/*    */   {
/* 81 */     return this.wrappingMethod;
/*    */   }
/*    */ 
/*    */   public long getCalledConHash()
/*    */   {
/* 86 */     return this.calledConHash;
/*    */   }
/*    */ 
/*    */   public Class getCalledClass()
/*    */   {
/* 91 */     return this.calledClass;
/*    */   }
/*    */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.aop.CallerConstructorInfo
 * JD-Core Version:    0.6.0
 */