/*      */ package org.jboss.aop;
/*      */ 
/*      */ import java.io.IOException;
/*      */ import java.io.InputStream;
/*      */ import java.io.PrintStream;
/*      */ import java.io.StringReader;
/*      */ import java.net.URL;
/*      */ import java.util.ArrayList;
/*      */ import java.util.Iterator;
/*      */ import java.util.StringTokenizer;
/*      */ import javax.xml.parsers.DocumentBuilder;
/*      */ import javax.xml.parsers.DocumentBuilderFactory;
/*      */ import javax.xml.parsers.ParserConfigurationException;
/*      */ import org.jboss.aop.advice.AdviceBinding;
/*      */ import org.jboss.aop.advice.AdviceFactory;
/*      */ import org.jboss.aop.advice.AdviceStack;
/*      */ import org.jboss.aop.advice.AdviceType;
/*      */ import org.jboss.aop.advice.AspectDefinition;
/*      */ import org.jboss.aop.advice.AspectFactory;
/*      */ import org.jboss.aop.advice.AspectFactoryDelegator;
/*      */ import org.jboss.aop.advice.AspectFactoryWithClassLoader;
/*      */ import org.jboss.aop.advice.DynamicCFlowDefinition;
/*      */ import org.jboss.aop.advice.GenericAspectFactory;
/*      */ import org.jboss.aop.advice.InterceptorFactory;
/*      */ import org.jboss.aop.advice.PrecedenceDef;
/*      */ import org.jboss.aop.advice.PrecedenceDefEntry;
/*      */ import org.jboss.aop.advice.Scope;
/*      */ import org.jboss.aop.advice.ScopeUtil;
/*      */ import org.jboss.aop.advice.ScopedInterceptorFactory;
/*      */ import org.jboss.aop.array.ArrayBinding;
/*      */ import org.jboss.aop.array.ArrayReplacement;
/*      */ import org.jboss.aop.array.Type;
/*      */ import org.jboss.aop.introduction.AnnotationIntroduction;
/*      */ import org.jboss.aop.introduction.InterfaceIntroduction;
/*      */ import org.jboss.aop.introduction.InterfaceIntroduction.Mixin;
/*      */ import org.jboss.aop.metadata.ClassMetaDataBinding;
/*      */ import org.jboss.aop.metadata.ClassMetaDataLoader;
/*      */ import org.jboss.aop.pointcut.CFlow;
/*      */ import org.jboss.aop.pointcut.CFlowStack;
/*      */ import org.jboss.aop.pointcut.DeclareDef;
/*      */ import org.jboss.aop.pointcut.Pointcut;
/*      */ import org.jboss.aop.pointcut.PointcutExpression;
/*      */ import org.jboss.aop.pointcut.Typedef;
/*      */ import org.jboss.aop.pointcut.TypedefExpression;
/*      */ import org.jboss.aop.pointcut.ast.ASTCFlowExpression;
/*      */ import org.jboss.aop.pointcut.ast.ASTStart;
/*      */ import org.jboss.aop.pointcut.ast.ParseException;
/*      */ import org.jboss.aop.pointcut.ast.PointcutExpressionParser;
/*      */ import org.jboss.aop.pointcut.ast.TypeExpressionParser;
/*      */ import org.jboss.aop.util.XmlHelper;
/*      */ import org.jboss.aop.util.logging.AOPLogger;
/*      */ import org.jboss.logging.Logger;
/*      */ import org.jboss.util.xml.XmlLoadable;
/*      */ import org.w3c.dom.Document;
/*      */ import org.w3c.dom.Element;
/*      */ import org.w3c.dom.Node;
/*      */ import org.w3c.dom.NodeList;
/*      */ import org.xml.sax.EntityResolver;
/*      */ import org.xml.sax.InputSource;
/*      */ import org.xml.sax.SAXException;
/*      */ 
/*      */ public class AspectXmlLoader
/*      */   implements XmlLoader
/*      */ {
/*   89 */   private static final Logger logger = AOPLogger.getLogger(AspectXmlLoader.class);
/*      */   protected int counter;
/*      */   protected String defaultBaseName;
/*      */   protected AspectManager manager;
/*   97 */   protected ArrayList<String> bindings = new ArrayList();
/*      */ 
/*   99 */   protected ArrayList<String> factories = new ArrayList();
/*      */ 
/*  101 */   protected ArrayList<String> aspects = new ArrayList();
/*      */   private ClassLoader cl;
/* 1315 */   public static XmlLoaderFactory factory = null;
/*      */ 
/*      */   public void setManager(AspectManager manager)
/*      */   {
/*  109 */     if ((AspectManager.verbose) && (logger.isDebugEnabled())) logger.debug("AspectXMLLoader using manager" + manager);
/*  110 */     this.manager = manager;
/*      */   }
/*      */ 
/*      */   public void setClassLoader(ClassLoader cl)
/*      */   {
/*  117 */     this.cl = cl;
/*      */   }
/*      */ 
/*      */   public ClassLoader getClassLoader()
/*      */   {
/*  122 */     if (this.cl == null)
/*  123 */       return SecurityActions.getContextClassLoader();
/*  124 */     return this.cl;
/*      */   }
/*      */ 
/*      */   private String getName(Element element, String errorHeader)
/*      */   {
/*  132 */     String name = element.getAttribute("name");
/*  133 */     if ((name != null) && (!name.equals("")))
/*      */     {
/*  135 */       return name;
/*      */     }
/*      */ 
/*  138 */     return getName(errorHeader);
/*      */   }
/*      */ 
/*      */   private String getName(String errorHeader)
/*      */   {
/*  144 */     return this.defaultBaseName + this.counter++;
/*      */   }
/*      */ 
/*      */   public void undeployInterceptor(Element element) throws Exception
/*      */   {
/*  149 */     String name = element.getAttribute("name");
/*  150 */     if ((name != null) && (name.trim().equals(""))) name = null;
/*      */ 
/*  152 */     String clazz = element.getAttribute("class");
/*  153 */     if ((clazz != null) && (clazz.trim().equals(""))) clazz = null;
/*  154 */     String factory = element.getAttribute("factory");
/*  155 */     if ((factory != null) && (factory.trim().equals(""))) factory = null;
/*  156 */     if (name == null) name = clazz == null ? factory : clazz;
/*      */ 
/*  158 */     this.aspects.add(name);
/*  159 */     String factoryName = name;
/*      */ 
/*  161 */     this.factories.add(factoryName);
/*      */   }
/*      */ 
/*      */   public InterceptorFactory deployInterceptor(Element element) throws Exception
/*      */   {
/*  166 */     String name = element.getAttribute("name");
/*  167 */     if ((name != null) && (name.trim().equals(""))) name = null;
/*      */ 
/*  169 */     String clazz = element.getAttribute("class");
/*  170 */     if ((clazz != null) && (clazz.trim().equals(""))) clazz = null;
/*  171 */     String factory1 = element.getAttribute("factory");
/*  172 */     if ((factory1 != null) && (factory1.trim().equals(""))) factory1 = null;
/*  173 */     if ((clazz == null) && (factory1 == null)) throw new RuntimeException("Interceptor " + name + " must have a class or factory associated with it.");
/*  174 */     if ((clazz != null) && (factory1 != null)) throw new RuntimeException("Interceptor " + name + " cannot have both the class and factory attribute set.");
/*  175 */     if (name == null) name = clazz == null ? factory1 : clazz;
/*      */ 
/*  177 */     String s = element.getAttribute("scope");
/*  178 */     if ((s != null) && (s.trim().equals(""))) s = null;
/*      */ 
/*  180 */     Scope scope = null;
/*  181 */     if (s != null)
/*      */     {
/*  183 */       scope = ScopeUtil.parse(s);
/*  184 */       if (scope == null) throw new RuntimeException("Illegal scope attribute value: " + s);
/*      */     }
/*  186 */     AspectDefinition def = this.manager.getAspectDefinition(name);
/*      */ 
/*  190 */     if (def != null)
/*      */     {
/*  192 */       if (scope == null) scope = Scope.PER_VM;
/*  193 */       if (scope != def.getScope()) throw new RuntimeException("multiple definitions of <interceptor> " + name + " with different scopes is illegal");
/*      */     }
/*      */     else
/*      */     {
/*      */       AspectFactory aspectFactory;
/*  198 */       if (clazz != null)
/*      */       {
/*  200 */         AspectFactory aspectFactory = new GenericAspectFactory(clazz, element);
/*  201 */         ((AspectFactoryWithClassLoader)aspectFactory).setClassLoader(this.cl);
/*      */       }
/*      */       else
/*      */       {
/*  205 */         aspectFactory = new AspectFactoryDelegator(factory1, element);
/*  206 */         ((AspectFactoryWithClassLoader)aspectFactory).setClassLoader(this.cl);
/*      */       }
/*      */ 
/*  209 */       def = new AspectDefinition(name, scope, aspectFactory);
/*  210 */       this.manager.addAspectDefinition(def);
/*      */     }
/*  212 */     ScopedInterceptorFactory factory = new ScopedInterceptorFactory(def);
/*  213 */     this.manager.addInterceptorFactory(factory.getName(), factory);
/*  214 */     return factory;
/*      */   }
/*      */ 
/*      */   public void undeployAdvice(Element element)
/*      */     throws Exception
/*      */   {
/*  220 */     String name = element.getAttribute("name");
/*  221 */     String aspect = element.getAttribute("aspect");
/*  222 */     String factory = aspect + "." + name;
/*      */ 
/*  224 */     this.factories.add(factory);
/*      */   }
/*      */ 
/*      */   public InterceptorFactory deployAdvice(Element element, AdviceType type) throws Exception
/*      */   {
/*  229 */     String name = element.getAttribute("name");
/*  230 */     String aspect = element.getAttribute("aspect");
/*  231 */     if ((aspect == null) || (aspect.length() < 1))
/*  232 */       throw new RuntimeException("Aspect couldnt be found for element: " + element.getNodeName() + ", typo perhaps?");
/*  233 */     AspectDefinition def = this.manager.getAspectDefinition(aspect);
/*  234 */     if (def == null) throw new RuntimeException("advice " + name + " cannot find aspect " + aspect);
/*      */ 
/*  236 */     AdviceFactory factory = null;
/*  237 */     if (type == null)
/*      */     {
/*  240 */       factory = new AdviceFactory(def, name);
/*      */     }
/*      */     else
/*      */     {
/*  244 */       factory = new AdviceFactory(def, name, type);
/*      */     }
/*      */ 
/*  247 */     this.manager.addInterceptorFactory(factory.getName(), factory);
/*  248 */     return factory;
/*      */   }
/*      */ 
/*      */   public void deployBinding(Element element)
/*      */     throws Exception
/*      */   {
/*  254 */     String name = getName(element, "binding");
/*  255 */     String pointcut = element.getAttribute("pointcut");
/*  256 */     if ((pointcut == null) || (pointcut.trim().equals("")))
/*      */     {
/*  258 */       throw new RuntimeException("Binding must have a pointcut element associated with it.");
/*      */     }
/*  260 */     String cflow = element.getAttribute("cflow");
/*  261 */     if ((cflow != null) && (cflow.trim().equals("")))
/*      */     {
/*  263 */       cflow = null;
/*      */     }
/*  265 */     ASTCFlowExpression cflowExpression = null;
/*  266 */     if (cflow != null)
/*      */     {
/*      */       try
/*      */       {
/*  270 */         cflowExpression = new PointcutExpressionParser(new StringReader(cflow)).CFlowExpression();
/*      */       }
/*      */       catch (ParseException e)
/*      */       {
/*  274 */         throw new RuntimeException(cflow, e);
/*      */       }
/*      */     }
/*  277 */     ArrayList interceptors = loadInterceptors(element);
/*  278 */     InterceptorFactory[] inters = (InterceptorFactory[])interceptors.toArray(new InterceptorFactory[interceptors.size()]);
/*  279 */     Pointcut p = null;
/*      */     try
/*      */     {
/*  282 */       p = new PointcutExpression(getName("binding pointcut "), pointcut);
/*      */     }
/*      */     catch (ParseException ex)
/*      */     {
/*  286 */       throw new RuntimeException("<bind> pointcut expression failed: " + pointcut, ex);
/*      */     }
/*  288 */     AdviceBinding binding = new AdviceBinding(name, p, cflowExpression, cflow, inters);
/*  289 */     this.manager.addBinding(binding);
/*      */   }
/*      */ 
/*      */   public void undeployBinding(Element element) throws Exception
/*      */   {
/*  294 */     String binding = getName(element, "binding");
/*  295 */     if (binding == null) throw new RuntimeException("undeploying Binding that is null!");
/*      */ 
/*  297 */     this.bindings.add(binding);
/*  298 */     unloadInterceptors(element);
/*  299 */     String pointcut = getName("pointcut");
/*  300 */     this.manager.removePointcut(pointcut);
/*      */   }
/*      */ 
/*      */   public void deployArrayBinding(Element element) throws Exception
/*      */   {
/*  305 */     String name = getName(element, "arraybinding");
/*  306 */     String type = element.getAttribute("type");
/*  307 */     if ((type == null) || (type.trim().equals("")))
/*      */     {
/*  309 */       throw new RuntimeException("Binding must have a type");
/*      */     }
/*      */ 
/*  312 */     Type theType = Type.valueOf(type);
/*      */ 
/*  314 */     ArrayList interceptors = loadInterceptors(element);
/*  315 */     InterceptorFactory[] inters = (InterceptorFactory[])(InterceptorFactory[])interceptors.toArray(new InterceptorFactory[interceptors.size()]);
/*  316 */     for (int i = 0; i < inters.length; i++)
/*      */     {
/*  318 */       if (inters[i].getAspect().getScope().equals(Scope.PER_VM))
/*      */         continue;
/*  320 */       throw new RuntimeException("Only PER_VM scoped aspects/interceptors can be used in arraybindings");
/*      */     }
/*      */ 
/*  323 */     ArrayBinding binding = new ArrayBinding(name, inters, theType);
/*  324 */     this.manager.addArrayBinding(binding);
/*      */   }
/*      */ 
/*      */   public void undeployArrayBinding(Element element) throws Exception
/*      */   {
/*  329 */     String binding = getName(element, "arraybinding");
/*  330 */     if (binding == null) throw new RuntimeException("undeploying Arraybinding that is null!");
/*  331 */     this.manager.removeArrayBinding(binding);
/*      */   }
/*      */ 
/*      */   private void deployPrecedence(Element element) throws Exception
/*      */   {
/*  336 */     String name = getName(element, "precedence");
/*      */ 
/*  338 */     ArrayList precedenceEntries = new ArrayList();
/*  339 */     NodeList children2 = element.getChildNodes();
/*  340 */     for (int j = 0; j < children2.getLength(); j++)
/*      */     {
/*  342 */       if (children2.item(j).getNodeType() != 1)
/*      */         continue;
/*  344 */       Element interceptorElement = (Element)children2.item(j);
/*  345 */       String tag2 = interceptorElement.getTagName();
/*  346 */       if (tag2.equals("interceptor-ref"))
/*      */       {
/*  348 */         String iname = interceptorElement.getAttribute("name");
/*  349 */         if ((iname == null) || (iname.length() == 0))
/*      */         {
/*  351 */           throw new RuntimeException("name must be specified for interceptor-ref in precedence declaration");
/*      */         }
/*  353 */         precedenceEntries.add(new PrecedenceDefEntry(iname, null));
/*      */       }
/*  355 */       else if (tag2.equals("advice"))
/*      */       {
/*  357 */         String method = interceptorElement.getAttribute("name");
/*  358 */         String aspect = interceptorElement.getAttribute("aspect");
/*      */ 
/*  360 */         if ((method == null) || (method.length() == 0))
/*      */         {
/*  362 */           throw new RuntimeException("name must be specified for advice in precedence declaration");
/*      */         }
/*      */ 
/*  365 */         if ((aspect == null) || (aspect.length() == 0))
/*      */         {
/*  367 */           throw new RuntimeException("aspect must be specified for advice in precedence declaration");
/*      */         }
/*      */ 
/*  370 */         precedenceEntries.add(new PrecedenceDefEntry(aspect, method));
/*      */       }
/*      */       else
/*      */       {
/*  374 */         throw new RuntimeException("Invalid child element of precedence : " + tag2);
/*      */       }
/*      */ 
/*      */     }
/*      */ 
/*  379 */     PrecedenceDefEntry[] entries = (PrecedenceDefEntry[])precedenceEntries.toArray(new PrecedenceDefEntry[precedenceEntries.size()]);
/*  380 */     this.manager.addPrecedence(new PrecedenceDef(name, entries));
/*      */   }
/*      */ 
/*      */   private ArrayList<InterceptorFactory> loadInterceptors(Element element)
/*      */     throws Exception
/*      */   {
/*  386 */     ArrayList interceptors = new ArrayList();
/*  387 */     NodeList children2 = element.getChildNodes();
/*  388 */     for (int j = 0; j < children2.getLength(); j++)
/*      */     {
/*  390 */       if (children2.item(j).getNodeType() != 1)
/*      */         continue;
/*  392 */       Element interceptorElement = (Element)children2.item(j);
/*  393 */       String tag2 = interceptorElement.getTagName();
/*  394 */       if (tag2.equals("interceptor"))
/*      */       {
/*  396 */         InterceptorFactory factory = deployInterceptor(interceptorElement);
/*  397 */         interceptors.add(factory);
/*      */       }
/*  399 */       else if (tag2.equals("interceptor-ref"))
/*      */       {
/*  401 */         String iname = interceptorElement.getAttribute("name");
/*  402 */         if (iname == null) throw new RuntimeException("interceptor-ref has null name attribute");
/*  403 */         InterceptorFactory factory = this.manager.getInterceptorFactory(iname);
/*  404 */         if (factory == null) throw new RuntimeException("unable to resolve interceptor-ref: " + iname);
/*  405 */         interceptors.add(factory);
/*      */       }
/*  407 */       else if (tag2.equals("stack-ref"))
/*      */       {
/*  409 */         String name = interceptorElement.getAttribute("name");
/*  410 */         AdviceStack stack = this.manager.getAdviceStack(name);
/*  411 */         if (stack == null) throw new Exception("there is no <stack> defined for name: " + name);
/*  412 */         interceptors.addAll(stack.getInterceptorFactories());
/*      */       }
/*      */       else
/*      */       {
/*  416 */         AdviceType type = null;
/*  417 */         if (!tag2.equals("advice"))
/*      */         {
/*      */           try
/*      */           {
/*  421 */             type = (AdviceType)Enum.valueOf(AdviceType.class, tag2.toUpperCase());
/*      */           }
/*      */           catch (IllegalArgumentException e)
/*      */           {
/*  425 */             StringBuffer message = new StringBuffer();
/*  426 */             message.append("unexpected tag inside binding: '");
/*  427 */             message.append(tag2);
/*  428 */             message.append("'\n\t\t\t\t\t   should be one of: \n\t\t\t\t\t\t'interceptor', \n\t\t\t\t\t\t'interceptor-ref', \n\t\t\t\t\t\t'advice', \n\t\t\t\t\t\t'");
/*  429 */             for (AdviceType adviceType : AdviceType.values())
/*      */             {
/*  431 */               message.append(adviceType.getName());
/*  432 */               message.append("', \n\t\t\t\t\t\t'");
/*      */             }
/*  434 */             message.append("stack-ref'.\n");
/*  435 */             throw new RuntimeException(message.toString());
/*      */           }
/*      */         }
/*  438 */         InterceptorFactory factory = deployAdvice(interceptorElement, type);
/*  439 */         interceptors.add(factory);
/*      */       }
/*      */     }
/*      */ 
/*  443 */     return interceptors;
/*      */   }
/*      */ 
/*      */   private void unloadInterceptors(Element element) throws Exception
/*      */   {
/*  448 */     NodeList children2 = element.getChildNodes();
/*  449 */     for (int j = 0; j < children2.getLength(); j++)
/*      */     {
/*  451 */       if (children2.item(j).getNodeType() != 1)
/*      */         continue;
/*  453 */       Element interceptorElement = (Element)children2.item(j);
/*  454 */       String tag2 = interceptorElement.getTagName();
/*  455 */       if (tag2.equals("interceptor"))
/*      */       {
/*  457 */         undeployInterceptor(interceptorElement);
/*      */       }
/*  459 */       if (!tag2.equals("advice"))
/*      */         continue;
/*  461 */       undeployAdvice(interceptorElement);
/*      */     }
/*      */   }
/*      */ 
/*      */   public void undeployAspect(Element pointcut)
/*      */     throws Exception
/*      */   {
/*  469 */     String clazz = pointcut.getAttribute("class");
/*  470 */     if ((clazz == null) || (clazz.trim().equals(""))) clazz = null;
/*  471 */     String name = pointcut.getAttribute("name");
/*  472 */     if ((name == null) || (name.trim().equals(""))) name = clazz;
/*  473 */     if (name == null) return;
/*      */ 
/*  475 */     this.aspects.add(name);
/*      */   }
/*      */ 
/*      */   public AspectDefinition deployAspect(Element element, String type) throws Exception
/*      */   {
/*  480 */     String name = element.getAttribute("name");
/*  481 */     if ((name != null) && (name.trim().equals(""))) name = null;
/*      */ 
/*  483 */     String clazz = element.getAttribute("class");
/*  484 */     if ((clazz != null) && (clazz.trim().equals(""))) clazz = null;
/*  485 */     String factory = element.getAttribute("factory");
/*  486 */     if ((factory != null) && (factory.trim().equals(""))) factory = null;
/*  487 */     if ((clazz == null) && (factory == null)) throw new RuntimeException(type + " " + name + " must have a class or factory associated with it.");
/*  488 */     if ((clazz != null) && (factory != null)) throw new RuntimeException(type + " " + name + " cannot have both the class and factory attribute set.");
/*  489 */     if (name == null) name = clazz == null ? factory : clazz;
/*      */ 
/*  491 */     String s = element.getAttribute("scope");
/*  492 */     if ((s != null) && (s.trim().equals(""))) s = null;
/*      */ 
/*  494 */     Scope scope = null;
/*  495 */     if (s != null)
/*      */     {
/*  497 */       scope = ScopeUtil.parse(s);
/*  498 */       if (scope == null) throw new RuntimeException("Illegal scope attribute value: " + s);
/*      */     }
/*      */     AspectFactory aspectFactory;
/*  501 */     if (clazz != null)
/*      */     {
/*  503 */       AspectFactory aspectFactory = new GenericAspectFactory(clazz, element);
/*  504 */       ((AspectFactoryWithClassLoader)aspectFactory).setClassLoader(this.cl);
/*      */     }
/*      */     else
/*      */     {
/*  508 */       aspectFactory = new AspectFactoryDelegator(factory, element);
/*  509 */       ((AspectFactoryWithClassLoader)aspectFactory).setClassLoader(this.cl);
/*      */     }
/*      */ 
/*  512 */     AspectDefinition def = new AspectDefinition(name, scope, aspectFactory);
/*  513 */     this.manager.addAspectDefinition(def);
/*  514 */     return def;
/*      */   }
/*      */ 
/*      */   public void undeployCFlowStack(Element pointcut) throws Exception
/*      */   {
/*  519 */     String name = pointcut.getAttribute("name");
/*  520 */     this.manager.removeCFlowStack(name);
/*      */   }
/*      */ 
/*      */   public void deployCFlowStack(Element pointcut) throws Exception
/*      */   {
/*  525 */     String name = pointcut.getAttribute("name");
/*  526 */     if ((name != null) && (name.trim().equals(""))) name = null;
/*  527 */     if (name == null) throw new RuntimeException("name required for a cflow-stack");
/*  528 */     CFlowStack stack = new CFlowStack(name);
/*  529 */     NodeList children2 = pointcut.getChildNodes();
/*  530 */     for (int j = 0; j < children2.getLength(); j++)
/*      */     {
/*  532 */       if (children2.item(j).getNodeType() != 1)
/*      */         continue;
/*  534 */       Element cflowElement = (Element)children2.item(j);
/*  535 */       String tag2 = cflowElement.getTagName();
/*  536 */       String expr = cflowElement.getAttribute("expr");
/*  537 */       if ((expr != null) && (expr.trim().equals("")))
/*      */       {
/*  539 */         throw new RuntimeException(tag2 + " requires an expr attribute to be defined");
/*      */       }
/*  541 */       if (tag2.equals("called"))
/*      */       {
/*  543 */         stack.addCFlow(new CFlow(expr, false));
/*      */       }
/*  545 */       if (!tag2.equals("not-called"))
/*      */         continue;
/*  547 */       stack.addCFlow(new CFlow(expr, true));
/*      */     }
/*      */ 
/*  552 */     this.manager.addCFlowStack(stack);
/*      */   }
/*      */ 
/*      */   public void undeployInterceptorStack(Element element)
/*      */     throws Exception
/*      */   {
/*  558 */     String name = element.getAttribute("name");
/*  559 */     unloadInterceptors(element);
/*  560 */     this.manager.removeInterceptorStack(name);
/*      */   }
/*      */ 
/*      */   public void deployInterceptorStack(Element element) throws Exception
/*      */   {
/*  565 */     ArrayList interceptors = loadInterceptors(element);
/*  566 */     String name = element.getAttribute("name");
/*  567 */     AdviceStack stack = new AdviceStack(name, interceptors);
/*  568 */     this.manager.addAdviceStack(stack);
/*      */   }
/*      */ 
/*      */   private ClassMetaDataBinding loadMetaData(Element element)
/*      */     throws Exception
/*      */   {
/*  574 */     String classExpr = element.getAttribute("class");
/*  575 */     String tag = element.getAttribute("tag");
/*  576 */     String name = getName(element, "metadata: " + tag + " " + classExpr);
/*  577 */     ClassMetaDataLoader loader = this.manager.findClassMetaDataLoader(tag);
/*  578 */     return loader.importMetaData(element, name, tag, classExpr);
/*      */   }
/*      */ 
/*      */   public void undeployMetaDataLoader(Element element) throws Exception
/*      */   {
/*  583 */     String tag = element.getAttribute("tag");
/*  584 */     this.manager.removeClassMetaDataLoader(tag);
/*      */   }
/*      */ 
/*      */   public void deployMetaDataLoader(Element element) throws Exception
/*      */   {
/*  589 */     String tag = element.getAttribute("tag");
/*  590 */     String classname = element.getAttribute("class");
/*  591 */     Class clazz = getClassLoader().loadClass(classname);
/*  592 */     ClassMetaDataLoader loader = (ClassMetaDataLoader)clazz.newInstance();
/*  593 */     if ((loader instanceof XmlLoadable))
/*      */     {
/*  595 */       ((XmlLoadable)loader).importXml(element);
/*      */     }
/*  597 */     this.manager.addClassMetaDataLoader(tag, loader);
/*      */   }
/*      */ 
/*      */   public void deployClassMetaData(Element element) throws Exception
/*      */   {
/*  602 */     ClassMetaDataBinding data = loadMetaData(element);
/*  603 */     this.manager.addClassMetaData(data);
/*      */   }
/*      */ 
/*      */   public void undeployClassMetaData(Element element) throws Exception
/*      */   {
/*  608 */     String classExpr = element.getAttribute("class");
/*  609 */     String tag = element.getAttribute("tag");
/*  610 */     String name = getName(element, "metadata: " + tag + " " + classExpr);
/*  611 */     this.manager.removeClassMetaData(name);
/*      */   }
/*      */ 
/*      */   public void undeployPointcut(Element pointcut) throws Exception
/*      */   {
/*  616 */     String name = pointcut.getAttribute("name");
/*  617 */     this.manager.removePointcut(name);
/*      */   }
/*      */ 
/*      */   public void undeployPluggablePointcut(Element pointcut) throws Exception
/*      */   {
/*  622 */     String name = pointcut.getAttribute("name");
/*  623 */     this.manager.removePointcut(name);
/*      */   }
/*      */ 
/*      */   public void deployPluggablePointcut(Element pointcut) throws Exception
/*      */   {
/*  628 */     String name = pointcut.getAttribute("name");
/*  629 */     if ((name == null) || (name.trim().equals("")))
/*      */     {
/*  631 */       throw new RuntimeException("pluggable pointcut declaration must have a name associated with it");
/*      */     }
/*  633 */     String clazz = pointcut.getAttribute("class");
/*  634 */     if ((clazz != null) && (clazz.trim().equals("")))
/*      */     {
/*  636 */       throw new RuntimeException("pluggable pointcut declaration must have an expr associated with it");
/*      */     }
/*      */ 
/*  639 */     Pointcut p = null;
/*      */ 
/*  641 */     Class pClass = null;
/*      */     try
/*      */     {
/*  644 */       pClass = getClassLoader().loadClass(clazz);
/*      */     }
/*      */     catch (ClassNotFoundException e)
/*      */     {
/*  648 */       throw new RuntimeException("pluggable pointcut class not found: " + clazz);
/*      */     }
/*  650 */     p = (Pointcut)pClass.newInstance();
/*  651 */     if ((p instanceof XmlLoadable))
/*      */     {
/*  653 */       ((XmlLoadable)p).importXml(pointcut);
/*      */     }
/*  655 */     this.manager.addPointcut(p);
/*      */   }
/*      */ 
/*      */   public void undeployDynamicCFlow(Element pointcut) throws Exception
/*      */   {
/*  660 */     String name = pointcut.getAttribute("name");
/*  661 */     this.manager.removeDynamicCFlow(name);
/*      */   }
/*      */ 
/*      */   public void deployDynamicCFlow(Element pointcut) throws Exception
/*      */   {
/*  666 */     String name = pointcut.getAttribute("name");
/*  667 */     if ((name == null) || (name.trim().equals("")))
/*      */     {
/*  669 */       throw new RuntimeException("dynamic cflow declaration must have a name associated with it");
/*      */     }
/*  671 */     String clazz = pointcut.getAttribute("class");
/*  672 */     if ((clazz != null) && (clazz.trim().equals("")))
/*      */     {
/*  674 */       throw new RuntimeException("dynamic cflow declaration must have an expr associated with it");
/*      */     }
/*      */ 
/*  677 */     this.manager.addDynamicCFlow(name, new DynamicCFlowDefinition(pointcut, clazz, name));
/*      */   }
/*      */ 
/*      */   public void deployPointcut(Element pointcut) throws Exception
/*      */   {
/*  682 */     String name = pointcut.getAttribute("name");
/*  683 */     if ((name == null) || (name.trim().equals("")))
/*      */     {
/*  685 */       throw new RuntimeException("pointcut declaration must have a name associated with it");
/*      */     }
/*  687 */     String expr = pointcut.getAttribute("expr");
/*  688 */     if ((expr == null) || (expr.trim().equals("")))
/*      */     {
/*  690 */       throw new RuntimeException("pointcut declaration must have an expr associated with it");
/*      */     }
/*  692 */     Pointcut p = null;
/*      */     try
/*      */     {
/*  695 */       p = new PointcutExpression(name, expr);
/*      */     }
/*      */     catch (ParseException ex)
/*      */     {
/*  699 */       throw new RuntimeException("<pointcut name='" + name + "' expr='" + expr + "'/> failed", ex);
/*      */     }
/*  701 */     this.manager.addPointcut(p);
/*      */   }
/*      */ 
/*      */   public void undeployPrepare(Element pointcut) throws Exception
/*      */   {
/*  706 */     String name = getName(pointcut, "prepare");
/*  707 */     this.manager.removePointcut(name);
/*      */   }
/*      */ 
/*      */   public void deployPrepare(Element pointcut) throws Exception
/*      */   {
/*  712 */     String name = getName(pointcut, "prepare");
/*  713 */     String expr = pointcut.getAttribute("expr");
/*  714 */     if ((expr != null) && (expr.trim().equals("")))
/*      */     {
/*  716 */       throw new RuntimeException("pointcut declaration must have an expr associated with it");
/*      */     }
/*  718 */     Pointcut p = null;
/*      */     try
/*      */     {
/*  721 */       p = new PointcutExpression(name, expr);
/*      */     }
/*      */     catch (ParseException ex)
/*      */     {
/*  725 */       throw new RuntimeException("<prepare> failed: " + expr, ex);
/*      */     }
/*  727 */     this.manager.addPointcut(p);
/*      */   }
/*      */ 
/*      */   public void undeployArrayReplacement(Element pointcut) throws Exception
/*      */   {
/*  732 */     String name = getName(pointcut, "arrayReplacement");
/*  733 */     this.manager.removeArrayReplacement(name);
/*      */   }
/*      */ 
/*      */   public void deployArrayReplacement(Element pointcut) throws Exception
/*      */   {
/*  738 */     String name = getName(pointcut, "arrayReplacement");
/*  739 */     String classExpr = pointcut.getAttribute("class");
/*  740 */     if ((classExpr != null) && (classExpr.trim().equals("")))
/*      */     {
/*  742 */       classExpr = null;
/*      */     }
/*      */ 
/*  745 */     String ast = pointcut.getAttribute("expr");
/*  746 */     if ((ast != null) && (ast.trim().equals("")))
/*      */     {
/*  748 */       ast = null;
/*      */     }
/*      */ 
/*  751 */     if ((classExpr == null) && (ast == null))
/*      */     {
/*  753 */       throw new RuntimeException("A class nor a expr attribute is defined for this <arrayreplacement>");
/*      */     }
/*      */ 
/*  756 */     if ((classExpr != null) && (ast != null))
/*      */     {
/*  758 */       throw new RuntimeException("You cannot define both a class and expr attribute in the same <arrayreplacement>");
/*      */     }
/*      */ 
/*  761 */     ArrayReplacement pcut = null;
/*  762 */     if (classExpr != null)
/*      */     {
/*  764 */       pcut = new ArrayReplacement(name, classExpr);
/*      */     }
/*      */     else
/*      */     {
/*  768 */       ASTStart start = new TypeExpressionParser(new StringReader(ast)).Start();
/*  769 */       pcut = new ArrayReplacement(name, start);
/*      */     }
/*  771 */     this.manager.addArrayReplacement(pcut);
/*      */   }
/*      */ 
/*      */   public void deployAnnotationIntroduction(Element pointcut)
/*      */     throws Exception
/*      */   {
/*  777 */     this.manager.addAnnotationIntroduction(loadAnnotationIntroduction(pointcut));
/*      */   }
/*      */ 
/*      */   public void deployAnnotationOverride(Element pointcut) throws Exception
/*      */   {
/*  782 */     this.manager.addAnnotationOverride(loadAnnotationIntroduction(pointcut));
/*      */   }
/*      */ 
/*      */   public void undeployAnnotationIntroduction(Element pointcut) throws Exception
/*      */   {
/*  787 */     this.manager.removeAnnotationIntroduction(loadAnnotationIntroduction(pointcut));
/*      */   }
/*      */ 
/*      */   public void undeployAnnotationOverride(Element pointcut) throws Exception
/*      */   {
/*  792 */     this.manager.removeAnnotationOverride(loadAnnotationIntroduction(pointcut));
/*      */   }
/*      */ 
/*      */   public AnnotationIntroduction loadAnnotationIntroduction(Element pointcut) throws Exception
/*      */   {
/*  797 */     String expr = pointcut.getAttribute("expr");
/*  798 */     if ((expr != null) && (expr.trim().equals("")))
/*      */     {
/*  800 */       throw new RuntimeException("annotation introduction must have an expr attribute");
/*      */     }
/*      */ 
/*  803 */     String invisible = pointcut.getAttribute("invisible");
/*  804 */     if ((invisible != null) && (expr.trim().equals("")))
/*      */     {
/*  806 */       throw new RuntimeException("annotation introduction must have an invisible attribute");
/*      */     }
/*      */ 
/*  809 */     boolean isInvisble = new Boolean(invisible).booleanValue();
/*      */ 
/*  811 */     String annotation = XmlHelper.getElementContent(pointcut);
/*      */ 
/*  813 */     return AnnotationIntroduction.createComplexAnnotationIntroduction(expr, annotation, isInvisble);
/*      */   }
/*      */ 
/*      */   public void undeployIntroductionPointcut(Element pointcut) throws Exception
/*      */   {
/*  818 */     String name = getName(pointcut, "introduction-pointcut");
/*      */ 
/*  820 */     this.manager.removeInterfaceIntroduction(name);
/*      */   }
/*      */ 
/*      */   public void deployIntroductionPointcut(Element pointcut) throws Exception
/*      */   {
/*  825 */     String name = getName(pointcut, "introduction");
/*  826 */     String classExpr = pointcut.getAttribute("class");
/*  827 */     if ((classExpr != null) && (classExpr.trim().equals("")))
/*      */     {
/*  829 */       classExpr = null;
/*      */     }
/*      */ 
/*  832 */     String ast = pointcut.getAttribute("expr");
/*  833 */     if ((ast != null) && (ast.trim().equals("")))
/*      */     {
/*  835 */       ast = null;
/*      */     }
/*      */ 
/*  839 */     if ((classExpr == null) && (ast == null))
/*      */     {
/*  841 */       throw new RuntimeException("A class nor a expr attribute is defined for this <introduction>");
/*      */     }
/*      */ 
/*  844 */     if ((classExpr != null) && (ast != null))
/*      */     {
/*  846 */       throw new RuntimeException("You cannot define both a class and expr attribute in the same <introduction>");
/*      */     }
/*      */ 
/*  849 */     String intfs = XmlHelper.getOptionalChildContent(pointcut, "interfaces");
/*  850 */     String[] ifaces = null;
/*  851 */     if (intfs != null)
/*      */     {
/*  853 */       StringTokenizer tokenizer = new StringTokenizer(intfs, ",");
/*  854 */       ArrayList interfaces = new ArrayList();
/*  855 */       while (tokenizer.hasMoreTokens())
/*      */       {
/*  857 */         String intf = tokenizer.nextToken().trim();
/*  858 */         if (!intf.equals("")) interfaces.add(intf);
/*      */       }
/*  860 */       ifaces = (String[])interfaces.toArray(new String[interfaces.size()]);
/*      */     }
/*      */ 
/*  863 */     InterfaceIntroduction pcut = null;
/*  864 */     if (classExpr != null)
/*      */     {
/*  866 */       pcut = new InterfaceIntroduction(name, classExpr, ifaces);
/*      */     }
/*      */     else
/*      */     {
/*  870 */       ASTStart start = new TypeExpressionParser(new StringReader(ast)).Start();
/*  871 */       pcut = new InterfaceIntroduction(name, start, ifaces);
/*      */     }
/*  873 */     Iterator it = XmlHelper.getChildrenByTagName(pointcut, "mixin");
/*  874 */     while (it.hasNext())
/*      */     {
/*  876 */       Element mixin = (Element)it.next();
/*  877 */       if (mixin != null)
/*      */       {
/*  879 */         String construction = XmlHelper.getOptionalChildContent(mixin, "construction");
/*  880 */         String classname = XmlHelper.getUniqueChildContent(mixin, "class");
/*  881 */         String isTransientString = mixin.getAttribute("transient");
/*  882 */         boolean isTransient = true;
/*  883 */         if ((isTransientString == null) || (isTransientString.trim().equals("")))
/*      */         {
/*  885 */           isTransient = true;
/*      */         }
/*      */         else
/*      */         {
/*  889 */           isTransient = new Boolean(isTransientString).booleanValue();
/*      */         }
/*      */ 
/*  892 */         intfs = XmlHelper.getUniqueChildContent(mixin, "interfaces");
/*  893 */         StringTokenizer tokenizer = new StringTokenizer(intfs, ",");
/*  894 */         ArrayList interfaces = new ArrayList();
/*  895 */         while (tokenizer.hasMoreTokens())
/*      */         {
/*  897 */           String intf = tokenizer.nextToken().trim();
/*  898 */           if (!intf.equals("")) interfaces.add(intf);
/*      */         }
/*  900 */         ifaces = (String[])interfaces.toArray(new String[interfaces.size()]);
/*  901 */         pcut.getMixins().add(new InterfaceIntroduction.Mixin(classname, ifaces, construction, isTransient));
/*      */       }
/*      */     }
/*  904 */     this.manager.addInterfaceIntroduction(pcut);
/*      */   }
/*      */ 
/*      */   public void deployTypedef(Element pointcut) throws Exception
/*      */   {
/*  909 */     String name = pointcut.getAttribute("name");
/*  910 */     if ((name == null) || (name.trim().equals("")))
/*      */     {
/*  912 */       throw new RuntimeException("typedef declaration must have a name associated with it");
/*      */     }
/*  914 */     String expr = pointcut.getAttribute("expr");
/*  915 */     if ((expr == null) || (expr.trim().equals("")))
/*      */     {
/*  917 */       throw new RuntimeException("typedef declaration must have an expr associated with it");
/*      */     }
/*      */ 
/*      */     try
/*      */     {
/*  922 */       Typedef typedef = new TypedefExpression(name, expr);
/*  923 */       this.manager.addTypedef(typedef);
/*      */     }
/*      */     catch (ParseException ex)
/*      */     {
/*  927 */       throw new RuntimeException("<typedef name='" + name + "' expr='" + expr + "'/> failed", ex);
/*      */     }
/*      */   }
/*      */ 
/*      */   public void undeployTypedef(Element pointcut) throws Exception
/*      */   {
/*  933 */     String name = pointcut.getAttribute("name");
/*  934 */     this.manager.removeTypedef(name);
/*      */   }
/*      */ 
/*      */   public void deployDeclare(Element pointcut, String tagName) throws Exception
/*      */   {
/*  939 */     String name = getName(pointcut, "declare");
/*  940 */     String expr = pointcut.getAttribute("expr");
/*  941 */     if ((expr == null) || (expr.trim().equals("")))
/*      */     {
/*  943 */       throw new RuntimeException("declare declaration must have an expr associated with it");
/*      */     }
/*      */ 
/*  946 */     boolean warning = tagName.equals("declare-warning");
/*  947 */     String msg = XmlHelper.getElementContent(pointcut);
/*      */     try
/*      */     {
/*  952 */       DeclareDef declare = new DeclareDef(name, expr, warning, msg);
/*  953 */       this.manager.addDeclare(declare);
/*      */     }
/*      */     catch (ParseException ex)
/*      */     {
/*  957 */       throw new RuntimeException("<declare name='" + name + "' expr='" + expr + "'/> failed", ex);
/*      */     }
/*      */   }
/*      */ 
/*      */   public void undeployDeclare(Element pointcut) throws Exception
/*      */   {
/*  963 */     String name = getName(pointcut, "declare");
/*  964 */     this.manager.removeDeclare(name);
/*      */   }
/*      */ 
/*      */   private void setupDefaultName(URL url)
/*      */     throws Exception
/*      */   {
/*  970 */     if (url == null) return;
/*  971 */     this.counter = 0;
/*  972 */     this.defaultBaseName = url.toString();
/*      */   }
/*      */ 
/*      */   public void deployXML(Document doc, URL url, ClassLoader cl) throws Exception
/*      */   {
/*  977 */     setClassLoader(cl);
/*  978 */     deployXML(doc, url);
/*      */   }
/*      */ 
/*      */   public void deployXML(Document doc, URL url) throws Exception
/*      */   {
/*  983 */     setupDefaultName(url);
/*  984 */     Element top = doc.getDocumentElement();
/*      */     try
/*      */     {
/*  987 */       deployTopElements(top);
/*      */     }
/*      */     catch (Exception e)
/*      */     {
/*  991 */       System.err.println("[error] " + e.getMessage() + " " + url);
/*  992 */       if (AspectManager.verbose) e.printStackTrace();
/*  993 */       throw new RuntimeException(e);
/*      */     }
/*      */   }
/*      */ 
/*      */   public void deployDomain(Element element) throws Exception
/*      */   {
/*  999 */     String name = element.getAttribute("name");
/* 1000 */     if ((name == null) || (name.trim().equals("")))
/*      */     {
/* 1002 */       throw new RuntimeException("domain declaration must have a name associated with it");
/*      */     }
/*      */ 
/* 1005 */     boolean parentFirst = false;
/* 1006 */     String parentFirstString = element.getAttribute("parentFirst");
/* 1007 */     if ((parentFirstString == null) || (parentFirstString.trim().equals("")))
/*      */     {
/* 1009 */       parentFirst = false;
/*      */     }
/*      */     else
/*      */     {
/* 1013 */       parentFirst = new Boolean(parentFirstString).booleanValue();
/*      */     }
/*      */ 
/* 1016 */     boolean inheritDefs = true;
/* 1017 */     String inheritDefsString = element.getAttribute("inheritDefinitions");
/* 1018 */     if ((inheritDefsString == null) || (inheritDefsString.trim().equals("")))
/*      */     {
/* 1020 */       inheritDefs = true;
/*      */     }
/*      */     else
/*      */     {
/* 1024 */       inheritDefs = new Boolean(inheritDefsString).booleanValue();
/*      */     }
/*      */ 
/* 1027 */     boolean inheritBindings = false;
/* 1028 */     String inheritBindingsString = element.getAttribute("inheritBindings");
/* 1029 */     if ((inheritBindingsString == null) || (inheritBindingsString.trim().equals("")))
/*      */     {
/* 1031 */       inheritBindings = false;
/*      */     }
/*      */     else
/*      */     {
/* 1035 */       inheritBindings = new Boolean(inheritBindingsString).booleanValue();
/*      */     }
/*      */ 
/* 1038 */     AspectManager parent = this.manager;
/* 1039 */     String extend = element.getAttribute("extends");
/* 1040 */     if ((extend != null) && (!extend.trim().equals("")))
/*      */     {
/* 1042 */       extend = extend.trim();
/* 1043 */       DomainDefinition parentDef = this.manager.getContainer(extend);
/* 1044 */       if (parentDef == null) throw new RuntimeException("unable to find parent Domain: " + extend);
/* 1045 */       parent = parentDef.getManager();
/*      */     }
/*      */ 
/* 1048 */     DomainDefinition def = new DomainDefinition(name, parent, parentFirst, inheritDefs, inheritBindings);
/* 1049 */     AspectManager push = this.manager;
/*      */     try
/*      */     {
/* 1052 */       this.manager = def.getManager();
/* 1053 */       deployTopElements(element);
/*      */     }
/*      */     finally
/*      */     {
/* 1057 */       this.manager = push;
/*      */     }
/* 1059 */     push.addContainer(def);
/*      */   }
/*      */ 
/*      */   public void undeployDomain(Element element) throws Exception
/*      */   {
/* 1064 */     String name = element.getAttribute("name");
/* 1065 */     if ((name == null) || (name.trim().equals("")))
/*      */     {
/* 1067 */       throw new RuntimeException("container declaration must have a name associated with it");
/*      */     }
/*      */ 
/* 1070 */     DomainDefinition def = this.manager.getContainer(name);
/* 1071 */     if (def == null) throw new RuntimeException("Unable to undeploy container: " + name);
/* 1072 */     AspectManager push = this.manager;
/* 1073 */     ArrayList oldFactories = this.factories;
/* 1074 */     ArrayList oldAspects = this.aspects;
/* 1075 */     ArrayList oldBindings = this.bindings;
/*      */     try
/*      */     {
/* 1078 */       this.factories = new ArrayList();
/* 1079 */       this.aspects = new ArrayList();
/* 1080 */       this.bindings = new ArrayList();
/* 1081 */       this.manager = def.getManager();
/* 1082 */       undeployTopElements(element);
/* 1083 */       bulkUndeploy();
/*      */     }
/*      */     finally
/*      */     {
/* 1087 */       this.manager = push;
/*      */     }
/* 1089 */     push.removeContainer(name);
/* 1090 */     this.factories = oldFactories;
/* 1091 */     this.aspects = oldAspects;
/* 1092 */     this.bindings = oldBindings;
/*      */   }
/*      */ 
/*      */   private void deployTopElements(Element top)
/*      */     throws Exception
/*      */   {
/* 1098 */     NodeList children = top.getChildNodes();
/* 1099 */     for (int i = 0; i < children.getLength(); i++)
/*      */     {
/* 1101 */       if (children.item(i).getNodeType() != 1)
/*      */         continue;
/* 1103 */       Element element = (Element)children.item(i);
/* 1104 */       String tag = element.getTagName();
/* 1105 */       if (tag.equals("interceptor"))
/*      */       {
/* 1107 */         deployInterceptor(element);
/*      */       }
/* 1109 */       else if (tag.equals("introduction"))
/*      */       {
/* 1111 */         deployIntroductionPointcut(element);
/*      */       }
/* 1113 */       else if (tag.equals("metadata-loader"))
/*      */       {
/* 1115 */         deployMetaDataLoader(element);
/*      */       }
/* 1117 */       else if (tag.equals("metadata"))
/*      */       {
/* 1119 */         deployClassMetaData(element);
/*      */       }
/* 1121 */       else if (tag.equals("stack"))
/*      */       {
/* 1123 */         deployInterceptorStack(element);
/*      */       }
/* 1125 */       else if (tag.equals("aspect"))
/*      */       {
/* 1127 */         deployAspect(element, "Aspect");
/*      */       }
/* 1129 */       else if (tag.equals("pointcut"))
/*      */       {
/* 1131 */         deployPointcut(element);
/*      */       }
/* 1133 */       else if (tag.equals("pluggable-pointcut"))
/*      */       {
/* 1135 */         deployPluggablePointcut(element);
/*      */       }
/* 1137 */       else if (tag.equals("bind"))
/*      */       {
/* 1139 */         deployBinding(element);
/*      */       }
/* 1141 */       else if (tag.equals("prepare"))
/*      */       {
/* 1143 */         deployPrepare(element);
/*      */       }
/* 1145 */       else if (tag.equals("cflow-stack"))
/*      */       {
/* 1147 */         deployCFlowStack(element);
/*      */       }
/* 1149 */       else if (tag.equals("dynamic-cflow"))
/*      */       {
/* 1151 */         deployDynamicCFlow(element);
/*      */       }
/* 1153 */       else if (tag.equals("annotation-introduction"))
/*      */       {
/* 1155 */         deployAnnotationIntroduction(element);
/*      */       }
/* 1157 */       else if (tag.equals("annotation"))
/*      */       {
/* 1159 */         deployAnnotationOverride(element);
/*      */       }
/* 1161 */       else if (tag.equals("typedef"))
/*      */       {
/* 1163 */         deployTypedef(element);
/*      */       }
/* 1165 */       else if (tag.equals("domain"))
/*      */       {
/* 1167 */         deployDomain(element);
/*      */       }
/* 1169 */       else if (tag.equals("precedence"))
/*      */       {
/* 1171 */         deployPrecedence(element);
/*      */       }
/* 1173 */       else if ((tag.equals("declare-error")) || (tag.equals("declare-warning")))
/*      */       {
/* 1175 */         deployDeclare(element, tag);
/*      */       } else {
/* 1177 */         if (tag.equals("loader-repository"))
/*      */         {
/*      */           continue;
/*      */         }
/* 1181 */         if (tag.equals("arrayreplacement"))
/*      */         {
/* 1183 */           deployArrayReplacement(element);
/*      */         }
/* 1185 */         else if (tag.equals("arraybind"))
/*      */         {
/* 1187 */           deployArrayBinding(element);
/*      */         }
/*      */         else
/*      */         {
/* 1191 */           throw new IllegalArgumentException("Unknown AOP tag: " + tag);
/*      */         }
/*      */       }
/*      */     }
/*      */   }
/*      */ 
/*      */   public void undeployXML(Document doc, URL url)
/*      */     throws Exception
/*      */   {
/* 1200 */     setupDefaultName(url);
/* 1201 */     undeployTopElements(doc.getDocumentElement());
/*      */ 
/* 1203 */     bulkUndeploy();
/*      */   }
/*      */ 
/*      */   private void bulkUndeploy()
/*      */   {
/* 1212 */     this.manager.removeBindings(this.bindings);
/* 1213 */     for (int i = 0; i < this.factories.size(); i++)
/*      */     {
/* 1215 */       String factory = (String)this.factories.get(i);
/* 1216 */       this.manager.removeInterceptorFactory(factory);
/*      */     }
/* 1218 */     for (int i = 0; i < this.aspects.size(); i++)
/*      */     {
/* 1220 */       String aspect = (String)this.aspects.get(i);
/* 1221 */       this.manager.removeAspectDefinition(aspect);
/*      */     }
/*      */   }
/*      */ 
/*      */   private void undeployTopElements(Element top)
/*      */     throws Exception
/*      */   {
/* 1228 */     NodeList children = top.getChildNodes();
/* 1229 */     for (int i = 0; i < children.getLength(); i++)
/*      */     {
/* 1231 */       if (children.item(i).getNodeType() != 1)
/*      */         continue;
/* 1233 */       Element element = (Element)children.item(i);
/* 1234 */       String tag = element.getTagName();
/* 1235 */       if (tag.equals("interceptor"))
/*      */       {
/* 1237 */         undeployInterceptor(element);
/*      */       }
/* 1239 */       else if (tag.equals("introduction"))
/*      */       {
/* 1241 */         undeployIntroductionPointcut(element);
/*      */       }
/* 1243 */       else if (tag.equals("metadata-loader"))
/*      */       {
/* 1245 */         undeployMetaDataLoader(element);
/*      */       }
/* 1247 */       else if (tag.equals("metadata"))
/*      */       {
/* 1249 */         undeployClassMetaData(element);
/*      */       }
/* 1251 */       else if (tag.equals("stack"))
/*      */       {
/* 1253 */         undeployInterceptorStack(element);
/*      */       }
/* 1255 */       else if (tag.equals("aspect"))
/*      */       {
/* 1257 */         undeployAspect(element);
/*      */       }
/* 1259 */       else if (tag.equals("pointcut"))
/*      */       {
/* 1261 */         undeployPointcut(element);
/*      */       }
/* 1263 */       else if (tag.equals("bind"))
/*      */       {
/* 1265 */         undeployBinding(element);
/*      */       }
/* 1267 */       else if (tag.equals("prepare"))
/*      */       {
/* 1269 */         undeployPrepare(element);
/*      */       }
/* 1271 */       else if (tag.equals("cflow-stack"))
/*      */       {
/* 1273 */         undeployCFlowStack(element);
/*      */       }
/* 1275 */       else if (tag.equals("pluggable-pointcut"))
/*      */       {
/* 1277 */         undeployPluggablePointcut(element);
/*      */       }
/* 1279 */       else if (tag.equals("dynamic-cflow"))
/*      */       {
/* 1281 */         undeployDynamicCFlow(element);
/*      */       }
/* 1283 */       else if (tag.equals("typedef"))
/*      */       {
/* 1285 */         undeployTypedef(element);
/*      */       }
/* 1287 */       else if (tag.equals("annotation-introduction"))
/*      */       {
/* 1289 */         undeployAnnotationIntroduction(element);
/*      */       }
/* 1291 */       else if (tag.equals("annotation"))
/*      */       {
/* 1293 */         undeployAnnotationOverride(element);
/*      */       }
/* 1295 */       else if (tag.equals("domain"))
/*      */       {
/* 1297 */         undeployDomain(element);
/*      */       }
/* 1299 */       else if ((tag.equals("declare-error")) || (tag.equals("declare-warning")))
/*      */       {
/* 1301 */         undeployDeclare(element);
/*      */       }
/* 1303 */       else if (tag.equals("arrayreplacement"))
/*      */       {
/* 1305 */         undeployArrayReplacement(element);
/*      */       } else {
/* 1307 */         if (!tag.equals("arraybind"))
/*      */           continue;
/* 1309 */         undeployArrayBinding(element);
/*      */       }
/*      */     }
/*      */   }
/*      */ 
/*      */   public void deploy(URL url, AspectManager manager, ClassLoader cl)
/*      */     throws Exception
/*      */   {
/* 1320 */     setClassLoader(cl);
/* 1321 */     deploy(url, manager);
/*      */   }
/*      */ 
/*      */   public void deploy(URL url, AspectManager manager) throws Exception
/*      */   {
/* 1326 */     setManager(manager);
/* 1327 */     deployXML(loadURL(url), url);
/*      */   }
/*      */ 
/*      */   public void undeploy(URL url, AspectManager manager) throws Exception
/*      */   {
/* 1332 */     setManager(manager);
/* 1333 */     undeployXML(loadURL(url), url);
/*      */   }
/*      */ 
/*      */   public static void deployXML(URL url) throws Exception
/*      */   {
/* 1338 */     deployXML(url, null, AspectManager.instance());
/*      */   }
/*      */ 
/*      */   @Deprecated
/*      */   public static void deployXML(URL url, ClassLoader cl)
/*      */     throws Exception
/*      */   {
/* 1347 */     XmlLoader loader = null;
/* 1348 */     if (factory == null)
/*      */     {
/* 1350 */       loader = new AspectXmlLoader();
/*      */     }
/*      */     else
/*      */     {
/* 1354 */       loader = factory.create();
/*      */     }
/* 1356 */     loader.setClassLoader(cl);
/* 1357 */     deployXML(url, cl, AspectManager.instance());
/*      */   }
/*      */ 
/*      */   public static void deployXML(URL url, ClassLoader cl, AspectManager manager) throws Exception
/*      */   {
/* 1362 */     XmlLoader loader = null;
/* 1363 */     if (factory == null)
/*      */     {
/* 1365 */       loader = new AspectXmlLoader();
/*      */     }
/*      */     else
/*      */     {
/* 1369 */       loader = factory.create();
/*      */     }
/* 1371 */     loader.setClassLoader(cl);
/* 1372 */     loader.deploy(url, manager);
/*      */   }
/*      */ 
/*      */   public static void undeployXML(URL url) throws Exception
/*      */   {
/* 1377 */     undeployXML(url, AspectManager.instance());
/*      */   }
/*      */ 
/*      */   public static void undeployXML(URL url, AspectManager manager) throws Exception
/*      */   {
/* 1382 */     XmlLoader loader = null;
/* 1383 */     if (factory == null)
/*      */     {
/* 1385 */       loader = new AspectXmlLoader();
/*      */     }
/*      */     else
/*      */     {
/* 1389 */       loader = factory.create();
/*      */     }
/* 1391 */     loader.undeploy(url, manager);
/*      */   }
/*      */ 
/*      */   public static Document loadURL(URL configURL)
/*      */     throws Exception
/*      */   {
/* 1418 */     InputStream is = configURL != null ? configURL.openStream() : null;
/* 1419 */     if (is == null) {
/* 1420 */       throw new IOException("Failed to obtain InputStream from url: " + configURL);
/*      */     }
/* 1422 */     return loadDocument(is);
/*      */   }
/*      */ 
/*      */   public static Document loadDocument(InputStream is)
/*      */     throws ParserConfigurationException, SAXException, IOException
/*      */   {
/* 1428 */     DocumentBuilderFactory docBuilderFactory = null;
/* 1429 */     docBuilderFactory = DocumentBuilderFactory.newInstance();
/* 1430 */     docBuilderFactory.setValidating(false);
/* 1431 */     InputSource source = new InputSource(is);
/* 1432 */     URL url = AspectXmlLoader.class.getResource("/jboss-aop_1_0.dtd");
/* 1433 */     source.setSystemId(url.toString());
/* 1434 */     DocumentBuilder docBuilder = docBuilderFactory.newDocumentBuilder();
/* 1435 */     docBuilder.setEntityResolver(new Resolver(null));
/*      */ 
/* 1437 */     Document doc = docBuilder.parse(source);
/* 1438 */     return doc;
/*      */   }
/*      */ 
/*      */   private static class Resolver
/*      */     implements EntityResolver
/*      */   {
/*      */     public InputSource resolveEntity(String publicId, String systemId)
/*      */       throws SAXException, IOException
/*      */     {
/* 1398 */       if (systemId.endsWith("jboss-aop_1_0.dtd"))
/*      */       {
/*      */         try
/*      */         {
/* 1402 */           URL url = AspectXmlLoader.class.getResource("/jboss-aop_1_0.dtd");
/* 1403 */           InputStream is = url.openStream();
/* 1404 */           return new InputSource(is);
/*      */         }
/*      */         catch (IOException e)
/*      */         {
/* 1408 */           e.printStackTrace();
/* 1409 */           return null;
/*      */         }
/*      */       }
/* 1412 */       return null;
/*      */     }
/*      */   }
/*      */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.aop.AspectXmlLoader
 * JD-Core Version:    0.6.0
 */