/*      */ package org.jboss.aop;
/*      */ 
/*      */ import java.lang.ref.WeakReference;
/*      */ import java.lang.reflect.Field;
/*      */ import java.security.AccessController;
/*      */ import java.security.PrivilegedAction;
/*      */ import java.security.ProtectionDomain;
/*      */ import java.util.ArrayList;
/*      */ import java.util.Collection;
/*      */ import java.util.HashMap;
/*      */ import java.util.HashSet;
/*      */ import java.util.Iterator;
/*      */ import java.util.LinkedHashMap;
/*      */ import java.util.List;
/*      */ import java.util.Map;
/*      */ import java.util.Set;
/*      */ import java.util.StringTokenizer;
/*      */ import java.util.WeakHashMap;
/*      */ import java.util.concurrent.ConcurrentHashMap;
/*      */ import java.util.concurrent.locks.ReentrantReadWriteLock;
/*      */ import java.util.concurrent.locks.ReentrantReadWriteLock.WriteLock;
/*      */ import javassist.ClassPool;
/*      */ import javassist.CtClass;
/*      */ import javassist.scopedpool.ScopedClassPool;
/*      */ import javassist.scopedpool.ScopedClassPoolFactory;
/*      */ import org.jboss.aop.advice.AdviceBinding;
/*      */ import org.jboss.aop.advice.AdviceStack;
/*      */ import org.jboss.aop.advice.AspectDefinition;
/*      */ import org.jboss.aop.advice.AspectFactory;
/*      */ import org.jboss.aop.advice.AspectFactoryWithClassLoader;
/*      */ import org.jboss.aop.advice.DynamicCFlowDefinition;
/*      */ import org.jboss.aop.advice.InterceptorFactory;
/*      */ import org.jboss.aop.advice.PrecedenceDef;
/*      */ import org.jboss.aop.advice.PrecedenceDefEntry;
/*      */ import org.jboss.aop.advice.PrecedenceSorter;
/*      */ import org.jboss.aop.advice.Scope;
/*      */ import org.jboss.aop.array.ArrayAdvisor;
/*      */ import org.jboss.aop.array.ArrayBinding;
/*      */ import org.jboss.aop.array.ArrayReplacement;
/*      */ import org.jboss.aop.classpool.AOPClassLoaderScopingPolicy;
/*      */ import org.jboss.aop.classpool.AOPClassPoolRepository;
/*      */ import org.jboss.aop.instrument.GeneratedAdvisorInstrumentor;
/*      */ import org.jboss.aop.instrument.InstrumentorFactory;
/*      */ import org.jboss.aop.instrument.TransformerCommon;
/*      */ import org.jboss.aop.introduction.AnnotationIntroduction;
/*      */ import org.jboss.aop.introduction.InterfaceIntroduction;
/*      */ import org.jboss.aop.metadata.ClassMetaDataBinding;
/*      */ import org.jboss.aop.metadata.ClassMetaDataLoader;
/*      */ import org.jboss.aop.metadata.SimpleClassMetaDataLoader;
/*      */ import org.jboss.aop.microcontainer.lifecycle.LifecycleCallbackBinding;
/*      */ import org.jboss.aop.microcontainer.lifecycle.LifecycleManager;
/*      */ import org.jboss.aop.pointcut.CFlowStack;
/*      */ import org.jboss.aop.pointcut.DeclareDef;
/*      */ import org.jboss.aop.pointcut.DynamicCFlow;
/*      */ import org.jboss.aop.pointcut.Pointcut;
/*      */ import org.jboss.aop.pointcut.PointcutExpression;
/*      */ import org.jboss.aop.pointcut.PointcutInfo;
/*      */ import org.jboss.aop.pointcut.PointcutStats;
/*      */ import org.jboss.aop.pointcut.Typedef;
/*      */ import org.jboss.aop.pointcut.ast.ClassExpression;
/*      */ import org.jboss.aop.util.UnmodifiableEmptyCollections;
/*      */ import org.jboss.aop.util.logging.AOPLogger;
/*      */ import org.jboss.logging.Logger;
/*      */ import org.jboss.util.collection.WeakValueHashMap;
/*      */ import org.jboss.util.loading.Translatable;
/*      */ import org.jboss.util.loading.Translator;
/*      */ 
/*      */ public class AspectManager
/*      */   implements Translator
/*      */ {
/*  108 */   private static final Logger logger = AOPLogger.getLogger(AspectManager.class);
/*      */ 
/*  111 */   ReentrantReadWriteLock lock = new ReentrantReadWriteLock();
/*      */ 
/*  114 */   protected final WeakHashMap advisors = new WeakHashMap();
/*      */ 
/*  117 */   protected volatile WeakHashMap subDomainsPerClass = UnmodifiableEmptyCollections.EMPTY_WEAK_HASHMAP;
/*      */ 
/*  120 */   protected volatile WeakValueHashMap subDomainsByName = UnmodifiableEmptyCollections.EMPTY_WEAK_VALUE_HASHMAP;
/*      */ 
/*  123 */   protected volatile WeakHashMap subscribedSubDomains = UnmodifiableEmptyCollections.EMPTY_WEAK_HASHMAP;
/*      */ 
/*  126 */   protected volatile WeakHashMap subscribedSubDomainsQueue = UnmodifiableEmptyCollections.EMPTY_WEAK_HASHMAP;
/*      */   protected int subscribedDomainQueueRef;
/*  129 */   protected volatile LinkedHashMap interfaceIntroductions = UnmodifiableEmptyCollections.EMPTY_LINKED_HASHMAP;
/*  130 */   protected volatile LinkedHashMap arrayReplacements = UnmodifiableEmptyCollections.EMPTY_LINKED_HASHMAP;
/*  131 */   protected volatile LinkedHashMap arrayBindings = UnmodifiableEmptyCollections.EMPTY_LINKED_HASHMAP;
/*  132 */   protected volatile LinkedHashMap annotationIntroductions = UnmodifiableEmptyCollections.EMPTY_LINKED_HASHMAP;
/*  133 */   protected volatile LinkedHashMap annotationOverrides = UnmodifiableEmptyCollections.EMPTY_LINKED_HASHMAP;
/*  134 */   protected volatile LinkedHashMap bindings = UnmodifiableEmptyCollections.EMPTY_LINKED_HASHMAP;
/*  135 */   protected volatile LinkedHashMap typedefs = UnmodifiableEmptyCollections.EMPTY_LINKED_HASHMAP;
/*  136 */   protected volatile HashMap interceptorFactories = UnmodifiableEmptyCollections.EMPTY_HASHMAP;
/*  137 */   protected volatile HashMap classMetaDataLoaders = UnmodifiableEmptyCollections.EMPTY_HASHMAP;
/*  138 */   protected volatile HashMap interceptorStacks = UnmodifiableEmptyCollections.EMPTY_HASHMAP;
/*  139 */   protected volatile HashMap declares = UnmodifiableEmptyCollections.EMPTY_HASHMAP;
/*  140 */   protected volatile ConcurrentHashMap cflowStacks = UnmodifiableEmptyCollections.EMPTY_CONCURRENT_HASHMAP;
/*  141 */   protected volatile ConcurrentHashMap dynamicCFlows = UnmodifiableEmptyCollections.EMPTY_CONCURRENT_HASHMAP;
/*  142 */   protected volatile ConcurrentHashMap aspectDefinitions = UnmodifiableEmptyCollections.EMPTY_CONCURRENT_HASHMAP;
/*  143 */   protected volatile ConcurrentHashMap perVMAspects = UnmodifiableEmptyCollections.EMPTY_CONCURRENT_HASHMAP;
/*      */ 
/*  146 */   protected volatile ArrayList exclude = UnmodifiableEmptyCollections.EMPTY_ARRAYLIST;
/*      */ 
/*  149 */   protected volatile ArrayList include = UnmodifiableEmptyCollections.EMPTY_ARRAYLIST;
/*      */ 
/*  152 */   protected volatile ArrayList ignore = UnmodifiableEmptyCollections.EMPTY_ARRAYLIST;
/*      */ 
/*  155 */   protected ClassExpression[] ignoreExpressions = new ClassExpression[0];
/*      */ 
/*  157 */   protected volatile LinkedHashMap pointcuts = UnmodifiableEmptyCollections.EMPTY_LINKED_HASHMAP;
/*      */ 
/*  159 */   protected volatile LinkedHashMap pointcutInfos = UnmodifiableEmptyCollections.EMPTY_LINKED_HASHMAP;
/*      */ 
/*  162 */   protected boolean execution = false;
/*  163 */   protected boolean construction = false;
/*  164 */   protected boolean call = false;
/*  165 */   protected boolean within = false;
/*  166 */   protected boolean get = false;
/*  167 */   protected boolean set = false;
/*  168 */   protected boolean withincode = false;
/*  169 */   public static boolean classicOrder = false;
/*      */ 
/*  171 */   protected volatile LinkedHashMap classMetaData = UnmodifiableEmptyCollections.EMPTY_LINKED_HASHMAP;
/*  172 */   protected volatile HashMap containers = UnmodifiableEmptyCollections.EMPTY_HASHMAP;
/*  173 */   protected volatile LinkedHashMap precedenceDefs = UnmodifiableEmptyCollections.EMPTY_LINKED_HASHMAP;
/*      */   protected PrecedenceDefEntry[] sortedPrecedenceDefEntries;
/*      */   protected WeavingStrategy weavingStrategy;
/*  177 */   protected DynamicAOPStrategy dynamicStrategy = new LoadInterceptedClassesStrategy();
/*      */ 
/*  179 */   protected boolean transformationStarted = false;
/*      */   private static AOPClassLoaderScopingPolicy classLoaderScopingPolicy;
/*  186 */   protected static InterceptionMarkers interceptionMarkers = new InterceptionMarkers();
/*      */   protected static AspectManager manager;
/*  191 */   public static boolean optimize = true;
/*      */   public static boolean debugClasses;
/*      */   public static ClassLoaderValidation classLoaderValidator;
/*  196 */   public LifecycleManager lifecycleManager = new LifecycleManager(this);
/*      */ 
/*  201 */   public static boolean verbose = false;
/*      */ 
/*  428 */   public static AspectNotificationHandler notificationHandler = null;
/*      */ 
/*  430 */   public static boolean suppressTransformationErrors = false;
/*      */ 
/*  438 */   public static boolean suppressReferenceErrors = true;
/*      */ 
/*      */   public static synchronized AspectManager getTopLevelAspectManager()
/*      */   {
/*  210 */     if (classLoaderScopingPolicy == null)
/*      */     {
/*  213 */       return instance();
/*      */     }
/*      */ 
/*  216 */     AspectManager result = initManager();
/*  217 */     Domain scopedDomain = classLoaderScopingPolicy.getTopLevelDomain(result);
/*  218 */     if (scopedDomain != null)
/*  219 */       result = scopedDomain;
/*  220 */     return result;
/*      */   }
/*      */ 
/*      */   public static synchronized AspectManager instance()
/*      */   {
/*  225 */     return instance(SecurityActions.getContextClassLoader());
/*      */   }
/*      */ 
/*      */   public static synchronized AspectManager instance(ClassLoader loadingClassLoader)
/*      */   {
/*  236 */     AspectManager result = initManager();
/*  237 */     if (classLoaderScopingPolicy != null)
/*      */     {
/*  239 */       Domain scopedDomain = classLoaderScopingPolicy.getDomain(loadingClassLoader, result);
/*  240 */       if (scopedDomain != null)
/*  241 */         result = scopedDomain;
/*      */     }
/*  243 */     return result;
/*      */   }
/*      */ 
/*      */   private static AspectManager initManager()
/*      */   {
/*  255 */     if (manager == null)
/*      */     {
/*  257 */       AccessController.doPrivileged(new PrivilegedAction()
/*      */       {
/*      */         public AspectManager run()
/*      */         {
/*  261 */           String optimized = System.getProperty("jboss.aop.optimized", null);
/*  262 */           if (optimized != null)
/*      */           {
/*  264 */             AspectManager.optimize = new Boolean(optimized).booleanValue();
/*      */           }
/*  266 */           String pruneit = System.getProperty("jboss.aop.prune", null);
/*  267 */           if (pruneit != null)
/*      */           {
/*  269 */             AOPClassPoolRepository.getInstance().setPrune(new Boolean(pruneit).booleanValue());
/*      */           }
/*  271 */           AspectManager.manager = new AspectManager();
/*      */ 
/*  273 */           AspectManager.manager.subDomainsPerClass = new WeakHashMap();
/*  274 */           AspectManager.manager.exclude = new ArrayList();
/*  275 */           AspectManager.manager.include = new ArrayList();
/*  276 */           AspectManager.manager.ignore = new ArrayList();
/*      */ 
/*  278 */           AOPClassPoolRepository.getInstance().setAspectManager(AspectManager.manager);
/*      */ 
/*  280 */           if (!AspectManager.verbose)
/*      */           {
/*  282 */             AspectManager.verbose = new Boolean(System.getProperty("jboss.aop.verbose", "false")).booleanValue();
/*      */           }
/*  284 */           String exclude = System.getProperty("jboss.aop.exclude", null);
/*  285 */           if (exclude != null)
/*      */           {
/*  287 */             ArrayList list = new ArrayList();
/*  288 */             StringTokenizer tokenizer = new StringTokenizer(exclude, ",");
/*  289 */             while (tokenizer.hasMoreTokens())
/*      */             {
/*  291 */               list.add(tokenizer.nextToken().trim());
/*      */             }
/*  293 */             AspectManager.manager.setExclude(list);
/*      */           }
/*  295 */           String include = System.getProperty("jboss.aop.include", null);
/*  296 */           if (include != null)
/*      */           {
/*  298 */             ArrayList list = new ArrayList();
/*  299 */             StringTokenizer tokenizer = new StringTokenizer(include, ",");
/*  300 */             while (tokenizer.hasMoreTokens())
/*      */             {
/*  302 */               list.add(tokenizer.nextToken().trim());
/*      */             }
/*  304 */             AspectManager.manager.setInclude(list);
/*      */           }
/*  306 */           String ignore = System.getProperty("jboss.aop.ignore", null);
/*  307 */           if (ignore != null)
/*      */           {
/*  309 */             ArrayList list = new ArrayList();
/*  310 */             StringTokenizer tokenizer = new StringTokenizer(ignore, ",");
/*  311 */             while (tokenizer.hasMoreTokens())
/*      */             {
/*  313 */               list.add(tokenizer.nextToken().trim());
/*      */             }
/*  315 */             AspectManager.manager.setIgnore(list);
/*      */           }
/*      */ 
/*  318 */           String instrument = System.getProperty("jboss.aop.instrumentor", null);
/*  319 */           InstrumentorFactory.initialise(instrument);
/*      */ 
/*  321 */           String advisorName = System.getProperty("jboss.aop.advisor", null);
/*  322 */           AdvisorFactory.initialise(advisorName);
/*      */ 
/*  324 */           String debugClass = System.getProperty("jboss.aop.debug.classes", null);
/*  325 */           if (debugClass != null)
/*      */           {
/*  327 */             AspectManager.debugClasses = new Boolean(debugClass).booleanValue();
/*      */           }
/*      */ 
/*  330 */           String classic = System.getProperty("jboss.aop.classicorder", null);
/*  331 */           if (classic != null)
/*      */           {
/*  333 */             AspectManager.classicOrder = new Boolean(classic).booleanValue();
/*      */           }
/*      */ 
/*  337 */           Deployment.deploy();
/*  338 */           return null;
/*      */         } } );
/*      */     }
/*  342 */     return manager;
/*      */   }
/*      */ 
/*      */   public static AOPClassLoaderScopingPolicy getClassLoaderScopingPolicy()
/*      */   {
/*  352 */     return classLoaderScopingPolicy;
/*      */   }
/*      */ 
/*      */   public static void setClassLoaderScopingPolicy(AOPClassLoaderScopingPolicy classLoaderScopingPolicy)
/*      */   {
/*  363 */     classLoaderScopingPolicy = classLoaderScopingPolicy;
/*      */   }
/*      */ 
/*      */   public InterceptionMarkers getInterceptionMarkers()
/*      */   {
/*  368 */     return interceptionMarkers;
/*      */   }
/*      */ 
/*      */   public LinkedHashMap getPointcuts()
/*      */   {
/*  373 */     return this.pointcuts;
/*      */   }
/*      */ 
/*      */   public LinkedHashMap getPointcutInfos()
/*      */   {
/*  378 */     return this.pointcutInfos;
/*      */   }
/*      */ 
/*      */   public CFlowStack getCFlowStack(String name)
/*      */   {
/*  383 */     return (CFlowStack)this.cflowStacks.get(name);
/*      */   }
/*      */ 
/*      */   public void addCFlowStack(CFlowStack stack)
/*      */   {
/*  388 */     initCflowStacksMap();
/*  389 */     this.cflowStacks.put(stack.getName(), stack);
/*      */   }
/*      */ 
/*      */   public void removeCFlowStack(String name)
/*      */   {
/*  394 */     this.cflowStacks.remove(name);
/*      */   }
/*      */ 
/*      */   public DynamicCFlow getDynamicCFlow(String name)
/*      */   {
/*  399 */     DynamicCFlowDefinition def = (DynamicCFlowDefinition)this.dynamicCFlows.get(name);
/*      */ 
/*  401 */     if (def != null)
/*      */     {
/*  403 */       return def.create();
/*      */     }
/*  405 */     return null;
/*      */   }
/*      */ 
/*      */   public void addDynamicCFlow(String name, DynamicCFlowDefinition cflow)
/*      */   {
/*  414 */     initDynamicCflowsMap();
/*  415 */     this.dynamicCFlows.put(name, cflow);
/*      */   }
/*      */ 
/*      */   public void removeDynamicCFlow(String name)
/*      */   {
/*  420 */     this.dynamicCFlows.remove(name);
/*      */   }
/*      */ 
/*      */   public ClassMetaDataLoader findClassMetaDataLoader(String group)
/*      */   {
/*  458 */     ClassMetaDataLoader loader = (ClassMetaDataLoader)this.classMetaDataLoaders.get(group);
/*  459 */     if (loader == null) loader = SimpleClassMetaDataLoader.singleton;
/*  460 */     return loader;
/*      */   }
/*      */ 
/*      */   public void addClassMetaDataLoader(String group, ClassMetaDataLoader loader)
/*      */   {
/*  472 */     initClassMetaDataLoadersMap();
/*  473 */     this.classMetaDataLoaders.put(group, loader);
/*      */   }
/*      */ 
/*      */   public void removeClassMetaDataLoader(String group)
/*      */   {
/*  481 */     this.classMetaDataLoaders.remove(group);
/*      */   }
/*      */ 
/*      */   public Map getAdvisors()
/*      */   {
/*  486 */     return this.advisors;
/*      */   }
/*      */ 
/*      */   public Advisor getAdvisor(String name)
/*      */   {
/*  497 */     throw new RuntimeException("OPERATION NOT SUPPORTED ANYMORE");
/*      */   }
/*      */ 
/*      */   public LinkedHashMap getBindings()
/*      */   {
/*  502 */     return this.bindings;
/*      */   }
/*      */ 
/*      */   protected Map getSubDomainsPerClass()
/*      */   {
/*  507 */     return this.subDomainsPerClass;
/*      */   }
/*      */ 
/*      */   public Advisor findAdvisor(Class clazz)
/*      */   {
/*  512 */     if (getSubDomainsPerClass().size() > 0)
/*      */     {
/*  516 */       Domain subDomain = null;
/*  517 */       synchronized (getSubDomainsPerClass())
/*      */       {
/*  519 */         WeakReference ref = (WeakReference)getSubDomainsPerClass().get(clazz);
/*  520 */         if (ref != null)
/*      */         {
/*  522 */           subDomain = (Domain)ref.get();
/*      */         }
/*      */       }
/*      */ 
/*  526 */       if ((subDomain != null) && (subDomain != this))
/*      */       {
/*  528 */         Advisor advisor = subDomain.findAdvisor(clazz);
/*  529 */         if (advisor != null)
/*      */         {
/*  531 */           return advisor;
/*      */         }
/*      */       }
/*      */     }
/*      */ 
/*  536 */     synchronized (this.advisors)
/*      */     {
/*  538 */       WeakReference ref = (WeakReference)this.advisors.get(clazz);
/*  539 */       if (ref == null) return null;
/*  540 */       return (Advisor)ref.get();
/*      */     }
/*      */   }
/*      */ 
/*      */   public AspectManager findManagerByName(String fqn)
/*      */   {
/*  553 */     String[] nameparts = fqn.split("/");
/*  554 */     return findManagerByName(nameparts);
/*      */   }
/*      */ 
/*      */   private AspectManager findManagerByName(String[] nameparts)
/*      */   {
/*  559 */     AspectManager found = this;
/*  560 */     for (int i = 0; i < nameparts.length; i++)
/*      */     {
/*  562 */       if (nameparts[i].trim().length() == 0)
/*      */       {
/*      */         continue;
/*      */       }
/*  566 */       found = found.findManagerByNameInternal(nameparts[i]);
/*  567 */       if (found == null)
/*      */       {
/*      */         break;
/*      */       }
/*      */     }
/*  572 */     return found;
/*      */   }
/*      */ 
/*      */   private AspectManager findManagerByNameInternal(String name)
/*      */   {
/*  577 */     return (Domain)this.subDomainsByName.get(name);
/*      */   }
/*      */ 
/*      */   protected void addSubDomainByName(Domain domain)
/*      */   {
/*  582 */     initSubDomainsByNameMap();
/*  583 */     this.subDomainsByName.put(domain.getDomainName(), domain);
/*      */   }
/*      */ 
/*      */   public String getManagerFQN()
/*      */   {
/*  588 */     return "/";
/*      */   }
/*      */ 
/*      */   public ClassAdvisor getAdvisorIfAdvised(Class clazz)
/*      */   {
/*  593 */     return (ClassAdvisor)getAnyAdvisorIfAdvised(clazz);
/*      */   }
/*      */ 
/*      */   public Advisor getAnyAdvisorIfAdvised(Class clazz)
/*      */   {
/*      */     try
/*      */     {
/*  604 */       Advisor advisor = findAdvisor(clazz);
/*  605 */       if (advisor == null)
/*      */       {
/*  607 */         return null;
/*      */       }
/*  609 */       if ((advisor.getClazz() == null) && ((advisor instanceof ClassAdvisor)))
/*      */       {
/*  611 */         ((ClassAdvisor)advisor).attachClass(clazz);
/*  612 */         if (notificationHandler != null)
/*      */         {
/*  614 */           notificationHandler.attachClass(clazz.getName());
/*      */         }
/*      */       }
/*  617 */       return advisor;
/*      */     }
/*      */     catch (RuntimeException ex)
/*      */     {
/*  621 */       ex.printStackTrace();
/*  622 */     }throw ex;
/*      */   }
/*      */ 
/*      */   public synchronized ClassAdvisor getAdvisor(Class clazz)
/*      */   {
/*  635 */     ClassAdvisor advisor = null;
/*      */ 
/*  637 */     advisor = (ClassAdvisor)findAdvisor(clazz);
/*      */ 
/*  639 */     if (advisor == null)
/*      */     {
/*  641 */       advisor = AdvisorFactory.getClassAdvisor(clazz, this);
/*  642 */       initialiseClassAdvisor(clazz, advisor);
/*      */     }
/*  644 */     return advisor;
/*      */   }
/*      */ 
/*      */   public synchronized void initialiseClassAdvisor(Class clazz, ClassAdvisor advisor)
/*      */   {
/*  649 */     synchronized (this.advisors)
/*      */     {
/*  651 */       this.advisors.put(clazz, new WeakReference(advisor));
/*      */     }
/*      */ 
/*  654 */     registerClass(clazz);
/*  655 */     advisor.attachClass(clazz);
/*  656 */     InterceptorChainObserver observer = this.dynamicStrategy.getInterceptorChainObserver(clazz);
/*  657 */     advisor.setInterceptorChainObserver(observer);
/*  658 */     if (notificationHandler != null)
/*      */     {
/*  660 */       notificationHandler.attachClass(clazz.getName());
/*      */     }
/*      */   }
/*      */ 
/*      */   public static Map getRegisteredCLs()
/*      */   {
/*  668 */     return AOPClassPoolRepository.getInstance().getRegisteredCLs();
/*      */   }
/*      */ 
/*      */   public static void clearUnregisteredClassLoaders()
/*      */   {
/*  676 */     AOPClassPoolRepository.getInstance().clearUnregisteredClassLoaders();
/*      */   }
/*      */ 
/*      */   public boolean isAdvisorRegistered(Advisor advisor)
/*      */   {
/*  687 */     synchronized (getRegisteredCLs())
/*      */     {
/*  689 */       if (!this.advisors.containsKey(advisor.getClazz())) return false;
/*  690 */       ScopedClassPool pool = (ScopedClassPool)getRegisteredClassPool(advisor.getClazz().getClassLoader());
/*  691 */       if (pool == null) return false;
/*  692 */       if (pool.isUnloadedClassLoader())
/*      */       {
/*  694 */         unregisterClassLoader(advisor.getClazz().getClassLoader());
/*  695 */         return false;
/*      */       }
/*      */ 
/*  699 */       return true;
/*      */     }
/*      */   }
/*      */ 
/*      */   public ClassPool findClassPool(ClassLoader cl)
/*      */   {
/*  706 */     if (!(cl instanceof Translatable))
/*      */     {
/*  709 */       return registerClassLoader(SecurityActions.getContextClassLoader());
/*      */     }
/*  711 */     return registerClassLoader(cl);
/*      */   }
/*      */ 
/*      */   protected ClassPool getRegisteredClassPool(ClassLoader cl)
/*      */   {
/*  716 */     return (ClassPool)getRegisteredCLs().get(cl);
/*      */   }
/*      */ 
/*      */   public ClassPool registerClassLoader(ClassLoader ucl)
/*      */   {
/*  721 */     return AOPClassPoolRepository.getInstance().registerClassLoader(ucl);
/*      */   }
/*      */ 
/*      */   protected void registerClass(Class clazz)
/*      */   {
/*  726 */     AOPClassPoolRepository.getInstance().registerClass(clazz);
/*      */   }
/*      */ 
/*      */   public void unregisterClassLoader(ClassLoader cl)
/*      */   {
/*  731 */     AOPClassPoolRepository.getInstance().unregisterClassLoader(cl);
/*      */   }
/*      */ 
/*      */   public ArrayList getExclude()
/*      */   {
/*  736 */     return this.exclude;
/*      */   }
/*      */ 
/*      */   public void setExclude(ArrayList exclude)
/*      */   {
/*  741 */     this.exclude.clear();
/*  742 */     this.exclude.addAll(exclude);
/*      */   }
/*      */ 
/*      */   public ArrayList getInclude()
/*      */   {
/*  747 */     return this.include;
/*      */   }
/*      */ 
/*      */   public void setInclude(ArrayList include)
/*      */   {
/*  752 */     this.include.clear();
/*  753 */     this.include.addAll(include);
/*      */   }
/*      */ 
/*      */   public ArrayList getIgnore()
/*      */   {
/*  758 */     return this.ignore;
/*      */   }
/*      */ 
/*      */   public ClassExpression[] getIgnoreExpressions()
/*      */   {
/*  763 */     return this.ignoreExpressions;
/*      */   }
/*      */ 
/*      */   public void setIgnore(ArrayList ignore)
/*      */   {
/*  768 */     this.ignore.clear();
/*  769 */     this.ignore.addAll(ignore);
/*  770 */     this.ignoreExpressions = new ClassExpression[ignore.size()];
/*  771 */     for (int i = 0; i < ignore.size(); i++)
/*      */     {
/*  773 */       String ex = (String)ignore.get(i);
/*  774 */       this.ignoreExpressions[i] = new ClassExpression(ex);
/*      */     }
/*      */   }
/*      */ 
/*      */   public boolean ignoreClass(String classname)
/*      */   {
/*  780 */     ArrayList ignore = getIgnore();
/*  781 */     if (ignore == null) return false;
/*  782 */     ClassExpression[] ignoreExprs = getIgnoreExpressions();
/*  783 */     for (int i = 0; i < ignoreExprs.length; i++)
/*      */     {
/*  785 */       if (ignoreExprs[i].matches(classname)) return true;
/*      */     }
/*  787 */     return false;
/*      */   }
/*      */ 
/*      */   public boolean includeClass(String classname)
/*      */   {
/*  792 */     ArrayList include = getInclude();
/*  793 */     if (include == null) return false;
/*  794 */     for (int i = 0; i < include.size(); i++)
/*      */     {
/*  796 */       String str = (String)include.get(i);
/*  797 */       if (classname.startsWith(str)) return true;
/*      */     }
/*  799 */     return false;
/*      */   }
/*      */ 
/*      */   public boolean excludeClass(String classname)
/*      */   {
/*  804 */     ArrayList exclude = getExclude();
/*  805 */     if (exclude == null) return false;
/*  806 */     for (int i = 0; i < exclude.size(); i++)
/*      */     {
/*  808 */       String str = (String)exclude.get(i);
/*  809 */       if (classname.startsWith(str)) return true;
/*      */     }
/*  811 */     return false;
/*      */   }
/*      */ 
/*      */   public static boolean getPrune()
/*      */   {
/*  816 */     return AOPClassPoolRepository.getInstance().isPrune();
/*      */   }
/*      */ 
/*      */   public static void setPrune(boolean prune)
/*      */   {
/*  821 */     AOPClassPoolRepository.getInstance().setPrune(prune);
/*      */   }
/*      */ 
/*      */   public static void setClassPoolFactory(ScopedClassPoolFactory factory)
/*      */   {
/*  826 */     AOPClassPoolRepository.getInstance().setClassPoolFactory(factory);
/*      */   }
/*      */ 
/*      */   public static ScopedClassPoolFactory getClassPoolFactory()
/*      */   {
/*  831 */     return AOPClassPoolRepository.getInstance().getClassPoolFactory();
/*      */   }
/*      */ 
/*      */   public boolean isNonAdvisableClassName(String classname)
/*      */   {
/*  836 */     if (ignoreClass(classname)) return true;
/*  837 */     if (includeClass(classname)) return false;
/*  838 */     if (excludeClass(classname)) return true;
/*  839 */     return (classname.startsWith("org.jboss.aop")) || (classname.endsWith("$aop")) || (classname.startsWith("javassist")) || (classname.startsWith("org.jboss.util.")) || (classname.startsWith("gnu.trove.")) || (classname.startsWith("EDU.oswego.cs.dl.util.concurrent.")) || (classname.startsWith("org.apache.tools.ant")) || (classname.startsWith("org.apache.crimson")) || (classname.startsWith("org.apache.xalan")) || (classname.startsWith("org.apache.xml")) || (classname.startsWith("org.apache.xpath")) || (classname.startsWith("org.ietf.")) || (classname.startsWith("org.omg.")) || (classname.startsWith("org.w3c.")) || (classname.startsWith("org.xml.sax.")) || (classname.startsWith("sunw.")) || (classname.startsWith("sun.")) || (classname.startsWith("java.")) || (classname.startsWith("javax.")) || (classname.startsWith("com.sun.")) || (classname.startsWith("junit")) || (classname.startsWith("jrockit.")) || (classname.startsWith("com.bea.vm.")) || (classname.startsWith("$Proxy"));
/*      */   }
/*      */ 
/*      */   public byte[] transform(ClassLoader loader, String className, Class classBeingRedefined, ProtectionDomain protectionDomain, byte[] classfileBuffer)
/*      */     throws Exception
/*      */   {
/*  880 */     byte[] b = translate(className, loader, classfileBuffer);
/*  881 */     return b;
/*      */   }
/*      */ 
/*      */   public byte[] translate(String className, ClassLoader loader)
/*      */     throws Exception
/*      */   {
/*  895 */     return translate(className, loader, null);
/*      */   }
/*      */ 
/*      */   public synchronized byte[] translate(String className, ClassLoader loader, byte[] classfileBuffer)
/*      */     throws Exception
/*      */   {
/*      */     try
/*      */     {
/*  913 */       if (isNonAdvisableClassName(className))
/*      */       {
/*  915 */         return null;
/*      */       }
/*  917 */       if (this.weavingStrategy == null)
/*      */       {
/*  919 */         if ((TransformerCommon.isCompileTime()) || (classicOrder))
/*      */         {
/*  921 */           this.weavingStrategy = new ClassicWeavingStrategy();
/*      */         }
/*  923 */         else if ((InstrumentorFactory.getInstrumentor(this, this.dynamicStrategy.getJoinpointClassifier()) instanceof GeneratedAdvisorInstrumentor))
/*      */         {
/*  926 */           this.weavingStrategy = new SuperClassesFirstWeavingStrategy();
/*      */         }
/*      */         else
/*      */         {
/*  930 */           this.weavingStrategy = new ClassicWeavingStrategy();
/*      */         }
/*      */       }
/*      */ 
/*  934 */       return this.weavingStrategy.translate(this, className, loader, classfileBuffer);
/*      */     }
/*      */     catch (Exception e)
/*      */     {
/*      */     }
/*  939 */     throw new RuntimeException(e);
/*      */   }
/*      */ 
/*      */   public void addInterceptorFactory(String name, InterceptorFactory factory)
/*      */   {
/*  948 */     initInterceptorFactoriesMap();
/*  949 */     synchronized (this.interceptorFactories)
/*      */     {
/*  951 */       this.interceptorFactories.put(name, factory);
/*      */     }
/*      */   }
/*      */ 
/*      */   public void removeInterceptorFactory(String name)
/*      */   {
/*  960 */     synchronized (this.interceptorFactories)
/*      */     {
/*  962 */       this.interceptorFactories.remove(name);
/*      */     }
/*      */   }
/*      */ 
/*      */   public Map getInterceptorFactories()
/*      */   {
/*  968 */     return this.interceptorFactories;
/*      */   }
/*      */ 
/*      */   public InterceptorFactory getInterceptorFactory(String name)
/*      */   {
/*  976 */     synchronized (this.interceptorFactories)
/*      */     {
/*  978 */       return (InterceptorFactory)this.interceptorFactories.get(name);
/*      */     }
/*      */   }
/*      */ 
/*      */   public void addPrecedence(PrecedenceDef precedenceDef)
/*      */   {
/*  985 */     initPrecedenceDefsMap();
/*  986 */     synchronized (this.precedenceDefs)
/*      */     {
/*  988 */       this.precedenceDefs.put(precedenceDef.getName(), precedenceDef);
/*      */     }
/*  990 */     forceResortPrecedenceDefs();
/*      */   }
/*      */ 
/*      */   public void removePrecedence(String name)
/*      */   {
/*  995 */     synchronized (this.precedenceDefs)
/*      */     {
/*  997 */       this.precedenceDefs.remove(name);
/*      */     }
/*      */ 
/* 1000 */     forceResortPrecedenceDefs();
/*      */   }
/*      */ 
/*      */   protected void forceResortPrecedenceDefs()
/*      */   {
/* 1005 */     synchronized (this.precedenceDefs)
/*      */     {
/* 1007 */       this.sortedPrecedenceDefEntries = null;
/*      */     }
/* 1009 */     synchronized (this.subscribedSubDomains)
/*      */     {
/* 1011 */       copySubDomainsFromQueue(true);
/* 1012 */       boolean newSubscribers = true;
/* 1013 */       while (newSubscribers)
/*      */       {
/* 1015 */         for (Iterator it = this.subscribedSubDomains.keySet().iterator(); it.hasNext(); )
/*      */         {
/* 1017 */           Domain domain = (Domain)it.next();
/* 1018 */           domain.forceResortPrecedenceDefs();
/*      */         }
/* 1020 */         newSubscribers = copySubDomainsFromQueue(false);
/*      */       }
/*      */     }
/*      */   }
/*      */ 
/*      */   public LinkedHashMap getPrecedenceDefs()
/*      */   {
/* 1027 */     return this.precedenceDefs;
/*      */   }
/*      */ 
/*      */   public PrecedenceDefEntry[] getSortedPrecedenceDefEntries()
/*      */   {
/* 1032 */     if (this.sortedPrecedenceDefEntries == null)
/*      */     {
/* 1034 */       synchronized (this.precedenceDefs)
/*      */       {
/* 1036 */         if (this.sortedPrecedenceDefEntries == null)
/*      */         {
/* 1038 */           this.sortedPrecedenceDefEntries = PrecedenceSorter.createOverallPrecedence(this);
/*      */         }
/*      */       }
/*      */     }
/* 1042 */     return this.sortedPrecedenceDefEntries;
/*      */   }
/*      */ 
/*      */   public void addAdviceStack(AdviceStack stack)
/*      */   {
/* 1050 */     initInerceptorStacksMap();
/* 1051 */     synchronized (this.interceptorStacks)
/*      */     {
/* 1053 */       this.interceptorStacks.put(stack.getName(), stack);
/*      */     }
/*      */   }
/*      */ 
/*      */   public void removeInterceptorStack(String name)
/*      */   {
/* 1062 */     synchronized (this.interceptorStacks)
/*      */     {
/* 1064 */       this.interceptorStacks.remove(name);
/*      */     }
/*      */   }
/*      */ 
/*      */   public AdviceStack getAdviceStack(String name)
/*      */   {
/* 1073 */     synchronized (this.interceptorStacks)
/*      */     {
/* 1075 */       return (AdviceStack)this.interceptorStacks.get(name);
/*      */     }
/*      */   }
/*      */ 
/*      */   protected boolean attachMetaData(ClassAdvisor advisor, CtClass clazz, boolean addAdvisor)
/*      */     throws Exception
/*      */   {
/* 1082 */     boolean attached = false;
/* 1083 */     synchronized (this.classMetaData)
/*      */     {
/* 1085 */       Iterator it = this.classMetaData.values().iterator();
/* 1086 */       while (it.hasNext())
/*      */       {
/* 1088 */         ClassMetaDataBinding data = (ClassMetaDataBinding)it.next();
/* 1089 */         if (data.matches(advisor, clazz))
/*      */         {
/* 1091 */           attached = true;
/* 1092 */           if (addAdvisor) data.addAdvisor(advisor);
/* 1093 */           ClassMetaDataLoader loader = data.getLoader();
/* 1094 */           loader.bind(advisor, data, clazz.getDeclaredMethods(), clazz.getDeclaredFields(), clazz.getDeclaredConstructors());
/*      */         }
/*      */       }
/*      */     }
/* 1098 */     return attached;
/*      */   }
/*      */ 
/*      */   protected void attachMetaData(Advisor advisor, Class clazz)
/*      */   {
/* 1103 */     synchronized (this.classMetaData)
/*      */     {
/* 1105 */       Iterator it = this.classMetaData.values().iterator();
/* 1106 */       while (it.hasNext())
/*      */       {
/* 1108 */         ClassMetaDataBinding data = (ClassMetaDataBinding)it.next();
/* 1109 */         addAdvisorToClassMetaDataBinding(data, clazz, advisor, clazz);
/*      */       }
/*      */     }
/*      */   }
/*      */ 
/*      */   public ClassAdvisor getTempClassAdvisor(CtClass clazz) throws Exception
/*      */   {
/* 1116 */     String classname = clazz.getName();
/* 1117 */     ClassAdvisor advisor = AdvisorFactory.getClassAdvisor(clazz, this);
/* 1118 */     attachMetaData(advisor, clazz, false);
/* 1119 */     applyInterfaceIntroductions(advisor, clazz);
/* 1120 */     return advisor;
/*      */   }
/*      */ 
/*      */   public Advisor getTempClassAdvisorIfNotExist(Class clazz)
/*      */   {
/* 1125 */     Advisor advisor = findAdvisor(clazz);
/* 1126 */     if (advisor != null) return advisor;
/* 1127 */     if (Advised.class.isAssignableFrom(clazz))
/*      */     {
/* 1130 */       Class superClass = clazz;
/*      */       try
/*      */       {
/* 1133 */         while (superClass != null)
/*      */         {
/*      */           try
/*      */           {
/* 1137 */             Field field = superClass.getDeclaredField("aop$classAdvisor$aop");
/* 1138 */             SecurityActions.setAccessible(field);
/* 1139 */             advisor = (ClassAdvisor)field.get(null);
/* 1140 */             if (advisor != null)
/*      */             {
/* 1142 */               return advisor;
/*      */             }
/*      */ 
/*      */           }
/*      */           catch (NoSuchFieldException e)
/*      */           {
/* 1151 */             superClass = clazz.getSuperclass();
/*      */           }
/*      */         }
/*      */       }
/*      */       catch (IllegalAccessException e)
/*      */       {
/* 1157 */         throw new RuntimeException(e);
/*      */       }
/*      */     }
/*      */ 
/* 1161 */     advisor = AdvisorFactory.getClassAdvisor(clazz, this);
/* 1162 */     advisor.setClazz(clazz);
/* 1163 */     return advisor;
/*      */   }
/*      */ 
/*      */   public DomainDefinition getContainer(String name)
/*      */   {
/* 1169 */     return (DomainDefinition)this.containers.get(name);
/*      */   }
/*      */ 
/*      */   public void addContainer(DomainDefinition def)
/*      */   {
/* 1174 */     initContainersMap();
/* 1175 */     this.containers.put(def.getName(), def);
/*      */   }
/*      */ 
/*      */   public void removeContainer(String name)
/*      */   {
/* 1180 */     this.containers.remove(name);
/*      */   }
/*      */ 
/*      */   public Pointcut getPointcut(String name)
/*      */   {
/* 1188 */     synchronized (this.pointcuts)
/*      */     {
/* 1190 */       return (Pointcut)this.pointcuts.get(name);
/*      */     }
/*      */   }
/*      */ 
/*      */   public void removePointcut(String name)
/*      */   {
/* 1199 */     synchronized (this.pointcuts)
/*      */     {
/* 1201 */       this.pointcuts.remove(name);
/* 1202 */       this.pointcutInfos.remove(name);
/*      */     }
/*      */   }
/*      */ 
/*      */   public synchronized void addPointcut(Pointcut pointcut)
/*      */   {
/* 1211 */     removePointcut(pointcut.getName());
/* 1212 */     initPointcutsMap();
/* 1213 */     initPointcutInfosMap();
/* 1214 */     synchronized (this.pointcuts)
/*      */     {
/* 1216 */       this.pointcuts.put(pointcut.getName(), pointcut);
/* 1217 */       this.pointcutInfos.put(pointcut.getName(), new PointcutInfo(pointcut, this.transformationStarted));
/*      */     }
/* 1219 */     updatePointcutStats(pointcut);
/*      */   }
/*      */ 
/*      */   protected void updatePointcutStats(Pointcut pointcut)
/*      */   {
/* 1230 */     if ((pointcut instanceof PointcutExpression))
/*      */     {
/* 1232 */       PointcutExpression expr = (PointcutExpression)pointcut;
/* 1233 */       expr.setManager(this);
/* 1234 */       PointcutStats stats = expr.getStats();
/* 1235 */       updateStats(stats);
/*      */     }
/*      */     else
/*      */     {
/* 1240 */       this.execution = true;
/* 1241 */       this.construction = true;
/* 1242 */       this.call = true;
/* 1243 */       this.within = true;
/* 1244 */       this.get = true;
/* 1245 */       this.set = true;
/* 1246 */       this.withincode = true;
/*      */     }
/*      */   }
/*      */ 
/*      */   protected void updateStats(PointcutStats stats)
/*      */   {
/* 1252 */     if (stats != null)
/*      */     {
/* 1254 */       this.construction |= stats.isConstruction();
/* 1255 */       this.execution |= stats.isExecution();
/* 1256 */       this.call |= stats.isCall();
/* 1257 */       this.within |= stats.isWithin();
/* 1258 */       this.get |= stats.isGet();
/* 1259 */       this.set |= stats.isSet();
/* 1260 */       this.withincode |= stats.isWithincode();
/*      */     }
/*      */     else
/*      */     {
/* 1264 */       if ((verbose) && (logger.isDebugEnabled())) logger.debug("Setting all pointcut stats to true");
/*      */ 
/* 1266 */       this.execution = true;
/* 1267 */       this.construction = true;
/* 1268 */       this.call = true;
/* 1269 */       this.within = true;
/* 1270 */       this.get = true;
/* 1271 */       this.set = true;
/* 1272 */       this.withincode = true;
/*      */     }
/*      */   }
/*      */ 
/*      */   public boolean isExecution()
/*      */   {
/* 1278 */     return this.execution;
/*      */   }
/*      */ 
/*      */   public boolean isConstruction()
/*      */   {
/* 1283 */     return this.construction;
/*      */   }
/*      */ 
/*      */   public boolean isCall()
/*      */   {
/* 1288 */     return this.call;
/*      */   }
/*      */ 
/*      */   public boolean isWithin()
/*      */   {
/* 1293 */     return this.within;
/*      */   }
/*      */ 
/*      */   public boolean isWithincode()
/*      */   {
/* 1298 */     return this.withincode;
/*      */   }
/*      */ 
/*      */   public boolean isGet()
/*      */   {
/* 1303 */     return this.get;
/*      */   }
/*      */ 
/*      */   public boolean isSet()
/*      */   {
/* 1308 */     return this.set;
/*      */   }
/*      */ 
/*      */   public synchronized void removeBinding(String name)
/*      */   {
/* 1316 */     AdviceBinding binding = internalRemoveBinding(name);
/* 1317 */     if (binding != null)
/*      */     {
/* 1319 */       binding.clearAdvisors();
/* 1320 */       this.dynamicStrategy.interceptorChainsUpdated();
/*      */     }
/*      */   }
/*      */ 
/*      */   public synchronized void removeBindings(ArrayList binds)
/*      */   {
/* 1326 */     clearUnregisteredClassLoaders();
/*      */ 
/* 1328 */     HashSet bindingAdvisors = new HashSet();
/* 1329 */     ArrayList removedBindings = new ArrayList();
/* 1330 */     synchronized (this.bindings)
/*      */     {
/* 1332 */       int bindSize = binds.size();
/*      */ 
/* 1334 */       for (int i = 0; i < bindSize; i++)
/*      */       {
/* 1337 */         AdviceBinding binding = (AdviceBinding)this.bindings.get(binds.get(i));
/* 1338 */         if (binding == null)
/*      */         {
/* 1340 */           logger.debug("AspectManager.removeBindings() no binding found with name " + binds.get(i));
/*      */         }
/*      */         else {
/* 1343 */           ArrayList ads = binding.getAdvisors();
/* 1344 */           bindingAdvisors.addAll(ads);
/* 1345 */           this.bindings.remove(binding.getName());
/* 1346 */           Pointcut pointcut = binding.getPointcut();
/* 1347 */           removePointcut(pointcut.getName());
/* 1348 */           removedBindings.add(binding);
/*      */         }
/*      */       }
/*      */     }
/* 1351 */     Iterator it = bindingAdvisors.iterator();
/* 1352 */     while (it.hasNext())
/*      */     {
/* 1354 */       Advisor advisor = (Advisor)it.next();
/* 1355 */       if (!isAdvisorRegistered(advisor))
/*      */       {
/* 1359 */         WeakReference ref = (WeakReference)getSubDomainsPerClass().get(advisor.getClazz());
/* 1360 */         Domain domain = null;
/* 1361 */         if (ref != null) domain = (Domain)ref.get();
/* 1362 */         if ((domain != null) && (
/* 1364 */           ((!this.subscribedSubDomains.containsKey(domain)) && (!this.subscribedSubDomainsQueue.containsKey(domain))) || 
/* 1366 */           (!domain.isAdvisorRegistered(advisor))))
/*      */         {
/*      */           continue;
/*      */         }
/*      */ 
/*      */       }
/*      */ 
/* 1374 */       advisor.removeAdviceBindings(removedBindings);
/*      */     }
/* 1376 */     this.dynamicStrategy.interceptorChainsUpdated();
/*      */   }
/*      */ 
/*      */   public synchronized void addBinding(AdviceBinding binding)
/*      */   {
/* 1384 */     AdviceBinding removedBinding = internalRemoveBinding(binding.getName());
/* 1385 */     Set affectedAdvisors = removedBinding == null ? new HashSet() : new HashSet(removedBinding.getAdvisors());
/* 1386 */     initBindingsMap();
/* 1387 */     synchronized (this.bindings)
/*      */     {
/* 1389 */       this.bindings.put(binding.getName(), binding);
/*      */     }
/*      */ 
/* 1392 */     initPointcutsMap();
/* 1393 */     initPointcutInfosMap();
/* 1394 */     synchronized (this.pointcuts)
/*      */     {
/* 1396 */       Pointcut pointcut = binding.getPointcut();
/* 1397 */       this.pointcuts.put(pointcut.getName(), pointcut);
/* 1398 */       this.pointcutInfos.put(pointcut.getName(), new PointcutInfo(pointcut, binding, this.transformationStarted));
/* 1399 */       updatePointcutStats(pointcut);
/*      */     }
/*      */     Iterator i;
/* 1402 */     synchronized (this.advisors)
/*      */     {
/* 1404 */       updateAdvisorsForAddedBinding(binding);
/*      */ 
/* 1406 */       for (i = affectedAdvisors.iterator(); i.hasNext(); )
/*      */       {
/* 1408 */         Advisor advisor = (Advisor)i.next();
/* 1409 */         if (isAdvisorRegistered(advisor))
/* 1410 */           advisor.removeAdviceBinding(removedBinding);
/*      */       }
/*      */     }
/* 1413 */     this.dynamicStrategy.interceptorChainsUpdated();
/*      */   }
/*      */ 
/*      */   public void updateAdvisorsForAddedBinding(AdviceBinding binding)
/*      */   {
/* 1419 */     synchronized (this.advisors)
/*      */     {
/* 1421 */       Collection keys = this.advisors.keySet();
/* 1422 */       if (keys.size() > 0)
/*      */       {
/* 1424 */         Iterator it = keys.iterator();
/* 1425 */         while (it.hasNext())
/*      */         {
/* 1427 */           Advisor advisor = getAdvisorFromAdvisorsKeySetIterator(it);
/* 1428 */           if (advisor == null)
/*      */             continue;
/* 1430 */           if (binding.getPointcut().softMatch(advisor))
/*      */           {
/* 1432 */             if ((verbose) && (logger.isDebugEnabled()))
/* 1433 */               logger.debug("softmatch succeeded for : " + advisor.getName() + " " + binding + " " + binding.getPointcut().getExpr());
/* 1434 */             advisor.newBindingAdded();
/*      */           }
/* 1439 */           else if ((verbose) && (logger.isDebugEnabled())) {
/* 1440 */             logger.debug("softmatch failed for : " + advisor.getName() + " " + binding + " " + binding.getPointcut().getExpr());
/*      */           }
/*      */         }
/*      */       }
/*      */     }
/* 1445 */     synchronized (this.subscribedSubDomains)
/*      */     {
/* 1447 */       copySubDomainsFromQueue(true);
/* 1448 */       boolean newSubscribers = true;
/* 1449 */       while (newSubscribers)
/*      */       {
/* 1451 */         Collection keys = this.subscribedSubDomains.keySet();
/*      */         Iterator it;
/* 1452 */         if (keys.size() > 0)
/*      */         {
/* 1455 */           for (it = keys.iterator(); it.hasNext(); )
/*      */           {
/* 1457 */             Domain domain = (Domain)it.next();
/* 1458 */             domain.updateAdvisorsForAddedBinding(binding);
/*      */           }
/*      */         }
/* 1461 */         newSubscribers = copySubDomainsFromQueue(false);
/*      */       }
/*      */     }
/*      */   }
/*      */ 
/*      */   public void removeClassMetaData(String name)
/*      */   {
/* 1468 */     internalRemoveClassMetaData(name);
/*      */   }
/*      */ 
/*      */   public void internalRemoveClassMetaData(String name)
/*      */   {
/* 1473 */     synchronized (this.classMetaData)
/*      */     {
/* 1475 */       ClassMetaDataBinding meta = (ClassMetaDataBinding)this.classMetaData.remove(name);
/* 1476 */       if (meta == null) return;
/* 1477 */       meta.clearAdvisors();
/*      */     }
/*      */   }
/*      */ 
/*      */   public void addClassMetaData(ClassMetaDataBinding meta)
/*      */   {
/* 1483 */     internalRemoveClassMetaData(meta.getName());
/*      */ 
/* 1486 */     initClassMetaDataMap();
/* 1487 */     synchronized (this.classMetaData)
/*      */     {
/* 1489 */       this.classMetaData.put(meta.getName(), meta);
/*      */     }
/*      */ 
/* 1492 */     updateAdvisorsForAddedClassMetaData(meta);
/*      */   }
/*      */ 
/*      */   protected void updateAdvisorsForAddedClassMetaData(ClassMetaDataBinding meta)
/*      */   {
/* 1497 */     synchronized (this.advisors)
/*      */     {
/* 1499 */       Iterator it = this.advisors.keySet().iterator();
/*      */ 
/* 1501 */       while (it.hasNext())
/*      */       {
/* 1503 */         Advisor advisor = getAdvisorFromAdvisorsKeySetIterator(it);
/* 1504 */         if (advisor == null)
/*      */           continue;
/* 1506 */         Class clazz = advisor.getClazz();
/* 1507 */         addAdvisorToClassMetaDataBinding(meta, clazz, advisor, clazz);
/*      */       }
/*      */     }
/*      */ 
/* 1511 */     synchronized (this.subscribedSubDomains)
/*      */     {
/* 1513 */       copySubDomainsFromQueue(true);
/* 1514 */       boolean newSubscribers = true;
/* 1515 */       while (newSubscribers)
/*      */       {
/*      */         Iterator it;
/* 1517 */         if (this.subscribedSubDomains.size() > 0)
/*      */         {
/* 1519 */           for (it = this.subscribedSubDomains.keySet().iterator(); it.hasNext(); )
/*      */           {
/* 1521 */             Domain domain = (Domain)it.next();
/* 1522 */             domain.updateAdvisorsForAddedClassMetaData(meta);
/*      */           }
/*      */         }
/* 1525 */         newSubscribers = copySubDomainsFromQueue(false);
/*      */       }
/*      */     }
/*      */   }
/*      */ 
/*      */   protected void addAdvisorToClassMetaDataBinding(ClassMetaDataBinding meta, Class clazz, Advisor advisor, Class advisedClass)
/*      */   {
/* 1532 */     if (meta.matches(advisor, clazz))
/*      */     {
/* 1534 */       meta.addAdvisor(advisor);
/*      */     }
/* 1536 */     else if (advisor.chainOverridingForInheritedMethods())
/*      */     {
/* 1540 */       Class superClass = clazz.getSuperclass();
/* 1541 */       if ((superClass != null) && (superClass != Object.class))
/*      */       {
/* 1543 */         addAdvisorToClassMetaDataBinding(meta, superClass, advisor, advisedClass);
/*      */       }
/*      */     }
/*      */   }
/*      */ 
/*      */   public InterfaceIntroduction getInterfaceIntroduction(String name)
/*      */   {
/* 1555 */     synchronized (this.interfaceIntroductions)
/*      */     {
/* 1557 */       return (InterfaceIntroduction)this.interfaceIntroductions.get(name);
/*      */     }
/*      */   }
/*      */ 
/*      */   public synchronized void addInterfaceIntroduction(InterfaceIntroduction pointcut)
/*      */   {
/* 1566 */     removeInterfaceIntroduction(pointcut.getName());
/* 1567 */     initInterfaceIntroductionsMap();
/* 1568 */     synchronized (this.interfaceIntroductions)
/*      */     {
/* 1570 */       this.interfaceIntroductions.put(pointcut.getName(), pointcut);
/*      */     }
/*      */   }
/*      */ 
/*      */   public void removeInterfaceIntroduction(String name)
/*      */   {
/* 1579 */     synchronized (this.interfaceIntroductions)
/*      */     {
/* 1581 */       InterfaceIntroduction pointcut = (InterfaceIntroduction)this.interfaceIntroductions.remove(name);
/* 1582 */       if (pointcut == null) return;
/* 1583 */       pointcut.clearAdvisors();
/*      */     }
/*      */   }
/*      */ 
/*      */   public InterfaceIntroduction getArrayReplacement(String name)
/*      */   {
/* 1592 */     synchronized (this.arrayReplacements)
/*      */     {
/* 1594 */       return (InterfaceIntroduction)this.arrayReplacements.get(name);
/*      */     }
/*      */   }
/*      */ 
/*      */   public synchronized void addArrayReplacement(ArrayReplacement pointcut)
/*      */   {
/* 1603 */     removeArrayReplacement(pointcut.getName());
/* 1604 */     initArrayReplacementMap();
/* 1605 */     synchronized (this.arrayReplacements)
/*      */     {
/* 1607 */       this.arrayReplacements.put(pointcut.getName(), pointcut);
/*      */     }
/*      */   }
/*      */ 
/*      */   public void removeArrayReplacement(String name)
/*      */   {
/* 1616 */     synchronized (this.arrayReplacements)
/*      */     {
/* 1618 */       ArrayReplacement pointcut = (ArrayReplacement)this.arrayReplacements.remove(name);
/* 1619 */       if (pointcut == null) return;
/*      */     }
/*      */   }
/*      */ 
/*      */   public ArrayBinding getArrayBinding(String name)
/*      */   {
/* 1628 */     synchronized (this.arrayBindings)
/*      */     {
/* 1630 */       return (ArrayBinding)this.arrayBindings.get(name);
/*      */     }
/*      */   }
/*      */ 
/*      */   public synchronized void addArrayBinding(ArrayBinding binding)
/*      */   {
/* 1639 */     removeArrayBinding(binding.getName());
/* 1640 */     initArrayBindingMap();
/* 1641 */     synchronized (this.arrayBindings)
/*      */     {
/* 1643 */       this.arrayBindings.put(binding.getName(), binding);
/* 1644 */       ArrayAdvisor.addBinding(binding);
/*      */     }
/*      */   }
/*      */ 
/*      */   public void removeArrayBinding(String name)
/*      */   {
/* 1653 */     synchronized (this.arrayBindings)
/*      */     {
/* 1655 */       ArrayBinding pointcut = (ArrayBinding)this.arrayBindings.remove(name);
/* 1656 */       if (pointcut == null) return;
/* 1657 */       ArrayAdvisor.removeBinding(pointcut);
/*      */     }
/*      */   }
/*      */ 
/*      */   public synchronized void addAnnotationIntroduction(AnnotationIntroduction pointcut)
/*      */   {
/* 1667 */     String name = pointcut.getOriginalAnnotationExpr() + pointcut.getOriginalExpression();
/* 1668 */     removeAnnotationIntroduction(pointcut);
/* 1669 */     initAnnotationIntroductionsMap();
/* 1670 */     synchronized (this.annotationIntroductions)
/*      */     {
/* 1672 */       this.annotationIntroductions.put(name, pointcut);
/*      */     }
/*      */   }
/*      */ 
/*      */   public void removeAnnotationIntroduction(AnnotationIntroduction pointcut)
/*      */   {
/* 1681 */     String name = pointcut.getOriginalAnnotationExpr() + pointcut.getOriginalExpression();
/* 1682 */     synchronized (this.annotationIntroductions)
/*      */     {
/* 1684 */       this.annotationIntroductions.remove(name);
/*      */     }
/*      */   }
/*      */ 
/*      */   public List getAnnotationIntroductions()
/*      */   {
/* 1690 */     synchronized (this.annotationIntroductions)
/*      */     {
/* 1692 */       return new ArrayList(this.annotationIntroductions.values());
/*      */     }
/*      */   }
/*      */ 
/*      */   public synchronized void addDeclare(DeclareDef declare)
/*      */   {
/* 1698 */     removeDeclare(declare.getName());
/* 1699 */     initDeclaresMap();
/* 1700 */     synchronized (this.declares)
/*      */     {
/* 1702 */       this.declares.put(declare.getName(), declare);
/*      */     }
/* 1704 */     if (declare.isPointcut())
/*      */     {
/* 1707 */       PointcutStats stats = new PointcutStats(declare.getAst(), manager);
/* 1708 */       stats.matches();
/* 1709 */       updateStats(stats);
/*      */     }
/*      */   }
/*      */ 
/*      */   public void removeDeclare(String name)
/*      */   {
/* 1715 */     synchronized (this.declares)
/*      */     {
/* 1717 */       this.declares.remove(name);
/*      */     }
/*      */   }
/*      */ 
/*      */   public Iterator getDeclares()
/*      */   {
/* 1723 */     return this.declares.values().iterator();
/*      */   }
/*      */ 
/*      */   protected void applyInterfaceIntroductions(Advisor advisor, Class clazz)
/*      */   {
/* 1728 */     Map interfaceIntroductions = getInterfaceIntroductions();
/* 1729 */     if ((interfaceIntroductions != null) && (interfaceIntroductions.size() > 0))
/*      */     {
/* 1731 */       Iterator it = interfaceIntroductions.values().iterator();
/* 1732 */       while (it.hasNext())
/*      */       {
/* 1734 */         InterfaceIntroduction pointcut = (InterfaceIntroduction)it.next();
/* 1735 */         if (pointcut.matches(advisor, clazz))
/*      */         {
/* 1737 */           pointcut.addAdvisor(advisor);
/*      */         }
/*      */       }
/*      */     }
/*      */   }
/*      */ 
/*      */   protected void applyInterfaceIntroductions(ClassAdvisor advisor, CtClass clazz) throws Exception
/*      */   {
/* 1745 */     Map interfaceIntroductions = getInterfaceIntroductions();
/* 1746 */     if ((interfaceIntroductions != null) && (interfaceIntroductions.size() > 0))
/*      */     {
/* 1748 */       Iterator it = interfaceIntroductions.values().iterator();
/* 1749 */       while (it.hasNext())
/*      */       {
/* 1751 */         InterfaceIntroduction pointcut = (InterfaceIntroduction)it.next();
/* 1752 */         if (pointcut.matches(advisor, clazz))
/*      */         {
/* 1754 */           pointcut.addAdvisor(advisor);
/*      */         }
/*      */       }
/*      */     }
/*      */   }
/*      */ 
/*      */   public synchronized void addAnnotationOverride(AnnotationIntroduction pointcut)
/*      */   {
/* 1766 */     String name = pointcut.getOriginalAnnotationExpr() + pointcut.getOriginalExpression();
/* 1767 */     initAnnotationOverridesMap();
/* 1768 */     synchronized (this.annotationOverrides)
/*      */     {
/* 1770 */       this.annotationOverrides.put(name, pointcut);
/*      */     }
/* 1772 */     updateAdvisorsForAddedAnnotationOverride(pointcut);
/*      */   }
/*      */ 
/*      */   public void updateAdvisorsForAddedAnnotationOverride(AnnotationIntroduction introduction)
/*      */   {
/* 1777 */     synchronized (this.advisors)
/*      */     {
/* 1779 */       Iterator it = this.advisors.keySet().iterator();
/* 1780 */       while (it.hasNext())
/*      */       {
/* 1782 */         Advisor advisor = getAdvisorFromAdvisorsKeySetIterator(it);
/* 1783 */         if (advisor == null)
/*      */           continue;
/* 1785 */         advisor.deployAnnotationOverride(introduction);
/*      */       }
/*      */     }
/* 1788 */     synchronized (this.subscribedSubDomains)
/*      */     {
/* 1790 */       copySubDomainsFromQueue(true);
/* 1791 */       boolean newSubscribers = true;
/* 1792 */       while (newSubscribers)
/*      */       {
/* 1794 */         for (Iterator it = this.subscribedSubDomains.keySet().iterator(); it.hasNext(); )
/*      */         {
/* 1796 */           Domain domain = (Domain)it.next();
/* 1797 */           domain.updateAdvisorsForAddedAnnotationOverride(introduction);
/*      */         }
/* 1799 */         newSubscribers = copySubDomainsFromQueue(false);
/*      */       }
/*      */     }
/*      */   }
/*      */ 
/*      */   public void removeAnnotationOverride(AnnotationIntroduction pointcut)
/*      */   {
/* 1810 */     String name = pointcut.getOriginalAnnotationExpr() + pointcut.getOriginalExpression();
/* 1811 */     synchronized (this.annotationOverrides)
/*      */     {
/* 1813 */       this.annotationOverrides.remove(name);
/*      */     }
/*      */   }
/*      */ 
/*      */   public List getAnnotationOverrides()
/*      */   {
/* 1819 */     synchronized (this.annotationOverrides)
/*      */     {
/* 1821 */       return new ArrayList(this.annotationOverrides.values());
/*      */     }
/*      */   }
/*      */ 
/*      */   public Object getPerVMAspect(AspectDefinition def)
/*      */   {
/* 1827 */     return getPerVMAspect(def.getName());
/*      */   }
/*      */ 
/*      */   public Object getPerVMAspect(String def)
/*      */   {
/* 1832 */     Object aspect = this.perVMAspects.get(def);
/* 1833 */     if (aspect == null)
/*      */     {
/* 1835 */       AspectDefinition adef = (AspectDefinition)this.aspectDefinitions.get(def);
/* 1836 */       if ((adef != null) && (adef.getScope() == Scope.PER_VM))
/*      */       {
/* 1838 */         synchronized (adef)
/*      */         {
/* 1840 */           aspect = createPerVmAspect(def, adef, null);
/*      */         }
/*      */       }
/*      */     }
/* 1844 */     return aspect;
/*      */   }
/*      */ 
/*      */   protected Object createPerVmAspect(String def, AspectDefinition adef, ClassLoader scopedClassLoader)
/*      */   {
/* 1849 */     Object instance = null;
/* 1850 */     synchronized (adef)
/*      */     {
/*      */       try
/*      */       {
/* 1854 */         if ((scopedClassLoader != null) && ((adef.getFactory() instanceof AspectFactoryWithClassLoader)))
/*      */         {
/* 1857 */           ((AspectFactoryWithClassLoader)adef.getFactory()).pushScopedClassLoader(scopedClassLoader);
/*      */         }
/* 1859 */         instance = adef.getFactory().createPerVM();
/* 1860 */         initPerVMAspectsMap();
/* 1861 */         this.perVMAspects.put(def, instance);
/*      */       }
/*      */       finally
/*      */       {
/* 1865 */         if ((scopedClassLoader != null) && ((adef.getFactory() instanceof AspectFactoryWithClassLoader)))
/*      */         {
/* 1867 */           ((AspectFactoryWithClassLoader)adef.getFactory()).popScopedClassLoader();
/*      */         }
/*      */       }
/*      */     }
/* 1871 */     return instance;
/*      */   }
/*      */ 
/*      */   public void addAspectDefinition(AspectDefinition def)
/*      */   {
/* 1876 */     removeAspectDefinition(def.getName());
/* 1877 */     initAspectDefintitionsMap();
/* 1878 */     this.aspectDefinitions.put(def.getName(), def);
/*      */   }
/*      */ 
/*      */   public void removeAspectDefinition(String name)
/*      */   {
/* 1883 */     internalRemoveAspectDefintion(name);
/*      */   }
/*      */ 
/*      */   protected AspectDefinition internalRemoveAspectDefintion(String name)
/*      */   {
/* 1888 */     AspectDefinition def = (AspectDefinition)this.aspectDefinitions.remove(name);
/* 1889 */     if (def != null)
/*      */     {
/* 1891 */       def.undeploy();
/* 1892 */       if (def.getScope() == Scope.PER_VM) this.perVMAspects.remove(def.getName());
/*      */     }
/* 1894 */     return def;
/*      */   }
/*      */ 
/*      */   public Map getAspectDefinitions()
/*      */   {
/* 1899 */     return this.aspectDefinitions;
/*      */   }
/*      */ 
/*      */   public AspectDefinition getAspectDefinition(String name)
/*      */   {
/* 1904 */     return (AspectDefinition)this.aspectDefinitions.get(name);
/*      */   }
/*      */ 
/*      */   public synchronized void addTypedef(Typedef def) throws Exception
/*      */   {
/* 1909 */     removeTypedef(def.getName());
/* 1910 */     initTypedefsMap();
/* 1911 */     synchronized (this.typedefs)
/*      */     {
/* 1913 */       this.typedefs.put(def.getName(), def);
/*      */     }
/*      */   }
/*      */ 
/*      */   public void removeTypedef(String name)
/*      */   {
/* 1919 */     synchronized (this.typedefs)
/*      */     {
/* 1921 */       this.typedefs.remove(name);
/*      */     }
/*      */   }
/*      */ 
/*      */   public Typedef getTypedef(String name)
/*      */   {
/* 1927 */     synchronized (this.typedefs)
/*      */     {
/* 1929 */       return (Typedef)this.typedefs.get(name);
/*      */     }
/*      */   }
/*      */ 
/*      */   public Map getInterfaceIntroductions()
/*      */   {
/* 1935 */     return this.interfaceIntroductions;
/*      */   }
/*      */ 
/*      */   public Map getArrayReplacements()
/*      */   {
/* 1940 */     return this.arrayReplacements;
/*      */   }
/*      */ 
/*      */   public Map getTypedefs()
/*      */   {
/* 1945 */     return this.typedefs;
/*      */   }
/*      */ 
/*      */   public Map getInterceptorStacks()
/*      */   {
/* 1950 */     return this.interceptorStacks;
/*      */   }
/*      */ 
/*      */   public Map getClassMetaDataLoaders()
/*      */   {
/* 1955 */     return this.classMetaDataLoaders;
/*      */   }
/*      */ 
/*      */   public Map getCflowStacks()
/*      */   {
/* 1960 */     return this.cflowStacks;
/*      */   }
/*      */ 
/*      */   public Map getDynamicCFlows()
/*      */   {
/* 1965 */     return this.dynamicCFlows;
/*      */   }
/*      */ 
/*      */   public Map getPerVMAspects()
/*      */   {
/* 1970 */     return this.perVMAspects;
/*      */   }
/*      */ 
/*      */   public Map getClassMetaData()
/*      */   {
/* 1975 */     return this.classMetaData;
/*      */   }
/*      */ 
/*      */   public DynamicAOPStrategy getDynamicAOPStrategy()
/*      */   {
/* 1983 */     return this.dynamicStrategy;
/*      */   }
/*      */ 
/*      */   public void setDynamicAOPStrategy(DynamicAOPStrategy strategy)
/*      */   {
/* 1994 */     if (this.transformationStarted)
/*      */     {
/* 1996 */       throw new RuntimeException("Dynamic AOP Strategy Update not allowed in run time");
/*      */     }
/* 1998 */     this.dynamicStrategy = strategy;
/*      */   }
/*      */ 
/*      */   private AdviceBinding internalRemoveBinding(String name)
/*      */   {
/* 2007 */     synchronized (this.bindings)
/*      */     {
/* 2009 */       AdviceBinding binding = (AdviceBinding)this.bindings.remove(name);
/* 2010 */       if (binding == null)
/*      */       {
/* 2012 */         return null;
/*      */       }
/* 2014 */       Pointcut pointcut = binding.getPointcut();
/* 2015 */       removePointcut(pointcut.getName());
/* 2016 */       return binding;
/*      */     }
/*      */   }
/*      */ 
/*      */   public void addSubDomainPerClass(Class clazz, Domain domain)
/*      */   {
/* 2029 */     synchronized (getSubDomainsPerClass())
/*      */     {
/* 2031 */       getSubDomainsPerClass().put(clazz, new WeakReference(domain));
/*      */     }
/*      */   }
/*      */ 
/*      */   public void subscribeSubDomain(Domain domain)
/*      */   {
/* 2041 */     initSubscribedSubDomainsMap();
/* 2042 */     initSubscribedSubDomainsQueueMap();
/* 2043 */     synchronized (this.subscribedSubDomains)
/*      */     {
/* 2045 */       this.subscribedSubDomainsQueue.put(domain, "Contents do not matter");
/*      */     }
/*      */   }
/*      */ 
/*      */   public void unsubscribeSubDomain(Domain domain)
/*      */   {
/* 2051 */     synchronized (this.subscribedSubDomains)
/*      */     {
/* 2053 */       this.subscribedSubDomains.remove(domain);
/*      */     }
/*      */   }
/*      */ 
/*      */   public Map getSubscribedSubDomains()
/*      */   {
/* 2059 */     return this.subscribedSubDomains;
/*      */   }
/*      */ 
/*      */   private Advisor getAdvisorFromAdvisorsKeySetIterator(Iterator it)
/*      */   {
/* 2064 */     Class clazz = (Class)it.next();
/* 2065 */     if ((classLoaderValidator != null) && (!classLoaderValidator.isValidClassLoader(clazz.getClassLoader())))
/*      */     {
/* 2067 */       it.remove();
/* 2068 */       return null;
/*      */     }
/* 2070 */     WeakReference ref = (WeakReference)this.advisors.get(clazz);
/* 2071 */     if (ref == null) return null;
/* 2072 */     Advisor advisor = (Advisor)ref.get();
/* 2073 */     if (advisor == null)
/*      */     {
/* 2075 */       it.remove();
/* 2076 */       return null;
/*      */     }
/* 2078 */     return advisor;
/*      */   }
/*      */ 
/*      */   private boolean copySubDomainsFromQueue(boolean increment)
/*      */   {
/* 2088 */     boolean copied = false;
/* 2089 */     initSubscribedSubDomainsMap();
/* 2090 */     synchronized (this.subscribedSubDomains)
/*      */     {
/* 2092 */       if ((!increment) && (this.subscribedDomainQueueRef > 0)) this.subscribedDomainQueueRef -= 1;
/*      */ 
/* 2094 */       if ((this.subscribedDomainQueueRef == 0) && (this.subscribedSubDomainsQueue.size() > 0)) {
/* 2095 */         this.subscribedSubDomains.putAll(this.subscribedSubDomainsQueue);
/* 2096 */         this.subscribedSubDomainsQueue.clear();
/* 2097 */         copied = true;
/*      */       }
/*      */ 
/* 2100 */       if (increment) this.subscribedDomainQueueRef += 1;
/*      */     }
/* 2102 */     return copied;
/*      */   }
/*      */ 
/*      */   public void addLifecycleDefinition(AspectDefinition def)
/*      */   {
/* 2107 */     this.lifecycleManager.addLifecycleDefinition(def);
/*      */   }
/*      */ 
/*      */   public void removeLifecycleDefinition(String name)
/*      */   {
/* 2112 */     this.lifecycleManager.removeLifecycleDefinition(name);
/*      */   }
/*      */ 
/*      */   public void addLifecycleBinding(LifecycleCallbackBinding lifecycleBinding)
/*      */   {
/* 2117 */     this.lifecycleManager.addLifecycleBinding(lifecycleBinding);
/*      */   }
/*      */ 
/*      */   public Map<String, LifecycleCallbackBinding> getLifecycleBindings()
/*      */   {
/* 2122 */     return this.lifecycleManager.getLifecycleBindings();
/*      */   }
/*      */ 
/*      */   public void removeLifecycleBinding(String name)
/*      */   {
/* 2127 */     this.lifecycleManager.removeLifecycleBinding(name);
/*      */   }
/*      */ 
/*      */   protected void lockWrite()
/*      */   {
/* 2180 */     this.lock.writeLock().lock();
/*      */   }
/*      */ 
/*      */   protected void unlockWrite()
/*      */   {
/* 2188 */     this.lock.writeLock().unlock();
/*      */   }
/*      */ 
/*      */   protected void initSubDomainsByNameMap()
/*      */   {
/* 2193 */     if (this.subDomainsByName == UnmodifiableEmptyCollections.EMPTY_WEAK_VALUE_HASHMAP)
/*      */     {
/* 2195 */       lockWrite();
/*      */       try
/*      */       {
/* 2198 */         if (this.subDomainsByName == UnmodifiableEmptyCollections.EMPTY_WEAK_VALUE_HASHMAP)
/*      */         {
/* 2200 */           this.subDomainsByName = new WeakValueHashMap();
/*      */         }
/*      */       }
/*      */       finally
/*      */       {
/* 2205 */         unlockWrite();
/*      */       }
/*      */     }
/*      */   }
/*      */ 
/*      */   protected void initSubscribedSubDomainsMap()
/*      */   {
/* 2212 */     if (this.subscribedSubDomains == UnmodifiableEmptyCollections.EMPTY_WEAK_HASHMAP)
/*      */     {
/* 2214 */       lockWrite();
/*      */       try
/*      */       {
/* 2217 */         if (this.subscribedSubDomains == UnmodifiableEmptyCollections.EMPTY_WEAK_HASHMAP)
/*      */         {
/* 2219 */           this.subscribedSubDomains = new WeakHashMap();
/*      */         }
/*      */       }
/*      */       finally
/*      */       {
/* 2224 */         unlockWrite();
/*      */       }
/*      */     }
/*      */   }
/*      */ 
/*      */   protected void initSubscribedSubDomainsQueueMap()
/*      */   {
/* 2231 */     if (this.subscribedSubDomainsQueue == UnmodifiableEmptyCollections.EMPTY_WEAK_HASHMAP)
/*      */     {
/* 2233 */       lockWrite();
/*      */       try
/*      */       {
/* 2236 */         if (this.subscribedSubDomainsQueue == UnmodifiableEmptyCollections.EMPTY_WEAK_HASHMAP)
/*      */         {
/* 2238 */           this.subscribedSubDomainsQueue = new WeakHashMap();
/*      */         }
/*      */       }
/*      */       finally
/*      */       {
/* 2243 */         unlockWrite();
/*      */       }
/*      */     }
/*      */   }
/*      */ 
/*      */   protected void initInterfaceIntroductionsMap()
/*      */   {
/* 2250 */     if (this.interfaceIntroductions == UnmodifiableEmptyCollections.EMPTY_LINKED_HASHMAP)
/*      */     {
/* 2252 */       lockWrite();
/*      */       try
/*      */       {
/* 2255 */         if (this.interfaceIntroductions == UnmodifiableEmptyCollections.EMPTY_LINKED_HASHMAP)
/*      */         {
/* 2257 */           this.interfaceIntroductions = new LinkedHashMap();
/*      */         }
/*      */       }
/*      */       finally
/*      */       {
/* 2262 */         unlockWrite();
/*      */       }
/*      */     }
/*      */   }
/*      */ 
/*      */   protected void initArrayReplacementMap()
/*      */   {
/* 2269 */     if (this.arrayReplacements == UnmodifiableEmptyCollections.EMPTY_LINKED_HASHMAP)
/*      */     {
/* 2271 */       lockWrite();
/*      */       try
/*      */       {
/* 2274 */         if (this.arrayReplacements == UnmodifiableEmptyCollections.EMPTY_LINKED_HASHMAP)
/*      */         {
/* 2276 */           this.arrayReplacements = new LinkedHashMap();
/*      */         }
/*      */       }
/*      */       finally
/*      */       {
/* 2281 */         unlockWrite();
/*      */       }
/*      */     }
/*      */   }
/*      */ 
/*      */   protected void initArrayBindingMap()
/*      */   {
/* 2288 */     if (this.arrayBindings == UnmodifiableEmptyCollections.EMPTY_LINKED_HASHMAP)
/*      */     {
/* 2290 */       lockWrite();
/*      */       try
/*      */       {
/* 2293 */         if (this.arrayBindings == UnmodifiableEmptyCollections.EMPTY_LINKED_HASHMAP)
/*      */         {
/* 2295 */           this.arrayBindings = new LinkedHashMap();
/*      */         }
/*      */       }
/*      */       finally
/*      */       {
/* 2300 */         unlockWrite();
/*      */       }
/*      */     }
/*      */   }
/*      */ 
/*      */   protected void initAnnotationIntroductionsMap()
/*      */   {
/* 2308 */     if (this.annotationIntroductions == UnmodifiableEmptyCollections.EMPTY_LINKED_HASHMAP)
/*      */     {
/* 2310 */       lockWrite();
/*      */       try
/*      */       {
/* 2313 */         if (this.annotationIntroductions == UnmodifiableEmptyCollections.EMPTY_LINKED_HASHMAP)
/*      */         {
/* 2315 */           this.annotationIntroductions = new LinkedHashMap();
/*      */         }
/*      */       }
/*      */       finally
/*      */       {
/* 2320 */         unlockWrite();
/*      */       }
/*      */     }
/*      */   }
/*      */ 
/*      */   protected void initAnnotationOverridesMap()
/*      */   {
/* 2327 */     if (this.annotationOverrides == UnmodifiableEmptyCollections.EMPTY_LINKED_HASHMAP)
/*      */     {
/* 2329 */       lockWrite();
/*      */       try
/*      */       {
/* 2332 */         if (this.annotationOverrides == UnmodifiableEmptyCollections.EMPTY_LINKED_HASHMAP)
/*      */         {
/* 2334 */           this.annotationOverrides = new LinkedHashMap();
/*      */         }
/*      */       }
/*      */       finally
/*      */       {
/* 2339 */         unlockWrite();
/*      */       }
/*      */     }
/*      */   }
/*      */ 
/*      */   protected void initBindingsMap()
/*      */   {
/* 2346 */     if (this.bindings == UnmodifiableEmptyCollections.EMPTY_LINKED_HASHMAP)
/*      */     {
/* 2348 */       lockWrite();
/*      */       try
/*      */       {
/* 2351 */         if (this.bindings == UnmodifiableEmptyCollections.EMPTY_LINKED_HASHMAP)
/*      */         {
/* 2353 */           this.bindings = new LinkedHashMap();
/*      */         }
/*      */       }
/*      */       finally
/*      */       {
/* 2358 */         unlockWrite();
/*      */       }
/*      */     }
/*      */   }
/*      */ 
/*      */   protected void initTypedefsMap()
/*      */   {
/* 2365 */     if (this.typedefs == UnmodifiableEmptyCollections.EMPTY_LINKED_HASHMAP)
/*      */     {
/* 2367 */       lockWrite();
/*      */       try
/*      */       {
/* 2370 */         if (this.typedefs == UnmodifiableEmptyCollections.EMPTY_LINKED_HASHMAP)
/*      */         {
/* 2372 */           this.typedefs = new LinkedHashMap();
/*      */         }
/*      */       }
/*      */       finally
/*      */       {
/* 2377 */         unlockWrite();
/*      */       }
/*      */     }
/*      */   }
/*      */ 
/*      */   protected void initInterceptorFactoriesMap()
/*      */   {
/* 2384 */     if (this.interceptorFactories == UnmodifiableEmptyCollections.EMPTY_HASHMAP)
/*      */     {
/* 2386 */       lockWrite();
/*      */       try
/*      */       {
/* 2389 */         if (this.interceptorFactories == UnmodifiableEmptyCollections.EMPTY_HASHMAP)
/*      */         {
/* 2391 */           this.interceptorFactories = new HashMap();
/*      */         }
/*      */       }
/*      */       finally
/*      */       {
/* 2396 */         unlockWrite();
/*      */       }
/*      */     }
/*      */   }
/*      */ 
/*      */   protected void initClassMetaDataLoadersMap()
/*      */   {
/* 2403 */     if (this.classMetaDataLoaders == UnmodifiableEmptyCollections.EMPTY_HASHMAP)
/*      */     {
/* 2405 */       lockWrite();
/*      */       try
/*      */       {
/* 2408 */         if (this.classMetaDataLoaders == UnmodifiableEmptyCollections.EMPTY_HASHMAP)
/*      */         {
/* 2410 */           this.classMetaDataLoaders = new HashMap();
/*      */         }
/*      */       }
/*      */       finally
/*      */       {
/* 2415 */         unlockWrite();
/*      */       }
/*      */     }
/*      */   }
/*      */ 
/*      */   protected void initInerceptorStacksMap()
/*      */   {
/* 2422 */     if (this.interceptorStacks == UnmodifiableEmptyCollections.EMPTY_HASHMAP)
/*      */     {
/* 2424 */       lockWrite();
/*      */       try
/*      */       {
/* 2427 */         if (this.interceptorStacks == UnmodifiableEmptyCollections.EMPTY_HASHMAP)
/*      */         {
/* 2429 */           this.interceptorStacks = new HashMap();
/*      */         }
/*      */       }
/*      */       finally
/*      */       {
/* 2434 */         unlockWrite();
/*      */       }
/*      */     }
/*      */   }
/*      */ 
/*      */   protected void initDeclaresMap()
/*      */   {
/* 2442 */     if (this.declares == UnmodifiableEmptyCollections.EMPTY_HASHMAP)
/*      */     {
/* 2444 */       lockWrite();
/*      */       try
/*      */       {
/* 2447 */         if (this.declares == UnmodifiableEmptyCollections.EMPTY_HASHMAP)
/*      */         {
/* 2449 */           this.declares = new HashMap();
/*      */         }
/*      */       }
/*      */       finally
/*      */       {
/* 2454 */         unlockWrite();
/*      */       }
/*      */     }
/*      */   }
/*      */ 
/*      */   protected void initCflowStacksMap()
/*      */   {
/* 2461 */     if (this.cflowStacks == UnmodifiableEmptyCollections.EMPTY_CONCURRENT_HASHMAP)
/*      */     {
/* 2463 */       lockWrite();
/*      */       try
/*      */       {
/* 2466 */         if (this.cflowStacks == UnmodifiableEmptyCollections.EMPTY_CONCURRENT_HASHMAP)
/*      */         {
/* 2468 */           this.cflowStacks = new ConcurrentHashMap();
/*      */         }
/*      */       }
/*      */       finally
/*      */       {
/* 2473 */         unlockWrite();
/*      */       }
/*      */     }
/*      */   }
/*      */ 
/*      */   protected void initDynamicCflowsMap()
/*      */   {
/* 2480 */     if (this.dynamicCFlows == UnmodifiableEmptyCollections.EMPTY_CONCURRENT_HASHMAP)
/*      */     {
/* 2482 */       lockWrite();
/*      */       try
/*      */       {
/* 2485 */         if (this.dynamicCFlows == UnmodifiableEmptyCollections.EMPTY_CONCURRENT_HASHMAP)
/*      */         {
/* 2487 */           this.dynamicCFlows = new ConcurrentHashMap();
/*      */         }
/*      */       }
/*      */       finally
/*      */       {
/* 2492 */         unlockWrite();
/*      */       }
/*      */     }
/*      */   }
/*      */ 
/*      */   protected void initAspectDefintitionsMap()
/*      */   {
/* 2499 */     if (this.aspectDefinitions == UnmodifiableEmptyCollections.EMPTY_CONCURRENT_HASHMAP)
/*      */     {
/* 2501 */       lockWrite();
/*      */       try
/*      */       {
/* 2504 */         if (this.aspectDefinitions == UnmodifiableEmptyCollections.EMPTY_CONCURRENT_HASHMAP)
/*      */         {
/* 2506 */           this.aspectDefinitions = new ConcurrentHashMap();
/*      */         }
/*      */       }
/*      */       finally
/*      */       {
/* 2511 */         unlockWrite();
/*      */       }
/*      */     }
/*      */   }
/*      */ 
/*      */   protected void initPerVMAspectsMap()
/*      */   {
/* 2518 */     if (this.perVMAspects == UnmodifiableEmptyCollections.EMPTY_CONCURRENT_HASHMAP)
/*      */     {
/* 2520 */       lockWrite();
/*      */       try
/*      */       {
/* 2523 */         if (this.perVMAspects == UnmodifiableEmptyCollections.EMPTY_CONCURRENT_HASHMAP)
/*      */         {
/* 2525 */           this.perVMAspects = new ConcurrentHashMap();
/*      */         }
/*      */       }
/*      */       finally
/*      */       {
/* 2530 */         unlockWrite();
/*      */       }
/*      */     }
/*      */   }
/*      */ 
/*      */   protected void initPointcutsMap()
/*      */   {
/* 2537 */     if (this.pointcuts == UnmodifiableEmptyCollections.EMPTY_LINKED_HASHMAP)
/*      */     {
/* 2539 */       lockWrite();
/*      */       try
/*      */       {
/* 2542 */         if (this.pointcuts == UnmodifiableEmptyCollections.EMPTY_LINKED_HASHMAP)
/*      */         {
/* 2544 */           this.pointcuts = new LinkedHashMap();
/*      */         }
/*      */       }
/*      */       finally
/*      */       {
/* 2549 */         unlockWrite();
/*      */       }
/*      */     }
/*      */   }
/*      */ 
/*      */   protected void initPointcutInfosMap()
/*      */   {
/* 2556 */     if (this.pointcutInfos == UnmodifiableEmptyCollections.EMPTY_LINKED_HASHMAP)
/*      */     {
/* 2558 */       lockWrite();
/*      */       try
/*      */       {
/* 2561 */         if (this.pointcutInfos == UnmodifiableEmptyCollections.EMPTY_LINKED_HASHMAP)
/*      */         {
/* 2563 */           this.pointcutInfos = new LinkedHashMap();
/*      */         }
/*      */       }
/*      */       finally
/*      */       {
/* 2568 */         unlockWrite();
/*      */       }
/*      */     }
/*      */   }
/*      */ 
/*      */   protected void initClassMetaDataMap()
/*      */   {
/* 2576 */     if (this.classMetaData == UnmodifiableEmptyCollections.EMPTY_LINKED_HASHMAP)
/*      */     {
/* 2578 */       lockWrite();
/*      */       try
/*      */       {
/* 2581 */         if (this.classMetaData == UnmodifiableEmptyCollections.EMPTY_LINKED_HASHMAP)
/*      */         {
/* 2583 */           this.classMetaData = new LinkedHashMap();
/*      */         }
/*      */       }
/*      */       finally
/*      */       {
/* 2588 */         unlockWrite();
/*      */       }
/*      */     }
/*      */   }
/*      */ 
/*      */   protected void initContainersMap() {
/* 2594 */     if (this.containers == UnmodifiableEmptyCollections.EMPTY_HASHMAP)
/*      */     {
/* 2596 */       lockWrite();
/*      */       try
/*      */       {
/* 2599 */         if (this.containers == UnmodifiableEmptyCollections.EMPTY_HASHMAP)
/*      */         {
/* 2601 */           this.containers = new HashMap();
/*      */         }
/*      */       }
/*      */       finally
/*      */       {
/* 2606 */         unlockWrite();
/*      */       }
/*      */     }
/*      */   }
/*      */ 
/*      */   protected void initPrecedenceDefsMap()
/*      */   {
/* 2613 */     if (this.precedenceDefs == UnmodifiableEmptyCollections.EMPTY_LINKED_HASHMAP)
/*      */     {
/* 2615 */       lockWrite();
/*      */       try
/*      */       {
/* 2618 */         if (this.precedenceDefs == UnmodifiableEmptyCollections.EMPTY_LINKED_HASHMAP)
/*      */         {
/* 2620 */           this.precedenceDefs = new LinkedHashMap();
/*      */         }
/*      */       }
/*      */       finally
/*      */       {
/* 2625 */         unlockWrite();
/*      */       }
/*      */     }
/*      */   }
/*      */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.aop.AspectManager
 * JD-Core Version:    0.6.0
 */