/*      */ package org.jboss.aop;
/*      */ 
/*      */ import java.io.DataInputStream;
/*      */ import java.io.InputStream;
/*      */ import java.io.StringReader;
/*      */ import java.util.ArrayList;
/*      */ import java.util.Iterator;
/*      */ import java.util.List;
/*      */ import javassist.CtClass;
/*      */ import javassist.CtPrimitiveType;
/*      */ import javassist.Modifier;
/*      */ import javassist.bytecode.AnnotationsAttribute;
/*      */ import javassist.bytecode.ClassFile;
/*      */ import javassist.bytecode.Descriptor;
/*      */ import javassist.bytecode.FieldInfo;
/*      */ import javassist.bytecode.MethodInfo;
/*      */ import javassist.bytecode.annotation.Annotation;
/*      */ import javassist.bytecode.annotation.ArrayMemberValue;
/*      */ import javassist.bytecode.annotation.BooleanMemberValue;
/*      */ import javassist.bytecode.annotation.ClassMemberValue;
/*      */ import javassist.bytecode.annotation.MemberValue;
/*      */ import javassist.bytecode.annotation.StringMemberValue;
/*      */ import org.jboss.annotation.factory.javassist.AnnotationProxy;
/*      */ import org.jboss.aop.advice.AdviceBinding;
/*      */ import org.jboss.aop.advice.AdviceFactory;
/*      */ import org.jboss.aop.advice.AspectDefinition;
/*      */ import org.jboss.aop.advice.AspectFactory;
/*      */ import org.jboss.aop.advice.AspectFactoryDelegator;
/*      */ import org.jboss.aop.advice.AspectFactoryWithClassLoader;
/*      */ import org.jboss.aop.advice.DynamicCFlowDefinition;
/*      */ import org.jboss.aop.advice.GenericAspectFactory;
/*      */ import org.jboss.aop.advice.Interceptor;
/*      */ import org.jboss.aop.advice.InterceptorFactory;
/*      */ import org.jboss.aop.advice.PrecedenceDef;
/*      */ import org.jboss.aop.advice.PrecedenceDefEntry;
/*      */ import org.jboss.aop.advice.Scope;
/*      */ import org.jboss.aop.advice.ScopedInterceptorFactory;
/*      */ import org.jboss.aop.introduction.AnnotationIntroduction;
/*      */ import org.jboss.aop.introduction.InterfaceIntroduction;
/*      */ import org.jboss.aop.introduction.InterfaceIntroduction.Mixin;
/*      */ import org.jboss.aop.pointcut.CFlow;
/*      */ import org.jboss.aop.pointcut.CFlowStack;
/*      */ import org.jboss.aop.pointcut.DeclareDef;
/*      */ import org.jboss.aop.pointcut.DynamicCFlow;
/*      */ import org.jboss.aop.pointcut.Pointcut;
/*      */ import org.jboss.aop.pointcut.PointcutExpression;
/*      */ import org.jboss.aop.pointcut.Typedef;
/*      */ import org.jboss.aop.pointcut.TypedefExpression;
/*      */ import org.jboss.aop.pointcut.ast.ASTCFlowExpression;
/*      */ import org.jboss.aop.pointcut.ast.ASTStart;
/*      */ import org.jboss.aop.pointcut.ast.PointcutExpressionParser;
/*      */ import org.jboss.aop.pointcut.ast.TypeExpressionParser;
/*      */ import org.jboss.aop.util.MethodHashing;
/*      */ import org.jboss.aop.util.logging.AOPLogger;
/*      */ import org.jboss.logging.Logger;
/*      */ 
/*      */ public class AspectAnnotationLoader
/*      */ {
/*   86 */   private static final Logger logger = AOPLogger.getLogger(AspectAnnotationLoader.class);
/*      */   protected AspectManager manager;
/*      */   private ClassLoader cl;
/*      */ 
/*      */   public AspectAnnotationLoader(AspectManager manager)
/*      */   {
/*   94 */     this.manager = manager;
/*      */   }
/*      */ 
/*      */   public void setClassLoader(ClassLoader cl)
/*      */   {
/*   99 */     this.cl = cl;
/*      */   }
/*      */ 
/*      */   public void deployInputStreamIterator(Iterator it) throws Exception
/*      */   {
/*  104 */     while (it.hasNext())
/*      */     {
/*  106 */       InputStream stream = (InputStream)it.next();
/*  107 */       DataInputStream dstream = new DataInputStream(stream);
/*  108 */       ClassFile cf = null;
/*      */       try
/*      */       {
/*  111 */         cf = new ClassFile(dstream);
/*      */       }
/*      */       finally
/*      */       {
/*  115 */         dstream.close();
/*  116 */         stream.close();
/*      */       }
/*  118 */       deployClassFile(cf);
/*      */     }
/*      */   }
/*      */ 
/*      */   public void deployClassFile(ClassFile cf) throws Exception
/*      */   {
/*  124 */     if ((AspectManager.verbose) && (logger.isDebugEnabled())) logger.debug("Looking for aspects in: " + cf.getName());
/*  125 */     AnnotationsAttribute visible = (AnnotationsAttribute)cf.getAttribute("RuntimeVisibleAnnotations");
/*  126 */     if (visible != null)
/*      */     {
/*  128 */       AspectDefinition def = deployAspect(visible, cf);
/*      */ 
/*  130 */       if (def == null)
/*      */       {
/*  132 */         def = deployInterceptor(visible, cf);
/*      */       }
/*      */ 
/*  135 */       if (def == null)
/*      */       {
/*  137 */         deployDynamicCFlow(visible, cf);
/*      */       }
/*      */ 
/*  140 */       if (def == null)
/*      */       {
/*  142 */         if (!deployPreparedClass(visible, cf))
/*      */         {
/*  144 */           deployPrecedence(visible, cf);
/*      */         }
/*      */       }
/*      */       else
/*      */       {
/*  149 */         deployPointcuts(cf);
/*  150 */         deployMixins(cf);
/*  151 */         deployIntroductions(cf);
/*  152 */         deployTypedefs(cf);
/*  153 */         deployCFlowStackDefs(cf);
/*  154 */         deployPrepares(cf);
/*  155 */         deployAnnotationIntroductions(cf);
/*  156 */         deployDeclares(cf);
/*      */       }
/*      */     }
/*      */   }
/*      */ 
/*      */   public void undeployInputStreamIterator(Iterator it) throws Exception
/*      */   {
/*  163 */     while (it.hasNext())
/*      */     {
/*  165 */       InputStream stream = (InputStream)it.next();
/*  166 */       DataInputStream dstream = new DataInputStream(stream);
/*  167 */       ClassFile cf = null;
/*      */       try
/*      */       {
/*  170 */         cf = new ClassFile(dstream);
/*      */       }
/*      */       finally
/*      */       {
/*  174 */         dstream.close();
/*  175 */         stream.close();
/*      */       }
/*  177 */       undeployClassFile(cf);
/*      */     }
/*      */   }
/*      */ 
/*      */   public void undeployClassFile(ClassFile cf) throws Exception
/*      */   {
/*  183 */     if ((AspectManager.verbose) && (logger.isDebugEnabled())) logger.debug("Looking for aspects in: " + cf.getName());
/*  184 */     AnnotationsAttribute visible = (AnnotationsAttribute)cf.getAttribute("RuntimeVisibleAnnotations");
/*  185 */     if (visible != null)
/*      */     {
/*  187 */       undeployAspect(visible, cf);
/*  188 */       undeployInterceptor(visible, cf);
/*  189 */       undeployDynamicCFlow(visible, cf);
/*  190 */       undeployPreparedClass(visible, cf);
/*  191 */       undeployPrecedence(visible, cf);
/*  192 */       undeployPointcuts(cf);
/*  193 */       undeployMixins(cf);
/*  194 */       undeployIntroductions(cf);
/*  195 */       undeployTypedefs(cf);
/*  196 */       undeployCFlowStackDefs(cf);
/*  197 */       undeployPrepares(cf);
/*  198 */       undeployAnnotationIntroductions(cf);
/*      */     }
/*      */   }
/*      */ 
/*      */   private AspectDefinition deployAspect(AnnotationsAttribute visible, ClassFile cf)
/*      */     throws Exception
/*      */   {
/*  205 */     Annotation info = visible.getAnnotation(Aspect.class.getName());
/*  206 */     if (info != null)
/*      */     {
/*  208 */       if ((AspectManager.verbose) && (logger.isDebugEnabled())) logger.debug("[debug] Found @Aspect in: " + cf.getName());
/*  209 */       Aspect aspect = (Aspect)AnnotationProxy.createProxy(info, Aspect.class);
/*  210 */       Scope scope = aspect.scope();
/*      */ 
/*  212 */       String[] interfaces = cf.getInterfaces();
/*  213 */       boolean isFactory = false;
/*  214 */       for (int i = 0; i < interfaces.length; i++)
/*      */       {
/*  216 */         if (!interfaces[i].equals(AspectFactory.class.getName()))
/*      */           continue;
/*  218 */         isFactory = true;
/*  219 */         break;
/*      */       }
/*      */ 
/*  222 */       AspectFactory factory = null;
/*  223 */       if (isFactory)
/*      */       {
/*  225 */         factory = new AspectFactoryDelegator(cf.getName(), null);
/*  226 */         ((AspectFactoryWithClassLoader)factory).setClassLoader(this.cl);
/*      */       }
/*      */       else
/*      */       {
/*  230 */         factory = new GenericAspectFactory(cf.getName(), null);
/*  231 */         ((AspectFactoryWithClassLoader)factory).setClassLoader(this.cl);
/*      */       }
/*  233 */       AspectDefinition def = new AspectDefinition(cf.getName(), scope, factory);
/*  234 */       this.manager.addAspectDefinition(def);
/*  235 */       if (!isFactory)
/*      */       {
/*  237 */         deployAspectMethodBindings(cf, def);
/*      */       }
/*      */ 
/*  240 */       return def;
/*      */     }
/*  242 */     return null;
/*      */   }
/*      */ 
/*      */   private void undeployAspect(AnnotationsAttribute visible, ClassFile cf)
/*      */     throws Exception
/*      */   {
/*  248 */     Annotation info = visible.getAnnotation(Aspect.class.getName());
/*  249 */     if (info != null)
/*      */     {
/*  251 */       if ((AspectManager.verbose) && (logger.isDebugEnabled())) logger.debug("Undeploying @Aspect in: " + cf.getName());
/*  252 */       this.manager.removeAspectDefinition(cf.getName());
/*      */ 
/*  254 */       undeployAspectMethodBindings(cf);
/*      */     }
/*      */   }
/*      */ 
/*      */   private AspectDefinition deployInterceptor(AnnotationsAttribute visible, ClassFile cf)
/*      */     throws Exception
/*      */   {
/*  261 */     Annotation info = visible.getAnnotation(InterceptorDef.class.getName());
/*  262 */     if (info != null)
/*      */     {
/*  264 */       if ((AspectManager.verbose) && (logger.isDebugEnabled())) logger.debug("Found @InterceptorDef in: " + cf.getName());
/*  265 */       Aspect aspect = (Aspect)AnnotationProxy.createProxy(info, Aspect.class);
/*  266 */       Scope scope = aspect.scope();
/*      */ 
/*  268 */       String[] interfaces = cf.getInterfaces();
/*  269 */       boolean isFactory = false;
/*  270 */       for (int i = 0; i < interfaces.length; i++)
/*      */       {
/*  272 */         if (interfaces[i].equals(AspectFactory.class.getName()))
/*      */         {
/*  274 */           isFactory = true;
/*  275 */           break;
/*      */         }
/*  277 */         if (interfaces[i].equals(Interceptor.class.getName()))
/*      */           break;
/*      */       }
/*      */       AspectFactory aspectFactory;
/*  284 */       if (isFactory)
/*      */       {
/*  286 */         AspectFactory aspectFactory = new AspectFactoryDelegator(cf.getName(), null);
/*  287 */         ((AspectFactoryWithClassLoader)aspectFactory).setClassLoader(this.cl);
/*      */       }
/*      */       else
/*      */       {
/*  291 */         aspectFactory = new GenericAspectFactory(cf.getName(), null);
/*  292 */         ((AspectFactoryWithClassLoader)aspectFactory).setClassLoader(this.cl);
/*      */       }
/*      */ 
/*  295 */       AspectDefinition def = new AspectDefinition(cf.getName(), scope, aspectFactory);
/*  296 */       this.manager.addAspectDefinition(def);
/*  297 */       ScopedInterceptorFactory factory = new ScopedInterceptorFactory(def);
/*  298 */       this.manager.addInterceptorFactory(factory.getName(), factory);
/*      */ 
/*  300 */       deployInterceptorBindings(visible, cf, factory);
/*      */ 
/*  302 */       return def;
/*      */     }
/*      */ 
/*  305 */     return null;
/*      */   }
/*      */ 
/*      */   private void undeployInterceptor(AnnotationsAttribute visible, ClassFile cf)
/*      */     throws Exception
/*      */   {
/*  311 */     Annotation info = visible.getAnnotation(InterceptorDef.class.getName());
/*  312 */     if (info != null)
/*      */     {
/*  314 */       if ((AspectManager.verbose) && (logger.isDebugEnabled())) logger.debug("Undeploying @InterceptorDef in: " + cf.getName());
/*  315 */       AnnotationProxy.createProxy(info, Aspect.class);
/*      */ 
/*  317 */       this.manager.removeAspectDefinition(cf.getName());
/*  318 */       this.manager.removeInterceptorFactory(cf.getName());
/*  319 */       undeployInterceptorBindings(visible, cf);
/*      */     }
/*      */   }
/*      */ 
/*      */   private void deployDynamicCFlow(AnnotationsAttribute visible, ClassFile cf)
/*      */     throws Exception
/*      */   {
/*  326 */     Annotation info = visible.getAnnotation(DynamicCFlowDef.class.getName());
/*  327 */     if (info != null)
/*      */     {
/*  329 */       if ((AspectManager.verbose) && (logger.isDebugEnabled())) logger.debug("Found @DynamicCFlowDef in: " + cf.getName());
/*  330 */       AnnotationProxy.createProxy(info, DynamicCFlowDef.class);
/*      */ 
/*  332 */       String name = cf.getName();
/*  333 */       String clazz = cf.getName();
/*      */ 
/*  335 */       String[] interfaces = cf.getInterfaces();
/*  336 */       boolean foundDCFlow = false;
/*  337 */       for (int i = 0; i < interfaces.length; i++)
/*      */       {
/*  339 */         if (!interfaces[i].equals(DynamicCFlow.class.getName()))
/*      */           continue;
/*  341 */         foundDCFlow = true;
/*  342 */         break;
/*      */       }
/*      */ 
/*  345 */       if (!foundDCFlow) throw new RuntimeException("@DynamicCFlow annotated class: " + clazz + " must implement " + DynamicCFlow.class.getName());
/*      */ 
/*  347 */       this.manager.addDynamicCFlow(name, new DynamicCFlowDefinition(null, clazz, name));
/*      */     }
/*      */   }
/*      */ 
/*      */   private void undeployDynamicCFlow(AnnotationsAttribute visible, ClassFile cf) throws Exception
/*      */   {
/*  353 */     Annotation info = visible.getAnnotation(DynamicCFlowDef.class.getName());
/*  354 */     if (info != null)
/*      */     {
/*  356 */       if ((AspectManager.verbose) && (logger.isDebugEnabled())) logger.debug("Undeploying @DynamicCFlowDef in: " + cf.getName());
/*  357 */       String name = cf.getName();
/*  358 */       this.manager.removeDynamicCFlow(name);
/*      */     }
/*      */   }
/*      */ 
/*      */   private boolean deployPreparedClass(AnnotationsAttribute visible, ClassFile cf)
/*      */     throws Exception
/*      */   {
/*  365 */     Annotation info = visible.getAnnotation(Prepare.class.getName());
/*  366 */     if (info != null)
/*      */     {
/*  368 */       if ((AspectManager.verbose) && (logger.isDebugEnabled())) logger.debug("Found top-level @Prepare in: " + cf.getName());
/*  369 */       Prepare prepare = (Prepare)AnnotationProxy.createProxy(info, Prepare.class);
/*      */ 
/*  371 */       String name = cf.getName() + "." + visible.getName();
/*  372 */       String expr = replaceThisInExpr(prepare.value(), cf.getName());
/*  373 */       Pointcut p = new PointcutExpression(name, expr);
/*  374 */       this.manager.addPointcut(p);
/*  375 */       return true;
/*      */     }
/*      */ 
/*  378 */     return false;
/*      */   }
/*      */ 
/*      */   private void undeployPreparedClass(AnnotationsAttribute visible, ClassFile cf)
/*      */     throws Exception
/*      */   {
/*  384 */     Annotation info = visible.getAnnotation(Prepare.class.getName());
/*  385 */     if (info != null)
/*      */     {
/*  387 */       String name = cf.getName() + "." + visible.getName();
/*  388 */       this.manager.removePointcut(name);
/*      */     }
/*      */   }
/*      */ 
/*      */   private void deployPrecedence(AnnotationsAttribute visible, ClassFile cf) throws Exception
/*      */   {
/*  394 */     Annotation info = visible.getAnnotation(Precedence.class.getName());
/*  395 */     if (info != null)
/*      */     {
/*  397 */       if ((AspectManager.verbose) && (logger.isDebugEnabled())) logger.debug("Found top-level @Precedence in: " + cf.getName());
/*      */ 
/*  399 */       ArrayList entries = new ArrayList();
/*  400 */       Iterator fields = cf.getFields().iterator();
/*  401 */       while (fields.hasNext())
/*      */       {
/*  403 */         FieldInfo finfo = (FieldInfo)fields.next();
/*  404 */         AnnotationsAttribute mgroup = (AnnotationsAttribute)finfo.getAttribute("RuntimeVisibleAnnotations");
/*  405 */         if (mgroup != null) {
/*  406 */           Annotation binfo = mgroup.getAnnotation(PrecedenceInterceptor.class.getName());
/*  407 */           if (binfo != null)
/*      */           {
/*  410 */             entries.add(new PrecedenceDefEntry(getFieldType(finfo), null));
/*      */           }
/*      */           else
/*      */           {
/*  414 */             binfo = mgroup.getAnnotation(PrecedenceAdvice.class.getName());
/*  415 */             if (binfo != null)
/*      */             {
/*  417 */               PrecedenceAdvice advice = (PrecedenceAdvice)AnnotationProxy.createProxy(binfo, PrecedenceAdvice.class);
/*  418 */               String method = advice.value();
/*  419 */               entries.add(new PrecedenceDefEntry(getFieldType(finfo), method));
/*      */             }
/*      */           }
/*      */         }
/*      */       }
/*  423 */       PrecedenceDefEntry[] pentries = (PrecedenceDefEntry[])(PrecedenceDefEntry[])entries.toArray(new PrecedenceDefEntry[entries.size()]);
/*  424 */       PrecedenceDef precedenceDef = new PrecedenceDef(cf.getName(), pentries);
/*  425 */       this.manager.addPrecedence(precedenceDef);
/*      */     }
/*      */   }
/*      */ 
/*      */   private void undeployPrecedence(AnnotationsAttribute visible, ClassFile cf) throws Exception
/*      */   {
/*  431 */     Annotation info = visible.getAnnotation(Precedence.class.getName());
/*  432 */     if (info != null)
/*      */     {
/*  434 */       this.manager.removePrecedence(cf.getName());
/*      */     }
/*      */   }
/*      */ 
/*      */   private void deployAspectMethodBindings(ClassFile cf, AspectDefinition def)
/*      */     throws Exception
/*      */   {
/*  441 */     Iterator methods = cf.getMethods().iterator();
/*  442 */     while (methods.hasNext())
/*      */     {
/*  444 */       MethodInfo minfo = (MethodInfo)methods.next();
/*  445 */       AnnotationsAttribute mgroup = (AnnotationsAttribute)minfo.getAttribute("RuntimeVisibleAnnotations");
/*  446 */       if (mgroup != null) {
/*  447 */         Annotation binfo = mgroup.getAnnotation(Bind.class.getName());
/*  448 */         if (binfo != null) {
/*  449 */           Bind binding = (Bind)AnnotationProxy.createProxy(binfo, Bind.class);
/*  450 */           String pointcutString = binding.pointcut();
/*  451 */           String cflow = binding.cflow();
/*  452 */           if ((cflow == null) || (cflow.trim().equals(""))) cflow = null;
/*  453 */           ASTCFlowExpression cflowExpression = null;
/*  454 */           if (cflow != null)
/*      */           {
/*  456 */             cflowExpression = new PointcutExpressionParser(new StringReader(cflow)).CFlowExpression();
/*      */           }
/*      */ 
/*  460 */           org.jboss.aop.advice.AdviceType internalAdviceType = getInternalAdviceType(binding.type());
/*  461 */           AdviceFactory factory = null;
/*  462 */           if (internalAdviceType == org.jboss.aop.advice.AdviceType.AROUND)
/*      */           {
/*  464 */             factory = new AdviceFactory(def, minfo.getName());
/*      */           }
/*      */           else
/*      */           {
/*  468 */             factory = new AdviceFactory(def, minfo.getName(), internalAdviceType);
/*      */           }
/*      */ 
/*  471 */           this.manager.addInterceptorFactory(factory.getName(), factory);
/*  472 */           InterceptorFactory[] fact = { factory };
/*  473 */           String name = getAspectMethodBindingName(cf, minfo);
/*  474 */           PointcutExpression pointcut = new PointcutExpression(name, pointcutString);
/*  475 */           AdviceBinding abinding = new AdviceBinding(name, pointcut, cflowExpression, cflow, fact);
/*  476 */           this.manager.addBinding(abinding);
/*      */         }
/*      */       }
/*      */     }
/*      */   }
/*      */ 
/*      */   private org.jboss.aop.advice.AdviceType getInternalAdviceType(AdviceType adviceType) {
/*  482 */     if (adviceType == AdviceType.AROUND)
/*      */     {
/*  484 */       return org.jboss.aop.advice.AdviceType.AROUND;
/*      */     }
/*  486 */     if (adviceType == AdviceType.BEFORE)
/*      */     {
/*  488 */       return org.jboss.aop.advice.AdviceType.BEFORE;
/*      */     }
/*  490 */     if (adviceType == AdviceType.AFTER)
/*      */     {
/*  492 */       return org.jboss.aop.advice.AdviceType.AFTER;
/*      */     }
/*  494 */     if (adviceType == AdviceType.THROWING)
/*      */     {
/*  496 */       return org.jboss.aop.advice.AdviceType.THROWING;
/*      */     }
/*  498 */     if (adviceType == AdviceType.FINALLY)
/*      */     {
/*  500 */       return org.jboss.aop.advice.AdviceType.FINALLY;
/*      */     }
/*      */ 
/*  503 */     throw new RuntimeException("Bad type " + adviceType);
/*      */   }
/*      */ 
/*      */   private void undeployAspectMethodBindings(ClassFile cf)
/*      */     throws Exception
/*      */   {
/*  509 */     Iterator methods = cf.getMethods().iterator();
/*  510 */     while (methods.hasNext())
/*      */     {
/*  512 */       MethodInfo minfo = (MethodInfo)methods.next();
/*  513 */       AnnotationsAttribute mgroup = (AnnotationsAttribute)minfo.getAttribute("RuntimeVisibleAnnotations");
/*  514 */       if (mgroup != null) {
/*  515 */         Annotation binfo = mgroup.getAnnotation(Bind.class.getName());
/*  516 */         if (binfo == null)
/*      */           continue;
/*  518 */         String adviceName = cf.getName() + "." + minfo.getName();
/*  519 */         this.manager.removeInterceptorFactory(adviceName);
/*  520 */         String name = getAspectMethodBindingName(cf, minfo);
/*  521 */         this.manager.removePointcut(name);
/*  522 */         this.manager.removeBinding(name);
/*      */       }
/*      */     }
/*      */   }
/*      */ 
/*      */   private String getAspectMethodBindingName(ClassFile cf, MethodInfo minfo) throws Exception {
/*  528 */     String method = cf.getName() + "." + minfo.getName();
/*  529 */     String fullMethod = method + minfo.getDescriptor();
/*  530 */     return method + " " + MethodHashing.createHash(fullMethod);
/*      */   }
/*      */ 
/*      */   private void deployInterceptorBindings(AnnotationsAttribute visible, ClassFile cf, InterceptorFactory factory)
/*      */     throws Exception
/*      */   {
/*  536 */     Annotation binfo = visible.getAnnotation(Bind.class.getName());
/*  537 */     if (binfo == null) return;
/*  538 */     Bind bind = (Bind)AnnotationProxy.createProxy(binfo, Bind.class);
/*  539 */     String pointcutString = bind.pointcut();
/*  540 */     String cflow = bind.cflow();
/*  541 */     if ((cflow == null) || (cflow.trim().equals(""))) cflow = null;
/*  542 */     ASTCFlowExpression cflowExpression = null;
/*  543 */     if (cflow != null)
/*      */     {
/*  545 */       cflowExpression = new PointcutExpressionParser(new StringReader(cflow)).CFlowExpression();
/*      */     }
/*      */ 
/*  549 */     String name = cf.getName();
/*  550 */     InterceptorFactory[] inters = { factory };
/*  551 */     Pointcut p = null;
/*  552 */     p = new PointcutExpression(name, pointcutString);
/*  553 */     AdviceBinding binding = new AdviceBinding(name, p, cflowExpression, cflow, inters);
/*  554 */     this.manager.addBinding(binding);
/*      */   }
/*      */ 
/*      */   private void undeployInterceptorBindings(AnnotationsAttribute visible, ClassFile cf)
/*      */     throws Exception
/*      */   {
/*  560 */     Annotation binfo = visible.getAnnotation(Bind.class.getName());
/*  561 */     if (binfo == null) return;
/*      */ 
/*  563 */     String name = cf.getName();
/*  564 */     this.manager.removePointcut(name);
/*  565 */     this.manager.removeBinding(name);
/*      */   }
/*      */ 
/*      */   private void deployPointcuts(ClassFile cf)
/*      */     throws Exception
/*      */   {
/*  572 */     Iterator fields = cf.getFields().iterator();
/*  573 */     while (fields.hasNext())
/*      */     {
/*  575 */       FieldInfo finfo = (FieldInfo)fields.next();
/*  576 */       AnnotationsAttribute mgroup = (AnnotationsAttribute)finfo.getAttribute("RuntimeVisibleAnnotations");
/*  577 */       if (mgroup != null) {
/*  578 */         Annotation binfo = mgroup.getAnnotation(PointcutDef.class.getName());
/*  579 */         if (binfo != null) {
/*  580 */           PointcutDef pdef = (PointcutDef)AnnotationProxy.createProxy(binfo, PointcutDef.class);
/*      */ 
/*  582 */           PointcutExpression pointcut = new PointcutExpression(getPointcutName(cf, finfo), pdef.value());
/*      */ 
/*  584 */           this.manager.addPointcut(pointcut);
/*      */         }
/*      */       }
/*      */     }
/*      */   }
/*      */ 
/*      */   private void undeployPointcuts(ClassFile cf) throws Exception {
/*  591 */     Iterator fields = cf.getFields().iterator();
/*  592 */     while (fields.hasNext())
/*      */     {
/*  594 */       FieldInfo finfo = (FieldInfo)fields.next();
/*  595 */       AnnotationsAttribute mgroup = (AnnotationsAttribute)finfo.getAttribute("RuntimeVisibleAnnotations");
/*  596 */       if (mgroup != null) {
/*  597 */         Annotation binfo = mgroup.getAnnotation(PointcutDef.class.getName());
/*  598 */         if (binfo != null)
/*  599 */           this.manager.removePointcut(getPointcutName(cf, finfo));
/*      */       }
/*      */     }
/*      */   }
/*      */ 
/*      */   private String getPointcutName(ClassFile cf, FieldInfo finfo) {
/*  605 */     return cf.getName() + "." + finfo.getName();
/*      */   }
/*      */ 
/*      */   private void deployMixins(ClassFile cf)
/*      */     throws Exception
/*      */   {
/*  611 */     Iterator methods = cf.getMethods().iterator();
/*  612 */     while (methods.hasNext())
/*      */     {
/*  614 */       MethodInfo minfo = (MethodInfo)methods.next();
/*  615 */       AnnotationsAttribute mgroup = (AnnotationsAttribute)minfo.getAttribute("RuntimeVisibleAnnotations");
/*  616 */       if (mgroup != null) {
/*  617 */         Annotation binfo = mgroup.getAnnotation(Mixin.class.getName());
/*  618 */         if (binfo == null)
/*      */         {
/*      */           continue;
/*      */         }
/*      */ 
/*  631 */         MemberValue mv = binfo.getMemberValue("target");
/*  632 */         String target = mv != null ? ((ClassMemberValue)mv).getValue() : "java.lang.Class";
/*  633 */         mv = binfo.getMemberValue("typeExpression");
/*  634 */         String typeExpression = mv != null ? ((StringMemberValue)mv).getValue() : "";
/*      */ 
/*  636 */         mv = binfo.getMemberValue("interfaces");
/*  637 */         MemberValue[] values = ((ArrayMemberValue)mv).getValue();
/*  638 */         String[] interfaces = new String[values.length];
/*  639 */         for (int i = 0; i < values.length; i++) interfaces[i] = ((ClassMemberValue)values[i]).getValue();
/*      */ 
/*  641 */         mv = binfo.getMemberValue("isTransient");
/*  642 */         boolean isTransient = mv != null ? ((BooleanMemberValue)mv).getValue() : true;
/*      */ 
/*  644 */         String name = cf.getName() + "." + minfo.getName();
/*      */ 
/*  646 */         InterfaceIntroduction intro = null;
/*  647 */         String construction = name;
/*  648 */         switch (Descriptor.numOfParameters(minfo.getDescriptor()))
/*      */         {
/*      */         case 0:
/*  651 */           construction = construction + "()";
/*  652 */           intro = createIntroduction(name, target, typeExpression, null, null, null);
/*  653 */           break;
/*      */         case 1:
/*  655 */           construction = construction + "(this)";
/*  656 */           intro = createIntroduction(name, target, typeExpression, null, cf.getName(), minfo.getName());
/*      */ 
/*  658 */           String parameter = Descriptor.getParamDescriptor(minfo.getDescriptor());
/*      */ 
/*  660 */           if (parameter.charAt(1) == 'L')
/*      */             break;
/*  662 */           String errorMessage = "Mixin creator method '" + name + "' parameter is primitive type ";
/*      */ 
/*  664 */           char desc = parameter.charAt(1);
/*  665 */           if (desc == ((CtPrimitiveType)CtClass.booleanType).getDescriptor())
/*      */           {
/*  667 */             errorMessage = errorMessage + "boolean";
/*      */           }
/*  669 */           else if (desc == ((CtPrimitiveType)CtClass.byteType).getDescriptor())
/*      */           {
/*  671 */             errorMessage = errorMessage + "byte";
/*      */           }
/*  673 */           else if (desc == ((CtPrimitiveType)CtClass.charType).getDescriptor())
/*      */           {
/*  675 */             errorMessage = errorMessage + "char";
/*      */           }
/*  677 */           else if (desc == ((CtPrimitiveType)CtClass.doubleType).getDescriptor())
/*      */           {
/*  679 */             errorMessage = errorMessage + "double";
/*      */           }
/*  681 */           else if (desc == ((CtPrimitiveType)CtClass.floatType).getDescriptor())
/*      */           {
/*  683 */             errorMessage = errorMessage + "float";
/*      */           }
/*  685 */           else if (desc == ((CtPrimitiveType)CtClass.intType).getDescriptor())
/*      */           {
/*  687 */             errorMessage = errorMessage + "int";
/*      */           }
/*  689 */           else if (desc == ((CtPrimitiveType)CtClass.longType).getDescriptor())
/*      */           {
/*  691 */             errorMessage = errorMessage + "long";
/*      */           } else {
/*  693 */             if (desc != ((CtPrimitiveType)CtClass.shortType).getDescriptor())
/*      */               break;
/*  695 */             errorMessage = errorMessage + "short";
/*      */           }
/*      */ 
/*  701 */           errorMessage = errorMessage + ".\n   It should have the introduction target type as parameter, or have no parameter at all.";
/*  702 */           throw new RuntimeException(errorMessage);
/*      */         default:
/*  707 */           throw new RuntimeException("Mixin creator method '" + name + "' should not have more than one parameter.");
/*      */         }
/*      */ 
/*  711 */         if ((!Modifier.isStatic(minfo.getAccessFlags())) || (!Modifier.isPublic(minfo.getAccessFlags())))
/*      */         {
/*  714 */           throw new RuntimeException("Mixin creator method '" + name + "' must be public and static.");
/*      */         }
/*      */ 
/*  719 */         String classname = getReturnType(minfo);
/*      */ 
/*  721 */         intro.getMixins().add(new InterfaceIntroduction.Mixin(classname, interfaces, construction, isTransient));
/*      */ 
/*  723 */         this.manager.addInterfaceIntroduction(intro);
/*      */       }
/*      */     }
/*      */   }
/*      */ 
/*      */   private void undeployMixins(ClassFile cf) throws Exception
/*      */   {
/*  730 */     Iterator methods = cf.getMethods().iterator();
/*  731 */     while (methods.hasNext())
/*      */     {
/*  733 */       MethodInfo minfo = (MethodInfo)methods.next();
/*  734 */       AnnotationsAttribute mgroup = (AnnotationsAttribute)minfo.getAttribute("RuntimeVisibleAnnotations");
/*  735 */       if (mgroup != null) {
/*  736 */         Annotation binfo = mgroup.getAnnotation(Mixin.class.getName());
/*  737 */         if (binfo == null)
/*      */           continue;
/*  739 */         String name = cf.getName() + "." + minfo.getName();
/*  740 */         this.manager.removeInterfaceIntroduction(name);
/*      */       }
/*      */     }
/*      */   }
/*      */ 
/*      */   private void deployIntroductions(ClassFile cf) throws Exception
/*      */   {
/*  747 */     Iterator fields = cf.getFields().iterator();
/*  748 */     while (fields.hasNext())
/*      */     {
/*  750 */       FieldInfo finfo = (FieldInfo)fields.next();
/*  751 */       AnnotationsAttribute mgroup = (AnnotationsAttribute)finfo.getAttribute("RuntimeVisibleAnnotations");
/*  752 */       if (mgroup != null) {
/*  753 */         Annotation binfo = mgroup.getAnnotation(Introduction.class.getName());
/*  754 */         if (binfo == null)
/*      */         {
/*      */           continue;
/*      */         }
/*      */ 
/*  766 */         MemberValue mv = binfo.getMemberValue("target");
/*  767 */         String target = mv != null ? ((ClassMemberValue)mv).getValue() : "java.lang.Class";
/*      */ 
/*  769 */         mv = binfo.getMemberValue("typeExpression");
/*  770 */         String typeExpression = mv != null ? ((StringMemberValue)mv).getValue() : "";
/*      */ 
/*  772 */         mv = binfo.getMemberValue("interfaces");
/*  773 */         MemberValue[] values = ((ArrayMemberValue)mv).getValue();
/*  774 */         String[] interfaces = new String[values.length];
/*  775 */         for (int i = 0; i < values.length; i++) interfaces[i] = ((ClassMemberValue)values[i]).getValue();
/*      */ 
/*  777 */         String name = cf.getName() + "." + finfo.getName();
/*      */ 
/*  779 */         InterfaceIntroduction interfaceIntro = createIntroduction(name, target, typeExpression, interfaces, null, null);
/*  780 */         this.manager.addInterfaceIntroduction(interfaceIntro);
/*      */       }
/*      */     }
/*      */   }
/*      */ 
/*      */   private void undeployIntroductions(ClassFile cf) throws Exception
/*      */   {
/*  787 */     Iterator fields = cf.getFields().iterator();
/*  788 */     while (fields.hasNext())
/*      */     {
/*  790 */       FieldInfo finfo = (FieldInfo)fields.next();
/*  791 */       AnnotationsAttribute mgroup = (AnnotationsAttribute)finfo.getAttribute("RuntimeVisibleAnnotations");
/*  792 */       if (mgroup != null) {
/*  793 */         Annotation binfo = mgroup.getAnnotation(Introduction.class.getName());
/*  794 */         if (binfo == null)
/*      */           continue;
/*  796 */         String name = cf.getName() + "." + finfo.getName();
/*      */ 
/*  798 */         this.manager.removeInterfaceIntroduction(name);
/*      */       }
/*      */     }
/*      */   }
/*      */ 
/*      */   private void deployTypedefs(ClassFile cf) throws Exception {
/*  804 */     Iterator fields = cf.getFields().iterator();
/*  805 */     while (fields.hasNext())
/*      */     {
/*  807 */       FieldInfo finfo = (FieldInfo)fields.next();
/*  808 */       AnnotationsAttribute mgroup = (AnnotationsAttribute)finfo.getAttribute("RuntimeVisibleAnnotations");
/*  809 */       if (mgroup != null) {
/*  810 */         Annotation binfo = mgroup.getAnnotation(TypeDef.class.getName());
/*  811 */         if (binfo != null) {
/*  812 */           TypeDef typeDefinition = (TypeDef)AnnotationProxy.createProxy(binfo, TypeDef.class);
/*      */ 
/*  814 */           String name = getTypedefName(cf, finfo);
/*  815 */           String expr = typeDefinition.value();
/*  816 */           Typedef typedef = new TypedefExpression(name, expr);
/*  817 */           this.manager.addTypedef(typedef);
/*      */         }
/*      */       }
/*      */     }
/*      */   }
/*      */ 
/*      */   private void undeployTypedefs(ClassFile cf) throws Exception {
/*  824 */     Iterator fields = cf.getFields().iterator();
/*  825 */     while (fields.hasNext())
/*      */     {
/*  827 */       FieldInfo finfo = (FieldInfo)fields.next();
/*  828 */       AnnotationsAttribute mgroup = (AnnotationsAttribute)finfo.getAttribute("RuntimeVisibleAnnotations");
/*  829 */       if (mgroup != null) {
/*  830 */         Annotation binfo = mgroup.getAnnotation(TypeDef.class.getName());
/*  831 */         if (binfo == null)
/*      */           continue;
/*  833 */         AnnotationProxy.createProxy(binfo, TypeDef.class);
/*      */ 
/*  835 */         this.manager.removeTypedef(getTypedefName(cf, finfo));
/*      */       }
/*      */     }
/*      */   }
/*      */ 
/*      */   private String getTypedefName(ClassFile cf, FieldInfo finfo)
/*      */   {
/*  842 */     return cf.getName() + "." + finfo.getName();
/*      */   }
/*      */ 
/*      */   private void deployCFlowStackDefs(ClassFile cf) throws Exception
/*      */   {
/*  847 */     Iterator fields = cf.getFields().iterator();
/*  848 */     while (fields.hasNext())
/*      */     {
/*  850 */       FieldInfo finfo = (FieldInfo)fields.next();
/*  851 */       AnnotationsAttribute mgroup = (AnnotationsAttribute)finfo.getAttribute("RuntimeVisibleAnnotations");
/*  852 */       if (mgroup != null) {
/*  853 */         Annotation binfo = mgroup.getAnnotation(CFlowStackDef.class.getName());
/*  854 */         if (binfo != null) {
/*  855 */           CFlowStackDef stackDef = (CFlowStackDef)AnnotationProxy.createProxy(binfo, CFlowStackDef.class);
/*      */ 
/*  857 */           String name = getStackDefName(cf, finfo);
/*  858 */           CFlowDef[] cflows = stackDef.cflows();
/*  859 */           CFlowStack stack = new CFlowStack(name);
/*      */ 
/*  861 */           for (int i = 0; i < cflows.length; i++)
/*      */           {
/*  863 */             CFlowDef cflow = cflows[i];
/*  864 */             boolean not = !cflow.called();
/*  865 */             stack.addCFlow(new CFlow(cflow.expr(), not));
/*      */           }
/*      */ 
/*  868 */           this.manager.addCFlowStack(stack);
/*      */         }
/*      */       }
/*      */     }
/*      */   }
/*      */ 
/*      */   private void undeployCFlowStackDefs(ClassFile cf) throws Exception {
/*  874 */     Iterator fields = cf.getFields().iterator();
/*  875 */     while (fields.hasNext())
/*      */     {
/*  877 */       FieldInfo finfo = (FieldInfo)fields.next();
/*  878 */       AnnotationsAttribute mgroup = (AnnotationsAttribute)finfo.getAttribute("RuntimeVisibleAnnotations");
/*  879 */       if (mgroup != null) {
/*  880 */         Annotation binfo = mgroup.getAnnotation(CFlowStackDef.class.getName());
/*  881 */         if (binfo != null) {
/*  882 */           AnnotationProxy.createProxy(binfo, CFlowStackDef.class);
/*      */ 
/*  884 */           this.manager.removeCFlowStack(getStackDefName(cf, finfo));
/*      */         }
/*      */       }
/*      */     }
/*      */   }
/*      */ 
/*      */   private String getStackDefName(ClassFile cf, FieldInfo finfo) {
/*  890 */     return cf.getName() + "." + finfo.getName();
/*      */   }
/*      */ 
/*      */   private void deployPrepares(ClassFile cf) throws Exception
/*      */   {
/*  895 */     Iterator fields = cf.getFields().iterator();
/*  896 */     while (fields.hasNext())
/*      */     {
/*  898 */       FieldInfo finfo = (FieldInfo)fields.next();
/*  899 */       AnnotationsAttribute mgroup = (AnnotationsAttribute)finfo.getAttribute("RuntimeVisibleAnnotations");
/*  900 */       if (mgroup != null) {
/*  901 */         Annotation binfo = mgroup.getAnnotation(Prepare.class.getName());
/*  902 */         if (binfo != null) {
/*  903 */           Prepare prepare = (Prepare)AnnotationProxy.createProxy(binfo, Prepare.class);
/*      */ 
/*  905 */           String name = getPrepareName(cf, finfo);
/*  906 */           String expr = prepare.value();
/*  907 */           Pointcut p = new PointcutExpression(name, expr);
/*  908 */           this.manager.addPointcut(p);
/*      */         }
/*      */       }
/*      */     }
/*      */   }
/*      */ 
/*      */   private void undeployPrepares(ClassFile cf) throws Exception {
/*  914 */     Iterator fields = cf.getFields().iterator();
/*  915 */     while (fields.hasNext())
/*      */     {
/*  917 */       FieldInfo finfo = (FieldInfo)fields.next();
/*  918 */       AnnotationsAttribute mgroup = (AnnotationsAttribute)finfo.getAttribute("RuntimeVisibleAnnotations");
/*  919 */       if (mgroup != null) {
/*  920 */         Annotation binfo = mgroup.getAnnotation(Prepare.class.getName());
/*  921 */         if (binfo != null) {
/*  922 */           AnnotationProxy.createProxy(binfo, Prepare.class);
/*      */ 
/*  924 */           this.manager.removePointcut(getPrepareName(cf, finfo));
/*      */         }
/*      */       }
/*      */     }
/*      */   }
/*      */ 
/*      */   private String getPrepareName(ClassFile cf, FieldInfo finfo) {
/*  930 */     return cf.getName() + "." + finfo.getName();
/*      */   }
/*      */ 
/*      */   private void deployAnnotationIntroductions(ClassFile cf) throws Exception
/*      */   {
/*  935 */     Iterator fields = cf.getFields().iterator();
/*  936 */     while (fields.hasNext())
/*      */     {
/*  938 */       FieldInfo finfo = (FieldInfo)fields.next();
/*  939 */       AnnotationsAttribute mgroup = (AnnotationsAttribute)finfo.getAttribute("RuntimeVisibleAnnotations");
/*  940 */       if (mgroup != null) {
/*  941 */         Annotation binfo = mgroup.getAnnotation(AnnotationIntroductionDef.class.getName());
/*  942 */         if (binfo != null) {
/*  943 */           AnnotationIntroductionDef intro = (AnnotationIntroductionDef)AnnotationProxy.createProxy(binfo, AnnotationIntroductionDef.class);
/*      */ 
/*  945 */           String expr = intro.expr();
/*  946 */           boolean invisible = intro.invisible();
/*  947 */           String annotation = intro.annotation();
/*      */ 
/*  949 */           annotation = annotation.replace('\'', '"');
/*      */ 
/*  951 */           AnnotationIntroduction annIntro = AnnotationIntroduction.createComplexAnnotationIntroduction(expr, annotation, invisible);
/*  952 */           this.manager.addAnnotationIntroduction(annIntro);
/*      */         }
/*      */       }
/*      */     }
/*      */   }
/*      */ 
/*      */   private void undeployAnnotationIntroductions(ClassFile cf) throws Exception {
/*  958 */     Iterator fields = cf.getFields().iterator();
/*  959 */     while (fields.hasNext())
/*      */     {
/*  961 */       FieldInfo finfo = (FieldInfo)fields.next();
/*  962 */       AnnotationsAttribute mgroup = (AnnotationsAttribute)finfo.getAttribute("RuntimeVisibleAnnotations");
/*  963 */       if (mgroup != null) {
/*  964 */         Annotation binfo = mgroup.getAnnotation(AnnotationIntroductionDef.class.getName());
/*  965 */         if (binfo != null) {
/*  966 */           AnnotationIntroductionDef intro = (AnnotationIntroductionDef)AnnotationProxy.createProxy(binfo, AnnotationIntroductionDef.class);
/*      */ 
/*  968 */           String expr = intro.expr();
/*  969 */           boolean invisible = intro.invisible();
/*  970 */           String annotation = intro.annotation();
/*      */ 
/*  972 */           annotation = annotation.replace('\'', '"');
/*      */ 
/*  974 */           AnnotationIntroduction annIntro = AnnotationIntroduction.createComplexAnnotationIntroduction(expr, annotation, invisible);
/*  975 */           this.manager.removeAnnotationIntroduction(annIntro);
/*      */         }
/*      */       }
/*      */     }
/*      */   }
/*      */ 
/*      */   private void deployDeclares(ClassFile cf) throws Exception {
/*  981 */     Iterator fields = cf.getFields().iterator();
/*  982 */     while (fields.hasNext())
/*      */     {
/*  984 */       FieldInfo finfo = (FieldInfo)fields.next();
/*  985 */       AnnotationsAttribute mgroup = (AnnotationsAttribute)finfo.getAttribute("RuntimeVisibleAnnotations");
/*  986 */       if (mgroup != null) {
/*  987 */         Annotation dwinfo = mgroup.getAnnotation(DeclareWarning.class.getName());
/*  988 */         Annotation deinfo = mgroup.getAnnotation(DeclareError.class.getName());
/*      */ 
/*  990 */         if ((dwinfo != null) || (deinfo != null)) {
/*  991 */           String name = getDeclareName(cf, finfo);
/*  992 */           if ((dwinfo != null) && (deinfo != null)) throw new RuntimeException("Cannot annotate " + name + " field with both DeclareError and DeclareWarning");
/*      */ 
/*  994 */           String expr = null;
/*  995 */           String msg = null;
/*  996 */           boolean warning = false;
/*  997 */           if (deinfo != null)
/*      */           {
/*  999 */             DeclareError derror = (DeclareError)AnnotationProxy.createProxy(deinfo, DeclareError.class);
/* 1000 */             expr = derror.expr();
/* 1001 */             msg = derror.msg();
/*      */           }
/*      */           else
/*      */           {
/* 1005 */             DeclareWarning dwarning = (DeclareWarning)AnnotationProxy.createProxy(dwinfo, DeclareWarning.class);
/* 1006 */             expr = dwarning.expr();
/* 1007 */             msg = dwarning.msg();
/* 1008 */             warning = true;
/*      */           }
/* 1010 */           DeclareDef def = new DeclareDef(name, expr, warning, msg);
/*      */ 
/* 1012 */           this.manager.addDeclare(def);
/*      */         }
/*      */       }
/*      */     }
/*      */   }
/*      */ 
/*      */   private String getDeclareName(ClassFile cf, FieldInfo finfo) {
/* 1018 */     return cf.getName() + "." + finfo.getName();
/*      */   }
/*      */ 
/*      */   private InterfaceIntroduction createIntroduction(String name, String target, String typeExpression, String[] interfaces, String constructorClass, String constructorMethod)
/*      */     throws Exception
/*      */   {
/* 1025 */     if ((typeExpression != null) && (typeExpression.trim().equals("")))
/*      */     {
/* 1027 */       typeExpression = null;
/*      */     }
/*      */ 
/* 1030 */     if ((typeExpression != null) && (target != null) && (target.equals("java.lang.Class")))
/*      */     {
/* 1032 */       target = null;
/*      */     }
/*      */ 
/* 1035 */     if ((target == null) && (typeExpression == null))
/*      */     {
/* 1037 */       throw new RuntimeException("No target nor a typeExpression attribute is defined for this @Mixin");
/*      */     }
/*      */ 
/* 1040 */     if ((target == null) && (typeExpression == null))
/*      */     {
/* 1042 */       throw new RuntimeException("You cannot define both a target and typeExpression attribute in the same @Mixin");
/*      */     }
/*      */ 
/* 1046 */     InterfaceIntroduction intro = null;
/*      */ 
/* 1048 */     if (target != null)
/*      */     {
/* 1050 */       intro = new InterfaceIntroduction(name, target, interfaces, constructorClass, constructorMethod);
/*      */     }
/*      */     else
/*      */     {
/* 1054 */       ASTStart start = new TypeExpressionParser(new StringReader(typeExpression)).Start();
/* 1055 */       intro = new InterfaceIntroduction(name, start, interfaces, constructorClass, constructorMethod);
/*      */     }
/*      */ 
/* 1058 */     return intro;
/*      */   }
/*      */ 
/*      */   private String getReturnType(MethodInfo minfo)
/*      */   {
/* 1063 */     String descriptor = minfo.getDescriptor();
/* 1064 */     int paramsEnd = descriptor.indexOf(")");
/* 1065 */     String classname = descriptor.substring(paramsEnd + 2, descriptor.length() - 1);
/* 1066 */     classname = classname.replace('/', '.');
/* 1067 */     return classname;
/*      */   }
/*      */ 
/*      */   private String getFieldType(FieldInfo finfo)
/*      */   {
/* 1073 */     String descriptor = finfo.getDescriptor();
/* 1074 */     String classname = descriptor.substring(1, descriptor.length() - 1);
/* 1075 */     classname = classname.replace('/', '.');
/* 1076 */     return classname;
/*      */   }
/*      */ 
/*      */   private static String replaceThisInExpr(String expr, String classname)
/*      */   {
/* 1092 */     String THIS = "this";
/*      */ 
/* 1094 */     StringBuffer buf = new StringBuffer();
/* 1095 */     int index = expr.indexOf("this");
/* 1096 */     if (index == -1)
/*      */     {
/* 1098 */       return expr;
/*      */     }
/*      */ 
/* 1101 */     int lastindex = 0;
/* 1102 */     while (index != -1)
/*      */     {
/* 1104 */       boolean isPartOfWord = false;
/* 1105 */       if (index > 0)
/*      */       {
/* 1107 */         char before = expr.charAt(index - 1);
/* 1108 */         isPartOfWord = Character.isJavaIdentifierPart(before);
/*      */       }
/*      */ 
/* 1111 */       if ((!isPartOfWord) && (index + "this".length() < expr.length() - 1))
/*      */       {
/* 1113 */         char after = expr.charAt(index + "this".length());
/* 1114 */         isPartOfWord = Character.isJavaIdentifierPart(after);
/*      */       }
/*      */ 
/* 1117 */       buf.append(expr.substring(lastindex, index));
/*      */ 
/* 1119 */       if (isPartOfWord)
/*      */       {
/* 1121 */         buf.append("this");
/*      */       }
/*      */       else
/*      */       {
/* 1125 */         buf.append(classname);
/*      */       }
/*      */ 
/* 1128 */       lastindex = index + "this".length();
/* 1129 */       index = expr.indexOf("this", lastindex);
/*      */     }
/* 1131 */     buf.append(expr.substring(lastindex));
/* 1132 */     return buf.toString();
/*      */   }
/*      */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.aop.AspectAnnotationLoader
 * JD-Core Version:    0.6.0
 */