/*     */ package org.jboss.aop;
/*     */ 
/*     */ import java.lang.reflect.Constructor;
/*     */ import java.lang.reflect.Method;
/*     */ import java.security.AccessController;
/*     */ import java.security.PrivilegedExceptionAction;
/*     */ import javassist.CtClass;
/*     */ import org.jboss.aop.instrument.InstrumentorEnum;
/*     */ import org.jboss.aop.instrument.InstrumentorFactory;
/*     */ import org.jboss.aop.util.logging.AOPLogger;
/*     */ import org.jboss.logging.Logger;
/*     */ 
/*     */ public class AdvisorFactory
/*     */ {
/*  45 */   private static final Logger logger = AOPLogger.getLogger(AdvisorFactory.class);
/*     */   protected static final int CLASS = 1;
/*     */   protected static final int OTHER_ADVISOR = 1000;
/*  49 */   protected static int advisor = 0;
/*     */   protected static Constructor otherAdvisorConstructor;
/*  53 */   private static final Class[] NO_ARGS = new Class[0];
/*  54 */   private static final Class[] CONSTRUCTOR_SIG = { String.class, AspectManager.class };
/*     */ 
/*     */   public static void initialise(String property)
/*     */   {
/*  59 */     if ((AspectManager.verbose) && (logger.isDebugEnabled()))
/*     */     {
/*  61 */       logger.debug("Passed in advisor: " + property);
/*     */     }
/*     */ 
/*  64 */     if (property != null)
/*     */     {
/*  66 */       if (property.equals(ClassAdvisor.class.getName()))
/*     */       {
/*  68 */         advisor = 1;
/*     */       }
/*     */       else
/*     */       {
/*     */         try
/*     */         {
/*  75 */           Class otherAdvisorClass = SecurityActions.getContextClassLoader().loadClass(property);
/*  76 */           otherAdvisorConstructor = otherAdvisorClass.getConstructor(CONSTRUCTOR_SIG);
/*     */         }
/*     */         catch (ClassNotFoundException e)
/*     */         {
/*  80 */           throw new RuntimeException("Invalid advisor " + property + " was used");
/*     */         }
/*     */         catch (NoSuchMethodException e)
/*     */         {
/*  84 */           throw new RuntimeException(property + " does not have a constructor with the expected signature");
/*     */         }
/*     */       }
/*     */     }
/*     */     else
/*     */     {
/*  90 */       if ((AspectManager.verbose) && (logger.isDebugEnabled()))
/*     */       {
/*  92 */         logger.debug("[debug] Defaulting advisor to: " + ClassAdvisor.class.getName());
/*     */       }
/*  94 */       advisor = 1;
/*     */     }
/*     */   }
/*     */ 
/*     */   public static ClassAdvisor getClassAdvisor(Class clazz, AspectManager am)
/*     */   {
/* 100 */     return getClassAdvisor(clazz.getName(), am, clazz);
/*     */   }
/*     */ 
/*     */   public static ClassAdvisor getClassAdvisor(CtClass clazz, AspectManager am)
/*     */   {
/* 105 */     return getClassAdvisor(clazz.getName(), am, null);
/*     */   }
/*     */ 
/*     */   private static ClassAdvisor getClassAdvisor(String className, AspectManager am, Class loadedClass)
/*     */   {
/* 110 */     if (advisor == 1)
/*     */     {
/* 112 */       if (loadedClass != null)
/*     */       {
/* 114 */         if (InstrumentorFactory.getInstrumentor() == InstrumentorEnum.GENERATED_ADVISOR)
/*     */         {
/*     */           try
/*     */           {
/* 119 */             Method getAdvisor = loadedClass.getMethod("_getClassAdvisor", NO_ARGS);
/* 120 */             if (!getAdvisor.isAccessible())
/*     */             {
/* 122 */               if (System.getSecurityManager() == null)
/*     */               {
/* 124 */                 getAdvisor.setAccessible(true);
/*     */               }
/*     */               else
/*     */               {
/* 128 */                 AccessController.doPrivileged(new PrivilegedExceptionAction(getAdvisor)
/*     */                 {
/*     */                   public Object run()
/*     */                     throws Exception
/*     */                   {
/* 133 */                     this.val$getAdvisor.setAccessible(true);
/* 134 */                     return null;
/*     */                   } } );
/*     */               }
/*     */             }
/* 139 */             ClassAdvisor advisor = (ClassAdvisor)getAdvisor.invoke(null, null);
/* 140 */             if ((advisor != null) && (advisor.getClazz() == loadedClass))
/*     */             {
/* 143 */               return advisor;
/*     */             }
/*     */ 
/*     */           }
/*     */           catch (NoSuchMethodException e)
/*     */           {
/*     */           }
/*     */           catch (Exception e)
/*     */           {
/* 152 */             throw new RuntimeException(e);
/*     */           }
/*     */         }
/*     */       }
/*     */ 
/* 157 */       return new ClassAdvisor(className, am);
/*     */     }
/* 159 */     if (otherAdvisorConstructor != null)
/*     */     {
/*     */       try
/*     */       {
/* 163 */         return (ClassAdvisor)otherAdvisorConstructor.newInstance(new Object[] { className, am });
/*     */       }
/*     */       catch (Exception e)
/*     */       {
/* 167 */         throw new RuntimeException(e);
/*     */       }
/*     */ 
/*     */     }
/*     */ 
/* 172 */     throw new RuntimeException("Advisor is not set");
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.aop.AdvisorFactory
 * JD-Core Version:    0.6.0
 */