/*      */ package org.jboss.aop;
/*      */ 
/*      */ import gnu.trove.TLongObjectHashMap;
/*      */ import java.io.PrintStream;
/*      */ import java.lang.ref.WeakReference;
/*      */ import java.lang.reflect.Constructor;
/*      */ import java.lang.reflect.Field;
/*      */ import java.lang.reflect.Method;
/*      */ import java.security.AccessController;
/*      */ import java.security.PrivilegedActionException;
/*      */ import java.security.PrivilegedExceptionAction;
/*      */ import java.util.ArrayList;
/*      */ import java.util.HashMap;
/*      */ import java.util.HashSet;
/*      */ import java.util.Iterator;
/*      */ import java.util.List;
/*      */ import java.util.Map;
/*      */ import java.util.Set;
/*      */ import java.util.concurrent.ConcurrentHashMap;
/*      */ import java.util.concurrent.CopyOnWriteArraySet;
/*      */ import java.util.concurrent.locks.ReentrantReadWriteLock;
/*      */ import java.util.concurrent.locks.ReentrantReadWriteLock.WriteLock;
/*      */ import javassist.CtClass;
/*      */ import javassist.CtConstructor;
/*      */ import javassist.CtField;
/*      */ import javassist.CtMethod;
/*      */ import org.jboss.annotation.factory.ast.ASTAnnotation;
/*      */ import org.jboss.aop.advice.AdviceBinding;
/*      */ import org.jboss.aop.advice.AdviceType;
/*      */ import org.jboss.aop.advice.AspectDefinition;
/*      */ import org.jboss.aop.advice.AspectFactory;
/*      */ import org.jboss.aop.advice.CFlowInterceptor;
/*      */ import org.jboss.aop.advice.Interceptor;
/*      */ import org.jboss.aop.advice.InterceptorFactory;
/*      */ import org.jboss.aop.advice.PrecedenceSorter;
/*      */ import org.jboss.aop.advice.Scope;
/*      */ import org.jboss.aop.annotation.AnnotationElement;
/*      */ import org.jboss.aop.annotation.AnnotationRepository;
/*      */ import org.jboss.aop.instrument.ConstructionTransformer;
/*      */ import org.jboss.aop.instrument.ConstructorExecutionTransformer;
/*      */ import org.jboss.aop.introduction.AnnotationIntroduction;
/*      */ import org.jboss.aop.introduction.InterfaceIntroduction;
/*      */ import org.jboss.aop.joinpoint.ConstructorJoinpoint;
/*      */ import org.jboss.aop.joinpoint.Invocation;
/*      */ import org.jboss.aop.joinpoint.InvocationResponse;
/*      */ import org.jboss.aop.joinpoint.Joinpoint;
/*      */ import org.jboss.aop.joinpoint.MethodInvocation;
/*      */ import org.jboss.aop.metadata.ClassMetaDataBinding;
/*      */ import org.jboss.aop.metadata.ConstructorMetaData;
/*      */ import org.jboss.aop.metadata.FieldMetaData;
/*      */ import org.jboss.aop.metadata.MethodMetaData;
/*      */ import org.jboss.aop.metadata.SimpleMetaData;
/*      */ import org.jboss.aop.pointcut.Pointcut;
/*      */ import org.jboss.aop.pointcut.PointcutMethodMatch;
/*      */ import org.jboss.aop.util.UnmodifiableEmptyCollections;
/*      */ import org.jboss.metadata.spi.MetaData;
/*      */ import org.jboss.metadata.spi.signature.ConstructorSignature;
/*      */ import org.jboss.metadata.spi.signature.FieldSignature;
/*      */ import org.jboss.metadata.spi.signature.MethodSignature;
/*      */ import org.jboss.metadata.spi.signature.Signature;
/*      */ import org.jboss.util.NestedRuntimeException;
/*      */ import org.jboss.util.NotImplementedException;
/*      */ 
/*      */ public abstract class Advisor
/*      */ {
/*  129 */   protected ReentrantReadWriteLock lock = new ReentrantReadWriteLock();
/*      */ 
/*  131 */   protected HashSet adviceBindings = new HashSet();
/*  132 */   protected volatile ArrayList interfaceIntroductions = UnmodifiableEmptyCollections.EMPTY_ARRAYLIST;
/*  133 */   protected volatile ArrayList classMetaDataBindings = UnmodifiableEmptyCollections.EMPTY_ARRAYLIST;
/*  134 */   protected SimpleMetaData defaultMetaData = new SimpleMetaData();
/*  135 */   protected MethodMetaData methodMetaData = new MethodMetaData();
/*  136 */   protected FieldMetaData fieldMetaData = new FieldMetaData();
/*  137 */   protected SimpleMetaData classMetaData = new SimpleMetaData();
/*  138 */   protected ConstructorMetaData constructorMetaData = new ConstructorMetaData();
/*      */ 
/*  141 */   protected AnnotationRepository annotations = new AnnotationRepository();
/*  142 */   protected boolean doesHaveAspects = false;
/*      */   protected String name;
/*  145 */   protected ConcurrentHashMap aspects = new ConcurrentHashMap();
/*  146 */   protected HashMap adviceInterceptors = new HashMap();
/*  147 */   protected volatile CopyOnWriteArraySet perInstanceAspectDefinitions = UnmodifiableEmptyCollections.EMPTY_COPYONWRITE_ARRAYSET;
/*  148 */   protected volatile ConcurrentHashMap perInstanceJoinpointAspectDefinitions = UnmodifiableEmptyCollections.EMPTY_CONCURRENT_HASHMAP;
/*      */ 
/*  150 */   static Class cl = String.class;
/*  151 */   protected volatile TLongObjectHashMap advisedMethods = UnmodifiableEmptyCollections.EMPTY_TLONG_OBJECT_HASHMAP;
/*      */ 
/*  155 */   protected TLongObjectHashMap methodInterceptors = new TLongObjectHashMap();
/*      */   protected AspectManager manager;
/*  157 */   protected Class clazz = null;
/*      */   protected Constructor[] constructors;
/*      */ 
/*      */   /** @deprecated */
/*      */   protected Interceptor[][] constructorInterceptors;
/*      */   protected ConstructorInfo[] constructorInfos;
/*      */ 
/*      */   /** @deprecated */
/*      */   protected Interceptor[][] constructionInterceptors;
/*      */   protected ConstructionInfo[] constructionInfos;
/*      */   private MetaData metadata;
/*      */ 
/*      */   public MethodInfo getMethodInfo(long hash)
/*      */   {
/*   92 */     return (MethodInfo)this.methodInterceptors.get(hash);
/*      */   }
/*      */ 
/*      */   public Advisor(String name, AspectManager manager)
/*      */   {
/*  174 */     this.name = name;
/*  175 */     this.manager = manager;
/*      */   }
/*      */ 
/*      */   public Constructor[] getConstructors()
/*      */   {
/*  180 */     return this.constructors;
/*      */   }
/*      */ 
/*      */   /** @deprecated */
/*      */   public Interceptor[][] getConstructorInterceptors() {
/*  186 */     return this.constructorInterceptors;
/*      */   }
/*      */ 
/*      */   public ConstructorInfo[] getConstructorInfos()
/*      */   {
/*  191 */     return this.constructorInfos;
/*      */   }
/*      */ 
/*      */   /** @deprecated */
/*      */   public Interceptor[][] getConstructionInterceptors() {
/*  197 */     return this.constructionInterceptors;
/*      */   }
/*      */ 
/*      */   public ConstructionInfo[] getConstructionInfos()
/*      */   {
/*  202 */     return this.constructionInfos;
/*      */   }
/*      */ 
/*      */   /** @deprecated */
/*      */   public Method[] getAllMethods()
/*      */   {
/*  212 */     return null;
/*      */   }
/*      */ 
/*      */   public AspectManager getManager()
/*      */   {
/*  217 */     return this.manager;
/*      */   }
/*      */ 
/*      */   protected void setManager(AspectManager manager)
/*      */   {
/*  226 */     this.manager = manager;
/*      */   }
/*      */ 
/*      */   public List getClassMetadataBindings()
/*      */   {
/*  232 */     return this.classMetaDataBindings;
/*      */   }
/*      */ 
/*      */   public SimpleMetaData getClassMetaData()
/*      */   {
/*  237 */     return this.classMetaData;
/*      */   }
/*      */ 
/*      */   public SimpleMetaData getDefaultMetaData()
/*      */   {
/*  242 */     return this.defaultMetaData;
/*      */   }
/*      */ 
/*      */   public MethodMetaData getMethodMetaData()
/*      */   {
/*  247 */     return this.methodMetaData;
/*      */   }
/*      */ 
/*      */   public FieldMetaData getFieldMetaData()
/*      */   {
/*  252 */     return this.fieldMetaData;
/*      */   }
/*      */ 
/*      */   public ConstructorMetaData getConstructorMetaData()
/*      */   {
/*  257 */     return this.constructorMetaData;
/*      */   }
/*      */ 
/*      */   public void deployAnnotationOverrides()
/*      */   {
/*  265 */     List annotationOverrides = getManager().getAnnotationOverrides();
/*  266 */     if (annotationOverrides != null)
/*      */     {
/*  268 */       for (int i = 0; i < annotationOverrides.size(); i++)
/*      */       {
/*  270 */         AnnotationIntroduction introduction = (AnnotationIntroduction)annotationOverrides.get(i);
/*  271 */         deployAnnotationOverride(introduction);
/*      */       }
/*      */     }
/*      */   }
/*      */ 
/*      */   public void deployAnnotationOverride(AnnotationIntroduction introduction)
/*      */   {
/*  278 */     if (System.getSecurityManager() == null)
/*      */     {
/*  280 */       DeployAnnotationOverrideAction.NON_PRIVILEGED.deploy(this, introduction);
/*      */     }
/*      */     else
/*      */     {
/*  284 */       DeployAnnotationOverrideAction.PRIVILEGED.deploy(this, introduction);
/*      */     }
/*      */   }
/*      */ 
/*      */   public void doDeployAnnotationOverride(AnnotationIntroduction introduction)
/*      */   {
/*  290 */     if (introduction.matches(this, this.clazz))
/*      */     {
/*  292 */       this.annotations.addClassAnnotation(introduction.getAnnotation().getIdentifier(), introduction.getOriginalAnnotationExpr());
/*      */     }
/*      */ 
/*  295 */     Class theClass = this.clazz;
/*      */ 
/*  297 */     deployMethodAnnotationOverrides(theClass, introduction);
/*  298 */     Field[] fields = theClass.getDeclaredFields();
/*  299 */     for (int i = 0; i < fields.length; i++)
/*      */     {
/*  301 */       if (!introduction.matches(this, fields[i]))
/*      */         continue;
/*  303 */       this.annotations.addAnnotation(fields[i], introduction.getAnnotation().getIdentifier(), introduction.getOriginalAnnotationExpr());
/*      */     }
/*      */ 
/*  306 */     Constructor[] cons = theClass.getDeclaredConstructors();
/*  307 */     for (int i = 0; i < cons.length; i++)
/*      */     {
/*  309 */       if (!introduction.matches(this, cons[i]))
/*      */         continue;
/*  311 */       this.annotations.addAnnotation(cons[i], introduction.getAnnotation().getIdentifier(), introduction.getOriginalAnnotationExpr());
/*      */     }
/*      */   }
/*      */ 
/*      */   protected void initializeInterfaceIntroductions(Class theClass)
/*      */   {
/*  318 */     this.manager.applyInterfaceIntroductions(this, theClass);
/*      */   }
/*      */ 
/*      */   protected void deployMethodAnnotationOverrides(Class theClass, AnnotationIntroduction introduction)
/*      */   {
/*  323 */     if (theClass.getSuperclass() != null)
/*      */     {
/*  325 */       deployMethodAnnotationOverrides(theClass.getSuperclass(), introduction);
/*      */     }
/*  327 */     Method[] methods = theClass.getDeclaredMethods();
/*  328 */     for (int i = 0; i < methods.length; i++)
/*      */     {
/*  330 */       if (!introduction.matches(this, methods[i]))
/*      */         continue;
/*  332 */       this.annotations.addAnnotation(methods[i], introduction.getAnnotation().getIdentifier(), introduction.getOriginalAnnotationExpr());
/*      */     }
/*      */   }
/*      */ 
/*      */   public AnnotationRepository getAnnotations()
/*      */   {
/*  340 */     return this.annotations;
/*      */   }
/*      */ 
/*      */   public Object resolveAnnotation(Class annotation)
/*      */   {
/*  345 */     if (this.metadata != null)
/*      */     {
/*  347 */       Object value = this.metadata.getAnnotation(annotation);
/*  348 */       if (value != null) return value;
/*      */     }
/*      */ 
/*  351 */     if (this.annotations.isDisabled(annotation)) {
/*  352 */       return null;
/*      */     }
/*  354 */     Object value = this.annotations.resolveClassAnnotation(annotation);
/*  355 */     if (this.clazz == null) return null;
/*  356 */     if ((value == null) && (this.metadata == null))
/*      */     {
/*  358 */       value = AnnotationElement.getVisibleAnnotation(this.clazz, annotation);
/*      */     }
/*  360 */     return value;
/*      */   }
/*      */ 
/*      */   public boolean hasAnnotation(String annotation)
/*      */   {
/*  365 */     return hasAnnotation(this.clazz, annotation);
/*      */   }
/*      */ 
/*      */   public boolean hasAnnotation(Class tgt, String annotation)
/*      */   {
/*  370 */     return hasAnnotation(tgt, annotation, null);
/*      */   }
/*      */ 
/*      */   public boolean hasAnnotation(Class tgt, Class annotation)
/*      */   {
/*  375 */     return hasAnnotation(tgt, null, annotation);
/*      */   }
/*      */ 
/*      */   private boolean hasAnnotation(Class tgt, String annotation, Class annotationClass)
/*      */   {
/*  380 */     if ((annotation == null) && (annotationClass == null))
/*      */     {
/*  382 */       throw new RuntimeException("annotation or annotationClass must be passed in");
/*      */     }
/*      */ 
/*      */     try
/*      */     {
/*  387 */       if (this.metadata != null)
/*      */       {
/*  389 */         if (annotationClass == null)
/*      */         {
/*  391 */           ClassLoader cl = SecurityActions.getClassLoader(tgt);
/*  392 */           if (cl == null)
/*      */           {
/*  394 */             cl = SecurityActions.getContextClassLoader();
/*      */           }
/*  396 */           annotationClass = cl.loadClass(annotation);
/*      */         }
/*  398 */         if ((annotationClass != null) && (this.metadata.isAnnotationPresent(annotationClass))) return true;
/*      */       }
/*      */ 
/*      */     }
/*      */     catch (ClassNotFoundException e)
/*      */     {
/*      */     }
/*      */ 
/*  406 */     if (annotation == null)
/*      */     {
/*  408 */       annotation = annotationClass.getName();
/*      */     }
/*      */ 
/*  411 */     if (this.annotations.hasClassAnnotation(annotation)) return true;
/*  412 */     if (tgt == null) return false;
/*      */     try
/*      */     {
/*  415 */       if (this.metadata == null)
/*      */       {
/*  417 */         return AnnotationElement.isAnyAnnotationPresent(tgt, annotation);
/*      */       }
/*      */     }
/*      */     catch (Exception e)
/*      */     {
/*  422 */       throw new RuntimeException(e);
/*      */     }
/*  424 */     return false;
/*      */   }
/*      */ 
/*      */   public Object resolveAnnotation(Method m, Class annotation)
/*      */   {
/*  429 */     return resolveAnnotation(0L, m, annotation);
/*      */   }
/*      */ 
/*      */   public Object resolveAnnotation(long hash, Method m, Class annotation)
/*      */   {
/*  434 */     if (this.metadata != null)
/*      */     {
/*  436 */       MethodSignature signature = new MethodSignature(m.getName(), m.getParameterTypes());
/*  437 */       MetaData methodMD = this.metadata.getComponentMetaData(signature);
/*  438 */       if (methodMD != null)
/*      */       {
/*  440 */         Object val = methodMD.getAnnotation(annotation);
/*  441 */         if (val != null) return val;
/*      */       }
/*      */     }
/*      */ 
/*  445 */     if (this.annotations.isDisabled(m, annotation)) {
/*  446 */       return null;
/*      */     }
/*  448 */     Object value = this.annotations.resolveAnnotation(m, annotation);
/*  449 */     if ((value == null) && (this.metadata == null))
/*      */     {
/*  451 */       value = AnnotationElement.getVisibleAnnotation(m, annotation);
/*      */     }
/*  453 */     return value;
/*      */   }
/*      */ 
/*      */   public Object resolveAnnotation(Method m, Class[] annotationChoices)
/*      */   {
/*  458 */     for (Class ann : annotationChoices)
/*      */     {
/*  460 */       Object val = resolveAnnotation(m, annotationChoices);
/*  461 */       if (val != null) return val;
/*      */     }
/*  463 */     return null;
/*      */   }
/*      */ 
/*      */   public Object resolveAnnotation(Field f, Class annotation)
/*      */   {
/*  468 */     Object value = null;
/*  469 */     if (this.metadata != null)
/*      */     {
/*  471 */       FieldSignature signature = new FieldSignature(f);
/*  472 */       MetaData fieldMD = this.metadata.getComponentMetaData(signature);
/*  473 */       if (fieldMD != null)
/*      */       {
/*  475 */         value = fieldMD.getAnnotation(annotation);
/*  476 */         if (value != null) return value;
/*      */       }
/*      */     }
/*      */ 
/*  480 */     value = this.annotations.resolveAnnotation(f, annotation);
/*  481 */     if ((value == null) && (this.metadata == null))
/*      */     {
/*  483 */       value = AnnotationElement.getVisibleAnnotation(f, annotation);
/*      */     }
/*  485 */     return value;
/*      */   }
/*      */ 
/*      */   public Object resolveAnnotation(Constructor c, Class annotation)
/*      */   {
/*  490 */     Object value = null;
/*  491 */     if (this.metadata != null)
/*      */     {
/*  493 */       ConstructorSignature signature = new ConstructorSignature(c);
/*  494 */       MetaData conMD = this.metadata.getComponentMetaData(signature);
/*  495 */       if (conMD != null)
/*      */       {
/*  497 */         value = conMD.getAnnotation(annotation);
/*  498 */         if (value != null) return value;
/*      */       }
/*      */     }
/*      */ 
/*  502 */     value = this.annotations.resolveAnnotation(c, annotation);
/*  503 */     if ((value == null) && (this.metadata == null))
/*      */     {
/*  505 */       value = AnnotationElement.getVisibleAnnotation(c, annotation);
/*      */     }
/*  507 */     return value;
/*      */   }
/*      */ 
/*      */   public boolean hasAnnotation(Method m, String annotation)
/*      */   {
/*  512 */     return hasAnnotation(0L, m, annotation, null);
/*      */   }
/*      */ 
/*      */   public boolean hasAnnotation(Method m, Class annotation)
/*      */   {
/*  517 */     return hasAnnotation(0L, m, null, annotation);
/*      */   }
/*      */ 
/*      */   private boolean hasAnnotation(long hash, Method m, String annotation, Class annotationClass)
/*      */   {
/*  522 */     if ((annotation == null) && (annotationClass == null))
/*      */     {
/*  524 */       throw new RuntimeException("annotation or annotationClass must be passed in");
/*      */     }
/*      */ 
/*  527 */     if (annotation == null)
/*      */     {
/*  529 */       annotation = annotationClass.getName();
/*      */     }
/*  531 */     if (this.metadata != null)
/*      */     {
/*  533 */       if (hasJoinPointAnnotationFromStringName(m.getDeclaringClass(), new MethodSignature(m), annotation))
/*      */       {
/*  535 */         return true;
/*      */       }
/*      */     }
/*      */ 
/*  539 */     if (this.annotations.hasAnnotation(m, annotation)) return true;
/*      */     try
/*      */     {
/*  542 */       if (this.metadata == null)
/*      */       {
/*  544 */         return AnnotationElement.isAnyAnnotationPresent(m, annotation);
/*      */       }
/*      */     }
/*      */     catch (Exception e)
/*      */     {
/*  549 */       throw new RuntimeException(e);
/*      */     }
/*  551 */     return false;
/*      */   }
/*      */ 
/*      */   public boolean hasAnnotation(Field m, String annotation)
/*      */   {
/*  556 */     if (this.metadata != null)
/*      */     {
/*  558 */       if (hasJoinPointAnnotationFromStringName(m.getDeclaringClass(), new FieldSignature(m), annotation))
/*      */       {
/*  560 */         return true;
/*      */       }
/*      */     }
/*  563 */     if (this.annotations.hasAnnotation(m, annotation)) return true;
/*      */     try
/*      */     {
/*  566 */       if (this.metadata == null)
/*      */       {
/*  568 */         return AnnotationElement.isAnyAnnotationPresent(m, annotation);
/*      */       }
/*      */     }
/*      */     catch (Exception e)
/*      */     {
/*  573 */       throw new RuntimeException(e);
/*      */     }
/*  575 */     return false;
/*      */   }
/*      */ 
/*      */   public boolean hasAnnotation(Constructor<?> m, String annotation)
/*      */   {
/*  580 */     if (this.metadata != null)
/*      */     {
/*  582 */       if (hasJoinPointAnnotationFromStringName(m.getDeclaringClass(), new ConstructorSignature(m), annotation))
/*      */       {
/*  584 */         return true;
/*      */       }
/*      */     }
/*  587 */     if (this.annotations.hasAnnotation(m, annotation)) return true;
/*      */     try
/*      */     {
/*  590 */       if (this.metadata == null)
/*      */       {
/*  592 */         return AnnotationElement.isAnyAnnotationPresent(m, annotation);
/*      */       }
/*      */     }
/*      */     catch (Exception e)
/*      */     {
/*  597 */       throw new RuntimeException(e);
/*      */     }
/*  599 */     return false;
/*      */   }
/*      */ 
/*      */   private boolean hasJoinPointAnnotationFromStringName(Class declaringClass, Signature sig, String annotationName)
/*      */   {
/*      */     try
/*      */     {
/*  606 */       if (this.metadata != null)
/*      */       {
/*  608 */         ClassLoader cl = SecurityActions.getClassLoader(declaringClass);
/*  609 */         if (cl == null)
/*      */         {
/*  611 */           cl = SecurityActions.getContextClassLoader();
/*      */         }
/*  613 */         if (cl != null)
/*      */         {
/*  615 */           Class annotationClass = cl.loadClass(annotationName);
/*  616 */           if (annotationClass != null)
/*      */           {
/*  618 */             MetaData md = this.metadata.getComponentMetaData(sig);
/*  619 */             if (md != null)
/*      */             {
/*  621 */               if (md.isAnnotationPresent(annotationClass)) {
/*  622 */                 return true;
/*      */               }
/*      */             }
/*      */           }
/*      */         }
/*      */       }
/*      */     }
/*      */     catch (ClassNotFoundException e)
/*      */     {
/*      */     }
/*      */     catch (Exception e)
/*      */     {
/*  634 */       throw new RuntimeException(e);
/*      */     }
/*  636 */     return false;
/*      */   }
/*      */ 
/*      */   public boolean hasAnnotation(CtClass clazz, String annotation)
/*      */   {
/*  641 */     if (this.annotations.hasClassAnnotation(annotation)) return true;
/*      */     try
/*      */     {
/*  644 */       return AnnotationElement.isAnyAnnotationPresent(clazz, annotation);
/*      */     }
/*      */     catch (Exception e) {
/*      */     }
/*  648 */     throw new RuntimeException(e);
/*      */   }
/*      */ 
/*      */   public boolean hasAnnotation(CtMethod member, String annotation)
/*      */   {
/*  655 */     if (this.annotations.hasAnnotation(member, annotation)) return true;
/*  656 */     return AnnotationElement.isAnyAnnotationPresent(member, annotation);
/*      */   }
/*      */ 
/*      */   public boolean hasAnnotation(CtField member, String annotation)
/*      */   {
/*  662 */     if (this.annotations.hasAnnotation(member, annotation)) return true;
/*  663 */     return AnnotationElement.isAnyAnnotationPresent(member, annotation);
/*      */   }
/*      */ 
/*      */   public boolean hasAnnotation(CtConstructor member, String annotation)
/*      */   {
/*  669 */     if (this.annotations.hasAnnotation(member, annotation)) return true;
/*  670 */     return AnnotationElement.isAnyAnnotationPresent(member, annotation);
/*      */   }
/*      */ 
/*      */   public MetaData getMetadata()
/*      */   {
/*  680 */     return this.metadata;
/*      */   }
/*      */ 
/*      */   public void setMetadata(MetaData metadata)
/*      */   {
/*  691 */     this.metadata = metadata;
/*      */   }
/*      */ 
/*      */   public String getName()
/*      */   {
/*  696 */     return this.name;
/*      */   }
/*      */ 
/*      */   public final boolean hasAspects()
/*      */   {
/*  701 */     return this.doesHaveAspects;
/*      */   }
/*      */ 
/*      */   public synchronized void removeAdviceBinding(AdviceBinding binding)
/*      */   {
/*  706 */     this.adviceBindings.remove(binding);
/*  707 */     rebuildInterceptors();
/*  708 */     this.doesHaveAspects = (this.adviceBindings.size() > 0);
/*      */   }
/*      */ 
/*      */   public synchronized void removeAdviceBindings(ArrayList bindings)
/*      */   {
/*  713 */     this.adviceBindings.removeAll(bindings);
/*  714 */     rebuildInterceptors();
/*  715 */     this.doesHaveAspects = (this.adviceBindings.size() > 0);
/*      */   }
/*      */ 
/*      */   public synchronized void newBindingAdded()
/*      */   {
/*  723 */     rebuildInterceptors();
/*  724 */     this.doesHaveAspects = (this.adviceBindings.size() > 0);
/*      */   }
/*      */ 
/*      */   public ArrayList getInterfaceIntroductions()
/*      */   {
/*  729 */     return this.interfaceIntroductions;
/*      */   }
/*      */ 
/*      */   public synchronized void addInterfaceIntroduction(InterfaceIntroduction pointcut)
/*      */   {
/*  734 */     initInterfaceIntroductionsList();
/*  735 */     this.interfaceIntroductions.add(pointcut);
/*      */   }
/*      */ 
/*      */   public synchronized void removeInterfaceIntroduction(InterfaceIntroduction pointcut)
/*      */   {
/*  740 */     this.interfaceIntroductions.remove(pointcut);
/*      */   }
/*      */ 
/*      */   protected abstract void rebuildInterceptors();
/*      */ 
/*      */   public abstract void addClassMetaData(ClassMetaDataBinding paramClassMetaDataBinding);
/*      */ 
/*      */   public abstract void removeClassMetaData(ClassMetaDataBinding paramClassMetaDataBinding);
/*      */ 
/*      */   public Object getPerVMAspect(AspectDefinition def)
/*      */   {
/*  757 */     return getManager().getPerVMAspect(def);
/*      */   }
/*      */ 
/*      */   public void addPerInstanceAspect(AspectDefinition def)
/*      */   {
/*  762 */     initPerInstanceAspectDefinitionsSet();
/*  763 */     this.perInstanceAspectDefinitions.add(def);
/*  764 */     def.registerAdvisor(this);
/*      */   }
/*      */ 
/*      */   public void removePerInstanceAspect(AspectDefinition def)
/*      */   {
/*  769 */     this.perInstanceAspectDefinitions.remove(def);
/*      */   }
/*      */ 
/*      */   public Set getPerInstanceAspectDefinitions()
/*      */   {
/*  774 */     return this.perInstanceAspectDefinitions;
/*      */   }
/*      */ 
/*      */   public void addPerInstanceJoinpointAspect(Joinpoint joinpoint, AspectDefinition def)
/*      */   {
/*  781 */     Set joinpoints = (Set)this.perInstanceJoinpointAspectDefinitions.get(def);
/*  782 */     if (joinpoints == null)
/*      */     {
/*  784 */       joinpoints = new CopyOnWriteArraySet();
/*  785 */       initPerInstanceJoinpointAspectDefinitionsMap();
/*  786 */       this.perInstanceJoinpointAspectDefinitions.put(def, joinpoints);
/*  787 */       def.registerAdvisor(this);
/*      */     }
/*  789 */     joinpoints.add(joinpoint);
/*      */   }
/*      */ 
/*      */   void addPerInstanceJoinpointAspect(Set joinpoints, AspectDefinition def)
/*      */   {
/*  794 */     initPerInstanceJoinpointAspectDefinitionsMap();
/*  795 */     Set setJoinpoints = (Set)this.perInstanceJoinpointAspectDefinitions.get(def);
/*  796 */     if (setJoinpoints == null)
/*      */     {
/*  798 */       setJoinpoints = new CopyOnWriteArraySet();
/*  799 */       this.perInstanceJoinpointAspectDefinitions.put(def, setJoinpoints);
/*  800 */       def.registerAdvisor(this);
/*      */     }
/*  802 */     setJoinpoints.addAll(joinpoints);
/*      */   }
/*      */ 
/*      */   public void removePerInstanceJoinpointAspect(AspectDefinition def)
/*      */   {
/*  807 */     this.perInstanceJoinpointAspectDefinitions.remove(def);
/*      */   }
/*      */ 
/*      */   public Map getPerInstanceJoinpointAspectDefinitions()
/*      */   {
/*  812 */     return this.perInstanceJoinpointAspectDefinitions;
/*      */   }
/*      */ 
/*      */   public Object getPerClassAspect(AspectDefinition def)
/*      */   {
/*  817 */     return this.aspects.get(def.getName());
/*      */   }
/*      */ 
/*      */   public Object getPerClassAspect(String def)
/*      */   {
/*  822 */     return this.aspects.get(def);
/*      */   }
/*      */ 
/*      */   public void addPerClassAspect(AspectDefinition def)
/*      */   {
/*  827 */     if (this.aspects.containsKey(def.getName())) return;
/*  828 */     Object aspect = def.getFactory().createPerClass(this);
/*  829 */     this.aspects.put(def.getName(), aspect);
/*  830 */     def.registerAdvisor(this);
/*      */   }
/*      */ 
/*      */   public void removePerClassAspect(AspectDefinition def)
/*      */   {
/*  835 */     this.aspects.remove(def.getName());
/*  836 */     this.adviceInterceptors.remove(def);
/*      */   }
/*      */ 
/*      */   public Interceptor getAdviceInterceptor(AspectDefinition def, String adviceName, Joinpoint joinpoint)
/*      */   {
/*  841 */     AdviceInterceptorKey key = new AdviceInterceptorKey(adviceName, joinpoint);
/*  842 */     synchronized (this.adviceInterceptors)
/*      */     {
/*  844 */       Map map = null;
/*  845 */       map = (Map)this.adviceInterceptors.get(def);
/*  846 */       if (map != null)
/*      */       {
/*  848 */         return (Interceptor)map.get(key);
/*      */       }
/*      */     }
/*  851 */     return null;
/*      */   }
/*      */ 
/*      */   public void addAdviceInterceptor(AspectDefinition def, String adviceName, Interceptor interceptor, Joinpoint joinpoint)
/*      */   {
/*  856 */     synchronized (this.adviceInterceptors)
/*      */     {
/*  858 */       Map map = (Map)this.adviceInterceptors.get(def);
/*  859 */       if (map == null)
/*      */       {
/*  861 */         map = new HashMap();
/*  862 */         this.adviceInterceptors.put(def, map);
/*      */       }
/*  864 */       map.put(adviceName, interceptor);
/*      */     }
/*      */   }
/*      */ 
/*      */   protected void createInterceptorChain(InterceptorFactory[] factories, ArrayList newinterceptors, Joinpoint joinpoint)
/*      */   {
/*  871 */     for (int i = 0; i < factories.length; i++)
/*      */     {
/*  873 */       if (factories[i].getType().isGeneratedOnly())
/*      */       {
/*  875 */         throw new RuntimeException("Before/After/Throwing is only supported for Generated Advisors");
/*      */       }
/*  877 */       if (!factories[i].isDeployed()) continue; newinterceptors.add(factories[i].create(this, joinpoint));
/*      */     }
/*      */   }
/*      */ 
/*      */   protected void resolveMethodPointcut(MethodInterceptors newMethodInterceptors, AdviceBinding binding)
/*      */   {
/*  883 */     long[] keys = this.advisedMethods.keys();
/*  884 */     for (int i = 0; i < keys.length; i++)
/*      */     {
/*  886 */       Method method = (Method)this.advisedMethods.get(keys[i]);
/*  887 */       PointcutMethodMatch match = binding.getPointcut().matchesExecution(this, method);
/*      */ 
/*  889 */       if ((match == null) || (!match.isMatch()))
/*      */         continue;
/*  891 */       this.adviceBindings.add(binding);
/*  892 */       if (AspectManager.verbose)
/*      */       {
/*  905 */         System.err.println("[debug] method matched binding: " + method.toString());
/*      */       }
/*  907 */       binding.addAdvisor(this);
/*  908 */       MethodMatchInfo info = newMethodInterceptors.getMatchInfo(keys[i]);
/*  909 */       info.addMatchedBinding(binding, match);
/*      */     }
/*      */   }
/*      */ 
/*      */   protected void finalizeMethodChain(MethodInterceptors newMethodInterceptors)
/*      */   {
/*  916 */     TLongObjectHashMap newMethodInfos = new TLongObjectHashMap();
/*      */ 
/*  918 */     long[] keys = newMethodInterceptors.keys();
/*  919 */     for (int i = 0; i < keys.length; i++)
/*      */     {
/*  921 */       MethodMatchInfo matchInfo = newMethodInterceptors.getMatchInfo(keys[i]);
/*  922 */       matchInfo.populateBindings();
/*      */ 
/*  924 */       MethodInfo info = matchInfo.getInfo();
/*  925 */       newMethodInfos.put(keys[i], info);
/*      */ 
/*  927 */       ArrayList list = info.getInterceptorChain();
/*  928 */       Interceptor[] interceptors = null;
/*  929 */       if (list.size() > 0)
/*      */       {
/*  931 */         interceptors = applyPrecedence((Interceptor[])(Interceptor[])list.toArray(new Interceptor[list.size()]));
/*      */       }
/*  933 */       info.setInterceptors(interceptors);
/*      */     }
/*  935 */     this.methodInterceptors = newMethodInfos;
/*      */   }
/*      */ 
/*      */   public InvocationResponse dynamicInvoke(Object target, Invocation invocation)
/*      */     throws Throwable
/*      */   {
/*  942 */     if ((invocation instanceof MethodInvocation))
/*      */     {
/*  944 */       Interceptor[] aspects = null;
/*  945 */       MethodInvocation methodInvocation = (MethodInvocation)invocation;
/*  946 */       long hash = methodInvocation.getMethodHash();
/*  947 */       MethodInfo info = (MethodInfo)this.methodInterceptors.get(hash);
/*  948 */       aspects = info.getInterceptors();
/*  949 */       if (aspects == null) aspects = new Interceptor[0];
/*  950 */       if ((target != null) && ((target instanceof Advised)))
/*      */       {
/*  952 */         InstanceAdvised advised = (InstanceAdvised)target;
/*  953 */         aspects = advised._getInstanceAdvisor().getInterceptors(aspects);
/*      */       }
/*  955 */       MethodInvocation nextInvocation = new MethodInvocation(info, aspects);
/*  956 */       nextInvocation.setMetaData(invocation.getMetaData());
/*  957 */       nextInvocation.setTargetObject(target);
/*  958 */       nextInvocation.setArguments(methodInvocation.getArguments());
/*  959 */       nextInvocation.setAdvisor(this);
/*  960 */       InvocationResponse response = new InvocationResponse(nextInvocation.invokeNext());
/*  961 */       response.setContextInfo(nextInvocation.getResponseContextInfo());
/*  962 */       return response;
/*      */     }
/*  964 */     throw new RuntimeException("dynamic field invocations not supported yet!");
/*      */   }
/*      */ 
/*      */   public Class getClazz()
/*      */   {
/*  969 */     return this.clazz;
/*      */   }
/*      */ 
/*      */   void setClazz(Class clazz)
/*      */   {
/*  974 */     this.clazz = clazz;
/*      */   }
/*      */ 
/*      */   public static String getSimpleName(Class clazz)
/*      */   {
/*  979 */     String name = clazz.getName();
/*  980 */     int lastIndex = name.lastIndexOf('.');
/*  981 */     if (lastIndex < 0)
/*      */     {
/*  983 */       return name;
/*      */     }
/*      */ 
/*  986 */     return name.substring(lastIndex + 1);
/*      */   }
/*      */ 
/*      */   protected ArrayList initializeConstructorChain()
/*      */   {
/*  991 */     if ((this.clazz != null) && (this.constructors == null))
/*      */     {
/*  993 */       this.constructors = this.clazz.getDeclaredConstructors();
/*      */     }
/*      */ 
/*  996 */     ArrayList newInfos = new ArrayList(this.constructors.length);
/*  997 */     for (int i = 0; i < this.constructors.length; i++)
/*      */     {
/*  999 */       ConstructorInfo info = new ConstructorInfo();
/* 1000 */       info.setConstructor(this.constructors[i]);
/* 1001 */       info.setIndex(i);
/*      */       try
/*      */       {
/* 1004 */         String name = ConstructorExecutionTransformer.constructorFactory(getSimpleName(this.clazz));
/* 1005 */         Class[] types = this.constructors[i].getParameterTypes();
/* 1006 */         Method method = (Method)AccessController.doPrivileged(new PrivilegedExceptionAction(name, types)
/*      */         {
/*      */           public Object run() throws Exception
/*      */           {
/* 1010 */             return Advisor.this.clazz.getDeclaredMethod(this.val$name, this.val$types);
/*      */           }
/*      */         });
/* 1013 */         info.setWrapper(method);
/*      */       }
/*      */       catch (PrivilegedActionException e1)
/*      */       {
/* 1017 */         Exception e = e1.getException();
/* 1018 */         if (!(e instanceof NoSuchMethodException)) {
/* 1019 */           throw new NestedRuntimeException(e);
/*      */         }
/*      */       }
/* 1022 */       info.setAdvisor(this);
/* 1023 */       newInfos.add(info);
/*      */       try
/*      */       {
/* 1027 */         String name = ConstructorExecutionTransformer.getConstructorInfoFieldName(getSimpleName(this.clazz), i);
/* 1028 */         AccessController.doPrivileged(new PrivilegedExceptionAction(name, info)
/*      */         {
/*      */           public Object run() throws Exception
/*      */           {
/* 1032 */             Field infoField = Advisor.this.clazz.getDeclaredField(this.val$name);
/* 1033 */             infoField.setAccessible(true);
/* 1034 */             infoField.set(null, new WeakReference(this.val$info));
/* 1035 */             return null;
/*      */           }
/*      */         });
/*      */       }
/*      */       catch (PrivilegedActionException e1) {
/* 1041 */         Exception e = e1.getException();
/* 1042 */         if (!(e instanceof NoSuchFieldException)) {
/* 1043 */           throw new NestedRuntimeException(e);
/*      */         }
/*      */       }
/*      */     }
/* 1047 */     return newInfos;
/*      */   }
/*      */ 
/*      */   protected ArrayList initializeConstructionChain()
/*      */   {
/* 1052 */     ArrayList newInfos = new ArrayList(this.constructors.length);
/* 1053 */     for (int i = 0; i < this.constructors.length; i++)
/*      */     {
/* 1055 */       ConstructionInfo info = new ConstructionInfo();
/* 1056 */       info.setConstructor(this.constructors[i]);
/* 1057 */       info.setIndex(i);
/* 1058 */       info.setAdvisor(this);
/* 1059 */       newInfos.add(info);
/*      */       try
/*      */       {
/* 1063 */         Field infoField = this.clazz.getDeclaredField(ConstructionTransformer.getConstructionInfoFieldName(getSimpleName(this.clazz), i));
/* 1064 */         infoField.setAccessible(true);
/* 1065 */         infoField.set(null, new WeakReference(info));
/*      */       }
/*      */       catch (NoSuchFieldException e)
/*      */       {
/*      */       }
/*      */       catch (IllegalAccessException e)
/*      */       {
/* 1073 */         throw new RuntimeException(e);
/*      */       }
/*      */     }
/*      */ 
/* 1077 */     return newInfos;
/*      */   }
/*      */ 
/*      */   protected void finalizeConstructorChain(ArrayList newConstructorInfos)
/*      */   {
/* 1082 */     for (int i = 0; i < newConstructorInfos.size(); i++)
/*      */     {
/* 1084 */       ConstructorInfo info = (ConstructorInfo)newConstructorInfos.get(i);
/* 1085 */       ArrayList list = info.getInterceptorChain();
/* 1086 */       Interceptor[] interceptors = null;
/* 1087 */       if (list.size() > 0)
/*      */       {
/* 1089 */         interceptors = applyPrecedence((Interceptor[])(Interceptor[])list.toArray(new Interceptor[list.size()]));
/*      */       }
/* 1091 */       info.setInterceptors(interceptors);
/*      */     }
/*      */   }
/*      */ 
/*      */   protected void finalizeConstructionChain(ArrayList newConstructionInfos)
/*      */   {
/* 1097 */     for (int i = 0; i < newConstructionInfos.size(); i++)
/*      */     {
/* 1099 */       ConstructionInfo info = (ConstructionInfo)newConstructionInfos.get(i);
/* 1100 */       ArrayList list = info.getInterceptorChain();
/* 1101 */       Interceptor[] interceptors = null;
/* 1102 */       if (list.size() > 0)
/*      */       {
/* 1104 */         interceptors = applyPrecedence((Interceptor[])(Interceptor[])list.toArray(new Interceptor[list.size()]));
/*      */       }
/* 1106 */       info.setInterceptors(interceptors);
/*      */     }
/*      */   }
/*      */ 
/*      */   protected void resolveConstructorPointcut(ArrayList newConstructorInfos, AdviceBinding binding)
/*      */   {
/* 1112 */     for (int i = 0; i < this.constructors.length; i++)
/*      */     {
/* 1114 */       Constructor constructor = this.constructors[i];
/* 1115 */       if (!binding.getPointcut().matchesExecution(this, constructor))
/*      */         continue;
/* 1117 */       if (AspectManager.verbose) System.err.println("[debug] constructor matched binding: " + constructor);
/* 1118 */       this.adviceBindings.add(binding);
/* 1119 */       binding.addAdvisor(this);
/* 1120 */       ConstructorInfo info = (ConstructorInfo)newConstructorInfos.get(i);
/* 1121 */       pointcutResolved(info, binding, new ConstructorJoinpoint(constructor));
/*      */     }
/*      */   }
/*      */ 
/*      */   protected void resolveConstructionPointcut(ArrayList newConstructionInfos, AdviceBinding binding)
/*      */   {
/*      */     Iterator it;
/* 1128 */     if (newConstructionInfos.size() > 0)
/*      */     {
/* 1130 */       for (it = newConstructionInfos.iterator(); it.hasNext(); )
/*      */       {
/* 1132 */         ConstructionInfo info = (ConstructionInfo)it.next();
/* 1133 */         Constructor constructor = info.getConstructor();
/* 1134 */         if (binding.getPointcut().matchesConstruction(this, constructor))
/*      */         {
/* 1136 */           if (AspectManager.verbose) System.err.println("[debug] construction matched binding: " + constructor);
/* 1137 */           this.adviceBindings.add(binding);
/* 1138 */           binding.addAdvisor(this);
/* 1139 */           pointcutResolved(info, binding, new ConstructorJoinpoint(constructor));
/*      */         }
/*      */       }
/*      */     }
/*      */   }
/*      */ 
/*      */   /** @deprecated */
/*      */   protected void populateInterceptorsFromInfos() {
/* 1148 */     this.constructorInterceptors = new Interceptor[this.constructorInfos.length][];
/* 1149 */     for (int i = 0; i < this.constructorInfos.length; i++)
/*      */     {
/* 1151 */       this.constructorInterceptors[i] = this.constructorInfos[i].getInterceptors();
/*      */     }
/*      */   }
/*      */ 
/*      */   protected void pointcutResolved(JoinPointInfo info, AdviceBinding binding, Joinpoint joinpoint)
/*      */   {
/* 1161 */     ArrayList curr = info.getInterceptorChain();
/* 1162 */     if (binding.getCFlow() != null)
/*      */     {
/* 1164 */       ArrayList cflowChain = new ArrayList();
/* 1165 */       createInterceptorChain(binding.getInterceptorFactories(), cflowChain, joinpoint);
/* 1166 */       Interceptor[] cflowInterceptors = (Interceptor[])(Interceptor[])cflowChain.toArray(new Interceptor[cflowChain.size()]);
/* 1167 */       curr.add(new CFlowInterceptor(binding.getCFlowString(), binding.getCFlow(), cflowInterceptors));
/*      */     }
/*      */     else
/*      */     {
/* 1171 */       createInterceptorChain(binding.getInterceptorFactories(), curr, joinpoint);
/*      */     }
/*      */   }
/*      */ 
/*      */   Interceptor[] applyPrecedence(Interceptor[] interceptors)
/*      */   {
/* 1177 */     return PrecedenceSorter.applyPrecedence(interceptors, this.manager);
/*      */   }
/*      */ 
/*      */   public boolean chainOverridingForInheritedMethods()
/*      */   {
/* 1207 */     return false;
/*      */   }
/*      */ 
/*      */   protected void setChainOverridingForInheritedMethods(boolean overriding)
/*      */   {
/* 1217 */     throw new NotImplementedException("Not a legal operation for Advisor");
/*      */   }
/*      */ 
/*      */   public void cleanup()
/*      */   {
/* 1263 */     for (Iterator it = this.perInstanceAspectDefinitions.iterator(); it.hasNext(); )
/*      */     {
/* 1265 */       AspectDefinition def = (AspectDefinition)it.next();
/* 1266 */       removePerInstanceAspect(def);
/* 1267 */       def.unregisterAdvisor(this);
/*      */     }
/*      */ 
/* 1270 */     for (Iterator it = this.perInstanceJoinpointAspectDefinitions.keySet().iterator(); it.hasNext(); )
/*      */     {
/* 1272 */       AspectDefinition def = (AspectDefinition)it.next();
/* 1273 */       removePerInstanceJoinpointAspect(def);
/* 1274 */       def.unregisterAdvisor(this);
/*      */     }
/*      */ 
/* 1277 */     AspectDefinition[] defs = (AspectDefinition[])(AspectDefinition[])this.adviceInterceptors.keySet().toArray(new AspectDefinition[this.adviceInterceptors.size()]);
/* 1278 */     for (int i = 0; i < defs.length; i++)
/*      */     {
/* 1280 */       if (defs[i].getScope() != Scope.PER_CLASS)
/*      */         continue;
/* 1282 */       removePerClassAspect(defs[i]);
/* 1283 */       defs[i].unregisterAdvisor(this);
/*      */     }
/*      */ 
/* 1287 */     if (this.methodInterceptors != null)
/*      */     {
/* 1289 */       this.methodInterceptors.clear();
/*      */     }
/*      */   }
/*      */ 
/*      */   protected void lockWrite()
/*      */   {
/* 1298 */     this.lock.writeLock().lock();
/*      */   }
/*      */ 
/*      */   protected void unlockWrite()
/*      */   {
/* 1306 */     this.lock.writeLock().unlock();
/*      */   }
/*      */ 
/*      */   protected void initInterfaceIntroductionsList()
/*      */   {
/* 1311 */     if (this.interfaceIntroductions == UnmodifiableEmptyCollections.EMPTY_ARRAYLIST)
/*      */     {
/* 1313 */       lockWrite();
/*      */       try
/*      */       {
/* 1316 */         if (this.interfaceIntroductions == UnmodifiableEmptyCollections.EMPTY_ARRAYLIST)
/*      */         {
/* 1318 */           this.interfaceIntroductions = new ArrayList();
/*      */         }
/*      */       }
/*      */       finally
/*      */       {
/* 1323 */         unlockWrite();
/*      */       }
/*      */     }
/*      */   }
/*      */ 
/*      */   protected void initClassMetaDataBindingsList()
/*      */   {
/* 1330 */     if (this.classMetaDataBindings == UnmodifiableEmptyCollections.EMPTY_ARRAYLIST)
/*      */     {
/* 1332 */       lockWrite();
/*      */       try
/*      */       {
/* 1335 */         if (this.classMetaDataBindings == UnmodifiableEmptyCollections.EMPTY_ARRAYLIST)
/*      */         {
/* 1337 */           this.classMetaDataBindings = new ArrayList();
/*      */         }
/*      */       }
/*      */       finally
/*      */       {
/* 1342 */         unlockWrite();
/*      */       }
/*      */     }
/*      */   }
/*      */ 
/*      */   protected void initPerInstanceAspectDefinitionsSet()
/*      */   {
/* 1349 */     if (this.perInstanceAspectDefinitions == UnmodifiableEmptyCollections.EMPTY_COPYONWRITE_ARRAYSET)
/*      */     {
/* 1351 */       lockWrite();
/*      */       try
/*      */       {
/* 1354 */         if (this.perInstanceAspectDefinitions == UnmodifiableEmptyCollections.EMPTY_COPYONWRITE_ARRAYSET)
/*      */         {
/* 1356 */           this.perInstanceAspectDefinitions = new CopyOnWriteArraySet();
/*      */         }
/*      */       }
/*      */       finally
/*      */       {
/* 1361 */         unlockWrite();
/*      */       }
/*      */     }
/*      */   }
/*      */ 
/*      */   protected void initPerInstanceJoinpointAspectDefinitionsMap()
/*      */   {
/* 1368 */     if (this.perInstanceJoinpointAspectDefinitions == UnmodifiableEmptyCollections.EMPTY_CONCURRENT_HASHMAP)
/*      */     {
/* 1370 */       lockWrite();
/*      */       try
/*      */       {
/* 1373 */         if (this.perInstanceJoinpointAspectDefinitions == UnmodifiableEmptyCollections.EMPTY_CONCURRENT_HASHMAP)
/*      */         {
/* 1375 */           this.perInstanceJoinpointAspectDefinitions = new ConcurrentHashMap();
/*      */         }
/*      */       }
/*      */       finally
/*      */       {
/* 1380 */         unlockWrite();
/*      */       }
/*      */     }
/*      */   }
/*      */ 
/*      */   protected void initAdvisedMethodsMap()
/*      */   {
/* 1387 */     if (this.advisedMethods == UnmodifiableEmptyCollections.EMPTY_TLONG_OBJECT_HASHMAP)
/*      */     {
/* 1389 */       lockWrite();
/*      */       try
/*      */       {
/* 1392 */         if (this.advisedMethods == UnmodifiableEmptyCollections.EMPTY_TLONG_OBJECT_HASHMAP)
/*      */         {
/* 1394 */           this.advisedMethods = new TLongObjectHashMap();
/*      */         }
/*      */       }
/*      */       finally
/*      */       {
/* 1399 */         unlockWrite();
/*      */       }
/*      */     }
/*      */   }
/*      */ 
/*      */   static abstract interface DeployAnnotationOverrideAction
/*      */   {
/* 1224 */     public static final DeployAnnotationOverrideAction PRIVILEGED = new DeployAnnotationOverrideAction()
/*      */     {
/*      */       public void deploy(Advisor advisor, AnnotationIntroduction introduction)
/*      */       {
/*      */         try
/*      */         {
/* 1230 */           AccessController.doPrivileged(new PrivilegedExceptionAction(advisor, introduction)
/*      */           {
/*      */             public Object run()
/*      */             {
/* 1234 */               this.val$advisor.doDeployAnnotationOverride(this.val$introduction);
/* 1235 */               return null;
/*      */             }
/*      */           });
/*      */         }
/*      */         catch (PrivilegedActionException e) {
/* 1241 */           Exception ex = e.getException();
/* 1242 */           if ((ex instanceof RuntimeException))
/*      */           {
/* 1244 */             throw ((RuntimeException)ex);
/*      */           }
/* 1246 */           throw new RuntimeException(ex);
/*      */         }
/*      */       }
/* 1224 */     };
/*      */ 
/* 1251 */     public static final DeployAnnotationOverrideAction NON_PRIVILEGED = new DeployAnnotationOverrideAction()
/*      */     {
/*      */       public void deploy(Advisor advisor, AnnotationIntroduction introduction)
/*      */       {
/* 1255 */         advisor.doDeployAnnotationOverride(introduction);
/*      */       }
/* 1251 */     };
/*      */ 
/*      */     public abstract void deploy(Advisor paramAdvisor, AnnotationIntroduction paramAnnotationIntroduction);
/*      */   }
/*      */ 
/*      */   private class AdviceInterceptorKey
/*      */   {
/*      */     private String adviceName;
/*      */     private Joinpoint joinpoint;
/*      */     private int hash;
/*      */ 
/*      */     public AdviceInterceptorKey(String adviceName, Joinpoint joinpoint)
/*      */     {
/*  103 */       this.adviceName = adviceName;
/*  104 */       this.joinpoint = joinpoint;
/*  105 */       this.hash = adviceName.hashCode();
/*  106 */       this.hash = (29 * this.hash + (joinpoint != null ? joinpoint.hashCode() : 0));
/*      */     }
/*      */ 
/*      */     public boolean equals(Object o)
/*      */     {
/*  111 */       if (this == o) return true;
/*  112 */       if (!(o instanceof AdviceInterceptorKey)) return false;
/*      */ 
/*  114 */       AdviceInterceptorKey adviceInterceptorKey = (AdviceInterceptorKey)o;
/*      */ 
/*  116 */       if (!this.adviceName.equals(adviceInterceptorKey.adviceName)) return false;
/*  117 */       return this.joinpoint != null ? this.joinpoint.equals(adviceInterceptorKey.joinpoint) : adviceInterceptorKey.joinpoint == null;
/*      */     }
/*      */ 
/*      */     public int hashCode()
/*      */     {
/*  124 */       return this.hash;
/*      */     }
/*      */   }
/*      */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.aop.Advisor
 * JD-Core Version:    0.6.0
 */