/*     */ package org.jboss.annotation.factory.javassist;
/*     */ 
/*     */ import java.lang.reflect.Array;
/*     */ import java.lang.reflect.Method;
/*     */ import javassist.bytecode.annotation.Annotation;
/*     */ import javassist.bytecode.annotation.AnnotationMemberValue;
/*     */ import javassist.bytecode.annotation.ArrayMemberValue;
/*     */ import javassist.bytecode.annotation.BooleanMemberValue;
/*     */ import javassist.bytecode.annotation.ByteMemberValue;
/*     */ import javassist.bytecode.annotation.CharMemberValue;
/*     */ import javassist.bytecode.annotation.ClassMemberValue;
/*     */ import javassist.bytecode.annotation.DoubleMemberValue;
/*     */ import javassist.bytecode.annotation.EnumMemberValue;
/*     */ import javassist.bytecode.annotation.FloatMemberValue;
/*     */ import javassist.bytecode.annotation.IntegerMemberValue;
/*     */ import javassist.bytecode.annotation.LongMemberValue;
/*     */ import javassist.bytecode.annotation.MemberValue;
/*     */ import javassist.bytecode.annotation.MemberValueVisitor;
/*     */ import javassist.bytecode.annotation.ShortMemberValue;
/*     */ import javassist.bytecode.annotation.StringMemberValue;
/*     */ import org.jboss.reflect.plugins.introspection.IntrospectionTypeInfoFactory;
/*     */ import org.jboss.reflect.spi.TypeInfoFactory;
/*     */ 
/*     */ public class MemberValueGetter
/*     */   implements MemberValueVisitor
/*     */ {
/*     */   Object value;
/*     */   Method method;
/*  55 */   static TypeInfoFactory typeFactory = new IntrospectionTypeInfoFactory();
/*     */ 
/*     */   public MemberValueGetter(Method method)
/*     */   {
/*  59 */     this.method = method;
/*     */   }
/*     */ 
/*     */   public Object getValue()
/*     */   {
/*  64 */     return this.value;
/*     */   }
/*     */ 
/*     */   public void visitAnnotationMemberValue(AnnotationMemberValue node)
/*     */   {
/*     */     try
/*     */     {
/*  71 */       Annotation ann = node.getValue();
/*  72 */       this.value = AnnotationProxy.createProxy(ann);
/*     */     }
/*     */     catch (Exception e)
/*     */     {
/*  76 */       throw new RuntimeException(e);
/*     */     }
/*     */   }
/*     */ 
/*     */   public void visitArrayMemberValue(ArrayMemberValue node)
/*     */   {
/*  82 */     MemberValue[] values = node.getValue();
/*  83 */     this.value = node.getValue();
/*  84 */     Object vals = Array.newInstance(getAttributeType(), values.length);
/*     */ 
/*  86 */     for (int i = 0; i < values.length; i++)
/*     */     {
/*  88 */       values[i].accept(this);
/*  89 */       Array.set(vals, i, this.value);
/*     */     }
/*     */ 
/*  92 */     this.value = vals;
/*     */   }
/*     */ 
/*     */   public void visitBooleanMemberValue(BooleanMemberValue node)
/*     */   {
/*  97 */     this.value = new Boolean(node.getValue());
/*     */   }
/*     */ 
/*     */   public void visitByteMemberValue(ByteMemberValue node)
/*     */   {
/* 102 */     this.value = new Byte(node.getValue());
/*     */   }
/*     */ 
/*     */   public void visitCharMemberValue(CharMemberValue node)
/*     */   {
/* 107 */     this.value = new Character(node.getValue());
/*     */   }
/*     */ 
/*     */   public void visitDoubleMemberValue(DoubleMemberValue node)
/*     */   {
/* 112 */     this.value = new Double(node.getValue());
/*     */   }
/*     */ 
/*     */   public void visitEnumMemberValue(EnumMemberValue node)
/*     */   {
/* 118 */     this.value = Enum.valueOf(getAttributeType(), node.getValue());
/*     */   }
/*     */ 
/*     */   public void visitFloatMemberValue(FloatMemberValue node)
/*     */   {
/* 123 */     this.value = new Float(node.getValue());
/*     */   }
/*     */ 
/*     */   public void visitIntegerMemberValue(IntegerMemberValue node)
/*     */   {
/* 128 */     this.value = new Integer(node.getValue());
/*     */   }
/*     */ 
/*     */   public void visitLongMemberValue(LongMemberValue node)
/*     */   {
/* 133 */     this.value = new Long(node.getValue());
/*     */   }
/*     */ 
/*     */   public void visitShortMemberValue(ShortMemberValue node)
/*     */   {
/* 138 */     this.value = new Short(node.getValue());
/*     */   }
/*     */ 
/*     */   public void visitStringMemberValue(StringMemberValue node)
/*     */   {
/* 143 */     this.value = node.getValue();
/*     */   }
/*     */ 
/*     */   public void visitClassMemberValue(ClassMemberValue node)
/*     */   {
/*     */     try
/*     */     {
/* 150 */       this.value = Class.forName(node.getValue());
/*     */     }
/*     */     catch (ClassNotFoundException e)
/*     */     {
/* 154 */       throw new RuntimeException(e);
/*     */     }
/*     */   }
/*     */ 
/*     */   private Class getAttributeType()
/*     */   {
/* 160 */     Class rtn = this.method.getReturnType();
/*     */ 
/* 162 */     while (rtn.isArray())
/*     */     {
/* 164 */       rtn = rtn.getComponentType();
/*     */     }
/*     */ 
/* 167 */     return rtn;
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.annotation.factory.javassist.MemberValueGetter
 * JD-Core Version:    0.6.0
 */