/*     */ package org.jboss.annotation.factory.javassist;
/*     */ 
/*     */ import java.lang.reflect.Method;
/*     */ import java.security.AccessController;
/*     */ import java.security.PrivilegedAction;
/*     */ import java.util.ArrayList;
/*     */ import java.util.Map;
/*     */ import javassist.ClassPool;
/*     */ import javassist.CtClass;
/*     */ import javassist.CtMethod;
/*     */ import javassist.NotFoundException;
/*     */ import javassist.bytecode.AnnotationDefaultAttribute;
/*     */ import javassist.bytecode.MethodInfo;
/*     */ import javassist.bytecode.annotation.MemberValue;
/*     */ import javassist.scopedpool.ScopedClassPoolRepository;
/*     */ import javassist.scopedpool.ScopedClassPoolRepositoryImpl;
/*     */ import org.jboss.annotation.factory.AnnotationValidationException;
/*     */ import org.jboss.annotation.factory.AnnotationValidator;
/*     */ 
/*     */ public class DefaultValueAnnotationValidator
/*     */   implements AnnotationValidator
/*     */ {
/*  52 */   ScopedClassPoolRepository repository = ScopedClassPoolRepositoryImpl.getInstance();
/*     */ 
/*     */   public void validate(Map<String, Object> map, Class annotation)
/*     */   {
/*  56 */     ArrayList notAssignedAttributes = null;
/*  57 */     CtClass ctClass = null;
/*     */ 
/*  59 */     Method[] methods = getDeclaredMethods(annotation);
/*  60 */     for (int i = 0; i < methods.length; i++)
/*     */     {
/*  62 */       if (map.get(methods[i].getName()) != null)
/*     */         continue;
/*  64 */       if (ctClass == null)
/*     */       {
/*  66 */         ctClass = getCtClass(annotation);
/*     */       }
/*     */       CtMethod method;
/*     */       try
/*     */       {
/*  72 */         method = ctClass.getDeclaredMethod(methods[i].getName());
/*     */       }
/*     */       catch (NotFoundException e)
/*     */       {
/*  76 */         throw new RuntimeException("Unable to find method " + methods[i].getName() + " for " + annotation.getName());
/*     */       }
/*  78 */       Object defaultValue = null;
/*  79 */       MethodInfo minfo = method.getMethodInfo2();
/*  80 */       AnnotationDefaultAttribute defAttr = (AnnotationDefaultAttribute)minfo.getAttribute("AnnotationDefault");
/*     */ 
/*  82 */       if (defAttr != null)
/*     */       {
/*  84 */         MemberValue value = defAttr.getDefaultValue();
/*  85 */         MemberValueGetter getter = new MemberValueGetter(methods[i]);
/*  86 */         value.accept(getter);
/*  87 */         defaultValue = getter.getValue();
/*     */       }
/*     */ 
/*  90 */       if (defaultValue != null)
/*     */       {
/*  92 */         map.put(methods[i].getName(), defaultValue);
/*     */       }
/*     */       else
/*     */       {
/*  96 */         if (notAssignedAttributes == null)
/*     */         {
/*  98 */           notAssignedAttributes = new ArrayList();
/*     */         }
/* 100 */         notAssignedAttributes.add(methods[i].getName());
/*     */       }
/*     */ 
/*     */     }
/*     */ 
/* 106 */     if (notAssignedAttributes != null)
/*     */     {
/* 108 */       throw new AnnotationValidationException("Unable to fill in default attributes for " + annotation + " " + notAssignedAttributes);
/*     */     }
/*     */   }
/*     */ 
/*     */   CtClass getCtClass(Class clazz)
/*     */   {
/*     */     try
/*     */     {
/* 117 */       ClassPool pool = this.repository.findClassPool(clazz.getClassLoader());
/* 118 */       return pool.get(clazz.getName());
/*     */     }
/*     */     catch (NotFoundException e) {
/*     */     }
/* 122 */     throw new RuntimeException("Unable to load CtClass for " + clazz, e);
/*     */   }
/*     */ 
/*     */   private Method[] getDeclaredMethods(Class clazz)
/*     */   {
/* 128 */     return (Method[])AccessController.doPrivileged(new PrivilegedAction(clazz)
/*     */     {
/*     */       public Method[] run()
/*     */       {
/* 132 */         return this.val$clazz.getDeclaredMethods();
/*     */       }
/*     */     });
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.annotation.factory.javassist.DefaultValueAnnotationValidator
 * JD-Core Version:    0.6.0
 */