/*     */ package org.jboss.annotation.factory.ast;
/*     */ 
/*     */ public class TokenMgrError extends Error
/*     */ {
/*     */   private static final long serialVersionUID = -8256510811060336766L;
/*     */   static final int LEXICAL_ERROR = 0;
/*     */   static final int STATIC_LEXER_ERROR = 1;
/*     */   static final int INVALID_LEXICAL_STATE = 2;
/*     */   static final int LOOP_DETECTED = 3;
/*     */   int errorCode;
/*     */ 
/*     */   protected static final String addEscapes(String str)
/*     */   {
/*  67 */     StringBuffer retval = new StringBuffer();
/*     */ 
/*  69 */     for (int i = 0; i < str.length(); i++) {
/*  70 */       switch (str.charAt(i))
/*     */       {
/*     */       case '\000':
/*  73 */         break;
/*     */       case '\b':
/*  75 */         retval.append("\\b");
/*  76 */         break;
/*     */       case '\t':
/*  78 */         retval.append("\\t");
/*  79 */         break;
/*     */       case '\n':
/*  81 */         retval.append("\\n");
/*  82 */         break;
/*     */       case '\f':
/*  84 */         retval.append("\\f");
/*  85 */         break;
/*     */       case '\r':
/*  87 */         retval.append("\\r");
/*  88 */         break;
/*     */       case '"':
/*  90 */         retval.append("\\\"");
/*  91 */         break;
/*     */       case '\'':
/*  93 */         retval.append("\\'");
/*  94 */         break;
/*     */       case '\\':
/*  96 */         retval.append("\\\\");
/*  97 */         break;
/*     */       default:
/*     */         char ch;
/*  99 */         if (((ch = str.charAt(i)) < ' ') || (ch > '~')) {
/* 100 */           String s = "0000" + Integer.toString(ch, 16);
/* 101 */           retval.append("\\u" + s.substring(s.length() - 4, s.length()));
/*     */         } else {
/* 103 */           retval.append(ch);
/*     */         }
/*     */       }
/*     */     }
/*     */ 
/* 108 */     return retval.toString();
/*     */   }
/*     */ 
/*     */   protected static String LexicalError(boolean EOFSeen, int lexState, int errorLine, int errorColumn, String errorAfter, char curChar)
/*     */   {
/* 125 */     return "Lexical error at line " + errorLine + ", column " + errorColumn + ".  Encountered: " + (EOFSeen ? "<EOF> " : new StringBuilder().append("\"").append(addEscapes(String.valueOf(curChar))).append("\"").append(" (").append(curChar).append("), ").toString()) + "after : \"" + addEscapes(errorAfter) + "\"";
/*     */   }
/*     */ 
/*     */   public String getMessage()
/*     */   {
/* 142 */     return super.getMessage();
/*     */   }
/*     */ 
/*     */   public TokenMgrError()
/*     */   {
/*     */   }
/*     */ 
/*     */   public TokenMgrError(String message, int reason)
/*     */   {
/* 153 */     super(message);
/* 154 */     this.errorCode = reason;
/*     */   }
/*     */ 
/*     */   public TokenMgrError(boolean EOFSeen, int lexState, int errorLine, int errorColumn, String errorAfter, char curChar, int reason) {
/* 158 */     this(LexicalError(EOFSeen, lexState, errorLine, errorColumn, errorAfter, curChar), reason);
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.annotation.factory.ast.TokenMgrError
 * JD-Core Version:    0.6.0
 */