/*     */ package org.jboss.annotation.factory.ast;
/*     */ 
/*     */ import java.io.IOException;
/*     */ import java.io.InputStream;
/*     */ import java.io.InputStreamReader;
/*     */ import java.io.Reader;
/*     */ 
/*     */ public class SimpleCharStream
/*     */ {
/*     */   public static final boolean staticFlag = false;
/*     */   int bufsize;
/*     */   int available;
/*     */   int tokenBegin;
/*  35 */   public int bufpos = -1;
/*     */   protected int[] bufline;
/*     */   protected int[] bufcolumn;
/*  39 */   protected int column = 0;
/*  40 */   protected int line = 1;
/*     */ 
/*  42 */   protected boolean prevCharIsCR = false;
/*  43 */   protected boolean prevCharIsLF = false;
/*     */   protected Reader inputStream;
/*     */   protected char[] buffer;
/*  48 */   protected int maxNextCharInd = 0;
/*  49 */   protected int inBuf = 0;
/*     */ 
/*     */   protected void ExpandBuff(boolean wrapAround)
/*     */   {
/*  53 */     char[] newbuffer = new char[this.bufsize + 2048];
/*  54 */     int[] newbufline = new int[this.bufsize + 2048];
/*  55 */     int[] newbufcolumn = new int[this.bufsize + 2048];
/*     */     try
/*     */     {
/*  59 */       if (wrapAround)
/*     */       {
/*  61 */         System.arraycopy(this.buffer, this.tokenBegin, newbuffer, 0, this.bufsize - this.tokenBegin);
/*  62 */         System.arraycopy(this.buffer, 0, newbuffer, this.bufsize - this.tokenBegin, this.bufpos);
/*     */ 
/*  64 */         this.buffer = newbuffer;
/*     */ 
/*  66 */         System.arraycopy(this.bufline, this.tokenBegin, newbufline, 0, this.bufsize - this.tokenBegin);
/*  67 */         System.arraycopy(this.bufline, 0, newbufline, this.bufsize - this.tokenBegin, this.bufpos);
/*  68 */         this.bufline = newbufline;
/*     */ 
/*  70 */         System.arraycopy(this.bufcolumn, this.tokenBegin, newbufcolumn, 0, this.bufsize - this.tokenBegin);
/*  71 */         System.arraycopy(this.bufcolumn, 0, newbufcolumn, this.bufsize - this.tokenBegin, this.bufpos);
/*  72 */         this.bufcolumn = newbufcolumn;
/*     */ 
/*  74 */         this.maxNextCharInd = (this.bufpos += this.bufsize - this.tokenBegin);
/*     */       }
/*     */       else
/*     */       {
/*  78 */         System.arraycopy(this.buffer, this.tokenBegin, newbuffer, 0, this.bufsize - this.tokenBegin);
/*  79 */         this.buffer = newbuffer;
/*     */ 
/*  81 */         System.arraycopy(this.bufline, this.tokenBegin, newbufline, 0, this.bufsize - this.tokenBegin);
/*  82 */         this.bufline = newbufline;
/*     */ 
/*  84 */         System.arraycopy(this.bufcolumn, this.tokenBegin, newbufcolumn, 0, this.bufsize - this.tokenBegin);
/*  85 */         this.bufcolumn = newbufcolumn;
/*     */ 
/*  87 */         this.maxNextCharInd = (this.bufpos -= this.tokenBegin);
/*     */       }
/*     */     }
/*     */     catch (Throwable t)
/*     */     {
/*  92 */       throw new Error(t.getMessage());
/*     */     }
/*     */ 
/*  96 */     this.bufsize += 2048;
/*  97 */     this.available = this.bufsize;
/*  98 */     this.tokenBegin = 0;
/*     */   }
/*     */ 
/*     */   protected void FillBuff() throws IOException
/*     */   {
/* 103 */     if (this.maxNextCharInd == this.available)
/*     */     {
/* 105 */       if (this.available == this.bufsize)
/*     */       {
/* 107 */         if (this.tokenBegin > 2048)
/*     */         {
/* 109 */           this.bufpos = (this.maxNextCharInd = 0);
/* 110 */           this.available = this.tokenBegin;
/*     */         }
/* 112 */         else if (this.tokenBegin < 0) {
/* 113 */           this.bufpos = (this.maxNextCharInd = 0);
/*     */         } else {
/* 115 */           ExpandBuff(false);
/*     */         }
/* 117 */       } else if (this.available > this.tokenBegin)
/* 118 */         this.available = this.bufsize;
/* 119 */       else if (this.tokenBegin - this.available < 2048)
/* 120 */         ExpandBuff(true);
/*     */       else
/* 122 */         this.available = this.tokenBegin;
/*     */     }
/*     */     try
/*     */     {
/*     */       int i;
/* 127 */       if ((i = this.inputStream.read(this.buffer, this.maxNextCharInd, this.available - this.maxNextCharInd)) == -1)
/*     */       {
/* 130 */         this.inputStream.close();
/* 131 */         throw new IOException();
/*     */       }
/*     */ 
/* 134 */       this.maxNextCharInd += i;
/* 135 */       return;
/*     */     }
/*     */     catch (IOException e) {
/* 138 */       this.bufpos -= 1;
/* 139 */       backup(0);
/* 140 */       if (this.tokenBegin == -1)
/* 141 */         this.tokenBegin = this.bufpos; 
/*     */     }
/* 142 */     throw e;
/*     */   }
/*     */ 
/*     */   public char BeginToken()
/*     */     throws IOException
/*     */   {
/* 148 */     this.tokenBegin = -1;
/* 149 */     char c = readChar();
/* 150 */     this.tokenBegin = this.bufpos;
/*     */ 
/* 152 */     return c;
/*     */   }
/*     */ 
/*     */   protected void UpdateLineColumn(char c)
/*     */   {
/* 157 */     this.column += 1;
/*     */ 
/* 159 */     if (this.prevCharIsLF)
/*     */     {
/* 161 */       this.prevCharIsLF = false;
/* 162 */       this.line += (this.column = 1);
/*     */     }
/* 164 */     else if (this.prevCharIsCR)
/*     */     {
/* 166 */       this.prevCharIsCR = false;
/* 167 */       if (c == '\n')
/*     */       {
/* 169 */         this.prevCharIsLF = true;
/*     */       }
/*     */       else {
/* 172 */         this.line += (this.column = 1);
/*     */       }
/*     */     }
/* 175 */     switch (c)
/*     */     {
/*     */     case '\r':
/* 178 */       this.prevCharIsCR = true;
/* 179 */       break;
/*     */     case '\n':
/* 181 */       this.prevCharIsLF = true;
/* 182 */       break;
/*     */     case '\t':
/* 184 */       this.column -= 1;
/* 185 */       this.column += 8 - (this.column & 0x7);
/* 186 */       break;
/*     */     case '\013':
/*     */     case '\f':
/*     */     }
/*     */ 
/* 191 */     this.bufline[this.bufpos] = this.line;
/* 192 */     this.bufcolumn[this.bufpos] = this.column;
/*     */   }
/*     */ 
/*     */   public char readChar() throws IOException
/*     */   {
/* 197 */     if (this.inBuf > 0)
/*     */     {
/* 199 */       this.inBuf -= 1;
/*     */ 
/* 201 */       if (++this.bufpos == this.bufsize) {
/* 202 */         this.bufpos = 0;
/*     */       }
/* 204 */       return this.buffer[this.bufpos];
/*     */     }
/*     */ 
/* 207 */     if (++this.bufpos >= this.maxNextCharInd) {
/* 208 */       FillBuff();
/*     */     }
/* 210 */     char c = this.buffer[this.bufpos];
/*     */ 
/* 212 */     UpdateLineColumn(c);
/* 213 */     return c;
/*     */   }
/*     */ 
/*     */   /** @deprecated */
/*     */   public int getColumn()
/*     */   {
/* 224 */     return this.bufcolumn[this.bufpos];
/*     */   }
/*     */ 
/*     */   /** @deprecated */
/*     */   public int getLine()
/*     */   {
/* 235 */     return this.bufline[this.bufpos];
/*     */   }
/*     */ 
/*     */   public int getEndColumn() {
/* 239 */     return this.bufcolumn[this.bufpos];
/*     */   }
/*     */ 
/*     */   public int getEndLine() {
/* 243 */     return this.bufline[this.bufpos];
/*     */   }
/*     */ 
/*     */   public int getBeginColumn() {
/* 247 */     return this.bufcolumn[this.tokenBegin];
/*     */   }
/*     */ 
/*     */   public int getBeginLine() {
/* 251 */     return this.bufline[this.tokenBegin];
/*     */   }
/*     */ 
/*     */   public void backup(int amount)
/*     */   {
/* 256 */     this.inBuf += amount;
/* 257 */     if (this.bufpos -= amount < 0)
/* 258 */       this.bufpos += this.bufsize;
/*     */   }
/*     */ 
/*     */   public SimpleCharStream(Reader dstream, int startline, int startcolumn, int buffersize)
/*     */   {
/* 264 */     this.inputStream = dstream;
/* 265 */     this.line = startline;
/* 266 */     this.column = (startcolumn - 1);
/*     */ 
/* 268 */     this.available = (this.bufsize = buffersize);
/* 269 */     this.buffer = new char[buffersize];
/* 270 */     this.bufline = new int[buffersize];
/* 271 */     this.bufcolumn = new int[buffersize];
/*     */   }
/*     */ 
/*     */   public SimpleCharStream(Reader dstream, int startline, int startcolumn)
/*     */   {
/* 277 */     this(dstream, startline, startcolumn, 4096);
/*     */   }
/*     */ 
/*     */   public SimpleCharStream(Reader dstream)
/*     */   {
/* 282 */     this(dstream, 1, 1, 4096);
/*     */   }
/*     */ 
/*     */   public void ReInit(Reader dstream, int startline, int startcolumn, int buffersize)
/*     */   {
/* 287 */     this.inputStream = dstream;
/* 288 */     this.line = startline;
/* 289 */     this.column = (startcolumn - 1);
/*     */ 
/* 291 */     if ((this.buffer == null) || (buffersize != this.buffer.length))
/*     */     {
/* 293 */       this.available = (this.bufsize = buffersize);
/* 294 */       this.buffer = new char[buffersize];
/* 295 */       this.bufline = new int[buffersize];
/* 296 */       this.bufcolumn = new int[buffersize];
/*     */     }
/* 298 */     this.prevCharIsLF = (this.prevCharIsCR = 0);
/* 299 */     this.tokenBegin = (this.inBuf = this.maxNextCharInd = 0);
/* 300 */     this.bufpos = -1;
/*     */   }
/*     */ 
/*     */   public void ReInit(Reader dstream, int startline, int startcolumn)
/*     */   {
/* 306 */     ReInit(dstream, startline, startcolumn, 4096);
/*     */   }
/*     */ 
/*     */   public void ReInit(Reader dstream)
/*     */   {
/* 311 */     ReInit(dstream, 1, 1, 4096);
/*     */   }
/*     */ 
/*     */   public SimpleCharStream(InputStream dstream, int startline, int startcolumn, int buffersize)
/*     */   {
/* 316 */     this(new InputStreamReader(dstream), startline, startcolumn, 4096);
/*     */   }
/*     */ 
/*     */   public SimpleCharStream(InputStream dstream, int startline, int startcolumn)
/*     */   {
/* 322 */     this(dstream, startline, startcolumn, 4096);
/*     */   }
/*     */ 
/*     */   public SimpleCharStream(InputStream dstream)
/*     */   {
/* 327 */     this(dstream, 1, 1, 4096);
/*     */   }
/*     */ 
/*     */   public void ReInit(InputStream dstream, int startline, int startcolumn, int buffersize)
/*     */   {
/* 333 */     ReInit(new InputStreamReader(dstream), startline, startcolumn, 4096);
/*     */   }
/*     */ 
/*     */   public void ReInit(InputStream dstream)
/*     */   {
/* 338 */     ReInit(dstream, 1, 1, 4096);
/*     */   }
/*     */ 
/*     */   public void ReInit(InputStream dstream, int startline, int startcolumn)
/*     */   {
/* 343 */     ReInit(dstream, startline, startcolumn, 4096);
/*     */   }
/*     */ 
/*     */   public String GetImage() {
/* 347 */     if (this.bufpos >= this.tokenBegin) {
/* 348 */       return new String(this.buffer, this.tokenBegin, this.bufpos - this.tokenBegin + 1);
/*     */     }
/* 350 */     return new String(this.buffer, this.tokenBegin, this.bufsize - this.tokenBegin) + new String(this.buffer, 0, this.bufpos + 1);
/*     */   }
/*     */ 
/*     */   public char[] GetSuffix(int len)
/*     */   {
/* 356 */     char[] ret = new char[len];
/*     */ 
/* 358 */     if (this.bufpos + 1 >= len) {
/* 359 */       System.arraycopy(this.buffer, this.bufpos - len + 1, ret, 0, len);
/*     */     }
/*     */     else {
/* 362 */       System.arraycopy(this.buffer, this.bufsize - (len - this.bufpos - 1), ret, 0, len - this.bufpos - 1);
/*     */ 
/* 364 */       System.arraycopy(this.buffer, 0, ret, len - this.bufpos - 1, this.bufpos + 1);
/*     */     }
/*     */ 
/* 367 */     return ret;
/*     */   }
/*     */ 
/*     */   public void Done()
/*     */   {
/* 372 */     this.buffer = null;
/* 373 */     this.bufline = null;
/* 374 */     this.bufcolumn = null;
/*     */   }
/*     */ 
/*     */   public void adjustBeginLineColumn(int newLine, int newCol)
/*     */   {
/* 385 */     int start = this.tokenBegin;
/*     */     int len;
/*     */     int len;
/* 388 */     if (this.bufpos >= this.tokenBegin)
/*     */     {
/* 390 */       len = this.bufpos - this.tokenBegin + this.inBuf + 1;
/*     */     }
/*     */     else
/*     */     {
/* 394 */       len = this.bufsize - this.tokenBegin + this.bufpos + 1 + this.inBuf;
/*     */     }
/*     */ 
/* 397 */     int i = 0; int j = 0; int k = 0;
/* 398 */     int nextColDiff = 0; int columnDiff = 0;
/*     */ 
/* 401 */     while (i < len) { start++; if (this.bufline[(j = start % this.bufsize)] != this.bufline[(k = start % this.bufsize)])
/*     */         break;
/* 403 */       this.bufline[j] = newLine;
/* 404 */       nextColDiff = columnDiff + this.bufcolumn[k] - this.bufcolumn[j];
/* 405 */       this.bufcolumn[j] = (newCol + columnDiff);
/* 406 */       columnDiff = nextColDiff;
/* 407 */       i++;
/*     */     }
/*     */ 
/* 410 */     if (i < len)
/*     */     {
/* 412 */       this.bufline[j] = (newLine++);
/* 413 */       this.bufcolumn[j] = (newCol + columnDiff);
/*     */ 
/* 415 */       while (i++ < len)
/*     */       {
/* 417 */         start++; if (this.bufline[(j = start % this.bufsize)] != this.bufline[(start % this.bufsize)]) {
/* 418 */           this.bufline[j] = (newLine++); continue;
/*     */         }
/* 420 */         this.bufline[j] = newLine;
/*     */       }
/*     */     }
/*     */ 
/* 424 */     this.line = this.bufline[j];
/* 425 */     this.column = this.bufcolumn[j];
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.annotation.factory.ast.SimpleCharStream
 * JD-Core Version:    0.6.0
 */