/*     */ package org.jboss.annotation.factory.ast;
/*     */ 
/*     */ import java.util.Stack;
/*     */ 
/*     */ class JJTAnnotationParserState
/*     */ {
/*     */   private Stack nodes;
/*     */   private Stack marks;
/*     */   private int sp;
/*     */   private int mk;
/*     */   private boolean node_created;
/*     */ 
/*     */   JJTAnnotationParserState()
/*     */   {
/*  34 */     this.nodes = new Stack();
/*  35 */     this.marks = new Stack();
/*  36 */     this.sp = 0;
/*  37 */     this.mk = 0;
/*     */   }
/*     */ 
/*     */   boolean nodeCreated()
/*     */   {
/*  44 */     return this.node_created;
/*     */   }
/*     */ 
/*     */   void reset()
/*     */   {
/*  50 */     this.nodes.removeAllElements();
/*  51 */     this.marks.removeAllElements();
/*  52 */     this.sp = 0;
/*  53 */     this.mk = 0;
/*     */   }
/*     */ 
/*     */   Node rootNode()
/*     */   {
/*  59 */     return (Node)this.nodes.elementAt(0);
/*     */   }
/*     */ 
/*     */   void pushNode(Node n)
/*     */   {
/*  65 */     this.nodes.push(n);
/*  66 */     this.sp += 1;
/*     */   }
/*     */ 
/*     */   Node popNode()
/*     */   {
/*  72 */     if (--this.sp < this.mk) {
/*  73 */       this.mk = ((Integer)this.marks.pop()).intValue();
/*     */     }
/*  75 */     return (Node)this.nodes.pop();
/*     */   }
/*     */ 
/*     */   Node peekNode()
/*     */   {
/*  80 */     return (Node)this.nodes.peek();
/*     */   }
/*     */ 
/*     */   int nodeArity()
/*     */   {
/*  86 */     return this.sp - this.mk;
/*     */   }
/*     */ 
/*     */   void clearNodeScope(Node n)
/*     */   {
/*  91 */     while (this.sp > this.mk) {
/*  92 */       popNode();
/*     */     }
/*  94 */     this.mk = ((Integer)this.marks.pop()).intValue();
/*     */   }
/*     */ 
/*     */   void openNodeScope(Node n)
/*     */   {
/* 100 */     this.marks.push(new Integer(this.mk));
/* 101 */     this.mk = this.sp;
/* 102 */     n.jjtOpen();
/*     */   }
/*     */ 
/*     */   void closeNodeScope(Node n, int num)
/*     */   {
/* 111 */     this.mk = ((Integer)this.marks.pop()).intValue();
/* 112 */     while (num-- > 0) {
/* 113 */       Node c = popNode();
/* 114 */       c.jjtSetParent(n);
/* 115 */       n.jjtAddChild(c, num);
/*     */     }
/* 117 */     n.jjtClose();
/* 118 */     pushNode(n);
/* 119 */     this.node_created = true;
/*     */   }
/*     */ 
/*     */   void closeNodeScope(Node n, boolean condition)
/*     */   {
/* 129 */     if (condition) {
/* 130 */       int a = nodeArity();
/* 131 */       this.mk = ((Integer)this.marks.pop()).intValue();
/* 132 */       while (a-- > 0) {
/* 133 */         Node c = popNode();
/* 134 */         c.jjtSetParent(n);
/* 135 */         n.jjtAddChild(c, a);
/*     */       }
/* 137 */       n.jjtClose();
/* 138 */       pushNode(n);
/* 139 */       this.node_created = true;
/*     */     } else {
/* 141 */       this.mk = ((Integer)this.marks.pop()).intValue();
/* 142 */       this.node_created = false;
/*     */     }
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.annotation.factory.ast.JJTAnnotationParserState
 * JD-Core Version:    0.6.0
 */