/*     */ package org.jboss.annotation.factory;
/*     */ 
/*     */ import java.io.Serializable;
/*     */ import java.lang.reflect.InvocationHandler;
/*     */ import java.lang.reflect.Method;
/*     */ import java.lang.reflect.Proxy;
/*     */ import java.util.Map;
/*     */ 
/*     */ public class AnnotationProxy
/*     */   implements InvocationHandler, Serializable
/*     */ {
/*     */   private static final long serialVersionUID = 1L;
/*     */   private Map map;
/*     */   private Class annotationType;
/*     */ 
/*     */   public AnnotationProxy(Class annotationType, Map valueMap)
/*     */   {
/*  45 */     this.annotationType = annotationType;
/*  46 */     this.map = valueMap;
/*     */   }
/*     */ 
/*     */   public Object invoke(Object proxy, Method method, Object[] args)
/*     */     throws Throwable
/*     */   {
/*  52 */     String name = method.getName();
/*  53 */     if ("equals".equals(name))
/*     */     {
/*  55 */       return doEquals(proxy, args[0]);
/*     */     }
/*  57 */     if ("hashCode".equals(name))
/*     */     {
/*  59 */       return doHashCode();
/*     */     }
/*  61 */     if ("toString".equals(name))
/*     */     {
/*  63 */       return this.map.toString();
/*     */     }
/*  65 */     if ("annotationType".equals(name))
/*     */     {
/*  67 */       return this.annotationType;
/*     */     }
/*     */ 
/*  78 */     return this.map.get(name);
/*     */   }
/*     */ 
/*     */   public Object getValue(String name)
/*     */   {
/*  83 */     return this.map.get(name);
/*     */   }
/*     */ 
/*     */   private Object doEquals(Object proxy, Object obj)
/*     */   {
/*  89 */     if (obj == proxy)
/*  90 */       return Boolean.TRUE;
/*  91 */     if (obj == null) {
/*  92 */       return Boolean.FALSE;
/*     */     }
/*  94 */     Class[] intfs = proxy.getClass().getInterfaces();
/*  95 */     if (!intfs[0].isAssignableFrom(obj.getClass()))
/*     */     {
/*  97 */       return Boolean.FALSE;
/*     */     }
/*     */     try
/*     */     {
/* 101 */       Proxy.getInvocationHandler(obj);
/*     */     }
/*     */     catch (Exception ex)
/*     */     {
/* 105 */       return Boolean.FALSE;
/*     */     }
/* 107 */     return Boolean.TRUE;
/*     */   }
/*     */ 
/*     */   private Object doHashCode()
/*     */   {
/* 112 */     return new Integer(this.map.hashCode());
/*     */   }
/*     */ 
/*     */   public static Object createProxy(Map map, Class annotation)
/*     */     throws Exception
/*     */   {
/* 124 */     AnnotationProxy proxyHandler = new AnnotationProxy(annotation, map);
/* 125 */     return Proxy.newProxyInstance(annotation.getClassLoader(), new Class[] { annotation }, proxyHandler);
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.annotation.factory.AnnotationProxy
 * JD-Core Version:    0.6.0
 */