/*     */ package org.jboss;
/*     */ 
/*     */ import gnu.getopt.Getopt;
/*     */ import gnu.getopt.LongOpt;
/*     */ import java.io.File;
/*     */ import java.io.FilenameFilter;
/*     */ import java.io.PrintStream;
/*     */ import java.net.MalformedURLException;
/*     */ import java.net.URL;
/*     */ import java.net.URLConnection;
/*     */ import java.net.URLDecoder;
/*     */ import java.security.CodeSource;
/*     */ import java.security.ProtectionDomain;
/*     */ import java.util.LinkedList;
/*     */ import java.util.List;
/*     */ import java.util.Properties;
/*     */ import org.jboss.system.server.Server;
/*     */ import org.jboss.system.server.ServerConfigUtil;
/*     */ import org.jboss.system.server.ServerLoader;
/*     */ 
/*     */ public class Main
/*     */ {
/*  64 */   private String concurrentLib = "concurrent.jar";
/*     */   private URL bootURL;
/*  72 */   private List<String> bootLibraries = new LinkedList();
/*     */ 
/*  75 */   private List<String> extraLibraries = new LinkedList();
/*     */ 
/*  78 */   private List<URL> extraClasspath = new LinkedList();
/*     */ 
/*  85 */   private Properties props = new Properties(System.getProperties());
/*     */   private Server server;
/*     */ 
/*     */   public Server getServer()
/*     */   {
/* 104 */     return this.server;
/*     */   }
/*     */ 
/*     */   public void boot(String[] args)
/*     */     throws Exception
/*     */   {
/* 117 */     processCommandLine(args);
/*     */ 
/* 120 */     String homeDir = this.props.getProperty("jboss.home.dir");
/* 121 */     if (homeDir == null)
/*     */     {
/* 123 */       String path = Main.class.getProtectionDomain().getCodeSource().getLocation().getFile();
/*     */ 
/* 128 */       path = URLDecoder.decode(path, "UTF-8");
/* 129 */       File runJar = new File(path);
/* 130 */       File homeFile = runJar.getParentFile().getParentFile();
/* 131 */       homeDir = homeFile.getCanonicalPath();
/*     */     }
/* 133 */     this.props.setProperty("jboss.home.dir", homeDir);
/*     */ 
/* 136 */     String homeURL = this.props.getProperty("jboss.home.url");
/* 137 */     if (homeURL == null)
/*     */     {
/* 139 */       File file = new File(homeDir);
/* 140 */       homeURL = file.toURL().toString();
/* 141 */       this.props.setProperty("jboss.home.url", homeURL);
/*     */     }
/*     */ 
/* 145 */     ServerLoader loader = new ServerLoader(this.props);
/*     */ 
/* 151 */     if (this.bootURL != null)
/*     */     {
/* 153 */       if (this.bootURL.getProtocol().equals("file"))
/*     */       {
/* 155 */         File dir = new File(this.bootURL.getFile());
/* 156 */         if (dir.exists())
/*     */         {
/* 159 */           loader.addURL(dir.toURL());
/*     */ 
/* 162 */           File[] jars = dir.listFiles(new JarFilter());
/*     */ 
/* 164 */           for (int j = 0; (jars != null) && (j < jars.length); j++)
/*     */           {
/* 166 */             loader.addURL(jars[j].getCanonicalFile().toURL());
/*     */           }
/*     */         }
/*     */       }
/*     */       else
/*     */       {
/* 172 */         loader.addURL(this.bootURL);
/*     */       }
/*     */ 
/*     */     }
/*     */ 
/* 177 */     for (int i = 0; i < this.bootLibraries.size(); i++)
/*     */     {
/* 179 */       loader.addLibrary((String)this.bootLibraries.get(i));
/*     */     }
/*     */ 
/* 183 */     loader.addEndorsedJars();
/*     */ 
/* 186 */     loader.addLibrary(this.concurrentLib);
/*     */ 
/* 189 */     for (int i = 0; i < this.extraLibraries.size(); i++)
/*     */     {
/* 191 */       loader.addLibrary((String)this.extraLibraries.get(i));
/*     */     }
/*     */ 
/* 195 */     for (int i = 0; i < this.extraClasspath.size(); i++)
/*     */     {
/* 197 */       loader.addURL((URL)this.extraClasspath.get(i));
/*     */     }
/*     */ 
/* 201 */     ClassLoader parentCL = Thread.currentThread().getContextClassLoader();
/* 202 */     this.server = loader.load(parentCL);
/*     */ 
/* 205 */     this.server.init(this.props);
/*     */ 
/* 208 */     this.server.start();
/*     */   }
/*     */ 
/*     */   public void shutdown()
/*     */   {
/* 217 */     this.server.shutdown();
/*     */   }
/*     */ 
/*     */   private URL makeURL(String urlspec) throws MalformedURLException
/*     */   {
/* 222 */     urlspec = urlspec.trim();
/*     */     URL url;
/*     */     try
/*     */     {
/* 228 */       url = new URL(urlspec);
/* 229 */       if (url.getProtocol().equals("file"))
/*     */       {
/* 232 */         File file = new File(url.getFile()).getCanonicalFile();
/* 233 */         url = file.toURL();
/*     */       }
/*     */ 
/*     */     }
/*     */     catch (Exception e)
/*     */     {
/*     */       try
/*     */       {
/* 241 */         File file = new File(urlspec).getCanonicalFile();
/* 242 */         url = file.toURL();
/*     */       }
/*     */       catch (Exception n)
/*     */       {
/* 246 */         throw new MalformedURLException(n.toString());
/*     */       }
/*     */     }
/*     */ 
/* 250 */     return url;
/*     */   }
/*     */ 
/*     */   private void processCommandLine(String[] args)
/*     */     throws Exception
/*     */   {
/* 257 */     String programName = System.getProperty("program.name", "jboss");
/* 258 */     String sopts = "-:hD:d:p:n:c:Vj::B:L:C:P:b:g:u:m:l:";
/* 259 */     LongOpt[] lopts = { new LongOpt("help", 0, null, 104), new LongOpt("bootdir", 1, null, 100), new LongOpt("patchdir", 1, null, 112), new LongOpt("netboot", 1, null, 110), new LongOpt("configuration", 1, null, 99), new LongOpt("version", 0, null, 86), new LongOpt("jaxp", 1, null, 106), new LongOpt("bootlib", 1, null, 66), new LongOpt("library", 1, null, 76), new LongOpt("classpath", 1, null, 67), new LongOpt("properties", 1, null, 80), new LongOpt("host", 1, null, 98), new LongOpt("partition", 1, null, 103), new LongOpt("udp", 1, null, 117), new LongOpt("mcast_port", 1, null, 109), new LongOpt("log", 1, null, 108) };
/*     */ 
/* 279 */     Getopt getopt = new Getopt(programName, args, sopts, lopts);
/*     */ 
/* 282 */     this.props.setProperty("jboss.bind.address", "127.0.0.1");
/* 283 */     System.setProperty("jboss.bind.address", "127.0.0.1");
/*     */     int code;
/* 284 */     while ((code = getopt.getopt()) != -1)
/*     */     {
/*     */       String arg;
/* 286 */       switch (code)
/*     */       {
/*     */       case 58:
/*     */       case 63:
/* 291 */         System.exit(1);
/* 292 */         break;
/*     */       case 1:
/* 297 */         System.err.println(programName + ": unused non-option argument: " + getopt.getOptarg());
/*     */ 
/* 300 */         break;
/*     */       case 104:
/* 304 */         System.out.println("usage: " + programName + " [options]");
/* 305 */         System.out.println();
/* 306 */         System.out.println("options:");
/* 307 */         System.out.println("    -h, --help                    Show this help message");
/* 308 */         System.out.println("    -V, --version                 Show version information");
/* 309 */         System.out.println("    --                            Stop processing options");
/* 310 */         System.out.println("    -D<name>[=<value>]            Set a system property");
/* 311 */         System.out.println("    -d, --bootdir=<dir>           Set the boot patch directory; Must be absolute or url");
/* 312 */         System.out.println("    -p, --patchdir=<dir>          Set the patch directory; Must be absolute or url");
/* 313 */         System.out.println("    -n, --netboot=<url>           Boot from net with the given url as base");
/* 314 */         System.out.println("    -c, --configuration=<name>    Set the server configuration name");
/* 315 */         System.out.println("    -B, --bootlib=<filename>      Add an extra library to the front bootclasspath");
/* 316 */         System.out.println("    -L, --library=<filename>      Add an extra library to the loaders classpath");
/* 317 */         System.out.println("    -C, --classpath=<url>         Add an extra url to the loaders classpath");
/* 318 */         System.out.println("    -P, --properties=<url>        Load system properties from the given url");
/* 319 */         System.out.println("    -b, --host=<host or ip>       Bind address for all JBoss services");
/* 320 */         System.out.println("    -g, --partition=<name>        HA Partition name (default=DefaultDomain)");
/* 321 */         System.out.println("    -m, --mcast_port=<ip>         UDP multicast port; Only used by JGroups multiplexer");
/* 322 */         System.out.println("    -u, --udp=<ip>                UDP multicast address");
/* 323 */         System.out.println("    -l, --log=<log4j|jdk>         Specify the logger plugin type");
/* 324 */         System.out.println();
/* 325 */         System.exit(0);
/* 326 */         break;
/*     */       case 68:
/* 331 */         arg = getopt.getOptarg();
/*     */ 
/* 333 */         int i = arg.indexOf("=");
/*     */         String value;
/*     */         String name;
/*     */         String value;
/* 334 */         if (i == -1)
/*     */         {
/* 336 */           String name = arg;
/* 337 */           value = "true";
/*     */         }
/*     */         else
/*     */         {
/* 341 */           name = arg.substring(0, i);
/* 342 */           value = arg.substring(i + 1, arg.length());
/*     */         }
/* 344 */         System.setProperty(name, value);
/*     */ 
/* 347 */         if ("bind.address".equals(name))
/*     */         {
/* 350 */           String addr = ServerConfigUtil.fixRemoteAddress(value);
/* 351 */           System.setProperty("jgroups.bind_addr", addr);
/*     */         } else {
/* 353 */           if (!"jgroups.bind_addr".equals(name)) {
/*     */             break;
/*     */           }
/* 356 */           String addr = ServerConfigUtil.fixRemoteAddress(value);
/* 357 */           System.setProperty("jgroups.bind_addr", addr);
/* 358 */         }break;
/*     */       case 100:
/* 364 */         this.bootURL = makeURL(getopt.getOptarg());
/* 365 */         break;
/*     */       case 112:
/* 370 */         URL patchURL = makeURL(getopt.getOptarg());
/* 371 */         this.props.put("jboss.patch.url", patchURL.toString());
/*     */ 
/* 373 */         break;
/*     */       case 110:
/* 378 */         arg = getopt.getOptarg();
/*     */ 
/* 381 */         if (!arg.endsWith("/")) arg = arg + "/";
/*     */ 
/* 383 */         this.props.put("jboss.home.url", new URL(arg).toString());
/* 384 */         break;
/*     */       case 99:
/* 388 */         arg = getopt.getOptarg();
/* 389 */         this.props.put("jboss.server.name", arg);
/* 390 */         break;
/*     */       case 86:
/* 395 */         Package jbossPackage = Package.getPackage("org.jboss");
/*     */ 
/* 398 */         System.out.println("JBoss " + jbossPackage.getImplementationVersion());
/* 399 */         System.out.println();
/* 400 */         System.out.println("Distributable under LGPL license.");
/* 401 */         System.out.println("See terms of license at gnu.org.");
/* 402 */         System.out.println();
/* 403 */         System.exit(0);
/* 404 */         break;
/*     */       case 106:
/* 409 */         System.err.println(programName + ": option '-j, --jaxp' no longer supported");
/* 410 */         System.exit(1);
/* 411 */         break;
/*     */       case 66:
/* 414 */         arg = getopt.getOptarg();
/* 415 */         this.bootLibraries.add(arg);
/* 416 */         break;
/*     */       case 76:
/* 419 */         arg = getopt.getOptarg();
/* 420 */         this.extraLibraries.add(arg);
/* 421 */         break;
/*     */       case 67:
/* 425 */         URL url = makeURL(getopt.getOptarg());
/* 426 */         this.extraClasspath.add(url);
/* 427 */         break;
/*     */       case 80:
/* 433 */         URL url = makeURL(getopt.getOptarg());
/* 434 */         Properties props = System.getProperties();
/* 435 */         props.load(url.openConnection().getInputStream());
/* 436 */         break;
/*     */       case 98:
/* 439 */         arg = getopt.getOptarg();
/* 440 */         this.props.put("jboss.bind.address", arg);
/* 441 */         System.setProperty("jboss.bind.address", arg);
/*     */ 
/* 446 */         String bindAddress = System.getProperty("bind.address");
/* 447 */         if (bindAddress == null)
/*     */         {
/* 450 */           bindAddress = ServerConfigUtil.fixRemoteAddress(arg);
/* 451 */           System.setProperty("bind.address", bindAddress);
/*     */         }
/* 453 */         bindAddress = System.getProperty("jgroups.bind_addr");
/* 454 */         if (bindAddress == null)
/*     */         {
/* 457 */           bindAddress = ServerConfigUtil.fixRemoteAddress(arg);
/* 458 */           System.setProperty("jgroups.bind_addr", bindAddress);
/*     */         }
/*     */ 
/* 462 */         String rmiHost = System.getProperty("java.rmi.server.hostname");
/* 463 */         if (rmiHost != null)
/*     */           break;
/* 465 */         rmiHost = ServerConfigUtil.fixRemoteAddress(arg);
/* 466 */         System.setProperty("java.rmi.server.hostname", rmiHost); break;
/*     */       case 103:
/* 470 */         arg = getopt.getOptarg();
/* 471 */         this.props.put("jboss.partition.name", arg);
/* 472 */         System.setProperty("jboss.partition.name", arg);
/* 473 */         break;
/*     */       case 117:
/* 475 */         arg = getopt.getOptarg();
/* 476 */         this.props.put("jboss.partition.udpGroup", arg);
/* 477 */         System.setProperty("jboss.partition.udpGroup", arg);
/*     */ 
/* 479 */         System.setProperty("jgroups.udp.mcast_addr", arg);
/* 480 */         break;
/*     */       case 109:
/* 482 */         arg = getopt.getOptarg();
/* 483 */         this.props.put("jgroups.udp.mcast_port", arg);
/* 484 */         System.setProperty("jgroups.udp.mcast_port", arg);
/* 485 */         break;
/*     */       case 108:
/* 488 */         arg = getopt.getOptarg();
/* 489 */         String logPlugin = arg;
/* 490 */         if (arg.equalsIgnoreCase("log4j")) {
/* 491 */           logPlugin = "org.jboss.logging.Log4jLoggerPlugin";
/* 492 */         } else if (arg.equalsIgnoreCase("jdk"))
/*     */         {
/* 494 */           logPlugin = "org.jboss.logging.JDK14LoggerPlugin";
/*     */ 
/* 496 */           System.setProperty("java.util.logging.manager", "org.jboss.logging.jdk.JDKLogManager");
/*     */         }
/*     */ 
/* 499 */         System.setProperty("org.jboss.logging.Logger.pluginClass", logPlugin);
/* 500 */         break;
/*     */       default:
/* 505 */         throw new Error("unhandled option code: " + code);
/*     */       }
/*     */ 
/*     */     }
/*     */ 
/* 510 */     String bindAddress = System.getProperty("jboss.bind.address");
/* 511 */     if (System.getProperty("java.rmi.server.hostname") == null)
/* 512 */       System.setProperty("java.rmi.server.hostname", bindAddress);
/* 513 */     if (System.getProperty("jgroups.bind_addr") == null)
/* 514 */       System.setProperty("jgroups.bind_addr", bindAddress);
/*     */   }
/*     */ 
/*     */   public static void main(String[] args)
/*     */     throws Exception
/*     */   {
/* 528 */     Runnable worker = new Runnable(args)
/*     */     {
/*     */       public void run()
/*     */       {
/*     */         try {
/* 533 */           Main main = new Main();
/* 534 */           main.boot(this.val$args);
/*     */         }
/*     */         catch (Exception e)
/*     */         {
/* 538 */           System.err.println("Failed to boot JBoss:");
/* 539 */           e.printStackTrace();
/*     */         }
/*     */       }
/*     */     };
/* 545 */     ThreadGroup threads = new ThreadGroup("jboss");
/* 546 */     new Thread(threads, worker, "main").start();
/*     */   }
/*     */ 
/*     */   public static void systemExit(String[] argv)
/*     */   {
/* 558 */     System.exit(0);
/*     */   }
/*     */ 
/*     */   static class JarFilter implements FilenameFilter
/*     */   {
/*     */     public boolean accept(File dir, String name)
/*     */     {
/* 565 */       return name.endsWith(".jar");
/*     */     }
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.Main
 * JD-Core Version:    0.6.0
 */