/*    */ package javax.xml.ws.addressing;
/*    */ 
/*    */ import java.net.URI;
/*    */ import java.net.URISyntaxException;
/*    */ import java.util.logging.Logger;
/*    */ import javax.xml.namespace.QName;
/*    */ 
/*    */ public abstract class AddressingBuilder
/*    */   implements AddressingType
/*    */ {
/* 38 */   private static Logger log = Logger.getLogger(AddressingBuilder.class.getName());
/*    */ 
/*    */   public static AddressingBuilder getAddressingBuilder()
/*    */   {
/*    */     ClassLoader classLoader;
/*    */     try
/*    */     {
/* 49 */       classLoader = Thread.currentThread().getContextClassLoader();
/*    */     }
/*    */     catch (Exception x)
/*    */     {
/* 53 */       throw new AddressingException(x.toString(), x);
/*    */     }
/*    */ 
/* 56 */     String name = null;
/*    */     try
/*    */     {
/* 61 */       name = System.getProperty("javax.xml.ws.addressing.AddressingBuilder");
/* 62 */       if (name != null)
/*    */       {
/* 64 */         return newInstance(name, classLoader);
/*    */       }
/*    */     }
/*    */     catch (Exception e)
/*    */     {
/* 69 */       log.warning("Could not create and instance of " + name + " trying " + "org.jboss.ws.extensions.addressing.soap.SOAPAddressingBuilderImpl");
/*    */     }
/*    */ 
/* 73 */     return newInstance("org.jboss.ws.extensions.addressing.soap.SOAPAddressingBuilderImpl", classLoader);
/*    */   }
/*    */ 
/*    */   private static AddressingBuilder newInstance(String className, ClassLoader classLoader)
/*    */   {
/*    */     try
/*    */     {
/*    */       Class cls;
/*    */       Class cls;
/* 81 */       if (classLoader == null)
/*    */       {
/* 83 */         cls = Class.forName(className);
/*    */       }
/*    */       else
/*    */       {
/* 87 */         cls = classLoader.loadClass(className);
/*    */       }
/* 89 */       return (AddressingBuilder)cls.newInstance();
/*    */     }
/*    */     catch (ClassNotFoundException x)
/*    */     {
/* 93 */       throw new AddressingException("Provider " + className + " not found", x);
/*    */     }
/*    */     catch (Exception x) {
/*    */     }
/* 97 */     throw new AddressingException("Provider " + className + " could not be instantiated: " + x, x);
/*    */   }
/*    */ 
/*    */   public abstract AttributedURI newURI(URI paramURI);
/*    */ 
/*    */   public abstract AttributedURI newURI(String paramString)
/*    */     throws URISyntaxException;
/*    */ 
/*    */   public abstract AttributedQName newQName(QName paramQName);
/*    */ 
/*    */   public abstract Relationship newRelationship(URI paramURI);
/*    */ 
/*    */   public abstract EndpointReference newEndpointReference(URI paramURI);
/*    */ 
/*    */   public abstract AddressingProperties newAddressingProperties();
/*    */ 
/*    */   public abstract AddressingConstants newAddressingConstants();
/*    */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     javax.xml.ws.addressing.AddressingBuilder
 * JD-Core Version:    0.6.0
 */