/*     */ package javax.xml.ws;
/*     */ 
/*     */ import java.net.URL;
/*     */ import java.util.Iterator;
/*     */ import java.util.concurrent.Executor;
/*     */ import javax.xml.bind.JAXBContext;
/*     */ import javax.xml.namespace.QName;
/*     */ import javax.xml.ws.handler.HandlerResolver;
/*     */ import javax.xml.ws.spi.Provider;
/*     */ import javax.xml.ws.spi.ServiceDelegate21;
/*     */ 
/*     */ public class Service
/*     */ {
/*     */   ServiceDelegate21 delegate;
/*     */ 
/*     */   protected Service(URL wsdlDocumentLocation, QName serviceName)
/*     */   {
/*  82 */     this.delegate = ((ServiceDelegate21)Provider.provider().createServiceDelegate(wsdlDocumentLocation, serviceName, getClass()));
/*     */   }
/*     */ 
/*     */   public <T> T getPort(QName portName, Class<T> serviceEndpointInterface)
/*     */   {
/* 115 */     return this.delegate.getPort(portName, serviceEndpointInterface);
/*     */   }
/*     */ 
/*     */   public <T> T getPort(Class<T> serviceEndpointInterface)
/*     */   {
/* 143 */     return this.delegate.getPort(serviceEndpointInterface);
/*     */   }
/*     */ 
/*     */   public void addPort(QName portName, String bindingId, String endpointAddress)
/*     */   {
/* 163 */     this.delegate.addPort(portName, bindingId, endpointAddress);
/*     */   }
/*     */ 
/*     */   public <T> Dispatch<T> createDispatch(QName portName, Class<T> type, Mode mode)
/*     */   {
/* 192 */     return this.delegate.createDispatch(portName, type, mode);
/*     */   }
/*     */ 
/*     */   public Dispatch<Object> createDispatch(QName portName, JAXBContext context, Mode mode)
/*     */   {
/* 216 */     return this.delegate.createDispatch(portName, context, mode);
/*     */   }
/*     */ 
/*     */   public QName getServiceName()
/*     */   {
/* 225 */     return this.delegate.getServiceName();
/*     */   }
/*     */ 
/*     */   public Iterator<QName> getPorts()
/*     */   {
/* 240 */     return this.delegate.getPorts();
/*     */   }
/*     */ 
/*     */   public URL getWSDLDocumentLocation()
/*     */   {
/* 251 */     return this.delegate.getWSDLDocumentLocation();
/*     */   }
/*     */ 
/*     */   public HandlerResolver getHandlerResolver()
/*     */   {
/* 263 */     return this.delegate.getHandlerResolver();
/*     */   }
/*     */ 
/*     */   public void setHandlerResolver(HandlerResolver handlerResolver)
/*     */   {
/* 281 */     this.delegate.setHandlerResolver(handlerResolver);
/*     */   }
/*     */ 
/*     */   public Executor getExecutor()
/*     */   {
/* 297 */     return this.delegate.getExecutor();
/*     */   }
/*     */ 
/*     */   public void setExecutor(Executor executor)
/*     */   {
/* 317 */     this.delegate.setExecutor(executor);
/*     */   }
/*     */ 
/*     */   public static Service create(URL wsdlLocation, QName serviceName)
/*     */   {
/* 334 */     return new Service(wsdlLocation, serviceName);
/*     */   }
/*     */ 
/*     */   public static Service create(QName serviceName)
/*     */   {
/* 346 */     return create(null, serviceName);
/*     */   }
/*     */ 
/*     */   public static enum Mode
/*     */   {
/*  77 */     MESSAGE, PAYLOAD;
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     javax.xml.ws.Service
 * JD-Core Version:    0.6.0
 */