/*     */ package javax.xml.ws;
/*     */ 
/*     */ import java.util.List;
/*     */ import java.util.Map;
/*     */ import java.util.concurrent.Executor;
/*     */ import javax.xml.transform.Source;
/*     */ import javax.xml.ws.spi.Provider;
/*     */ 
/*     */ public abstract class Endpoint
/*     */ {
/*     */   public static final String WSDL_SERVICE = "javax.xml.ws.wsdl.service";
/*     */   public static final String WSDL_PORT = "javax.xml.ws.wsdl.port";
/*     */ 
/*     */   public static Endpoint create(Object implementor)
/*     */   {
/*  97 */     if (implementor == null) {
/*  98 */       throw new IllegalArgumentException("Implementor cannot be null");
/*     */     }
/* 100 */     String bindingId = "http://schemas.xmlsoap.org/wsdl/soap/http";
/* 101 */     BindingType anBindingType = (BindingType)implementor.getClass().getAnnotation(BindingType.class);
/* 102 */     if (anBindingType != null) {
/* 103 */       bindingId = anBindingType.value();
/*     */     }
/* 105 */     return create(bindingId, implementor);
/*     */   }
/*     */ 
/*     */   public static Endpoint create(String bindingId, Object implementor)
/*     */   {
/* 127 */     return Provider.provider().createEndpoint(bindingId, implementor);
/*     */   }
/*     */ 
/*     */   public abstract Binding getBinding();
/*     */ 
/*     */   public abstract Object getImplementor();
/*     */ 
/*     */   public abstract void publish(String paramString);
/*     */ 
/*     */   public static Endpoint publish(String address, Object implementor)
/*     */   {
/* 186 */     return Provider.provider().createAndPublishEndpoint(address, implementor);
/*     */   }
/*     */ 
/*     */   public abstract void publish(Object paramObject);
/*     */ 
/*     */   public abstract void stop();
/*     */ 
/*     */   public abstract boolean isPublished();
/*     */ 
/*     */   public abstract List<Source> getMetadata();
/*     */ 
/*     */   public abstract void setMetadata(List<Source> paramList);
/*     */ 
/*     */   public abstract Executor getExecutor();
/*     */ 
/*     */   public abstract void setExecutor(Executor paramExecutor);
/*     */ 
/*     */   public abstract Map<String, Object> getProperties();
/*     */ 
/*     */   public abstract void setProperties(Map<String, Object> paramMap);
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     javax.xml.ws.Endpoint
 * JD-Core Version:    0.6.0
 */