/*     */ package javax.xml.stream;
/*     */ 
/*     */ import java.io.OutputStream;
/*     */ import java.io.Writer;
/*     */ import javax.xml.transform.Result;
/*     */ 
/*     */ public abstract class XMLOutputFactory
/*     */ {
/*     */   private static final String XML_OUTPUT_FACTORY_KEY = "javax.xml.stream.XMLOutputFactory";
/*     */   private static final String XML_OUTPUT_FACTORY_DEFAULT = "com.ctc.wstx.stax.WstxOutputFactory";
/*     */   public static final String IS_REPAIRING_NAMESPACES = "javax.xml.stream.isRepairingNamespaces";
/*     */ 
/*     */   public static XMLOutputFactory newInstance()
/*     */     throws FactoryConfigurationError
/*     */   {
/* 141 */     return (XMLOutputFactory)FactoryLocator.find("javax.xml.stream.XMLOutputFactory", "com.ctc.wstx.stax.WstxOutputFactory");
/*     */   }
/*     */ 
/*     */   public static XMLInputFactory newInstance(String factoryId, ClassLoader classLoader)
/*     */     throws FactoryConfigurationError
/*     */   {
/* 155 */     return (XMLInputFactory)FactoryLocator.find(factoryId, "com.ctc.wstx.stax.WstxOutputFactory", classLoader);
/*     */   }
/*     */ 
/*     */   public abstract XMLStreamWriter createXMLStreamWriter(Writer paramWriter)
/*     */     throws XMLStreamException;
/*     */ 
/*     */   public abstract XMLStreamWriter createXMLStreamWriter(OutputStream paramOutputStream)
/*     */     throws XMLStreamException;
/*     */ 
/*     */   public abstract XMLStreamWriter createXMLStreamWriter(OutputStream paramOutputStream, String paramString)
/*     */     throws XMLStreamException;
/*     */ 
/*     */   public abstract XMLStreamWriter createXMLStreamWriter(Result paramResult)
/*     */     throws XMLStreamException;
/*     */ 
/*     */   public abstract XMLEventWriter createXMLEventWriter(Result paramResult)
/*     */     throws XMLStreamException;
/*     */ 
/*     */   public abstract XMLEventWriter createXMLEventWriter(OutputStream paramOutputStream)
/*     */     throws XMLStreamException;
/*     */ 
/*     */   public abstract XMLEventWriter createXMLEventWriter(OutputStream paramOutputStream, String paramString)
/*     */     throws XMLStreamException;
/*     */ 
/*     */   public abstract XMLEventWriter createXMLEventWriter(Writer paramWriter)
/*     */     throws XMLStreamException;
/*     */ 
/*     */   public abstract void setProperty(String paramString, Object paramObject)
/*     */     throws IllegalArgumentException;
/*     */ 
/*     */   public abstract Object getProperty(String paramString)
/*     */     throws IllegalArgumentException;
/*     */ 
/*     */   public abstract boolean isPropertySupported(String paramString);
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     javax.xml.stream.XMLOutputFactory
 * JD-Core Version:    0.6.0
 */