/*     */ package javax.xml.stream;
/*     */ 
/*     */ import java.io.BufferedReader;
/*     */ import java.io.File;
/*     */ import java.io.FileInputStream;
/*     */ import java.io.InputStream;
/*     */ import java.io.InputStreamReader;
/*     */ import java.util.Properties;
/*     */ 
/*     */ class FactoryLocator
/*     */ {
/*  41 */   private static final String JAVA_HOME = System.getProperty("java.home");
/*     */ 
/*  43 */   private static final String PROPERTY_FILE = JAVA_HOME + File.pathSeparator + "lib" + File.pathSeparator + "xml.stream.properties";
/*     */   private static final String SERVICES_PATH = "META-INF/services/";
/*     */ 
/*     */   private static Object newInstance(String className, ClassLoader classLoader)
/*     */   {
/*     */     try
/*     */     {
/*  51 */       return classLoader.loadClass(className).newInstance();
/*     */     }
/*     */     catch (ClassNotFoundException e)
/*     */     {
/*  55 */       throw new FactoryConfigurationError("Could not locate provider [" + className + "]", e);
/*     */     }
/*     */     catch (Exception e) {
/*     */     }
/*  59 */     throw new FactoryConfigurationError("Error creating provider [" + className + "]", e);
/*     */   }
/*     */ 
/*     */   private static String getPropertyFromFile(String property)
/*     */   {
/*  68 */     File file = new File(PROPERTY_FILE);
/*     */ 
/*  70 */     if (!file.exists()) {
/*  71 */       return null;
/*     */     }
/*  73 */     Properties properties = new Properties();
/*     */     try
/*     */     {
/*  76 */       properties.load(new FileInputStream(file));
/*  77 */       return properties.getProperty(property);
/*     */     }
/*     */     catch (Exception e)
/*     */     {
/*     */     }
/*  82 */     return null;
/*     */   }
/*     */ 
/*     */   private static String getPropertyFromServices(String property, ClassLoader classLoader)
/*     */   {
/*  88 */     String resource = "META-INF/services/" + property;
/*  89 */     InputStream stream = classLoader.getResourceAsStream(property);
/*     */ 
/*  91 */     if (stream == null)
/*  92 */       return null;
/*     */     try
/*     */     {
/*  95 */       BufferedReader reader = new BufferedReader(new InputStreamReader(stream, "UTF-8"));
/*  96 */       return reader.readLine();
/*     */     }
/*     */     catch (Exception e)
/*     */     {
/*     */     }
/* 101 */     return null;
/*     */   }
/*     */ 
/*     */   static Object find(String factoryId, String defaultFactory)
/*     */     throws FactoryConfigurationError
/*     */   {
/* 113 */     ClassLoader loader = Thread.currentThread().getContextClassLoader();
/* 114 */     return find(factoryId, defaultFactory, loader);
/*     */   }
/*     */ 
/*     */   static Object find(String factoryId, String defaultFactory, ClassLoader classLoader)
/*     */     throws FactoryConfigurationError
/*     */   {
/* 130 */     if (classLoader == null) {
/* 131 */       throw new FactoryConfigurationError("Could not determine classloader.");
/*     */     }
/* 133 */     String value = System.getProperty(factoryId);
/* 134 */     if (value != null) {
/* 135 */       return newInstance(value, classLoader);
/*     */     }
/* 137 */     value = getPropertyFromFile(factoryId);
/* 138 */     if (value != null) {
/* 139 */       return newInstance(value, classLoader);
/*     */     }
/* 141 */     value = getPropertyFromServices(factoryId, classLoader);
/* 142 */     if (value != null) {
/* 143 */       return newInstance(value, classLoader);
/*     */     }
/* 145 */     return newInstance(defaultFactory, classLoader);
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     javax.xml.stream.FactoryLocator
 * JD-Core Version:    0.6.0
 */