package javax.servlet.http;

import java.security.Principal;
import java.util.Enumeration;
import javax.servlet.ServletRequest;

public abstract interface HttpServletRequest extends ServletRequest
{
  public static final String BASIC_AUTH = "BASIC";
  public static final String FORM_AUTH = "FORM";
  public static final String CLIENT_CERT_AUTH = "CLIENT_CERT";
  public static final String DIGEST_AUTH = "DIGEST";

  public abstract String getAuthType();

  public abstract Cookie[] getCookies();

  public abstract long getDateHeader(String paramString);

  public abstract String getHeader(String paramString);

  public abstract Enumeration getHeaders(String paramString);

  public abstract Enumeration getHeaderNames();

  public abstract int getIntHeader(String paramString);

  public abstract String getMethod();

  public abstract String getPathInfo();

  public abstract String getPathTranslated();

  public abstract String getContextPath();

  public abstract String getQueryString();

  public abstract String getRemoteUser();

  public abstract boolean isUserInRole(String paramString);

  public abstract Principal getUserPrincipal();

  public abstract String getRequestedSessionId();

  public abstract String getRequestURI();

  public abstract StringBuffer getRequestURL();

  public abstract String getServletPath();

  public abstract HttpSession getSession(boolean paramBoolean);

  public abstract HttpSession getSession();

  public abstract boolean isRequestedSessionIdValid();

  public abstract boolean isRequestedSessionIdFromCookie();

  public abstract boolean isRequestedSessionIdFromURL();

  /** @deprecated */
  public abstract boolean isRequestedSessionIdFromUrl();
}

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     javax.servlet.http.HttpServletRequest
 * JD-Core Version:    0.6.0
 */