/*     */ package javax.servlet.http;
/*     */ 
/*     */ import java.text.MessageFormat;
/*     */ import java.util.ResourceBundle;
/*     */ 
/*     */ public class Cookie
/*     */   implements Cloneable
/*     */ {
/*     */   private static final String LSTRING_FILE = "javax.servlet.http.LocalStrings";
/*  70 */   private static ResourceBundle lStrings = ResourceBundle.getBundle("javax.servlet.http.LocalStrings");
/*     */   private String name;
/*     */   private String value;
/*     */   private String comment;
/*     */   private String domain;
/*  87 */   private int maxAge = -1;
/*     */   private String path;
/*     */   private boolean secure;
/*  90 */   private int version = 0;
/*     */   private static final String tspecials = ",; ";
/*     */ 
/*     */   public Cookie(String name, String value)
/*     */   {
/* 126 */     if ((!isToken(name)) || (name.equalsIgnoreCase("Comment")) || (name.equalsIgnoreCase("Discard")) || (name.equalsIgnoreCase("Domain")) || (name.equalsIgnoreCase("Expires")) || (name.equalsIgnoreCase("Max-Age")) || (name.equalsIgnoreCase("Path")) || (name.equalsIgnoreCase("Secure")) || (name.equalsIgnoreCase("Version")) || (name.startsWith("$")))
/*     */     {
/* 137 */       String errMsg = lStrings.getString("err.cookie_name_is_token");
/* 138 */       Object[] errArgs = new Object[1];
/* 139 */       errArgs[0] = name;
/* 140 */       errMsg = MessageFormat.format(errMsg, errArgs);
/* 141 */       throw new IllegalArgumentException(errMsg);
/*     */     }
/*     */ 
/* 144 */     this.name = name;
/* 145 */     this.value = value;
/*     */   }
/*     */ 
/*     */   public void setComment(String purpose)
/*     */   {
/* 167 */     this.comment = purpose;
/*     */   }
/*     */ 
/*     */   public String getComment()
/*     */   {
/* 185 */     return this.comment;
/*     */   }
/*     */ 
/*     */   public void setDomain(String pattern)
/*     */   {
/* 213 */     this.domain = pattern.toLowerCase();
/*     */   }
/*     */ 
/*     */   public String getDomain()
/*     */   {
/* 231 */     return this.domain;
/*     */   }
/*     */ 
/*     */   public void setMaxAge(int expiry)
/*     */   {
/* 261 */     this.maxAge = expiry;
/*     */   }
/*     */ 
/*     */   public int getMaxAge()
/*     */   {
/* 283 */     return this.maxAge;
/*     */   }
/*     */ 
/*     */   public void setPath(String uri)
/*     */   {
/* 311 */     this.path = uri;
/*     */   }
/*     */ 
/*     */   public String getPath()
/*     */   {
/* 331 */     return this.path;
/*     */   }
/*     */ 
/*     */   public void setSecure(boolean flag)
/*     */   {
/* 353 */     this.secure = flag;
/*     */   }
/*     */ 
/*     */   public boolean getSecure()
/*     */   {
/* 372 */     return this.secure;
/*     */   }
/*     */ 
/*     */   public String getName()
/*     */   {
/* 388 */     return this.name;
/*     */   }
/*     */ 
/*     */   public void setValue(String newValue)
/*     */   {
/* 415 */     this.value = newValue;
/*     */   }
/*     */ 
/*     */   public String getValue()
/*     */   {
/* 433 */     return this.value;
/*     */   }
/*     */ 
/*     */   public int getVersion()
/*     */   {
/* 456 */     return this.version;
/*     */   }
/*     */ 
/*     */   public void setVersion(int v)
/*     */   {
/* 480 */     this.version = v;
/*     */   }
/*     */ 
/*     */   private boolean isToken(String value)
/*     */   {
/* 505 */     int len = value.length();
/*     */ 
/* 507 */     for (int i = 0; i < len; i++) {
/* 508 */       char c = value.charAt(i);
/*     */ 
/* 510 */       if ((c < ' ') || (c >= '') || (",; ".indexOf(c) != -1))
/* 511 */         return false;
/*     */     }
/* 513 */     return true;
/*     */   }
/*     */ 
/*     */   public Object clone()
/*     */   {
/*     */     try
/*     */     {
/* 531 */       return super.clone(); } catch (CloneNotSupportedException e) {
/*     */     }
/* 533 */     throw new RuntimeException(e.getMessage());
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     javax.servlet.http.Cookie
 * JD-Core Version:    0.6.0
 */