/*     */ package javax.servlet;
/*     */ 
/*     */ import java.io.BufferedReader;
/*     */ import java.io.IOException;
/*     */ import java.io.UnsupportedEncodingException;
/*     */ import java.util.Enumeration;
/*     */ import java.util.Locale;
/*     */ import java.util.Map;
/*     */ 
/*     */ public class ServletRequestWrapper
/*     */   implements ServletRequest
/*     */ {
/*     */   private ServletRequest request;
/*     */ 
/*     */   public ServletRequestWrapper(ServletRequest request)
/*     */   {
/*  50 */     if (request == null) {
/*  51 */       throw new IllegalArgumentException("Request cannot be null");
/*     */     }
/*  53 */     this.request = request;
/*     */   }
/*     */ 
/*     */   public ServletRequest getRequest()
/*     */   {
/*  60 */     return this.request;
/*     */   }
/*     */ 
/*     */   public void setRequest(ServletRequest request)
/*     */   {
/*  69 */     if (request == null) {
/*  70 */       throw new IllegalArgumentException("Request cannot be null");
/*     */     }
/*  72 */     this.request = request;
/*     */   }
/*     */ 
/*     */   public Object getAttribute(String name)
/*     */   {
/*  82 */     return this.request.getAttribute(name);
/*     */   }
/*     */ 
/*     */   public Enumeration getAttributeNames()
/*     */   {
/*  93 */     return this.request.getAttributeNames();
/*     */   }
/*     */ 
/*     */   public String getCharacterEncoding()
/*     */   {
/* 104 */     return this.request.getCharacterEncoding();
/*     */   }
/*     */ 
/*     */   public void setCharacterEncoding(String enc)
/*     */     throws UnsupportedEncodingException
/*     */   {
/* 113 */     this.request.setCharacterEncoding(enc);
/*     */   }
/*     */ 
/*     */   public int getContentLength()
/*     */   {
/* 123 */     return this.request.getContentLength();
/*     */   }
/*     */ 
/*     */   public String getContentType()
/*     */   {
/* 134 */     return this.request.getContentType();
/*     */   }
/*     */ 
/*     */   public ServletInputStream getInputStream()
/*     */     throws IOException
/*     */   {
/* 146 */     return this.request.getInputStream();
/*     */   }
/*     */ 
/*     */   public String getParameter(String name)
/*     */   {
/* 158 */     return this.request.getParameter(name);
/*     */   }
/*     */ 
/*     */   public Map getParameterMap()
/*     */   {
/* 166 */     return this.request.getParameterMap();
/*     */   }
/*     */ 
/*     */   public Enumeration getParameterNames()
/*     */   {
/* 178 */     return this.request.getParameterNames();
/*     */   }
/*     */ 
/*     */   public String[] getParameterValues(String name)
/*     */   {
/* 189 */     return this.request.getParameterValues(name);
/*     */   }
/*     */ 
/*     */   public String getProtocol()
/*     */   {
/* 201 */     return this.request.getProtocol();
/*     */   }
/*     */ 
/*     */   public String getScheme()
/*     */   {
/* 214 */     return this.request.getScheme();
/*     */   }
/*     */ 
/*     */   public String getServerName()
/*     */   {
/* 225 */     return this.request.getServerName();
/*     */   }
/*     */ 
/*     */   public int getServerPort()
/*     */   {
/* 237 */     return this.request.getServerPort();
/*     */   }
/*     */ 
/*     */   public BufferedReader getReader()
/*     */     throws IOException
/*     */   {
/* 248 */     return this.request.getReader();
/*     */   }
/*     */ 
/*     */   public String getRemoteAddr()
/*     */   {
/* 260 */     return this.request.getRemoteAddr();
/*     */   }
/*     */ 
/*     */   public String getRemoteHost()
/*     */   {
/* 272 */     return this.request.getRemoteHost();
/*     */   }
/*     */ 
/*     */   public void setAttribute(String name, Object o)
/*     */   {
/* 284 */     this.request.setAttribute(name, o);
/*     */   }
/*     */ 
/*     */   public void removeAttribute(String name)
/*     */   {
/* 295 */     this.request.removeAttribute(name);
/*     */   }
/*     */ 
/*     */   public Locale getLocale()
/*     */   {
/* 307 */     return this.request.getLocale();
/*     */   }
/*     */ 
/*     */   public Enumeration getLocales()
/*     */   {
/* 319 */     return this.request.getLocales();
/*     */   }
/*     */ 
/*     */   public boolean isSecure()
/*     */   {
/* 331 */     return this.request.isSecure();
/*     */   }
/*     */ 
/*     */   public RequestDispatcher getRequestDispatcher(String path)
/*     */   {
/* 343 */     return this.request.getRequestDispatcher(path);
/*     */   }
/*     */ 
/*     */   public String getRealPath(String path)
/*     */   {
/* 355 */     return this.request.getRealPath(path);
/*     */   }
/*     */ 
/*     */   public int getRemotePort()
/*     */   {
/* 365 */     return this.request.getRemotePort();
/*     */   }
/*     */ 
/*     */   public String getLocalName()
/*     */   {
/* 376 */     return this.request.getLocalName();
/*     */   }
/*     */ 
/*     */   public String getLocalAddr()
/*     */   {
/* 386 */     return this.request.getLocalAddr();
/*     */   }
/*     */ 
/*     */   public int getLocalPort()
/*     */   {
/* 397 */     return this.request.getLocalPort();
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     javax.servlet.ServletRequestWrapper
 * JD-Core Version:    0.6.0
 */