/*     */ package javax.servlet;
/*     */ 
/*     */ import java.io.CharConversionException;
/*     */ import java.io.IOException;
/*     */ import java.io.OutputStream;
/*     */ import java.text.MessageFormat;
/*     */ import java.util.ResourceBundle;
/*     */ 
/*     */ public abstract class ServletOutputStream extends OutputStream
/*     */ {
/*     */   private static final String LSTRING_FILE = "javax.servlet.LocalStrings";
/*  46 */   private static ResourceBundle lStrings = ResourceBundle.getBundle("javax.servlet.LocalStrings");
/*     */ 
/*     */   public void print(String s)
/*     */     throws IOException
/*     */   {
/*  73 */     if (s == null) s = "null";
/*  74 */     int len = s.length();
/*  75 */     for (int i = 0; i < len; i++) {
/*  76 */       char c = s.charAt(i);
/*     */ 
/*  84 */       if ((c & 0xFF00) != 0) {
/*  85 */         String errMsg = lStrings.getString("err.not_iso8859_1");
/*  86 */         Object[] errArgs = new Object[1];
/*  87 */         errArgs[0] = new Character(c);
/*  88 */         errMsg = MessageFormat.format(errMsg, errArgs);
/*  89 */         throw new CharConversionException(errMsg);
/*     */       }
/*  91 */       write(c);
/*     */     }
/*     */   }
/*     */ 
/*     */   public void print(boolean b)
/*     */     throws IOException
/*     */   {
/*     */     String msg;
/*     */     String msg;
/* 111 */     if (b)
/* 112 */       msg = lStrings.getString("value.true");
/*     */     else {
/* 114 */       msg = lStrings.getString("value.false");
/*     */     }
/* 116 */     print(msg);
/*     */   }
/*     */ 
/*     */   public void print(char c)
/*     */     throws IOException
/*     */   {
/* 133 */     print(String.valueOf(c));
/*     */   }
/*     */ 
/*     */   public void print(int i)
/*     */     throws IOException
/*     */   {
/* 152 */     print(String.valueOf(i));
/*     */   }
/*     */ 
/*     */   public void print(long l)
/*     */     throws IOException
/*     */   {
/* 172 */     print(String.valueOf(l));
/*     */   }
/*     */ 
/*     */   public void print(float f)
/*     */     throws IOException
/*     */   {
/* 191 */     print(String.valueOf(f));
/*     */   }
/*     */ 
/*     */   public void print(double d)
/*     */     throws IOException
/*     */   {
/* 209 */     print(String.valueOf(d));
/*     */   }
/*     */ 
/*     */   public void println()
/*     */     throws IOException
/*     */   {
/* 225 */     print("\r\n");
/*     */   }
/*     */ 
/*     */   public void println(String s)
/*     */     throws IOException
/*     */   {
/* 242 */     print(s);
/* 243 */     println();
/*     */   }
/*     */ 
/*     */   public void println(boolean b)
/*     */     throws IOException
/*     */   {
/* 264 */     print(b);
/* 265 */     println();
/*     */   }
/*     */ 
/*     */   public void println(char c)
/*     */     throws IOException
/*     */   {
/* 282 */     print(c);
/* 283 */     println();
/*     */   }
/*     */ 
/*     */   public void println(int i)
/*     */     throws IOException
/*     */   {
/* 301 */     print(i);
/* 302 */     println();
/*     */   }
/*     */ 
/*     */   public void println(long l)
/*     */     throws IOException
/*     */   {
/* 320 */     print(l);
/* 321 */     println();
/*     */   }
/*     */ 
/*     */   public void println(float f)
/*     */     throws IOException
/*     */   {
/* 341 */     print(f);
/* 342 */     println();
/*     */   }
/*     */ 
/*     */   public void println(double d)
/*     */     throws IOException
/*     */   {
/* 361 */     print(d);
/* 362 */     println();
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     javax.servlet.ServletOutputStream
 * JD-Core Version:    0.6.0
 */