package javax.servlet;

import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Enumeration;
import java.util.Set;

public abstract interface ServletContext
{
  public abstract ServletContext getContext(String paramString);

  public abstract String getContextPath();

  public abstract int getMajorVersion();

  public abstract int getMinorVersion();

  public abstract String getMimeType(String paramString);

  public abstract Set getResourcePaths(String paramString);

  public abstract URL getResource(String paramString)
    throws MalformedURLException;

  public abstract InputStream getResourceAsStream(String paramString);

  public abstract RequestDispatcher getRequestDispatcher(String paramString);

  public abstract RequestDispatcher getNamedDispatcher(String paramString);

  /** @deprecated */
  public abstract Servlet getServlet(String paramString)
    throws ServletException;

  /** @deprecated */
  public abstract Enumeration getServlets();

  /** @deprecated */
  public abstract Enumeration getServletNames();

  public abstract void log(String paramString);

  /** @deprecated */
  public abstract void log(Exception paramException, String paramString);

  public abstract void log(String paramString, Throwable paramThrowable);

  public abstract String getRealPath(String paramString);

  public abstract String getServerInfo();

  public abstract String getInitParameter(String paramString);

  public abstract Enumeration getInitParameterNames();

  public abstract Object getAttribute(String paramString);

  public abstract Enumeration getAttributeNames();

  public abstract void setAttribute(String paramString, Object paramObject);

  public abstract void removeAttribute(String paramString);

  public abstract String getServletContextName();
}

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     javax.servlet.ServletContext
 * JD-Core Version:    0.6.0
 */