/*     */ package javax.servlet;
/*     */ 
/*     */ import java.io.IOException;
/*     */ import java.io.Serializable;
/*     */ import java.util.Enumeration;
/*     */ 
/*     */ public abstract class GenericServlet
/*     */   implements Servlet, ServletConfig, Serializable
/*     */ {
/*     */   private transient ServletConfig config;
/*     */ 
/*     */   public void destroy()
/*     */   {
/*     */   }
/*     */ 
/*     */   public String getInitParameter(String name)
/*     */   {
/* 100 */     return getServletConfig().getInitParameter(name);
/*     */   }
/*     */ 
/*     */   public Enumeration getInitParameterNames()
/*     */   {
/* 123 */     return getServletConfig().getInitParameterNames();
/*     */   }
/*     */ 
/*     */   public ServletConfig getServletConfig()
/*     */   {
/* 139 */     return this.config;
/*     */   }
/*     */ 
/*     */   public ServletContext getServletContext()
/*     */   {
/* 160 */     return getServletConfig().getServletContext();
/*     */   }
/*     */ 
/*     */   public String getServletInfo()
/*     */   {
/* 181 */     return "";
/*     */   }
/*     */ 
/*     */   public void init(ServletConfig config)
/*     */     throws ServletException
/*     */   {
/* 211 */     this.config = config;
/* 212 */     init();
/*     */   }
/*     */ 
/*     */   public void init()
/*     */     throws ServletException
/*     */   {
/*     */   }
/*     */ 
/*     */   public void log(String msg)
/*     */   {
/* 254 */     getServletContext().log(getServletName() + ": " + msg);
/*     */   }
/*     */ 
/*     */   public void log(String message, Throwable t)
/*     */   {
/* 277 */     getServletContext().log(getServletName() + ": " + message, t);
/*     */   }
/*     */ 
/*     */   public abstract void service(ServletRequest paramServletRequest, ServletResponse paramServletResponse)
/*     */     throws ServletException, IOException;
/*     */ 
/*     */   public String getServletName()
/*     */   {
/* 322 */     return this.config.getServletName();
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     javax.servlet.GenericServlet
 * JD-Core Version:    0.6.0
 */