/*     */ package javax.security.jacc;
/*     */ 
/*     */ import java.io.IOException;
/*     */ import java.io.ObjectInputStream;
/*     */ import java.io.ObjectInputStream.GetField;
/*     */ import java.io.ObjectOutputStream;
/*     */ import java.io.ObjectOutputStream.PutField;
/*     */ import java.io.ObjectStreamField;
/*     */ import java.io.Serializable;
/*     */ import java.security.Permission;
/*     */ import java.util.TreeSet;
/*     */ import javax.servlet.http.HttpServletRequest;
/*     */ import org.jboss.util.id.SerialVersion;
/*     */ 
/*     */ public final class WebUserDataPermission extends Permission
/*     */   implements Serializable
/*     */ {
/*     */   private static final long serialVersionUID;
/*     */   private static final ObjectStreamField[] serialPersistentFields;
/*     */   private transient URLPatternSpec urlSpec;
/*     */   private transient String httpMethodsString;
/*     */   private transient String transportType;
/*     */   private transient TreeSet httpMethods;
/*     */   private transient TreeSet httpExceptionList;
/*     */   private transient String httpExceptionString;
/*     */ 
/*     */   public WebUserDataPermission(HttpServletRequest request)
/*     */   {
/*  90 */     this(WebResourcePermission.requestURI(request), requestActions(request));
/*     */   }
/*     */ 
/*     */   public WebUserDataPermission(String name, String actions)
/*     */   {
/* 168 */     super(name == null ? "/" : name);
/* 169 */     if (name == null)
/* 170 */       name = "/";
/* 171 */     this.urlSpec = new URLPatternSpec(name);
/* 172 */     parseActions(actions);
/*     */   }
/*     */ 
/*     */   public WebUserDataPermission(String urlPatternSpec, String[] httpMethods, String transportType)
/*     */   {
/* 196 */     super(urlPatternSpec);
/* 197 */     this.urlSpec = new URLPatternSpec(urlPatternSpec);
/* 198 */     Object[] methodInfo = WebResourcePermission.canonicalMethods(httpMethods);
/* 199 */     this.httpMethods = ((TreeSet)methodInfo[0]);
/* 200 */     this.httpMethodsString = ((String)methodInfo[1]);
/* 201 */     if ((transportType != null) && (transportType.equalsIgnoreCase("NONE")))
/* 202 */       transportType = null;
/* 203 */     this.transportType = transportType;
/*     */   }
/*     */ 
/*     */   public boolean equals(Object p)
/*     */   {
/* 221 */     if ((p == null) || (!(p instanceof WebUserDataPermission)))
/* 222 */       return false;
/* 223 */     WebUserDataPermission perm = (WebUserDataPermission)p;
/*     */ 
/* 228 */     return (implies(perm)) && (perm.implies(this));
/*     */   }
/*     */ 
/*     */   public String getActions()
/*     */   {
/* 266 */     String actions = null;
/* 267 */     if (this.httpMethodsString != null)
/*     */     {
/* 269 */       if (this.transportType != null)
/* 270 */         actions = this.httpMethodsString + ":" + this.transportType;
/*     */       else
/* 272 */         actions = this.httpMethodsString;
/*     */     }
/* 274 */     else if (this.transportType != null)
/*     */     {
/* 276 */       actions = ":" + this.transportType;
/*     */     }
/* 278 */     return actions;
/*     */   }
/*     */ 
/*     */   public int hashCode()
/*     */   {
/* 296 */     int hashCode = this.urlSpec.hash();
/* 297 */     if (this.httpMethods != null)
/* 298 */       hashCode += this.httpMethods.hashCode();
/* 299 */     return hashCode;
/*     */   }
/*     */ 
/*     */   public boolean implies(Permission p)
/*     */   {
/* 344 */     if ((p == null) || (!(p instanceof WebUserDataPermission)))
/* 345 */       return false;
/* 346 */     WebUserDataPermission perm = (WebUserDataPermission)p;
/*     */ 
/* 348 */     boolean implies = this.urlSpec.implies(perm.urlSpec);
/* 349 */     if (implies == true)
/*     */     {
/* 351 */       if (this.httpExceptionList != null) {
/* 352 */         implies = WebResourcePermission.matchExceptionList(this.httpExceptionList, perm.httpExceptionList);
/*     */       }
/*     */ 
/* 355 */       if ((this.httpMethods != null) && (perm.httpMethods != null)) {
/* 356 */         implies = this.httpMethods.containsAll(perm.httpMethods);
/*     */       }
/* 358 */       if ((implies == true) && (this.transportType != null)) {
/* 359 */         implies = this.transportType.equals(perm.transportType);
/*     */       }
/*     */     }
/* 362 */     return implies;
/*     */   }
/*     */ 
/*     */   private static String requestActions(HttpServletRequest request)
/*     */   {
/* 375 */     String actions = request.getMethod() + (request.isSecure() ? ":CONFIDENTIAL" : "");
/*     */ 
/* 377 */     return actions;
/*     */   }
/*     */ 
/*     */   private void parseActions(String actions)
/*     */   {
/* 383 */     if (actions != null)
/*     */     {
/* 385 */       int colon = actions.indexOf(':');
/* 386 */       if (colon >= 0)
/*     */       {
/* 388 */         this.transportType = actions.substring(colon + 1);
/* 389 */         if (this.transportType.equalsIgnoreCase("NONE"))
/* 390 */           this.transportType = null;
/* 391 */         actions = actions.substring(0, colon);
/*     */       }
/*     */     }
/* 394 */     boolean exceptionListNeeded = (actions != null) && (actions.startsWith("!"));
/*     */ 
/* 396 */     Object[] methodInfo = WebResourcePermission.canonicalMethods(actions);
/* 397 */     if (exceptionListNeeded)
/*     */     {
/* 399 */       this.httpExceptionList = ((TreeSet)methodInfo[0]);
/* 400 */       this.httpExceptionString = ((String)methodInfo[1]);
/*     */     }
/*     */     else
/*     */     {
/* 404 */       this.httpMethods = ((TreeSet)methodInfo[0]);
/* 405 */       this.httpMethodsString = ((String)methodInfo[1]);
/*     */     }
/*     */   }
/*     */ 
/*     */   private void readObject(ObjectInputStream ois)
/*     */     throws ClassNotFoundException, IOException
/*     */   {
/* 412 */     ObjectInputStream.GetField fields = ois.readFields();
/* 413 */     String actions = (String)fields.get("actions", null);
/* 414 */     parseActions(actions);
/*     */   }
/*     */ 
/*     */   private void writeObject(ObjectOutputStream oos)
/*     */     throws IOException
/*     */   {
/* 420 */     ObjectOutputStream.PutField fields = oos.putFields();
/* 421 */     fields.put("actions", getActions());
/* 422 */     oos.writeFields();
/*     */   }
/*     */ 
/*     */   static
/*     */   {
/*  56 */     if (SerialVersion.version == 0)
/*  57 */       serialVersionUID = 141000L;
/*     */     else {
/*  59 */       serialVersionUID = 1L;
/*     */     }
/*     */ 
/*  65 */     serialPersistentFields = new ObjectStreamField[] { new ObjectStreamField("actions", String.class) };
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     javax.security.jacc.WebUserDataPermission
 * JD-Core Version:    0.6.0
 */