/*     */ package javax.security.jacc;
/*     */ 
/*     */ import java.security.AccessController;
/*     */ import java.security.PrivilegedActionException;
/*     */ import java.security.PrivilegedExceptionAction;
/*     */ import java.security.ProtectionDomain;
/*     */ import java.security.SecurityPermission;
/*     */ 
/*     */ public abstract class PolicyConfigurationFactory
/*     */ {
/*     */   private static final String FACTORY_PROP = "javax.security.jacc.PolicyConfigurationFactory.provider";
/*     */   private static final String DEFAULT_FACTORY_NAME = "org.jboss.security.jacc.JBossPolicyConfigurationFactory";
/*     */   private static PolicyConfigurationFactory factory;
/*     */ 
/*     */   public static PolicyConfigurationFactory getPolicyConfigurationFactory()
/*     */     throws ClassNotFoundException, PolicyContextException
/*     */   {
/*  66 */     SecurityManager sm = System.getSecurityManager();
/*  67 */     if (sm != null) {
/*  68 */       sm.checkPermission(new SecurityPermission("setPolicy"));
/*     */     }
/*  70 */     if (factory == null)
/*     */     {
/*  72 */       String factoryName = null;
/*  73 */       Class clazz = null;
/*     */       try
/*     */       {
/*  76 */         LoadAction action = new LoadAction(null);
/*     */         try
/*     */         {
/*  79 */           clazz = (Class)AccessController.doPrivileged(action);
/*  80 */           factoryName = action.getName();
/*     */         }
/*     */         catch (PrivilegedActionException ex)
/*     */         {
/*  84 */           factoryName = action.getName();
/*  85 */           Exception e = ex.getException();
/*  86 */           if ((e instanceof ClassNotFoundException)) {
/*  87 */             throw ((ClassNotFoundException)e);
/*     */           }
/*  89 */           throw new PolicyContextException("Failure during load of class: " + action.getName(), e);
/*     */         }
/*  91 */         factory = (PolicyConfigurationFactory)clazz.newInstance();
/*     */       }
/*     */       catch (ClassNotFoundException e)
/*     */       {
/*  95 */         String msg = "Failed to find PolicyConfigurationFactory : " + factoryName;
/*  96 */         throw new ClassNotFoundException(msg, e);
/*     */       }
/*     */       catch (IllegalAccessException e)
/*     */       {
/* 100 */         String msg = "Unable to access class : " + factoryName;
/* 101 */         throw new PolicyContextException(msg, e);
/*     */       }
/*     */       catch (InstantiationException e)
/*     */       {
/* 105 */         String msg = "Failed to create instance of: " + factoryName;
/* 106 */         throw new PolicyContextException(msg, e);
/*     */       }
/*     */       catch (ClassCastException e)
/*     */       {
/* 110 */         StringBuffer msg = new StringBuffer(factoryName + " Is not a PolicyConfigurationFactory, ");
/* 111 */         msg.append("PCF.class.CL: " + PolicyConfigurationFactory.class.getClassLoader());
/* 112 */         msg.append("\nPCF.class.CS: " + PolicyConfigurationFactory.class.getProtectionDomain().getCodeSource());
/* 113 */         msg.append("\nPCF.class.hash: " + System.identityHashCode(PolicyConfigurationFactory.class));
/* 114 */         msg.append("\nclazz.CL: " + clazz.getClassLoader());
/* 115 */         msg.append("\nclazz.CS: " + clazz.getProtectionDomain().getCodeSource());
/* 116 */         msg.append("\nclazz.super.CL: " + clazz.getSuperclass().getClassLoader());
/* 117 */         msg.append("\nclazz.super.CS: " + clazz.getSuperclass().getProtectionDomain().getCodeSource());
/* 118 */         msg.append("\nclazz.super.hash: " + System.identityHashCode(clazz.getSuperclass()));
/* 119 */         ClassCastException cce = new ClassCastException(msg.toString());
/* 120 */         cce.initCause(e);
/* 121 */         throw cce;
/*     */       }
/*     */     }
/* 124 */     return factory;
/*     */   }
/*     */ 
/*     */   public abstract PolicyConfiguration getPolicyConfiguration(String paramString, boolean paramBoolean)
/*     */     throws PolicyContextException;
/*     */ 
/*     */   public abstract boolean inService(String paramString)
/*     */     throws PolicyContextException;
/*     */ 
/*     */   private static class LoadAction
/*     */     implements PrivilegedExceptionAction
/*     */   {
/*     */     private String name;
/*     */ 
/*     */     public String getName()
/*     */     {
/* 184 */       return this.name;
/*     */     }
/*     */ 
/*     */     public Object run() throws Exception
/*     */     {
/* 189 */       this.name = System.getProperty("javax.security.jacc.PolicyConfigurationFactory.provider");
/* 190 */       if (this.name == null)
/*     */       {
/* 193 */         this.name = "org.jboss.security.jacc.JBossPolicyConfigurationFactory";
/*     */       }
/* 195 */       ClassLoader loader = Thread.currentThread().getContextClassLoader();
/* 196 */       Class factoryClass = loader.loadClass(this.name);
/* 197 */       return factoryClass;
/*     */     }
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     javax.security.jacc.PolicyConfigurationFactory
 * JD-Core Version:    0.6.0
 */