/*     */ package javax.security.jacc;
/*     */ 
/*     */ import java.io.Serializable;
/*     */ import java.security.Permission;
/*     */ import org.jboss.util.id.SerialVersion;
/*     */ 
/*     */ public final class EJBRoleRefPermission extends Permission
/*     */   implements Serializable
/*     */ {
/*     */   private static final long serialVersionUID;
/*     */   private String actions;
/*     */   private transient int hashCode;
/*     */ 
/*     */   public EJBRoleRefPermission(String ejbName, String actions)
/*     */   {
/*  76 */     super(ejbName);
/*  77 */     this.actions = actions;
/*  78 */     this.hashCode = (ejbName.hashCode() + actions.hashCode());
/*     */   }
/*     */ 
/*     */   public boolean equals(Object p)
/*     */   {
/*  88 */     if (p == this)
/*  89 */       return true;
/*  90 */     if (!(p instanceof EJBRoleRefPermission)) {
/*  91 */       return false;
/*     */     }
/*  93 */     boolean equals = false;
/*  94 */     EJBRoleRefPermission errp = (EJBRoleRefPermission)p;
/*  95 */     String pname = errp.getName();
/*  96 */     if (getName().equals(pname))
/*     */     {
/*  98 */       String pactions = errp.getActions();
/*  99 */       if (getActions().equals(pactions))
/* 100 */         equals = true;
/*     */     }
/* 102 */     return equals;
/*     */   }
/*     */ 
/*     */   public String getActions()
/*     */   {
/* 107 */     return this.actions;
/*     */   }
/*     */ 
/*     */   public int hashCode()
/*     */   {
/* 112 */     return this.hashCode;
/*     */   }
/*     */ 
/*     */   public boolean implies(Permission p)
/*     */   {
/* 131 */     return equals(p);
/*     */   }
/*     */ 
/*     */   public String toString()
/*     */   {
/* 139 */     return "[" + getName() + ",role-ref=" + this.actions + "]";
/*     */   }
/*     */ 
/*     */   static
/*     */   {
/*  55 */     if (SerialVersion.version == 0)
/*  56 */       serialVersionUID = 141000L;
/*     */     else
/*  58 */       serialVersionUID = 1L;
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     javax.security.jacc.EJBRoleRefPermission
 * JD-Core Version:    0.6.0
 */