/*     */ package javax.security.jacc;
/*     */ 
/*     */ import java.io.IOException;
/*     */ import java.io.ObjectInputStream;
/*     */ import java.io.ObjectInputStream.GetField;
/*     */ import java.io.ObjectOutputStream;
/*     */ import java.io.ObjectOutputStream.PutField;
/*     */ import java.io.ObjectStreamField;
/*     */ import java.io.Serializable;
/*     */ import java.lang.reflect.Method;
/*     */ import java.security.Permission;
/*     */ import java.util.ArrayList;
/*     */ import java.util.StringTokenizer;
/*     */ import org.jboss.util.id.SerialVersion;
/*     */ 
/*     */ public final class EJBMethodPermission extends Permission
/*     */   implements Serializable
/*     */ {
/*     */   private static final long serialVersionUID;
/*     */   private static final ObjectStreamField[] serialPersistentFields;
/*     */   private transient String methodName;
/*     */   private transient String methodInterface;
/*     */   private transient String methodSig;
/*     */ 
/*     */   public EJBMethodPermission(String name, String actions)
/*     */   {
/* 138 */     super(name);
/* 139 */     parseMethodSpec(actions);
/*     */   }
/*     */ 
/*     */   public EJBMethodPermission(String ejbName, String methodInterface, Method method)
/*     */   {
/* 160 */     this(ejbName, method.getName(), methodInterface, convertParameters(method.getParameterTypes()));
/*     */   }
/*     */ 
/*     */   public EJBMethodPermission(String ejbName, String methodName, String methodInterface, String[] methodParams)
/*     */   {
/* 191 */     super(ejbName);
/* 192 */     this.methodInterface = methodInterface;
/* 193 */     this.methodName = methodName;
/* 194 */     if (methodParams == null) {
/* 195 */       this.methodSig = null;
/*     */     }
/*     */     else {
/* 198 */       StringBuffer tmp = new StringBuffer();
/* 199 */       for (int n = 0; n < methodParams.length; n++)
/*     */       {
/* 201 */         tmp.append(methodParams[n]);
/* 202 */         tmp.append(',');
/*     */       }
/* 204 */       if (tmp.length() > 0)
/* 205 */         tmp.setLength(tmp.length() - 1);
/* 206 */       this.methodSig = tmp.toString();
/*     */     }
/*     */   }
/*     */ 
/*     */   public boolean equals(Object p)
/*     */   {
/* 217 */     boolean equals = false;
/* 218 */     if ((p == null) || (!(p instanceof EJBMethodPermission)))
/* 219 */       return false;
/* 220 */     EJBMethodPermission perm = (EJBMethodPermission)p;
/* 221 */     equals = getName().equals(perm.getName());
/* 222 */     if (equals == true)
/*     */     {
/* 225 */       if (this.methodName != null)
/*     */       {
/* 227 */         if (perm.methodName == null)
/* 228 */           return false;
/* 229 */         if (!this.methodName.equals(perm.methodName))
/* 230 */           return false;
/*     */       }
/* 232 */       else if (perm.methodName != null)
/*     */       {
/* 234 */         return false;
/*     */       }
/*     */ 
/* 238 */       equals = this.methodInterface != perm.methodInterface;
/* 239 */       if ((!equals) && (this.methodInterface != null))
/* 240 */         equals = this.methodInterface.equals(perm.methodInterface);
/* 241 */       if (!equals) {
/* 242 */         return false;
/*     */       }
/*     */ 
/* 245 */       if (this.methodSig != null)
/*     */       {
/* 247 */         equals = (perm.methodSig != null) && (this.methodSig.equals(perm.methodSig));
/*     */       }
/*     */       else
/*     */       {
/* 252 */         equals = perm.methodSig == null;
/*     */       }
/*     */     }
/* 255 */     return equals;
/*     */   }
/*     */ 
/*     */   public int hashCode()
/*     */   {
/* 264 */     int hashCode = 0;
/* 265 */     if (this.methodName != null)
/* 266 */       hashCode += this.methodName.hashCode();
/* 267 */     if (this.methodInterface != null)
/* 268 */       hashCode += this.methodInterface.hashCode();
/* 269 */     if (this.methodSig != null)
/* 270 */       hashCode += this.methodSig.hashCode();
/* 271 */     return hashCode;
/*     */   }
/*     */ 
/*     */   public String getActions()
/*     */   {
/* 308 */     StringBuffer actions = new StringBuffer();
/* 309 */     if (this.methodName != null)
/* 310 */       actions.append(this.methodName);
/* 311 */     if (this.methodInterface != null)
/*     */     {
/* 313 */       actions.append(',');
/* 314 */       actions.append(this.methodInterface);
/*     */     }
/* 316 */     else if (this.methodSig != null)
/*     */     {
/* 318 */       actions.append(',');
/*     */     }
/*     */ 
/* 321 */     if (this.methodSig != null)
/*     */     {
/* 323 */       actions.append(',');
/* 324 */       actions.append(this.methodSig);
/*     */     }
/* 326 */     String methodSpec = null;
/* 327 */     if (actions.length() > 0)
/* 328 */       methodSpec = actions.toString();
/* 329 */     return methodSpec;
/*     */   }
/*     */ 
/*     */   public boolean implies(Permission p)
/*     */   {
/* 358 */     boolean implies = false;
/* 359 */     if ((p == null) || (!(p instanceof EJBMethodPermission)))
/* 360 */       return false;
/* 361 */     EJBMethodPermission perm = (EJBMethodPermission)p;
/* 362 */     implies = getName().equals(perm.getName());
/* 363 */     if (!implies) {
/* 364 */       return false;
/*     */     }
/*     */ 
/* 367 */     if (this.methodName != null)
/*     */     {
/* 369 */       implies = this.methodName.equals(perm.methodName);
/*     */     }
/*     */     else {
/* 372 */       implies = true;
/*     */     }
/*     */ 
/* 375 */     if ((implies == true) && (this.methodInterface != null))
/*     */     {
/* 377 */       implies = this.methodInterface.equals(perm.methodInterface);
/*     */     }
/*     */ 
/* 380 */     if ((implies == true) && (this.methodSig != null))
/*     */     {
/* 382 */       implies = this.methodSig.equals(perm.methodSig);
/*     */     }
/*     */ 
/* 385 */     return implies;
/*     */   }
/*     */ 
/*     */   public String toString()
/*     */   {
/* 393 */     StringBuffer tmp = new StringBuffer(super.toString());
/* 394 */     tmp.append('[');
/* 395 */     if (this.methodInterface != null)
/*     */     {
/* 397 */       tmp.append(this.methodInterface);
/* 398 */       tmp.append(':');
/*     */     }
/*     */     else
/*     */     {
/* 402 */       tmp.append("*:");
/*     */     }
/* 404 */     if (this.methodName != null)
/*     */     {
/* 406 */       tmp.append(this.methodName);
/*     */     }
/*     */     else
/*     */     {
/* 410 */       tmp.append("*");
/*     */     }
/* 412 */     tmp.append('(');
/* 413 */     if (this.methodSig != null)
/*     */     {
/* 415 */       tmp.append(this.methodSig);
/*     */     }
/* 417 */     tmp.append(")]");
/* 418 */     return tmp.toString();
/*     */   }
/*     */ 
/*     */   private static String[] convertParameters(Class[] params)
/*     */   {
/* 423 */     ArrayList tmp = new ArrayList();
/* 424 */     for (int p = 0; p < params.length; p++)
/*     */     {
/* 426 */       Class c = params[p];
/* 427 */       if (c.isArray())
/*     */       {
/* 429 */         StringBuffer sb = new StringBuffer();
/* 430 */         Class subType = c.getComponentType();
/* 431 */         sb.append(subType.getName());
/*     */ 
/* 433 */         while (subType != null)
/*     */         {
/* 435 */           sb.append("[]");
/* 436 */           subType = subType.getComponentType();
/*     */         }
/* 438 */         tmp.add(sb.toString());
/*     */       }
/*     */       else
/*     */       {
/* 442 */         tmp.add(c.getName());
/*     */       }
/*     */     }
/* 445 */     String[] sig = new String[tmp.size()];
/* 446 */     tmp.toArray(sig);
/* 447 */     return sig;
/*     */   }
/*     */ 
/*     */   private void parseMethodSpec(String methodSpec)
/*     */   {
/* 475 */     this.methodName = null;
/* 476 */     this.methodInterface = null;
/* 477 */     this.methodSig = null;
/*     */ 
/* 479 */     if (methodSpec != null)
/*     */     {
/* 481 */       StringTokenizer tokenizer = new StringTokenizer(methodSpec, ",", true);
/*     */ 
/* 483 */       if (tokenizer.hasMoreTokens())
/*     */       {
/* 485 */         this.methodName = tokenizer.nextToken();
/* 486 */         if (this.methodName.equals(",")) {
/* 487 */           this.methodName = null;
/*     */         }
/*     */       }
/* 490 */       if (tokenizer.hasMoreTokens())
/*     */       {
/* 492 */         this.methodInterface = tokenizer.nextToken();
/* 493 */         if ((this.methodName != null) && (this.methodInterface.equals(",")))
/* 494 */           this.methodInterface = tokenizer.nextToken();
/* 495 */         if (this.methodInterface.equals(","))
/*     */         {
/* 497 */           this.methodInterface = null;
/* 498 */           this.methodSig = "";
/*     */         }
/*     */       }
/*     */ 
/* 502 */       if (tokenizer.hasMoreTokens())
/*     */       {
/* 504 */         if (this.methodInterface != null)
/* 505 */           tokenizer.nextToken();
/* 506 */         StringBuffer tmp = new StringBuffer();
/* 507 */         while (tokenizer.hasMoreTokens())
/*     */         {
/* 509 */           tmp.append(tokenizer.nextToken());
/*     */         }
/* 511 */         this.methodSig = tmp.toString();
/*     */       }
/*     */     }
/*     */   }
/*     */ 
/*     */   private void readObject(ObjectInputStream ois)
/*     */     throws ClassNotFoundException, IOException
/*     */   {
/* 520 */     ObjectInputStream.GetField fields = ois.readFields();
/* 521 */     String actions = (String)fields.get("actions", null);
/* 522 */     parseMethodSpec(actions);
/*     */   }
/*     */ 
/*     */   private void writeObject(ObjectOutputStream oos)
/*     */     throws IOException
/*     */   {
/* 528 */     ObjectOutputStream.PutField fields = oos.putFields();
/* 529 */     fields.put("actions", getActions());
/* 530 */     oos.writeFields();
/*     */   }
/*     */ 
/*     */   static
/*     */   {
/*  60 */     if (SerialVersion.version == 0)
/*  61 */       serialVersionUID = 141000L;
/*     */     else {
/*  63 */       serialVersionUID = 1L;
/*     */     }
/*     */ 
/*  69 */     serialPersistentFields = new ObjectStreamField[] { new ObjectStreamField("actions", String.class) };
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     javax.security.jacc.EJBMethodPermission
 * JD-Core Version:    0.6.0
 */