/*     */ package javax.security.auth.message.callback;
/*     */ 
/*     */ import java.math.BigInteger;
/*     */ import java.security.PrivateKey;
/*     */ import java.security.cert.Certificate;
/*     */ import javax.security.auth.callback.Callback;
/*     */ import javax.security.auth.x500.X500Principal;
/*     */ 
/*     */ public class PrivateKeyCallback
/*     */   implements Callback
/*     */ {
/* 152 */   private Request request = null;
/* 153 */   private Certificate[] chain = null;
/* 154 */   private PrivateKey key = null;
/*     */ 
/*     */   public PrivateKeyCallback(Request request)
/*     */   {
/* 169 */     this.request = request;
/*     */   }
/*     */ 
/*     */   public Certificate[] getChain()
/*     */   {
/* 178 */     return this.chain;
/*     */   }
/*     */ 
/*     */   public PrivateKey getKey()
/*     */   {
/* 187 */     return this.key;
/*     */   }
/*     */ 
/*     */   public Request getRequest()
/*     */   {
/* 197 */     return this.request;
/*     */   }
/*     */ 
/*     */   public void setKey(PrivateKey key, Certificate[] chain)
/*     */   {
/* 210 */     this.key = key;
/* 211 */     this.chain = chain;
/*     */   }
/*     */ 
/*     */   public static class SubjectKeyIDRequest
/*     */   {
/*     */     private byte[] subjectKeyID;
/*     */ 
/*     */     public SubjectKeyIDRequest(byte[] keyID)
/*     */     {
/* 138 */       this.subjectKeyID = keyID;
/*     */     }
/*     */ 
/*     */     public byte[] getSubjectKeyID()
/*     */     {
/* 147 */       return this.subjectKeyID;
/*     */     }
/*     */   }
/*     */ 
/*     */   public static class IssuerSerialNumRequest
/*     */   {
/*     */     private X500Principal issuer;
/*     */     private BigInteger serialNumber;
/*     */ 
/*     */     public IssuerSerialNumRequest(X500Principal issuer, BigInteger serialNumber)
/*     */     {
/*  96 */       this.issuer = issuer;
/*  97 */       this.serialNumber = serialNumber;
/*     */     }
/*     */ 
/*     */     public X500Principal getIssuer()
/*     */     {
/* 106 */       return this.issuer;
/*     */     }
/*     */ 
/*     */     public BigInteger getSerialNumber()
/*     */     {
/* 115 */       return this.serialNumber;
/*     */     }
/*     */   }
/*     */ 
/*     */   public static class AliasRequest
/*     */     implements PrivateKeyCallback.Request
/*     */   {
/*  55 */     private String alias = null;
/*     */ 
/*     */     public AliasRequest(String alias)
/*     */     {
/*  67 */       this.alias = alias;
/*     */     }
/*     */ 
/*     */     public String getAlias()
/*     */     {
/*  76 */       return this.alias;
/*     */     }
/*     */   }
/*     */ 
/*     */   public static abstract interface Request
/*     */   {
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     javax.security.auth.message.callback.PrivateKeyCallback
 * JD-Core Version:    0.6.0
 */