/*     */ package javax.security.auth.message;
/*     */ 
/*     */ public class MessagePolicy
/*     */ {
/*  38 */   protected TargetPolicy[] targetPolicies = null;
/*     */   private boolean mandatory;
/*     */ 
/*     */   public MessagePolicy(TargetPolicy[] targetPolicies, boolean mandatory)
/*     */   {
/*  51 */     if (targetPolicies == null) {
/*  52 */       throw new IllegalArgumentException("specified targetPolicies is null");
/*     */     }
/*  54 */     this.targetPolicies = targetPolicies;
/*  55 */     this.mandatory = mandatory;
/*     */   }
/*     */ 
/*     */   public TargetPolicy[] getTargetPolicies()
/*     */   {
/*  72 */     if ((this.targetPolicies != null) && (this.targetPolicies.length == 0))
/*  73 */       throw new IllegalStateException("Target Policies should not be of zero length");
/*  74 */     return this.targetPolicies;
/*     */   }
/*     */ 
/*     */   public boolean isMandatory()
/*     */   {
/*  79 */     return this.mandatory;
/*     */   }
/*     */ 
/*     */   public static abstract interface ProtectionPolicy
/*     */   {
/*     */     public static final String AUTHENTICATE_SENDER = "http://jboss.org/security/auth/container/auth_sender";
/*     */     public static final String AUTHENTICATE_RECIPIENT = "http://jboss.org/security/auth/container/auth_recipient";
/*     */     public static final String AUTHENTICATE_CONTENT = "http://jboss.org/security/auth/container/auth_content";
/*     */ 
/*     */     public abstract String getID();
/*     */   }
/*     */ 
/*     */   public static class TargetPolicy
/*     */   {
/*     */     protected MessagePolicy.ProtectionPolicy protectionPolicy;
/*     */     protected MessagePolicy.Target[] targets;
/*     */ 
/*     */     public TargetPolicy(MessagePolicy.Target[] targets, MessagePolicy.ProtectionPolicy protectionPolicy)
/*     */     {
/* 133 */       this.targets = targets;
/* 134 */       this.protectionPolicy = protectionPolicy;
/*     */     }
/*     */ 
/*     */     public MessagePolicy.ProtectionPolicy getProtectionPolicy()
/*     */     {
/* 144 */       return this.protectionPolicy;
/*     */     }
/*     */ 
/*     */     public MessagePolicy.Target[] getTargets()
/*     */     {
/* 157 */       if ((this.targets != null) && (this.targets.length == 0))
/* 158 */         throw new IllegalStateException(" Targets cannot be of length zero");
/* 159 */       return this.targets;
/*     */     }
/*     */   }
/*     */ 
/*     */   public static abstract interface Target
/*     */   {
/*     */     public abstract Object get(MessageInfo paramMessageInfo);
/*     */ 
/*     */     public abstract void put(MessageInfo paramMessageInfo, Object paramObject);
/*     */ 
/*     */     public abstract void remove(MessageInfo paramMessageInfo);
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     javax.security.auth.message.MessagePolicy
 * JD-Core Version:    0.6.0
 */