/*     */ package javax.resource;
/*     */ 
/*     */ import org.jboss.util.id.SerialVersion;
/*     */ 
/*     */ public class ResourceException extends Exception
/*     */ {
/*     */   static final long serialVersionUID;
/*     */   private String errorCode;
/*     */   private Exception linkedException;
/*     */ 
/*     */   public ResourceException()
/*     */   {
/*     */   }
/*     */ 
/*     */   public ResourceException(String reason)
/*     */   {
/*  70 */     super(reason);
/*     */   }
/*     */ 
/*     */   public ResourceException(String reason, String errorCode)
/*     */   {
/*  81 */     super(reason);
/*  82 */     this.errorCode = errorCode;
/*     */   }
/*     */ 
/*     */   public ResourceException(String reason, Throwable throwable)
/*     */   {
/*  93 */     super(reason, throwable);
/*     */   }
/*     */ 
/*     */   public ResourceException(Throwable throwable)
/*     */   {
/* 103 */     super(throwable);
/*     */   }
/*     */ 
/*     */   public String getErrorCode()
/*     */   {
/* 113 */     return this.errorCode;
/*     */   }
/*     */ 
/*     */   public Exception getLinkedException()
/*     */   {
/* 123 */     return this.linkedException;
/*     */   }
/*     */ 
/*     */   public String getMessage()
/*     */   {
/* 133 */     String msg = super.getMessage();
/* 134 */     String ec = getErrorCode();
/* 135 */     if ((msg == null) && (ec == null))
/*     */     {
/* 137 */       return null;
/*     */     }
/* 139 */     if ((msg != null) && (ec != null))
/*     */     {
/* 141 */       return msg + ", error code: " + ec;
/*     */     }
/* 143 */     return "error code: " + ec;
/*     */   }
/*     */ 
/*     */   public void setErrorCode(String errorCode)
/*     */   {
/* 153 */     this.errorCode = errorCode;
/*     */   }
/*     */ 
/*     */   /** @deprecated */
/*     */   public void setLinkedException(Exception linkedException)
/*     */   {
/* 164 */     this.linkedException = linkedException;
/* 165 */     initCause(linkedException);
/*     */   }
/*     */ 
/*     */   static
/*     */   {
/*  43 */     if (SerialVersion.version == 0)
/*  44 */       serialVersionUID = 4770679801401540475L;
/*     */     else
/*  46 */       serialVersionUID = 547071213627824490L;
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     javax.resource.ResourceException
 * JD-Core Version:    0.6.0
 */