/*    */ package javax.jms;
/*    */ 
/*    */ public class TopicRequestor
/*    */ {
/* 36 */   private TopicSession topicSession = null;
/*    */ 
/* 38 */   private TopicPublisher requestPublisher = null;
/*    */ 
/* 40 */   private TemporaryTopic responseTopic = null;
/*    */ 
/* 42 */   private TopicSubscriber responseSubscriber = null;
/*    */ 
/*    */   public TopicRequestor(TopicSession session, Topic topic) throws JMSException
/*    */   {
/* 46 */     this.topicSession = session;
/* 47 */     this.requestPublisher = this.topicSession.createPublisher(topic);
/* 48 */     this.responseTopic = this.topicSession.createTemporaryTopic();
/* 49 */     this.responseSubscriber = this.topicSession.createSubscriber(this.responseTopic);
/*    */   }
/*    */ 
/*    */   public Message request(Message message) throws JMSException
/*    */   {
/* 54 */     message.setJMSReplyTo(this.responseTopic);
/* 55 */     this.requestPublisher.publish(message);
/* 56 */     return this.responseSubscriber.receive();
/*    */   }
/*    */ 
/*    */   public void close() throws JMSException
/*    */   {
/*    */     try
/*    */     {
/* 63 */       this.responseSubscriber.close();
/*    */     }
/*    */     catch (JMSException ignored)
/*    */     {
/*    */     }
/*    */     try
/*    */     {
/* 70 */       this.responseTopic.delete();
/*    */     }
/*    */     catch (JMSException ignored)
/*    */     {
/*    */     }
/* 75 */     this.topicSession.close();
/*    */   }
/*    */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     javax.jms.TopicRequestor
 * JD-Core Version:    0.6.0
 */