package javax.jms;

import java.io.Serializable;

public abstract interface Session extends Runnable
{
  public static final int AUTO_ACKNOWLEDGE = 1;
  public static final int CLIENT_ACKNOWLEDGE = 2;
  public static final int DUPS_OK_ACKNOWLEDGE = 3;
  public static final int SESSION_TRANSACTED = 0;

  public abstract BytesMessage createBytesMessage()
    throws JMSException;

  public abstract MapMessage createMapMessage()
    throws JMSException;

  public abstract Message createMessage()
    throws JMSException;

  public abstract ObjectMessage createObjectMessage()
    throws JMSException;

  public abstract ObjectMessage createObjectMessage(Serializable paramSerializable)
    throws JMSException;

  public abstract StreamMessage createStreamMessage()
    throws JMSException;

  public abstract TextMessage createTextMessage()
    throws JMSException;

  public abstract TextMessage createTextMessage(String paramString)
    throws JMSException;

  public abstract boolean getTransacted()
    throws JMSException;

  public abstract int getAcknowledgeMode()
    throws JMSException;

  public abstract void commit()
    throws JMSException;

  public abstract void rollback()
    throws JMSException;

  public abstract void close()
    throws JMSException;

  public abstract void recover()
    throws JMSException;

  public abstract MessageListener getMessageListener()
    throws JMSException;

  public abstract void setMessageListener(MessageListener paramMessageListener)
    throws JMSException;

  public abstract void run();

  public abstract MessageProducer createProducer(Destination paramDestination)
    throws JMSException;

  public abstract MessageConsumer createConsumer(Destination paramDestination)
    throws JMSException;

  public abstract MessageConsumer createConsumer(Destination paramDestination, String paramString)
    throws JMSException;

  public abstract MessageConsumer createConsumer(Destination paramDestination, String paramString, boolean paramBoolean)
    throws JMSException;

  public abstract Queue createQueue(String paramString)
    throws JMSException;

  public abstract Topic createTopic(String paramString)
    throws JMSException;

  public abstract TopicSubscriber createDurableSubscriber(Topic paramTopic, String paramString)
    throws JMSException;

  public abstract TopicSubscriber createDurableSubscriber(Topic paramTopic, String paramString1, String paramString2, boolean paramBoolean)
    throws JMSException;

  public abstract QueueBrowser createBrowser(Queue paramQueue)
    throws JMSException;

  public abstract QueueBrowser createBrowser(Queue paramQueue, String paramString)
    throws JMSException;

  public abstract TemporaryQueue createTemporaryQueue()
    throws JMSException;

  public abstract TemporaryTopic createTemporaryTopic()
    throws JMSException;

  public abstract void unsubscribe(String paramString)
    throws JMSException;
}

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     javax.jms.Session
 * JD-Core Version:    0.6.0
 */