package javax.jms;

import java.util.Enumeration;

public abstract interface Message
{
  public static final int DEFAULT_DELIVERY_MODE = 2;
  public static final int DEFAULT_PRIORITY = 4;
  public static final long DEFAULT_TIME_TO_LIVE = 0L;

  public abstract String getJMSMessageID()
    throws JMSException;

  public abstract void setJMSMessageID(String paramString)
    throws JMSException;

  public abstract long getJMSTimestamp()
    throws JMSException;

  public abstract void setJMSTimestamp(long paramLong)
    throws JMSException;

  public abstract byte[] getJMSCorrelationIDAsBytes()
    throws JMSException;

  public abstract void setJMSCorrelationIDAsBytes(byte[] paramArrayOfByte)
    throws JMSException;

  public abstract void setJMSCorrelationID(String paramString)
    throws JMSException;

  public abstract String getJMSCorrelationID()
    throws JMSException;

  public abstract Destination getJMSReplyTo()
    throws JMSException;

  public abstract void setJMSReplyTo(Destination paramDestination)
    throws JMSException;

  public abstract Destination getJMSDestination()
    throws JMSException;

  public abstract void setJMSDestination(Destination paramDestination)
    throws JMSException;

  public abstract int getJMSDeliveryMode()
    throws JMSException;

  public abstract void setJMSDeliveryMode(int paramInt)
    throws JMSException;

  public abstract boolean getJMSRedelivered()
    throws JMSException;

  public abstract void setJMSRedelivered(boolean paramBoolean)
    throws JMSException;

  public abstract String getJMSType()
    throws JMSException;

  public abstract void setJMSType(String paramString)
    throws JMSException;

  public abstract long getJMSExpiration()
    throws JMSException;

  public abstract void setJMSExpiration(long paramLong)
    throws JMSException;

  public abstract int getJMSPriority()
    throws JMSException;

  public abstract void setJMSPriority(int paramInt)
    throws JMSException;

  public abstract void clearProperties()
    throws JMSException;

  public abstract boolean propertyExists(String paramString)
    throws JMSException;

  public abstract boolean getBooleanProperty(String paramString)
    throws JMSException;

  public abstract byte getByteProperty(String paramString)
    throws JMSException;

  public abstract short getShortProperty(String paramString)
    throws JMSException;

  public abstract int getIntProperty(String paramString)
    throws JMSException;

  public abstract long getLongProperty(String paramString)
    throws JMSException;

  public abstract float getFloatProperty(String paramString)
    throws JMSException;

  public abstract double getDoubleProperty(String paramString)
    throws JMSException;

  public abstract String getStringProperty(String paramString)
    throws JMSException;

  public abstract Object getObjectProperty(String paramString)
    throws JMSException;

  public abstract Enumeration getPropertyNames()
    throws JMSException;

  public abstract void setBooleanProperty(String paramString, boolean paramBoolean)
    throws JMSException;

  public abstract void setByteProperty(String paramString, byte paramByte)
    throws JMSException;

  public abstract void setShortProperty(String paramString, short paramShort)
    throws JMSException;

  public abstract void setIntProperty(String paramString, int paramInt)
    throws JMSException;

  public abstract void setLongProperty(String paramString, long paramLong)
    throws JMSException;

  public abstract void setFloatProperty(String paramString, float paramFloat)
    throws JMSException;

  public abstract void setDoubleProperty(String paramString, double paramDouble)
    throws JMSException;

  public abstract void setStringProperty(String paramString1, String paramString2)
    throws JMSException;

  public abstract void setObjectProperty(String paramString, Object paramObject)
    throws JMSException;

  public abstract void acknowledge()
    throws JMSException;

  public abstract void clearBody()
    throws JMSException;
}

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     javax.jms.Message
 * JD-Core Version:    0.6.0
 */