/*     */ package javax.enterprise.deploy.spi.status;
/*     */ 
/*     */ import java.io.IOException;
/*     */ import java.io.ObjectInputStream;
/*     */ import java.io.ObjectInputStream.GetField;
/*     */ import java.io.ObjectOutputStream;
/*     */ import java.io.ObjectOutputStream.PutField;
/*     */ import java.io.ObjectStreamField;
/*     */ import java.util.EventObject;
/*     */ import javax.enterprise.deploy.spi.TargetModuleID;
/*     */ import org.jboss.util.id.SerialVersion;
/*     */ 
/*     */ public class ProgressEvent extends EventObject
/*     */ {
/*     */   static final long serialVersionUID;
/*     */   private static final ObjectStreamField[] serialPersistentFields;
/*     */   private static final int STATUS_IDX = 0;
/*     */   private static final int MODULE_ID_IDX = 1;
/*     */   private DeploymentStatus status;
/*     */   private TargetModuleID moduleID;
/*     */ 
/*     */   public ProgressEvent(Object source, TargetModuleID moduleID, DeploymentStatus status)
/*     */   {
/*  95 */     super(source);
/*  96 */     this.status = status;
/*  97 */     this.moduleID = moduleID;
/*     */   }
/*     */ 
/*     */   public TargetModuleID getTargetModuleID()
/*     */   {
/* 109 */     return this.moduleID;
/*     */   }
/*     */ 
/*     */   public DeploymentStatus getDeploymentStatus()
/*     */   {
/* 119 */     return this.status;
/*     */   }
/*     */ 
/*     */   private void readObject(ObjectInputStream ois)
/*     */     throws ClassNotFoundException, IOException
/*     */   {
/* 130 */     ObjectInputStream.GetField fields = ois.readFields();
/* 131 */     String name = serialPersistentFields[0].getName();
/* 132 */     this.status = ((DeploymentStatus)fields.get(name, null));
/* 133 */     name = serialPersistentFields[1].getName();
/* 134 */     this.moduleID = ((TargetModuleID)fields.get(name, null));
/*     */   }
/*     */ 
/*     */   private void writeObject(ObjectOutputStream oos)
/*     */     throws IOException
/*     */   {
/* 141 */     ObjectOutputStream.PutField fields = oos.putFields();
/* 142 */     String name = serialPersistentFields[0].getName();
/* 143 */     fields.put(name, this.status);
/* 144 */     name = serialPersistentFields[1].getName();
/* 145 */     fields.put(name, this.moduleID);
/* 146 */     oos.writeFields();
/*     */   }
/*     */ 
/*     */   static
/*     */   {
/*  52 */     if (SerialVersion.version == 0)
/*     */     {
/*  54 */       serialVersionUID = 3097551795061550569L;
/*  55 */       serialPersistentFields = new ObjectStreamField[] { new ObjectStreamField("status", DeploymentStatus.class), new ObjectStreamField("moduleID", TargetModuleID.class) };
/*     */     }
/*     */     else
/*     */     {
/*  65 */       serialVersionUID = 7815118532096485937L;
/*  66 */       serialPersistentFields = new ObjectStreamField[] { new ObjectStreamField("statuscode", DeploymentStatus.class), new ObjectStreamField("targetModuleID", TargetModuleID.class) };
/*     */     }
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     javax.enterprise.deploy.spi.status.ProgressEvent
 * JD-Core Version:    0.6.0
 */