package javax.enterprise.deploy.spi;

import java.io.File;
import java.io.InputStream;
import java.util.Locale;
import javax.enterprise.deploy.model.DeployableObject;
import javax.enterprise.deploy.shared.DConfigBeanVersionType;
import javax.enterprise.deploy.shared.ModuleType;
import javax.enterprise.deploy.spi.exceptions.DConfigBeanVersionUnsupportedException;
import javax.enterprise.deploy.spi.exceptions.InvalidModuleException;
import javax.enterprise.deploy.spi.exceptions.TargetException;
import javax.enterprise.deploy.spi.status.ProgressObject;

public abstract interface DeploymentManager
{
  public abstract Target[] getTargets()
    throws IllegalStateException;

  public abstract TargetModuleID[] getRunningModules(ModuleType paramModuleType, Target[] paramArrayOfTarget)
    throws TargetException, IllegalStateException;

  public abstract TargetModuleID[] getNonRunningModules(ModuleType paramModuleType, Target[] paramArrayOfTarget)
    throws TargetException, IllegalStateException;

  public abstract TargetModuleID[] getAvailableModules(ModuleType paramModuleType, Target[] paramArrayOfTarget)
    throws TargetException, IllegalStateException;

  public abstract DeploymentConfiguration createConfiguration(DeployableObject paramDeployableObject)
    throws InvalidModuleException;

  public abstract ProgressObject distribute(Target[] paramArrayOfTarget, File paramFile1, File paramFile2)
    throws IllegalStateException;

  public abstract ProgressObject distribute(Target[] paramArrayOfTarget, InputStream paramInputStream1, InputStream paramInputStream2)
    throws IllegalStateException;

  public abstract ProgressObject distribute(Target[] paramArrayOfTarget, ModuleType paramModuleType, InputStream paramInputStream1, InputStream paramInputStream2)
    throws IllegalStateException;

  public abstract ProgressObject start(TargetModuleID[] paramArrayOfTargetModuleID)
    throws IllegalStateException;

  public abstract ProgressObject stop(TargetModuleID[] paramArrayOfTargetModuleID)
    throws IllegalStateException;

  public abstract ProgressObject undeploy(TargetModuleID[] paramArrayOfTargetModuleID)
    throws IllegalStateException;

  public abstract boolean isRedeploySupported();

  public abstract ProgressObject redeploy(TargetModuleID[] paramArrayOfTargetModuleID, File paramFile1, File paramFile2)
    throws UnsupportedOperationException, IllegalStateException;

  public abstract ProgressObject redeploy(TargetModuleID[] paramArrayOfTargetModuleID, InputStream paramInputStream1, InputStream paramInputStream2)
    throws UnsupportedOperationException, IllegalStateException;

  public abstract void release();

  public abstract Locale getDefaultLocale();

  public abstract Locale getCurrentLocale();

  public abstract void setLocale(Locale paramLocale)
    throws UnsupportedOperationException;

  public abstract Locale[] getSupportedLocales();

  public abstract boolean isLocaleSupported(Locale paramLocale);

  public abstract DConfigBeanVersionType getDConfigBeanVersion();

  public abstract boolean isDConfigBeanVersionSupported(DConfigBeanVersionType paramDConfigBeanVersionType);

  public abstract void setDConfigBeanVersion(DConfigBeanVersionType paramDConfigBeanVersionType)
    throws DConfigBeanVersionUnsupportedException;
}

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     javax.enterprise.deploy.spi.DeploymentManager
 * JD-Core Version:    0.6.0
 */