/*     */ package javax.enterprise.deploy.shared;
/*     */ 
/*     */ public class ModuleType
/*     */ {
/*     */   private static final int EAR_INT = 0;
/*     */   private static final int EJB_INT = 1;
/*     */   private static final int CAR_INT = 2;
/*     */   private static final int RAR_INT = 3;
/*     */   private static final int WAR_INT = 4;
/*  46 */   public static final ModuleType EAR = new ModuleType(0);
/*     */ 
/*  48 */   public static final ModuleType EJB = new ModuleType(1);
/*     */ 
/*  50 */   public static final ModuleType CAR = new ModuleType(2);
/*     */ 
/*  52 */   public static final ModuleType RAR = new ModuleType(3);
/*     */ 
/*  54 */   public static final ModuleType WAR = new ModuleType(4);
/*     */ 
/*  57 */   private static final ModuleType[] moduleTypes = { EAR, EJB, CAR, RAR, WAR };
/*     */ 
/*  63 */   private static final String[] stringTable = { "ear", "ejb", "car", "rar", "war" };
/*     */ 
/*  69 */   private static final String[] moduleExtensions = { ".ear", ".jar", ".jar", ".rar", ".war" };
/*     */   private int value;
/*     */ 
/*     */   protected ModuleType(int value)
/*     */   {
/*  86 */     this.value = value;
/*     */   }
/*     */ 
/*     */   public int getValue()
/*     */   {
/*  98 */     return this.value;
/*     */   }
/*     */ 
/*     */   protected String[] getStringTable()
/*     */   {
/* 109 */     return stringTable;
/*     */   }
/*     */ 
/*     */   protected ModuleType[] getEnumValueTable()
/*     */   {
/* 119 */     return moduleTypes;
/*     */   }
/*     */ 
/*     */   public String getModuleExtension()
/*     */   {
/* 129 */     if (this.value >= moduleExtensions.length)
/* 130 */       return Integer.toString(this.value);
/* 131 */     return moduleExtensions[this.value];
/*     */   }
/*     */ 
/*     */   public static ModuleType getModuleType(int type)
/*     */   {
/* 142 */     if (type >= moduleTypes.length)
/* 143 */       return null;
/* 144 */     return moduleTypes[type];
/*     */   }
/*     */ 
/*     */   public String toString()
/*     */   {
/* 153 */     if (this.value >= stringTable.length)
/* 154 */       return Integer.toString(this.value);
/* 155 */     return stringTable[this.value];
/*     */   }
/*     */ 
/*     */   protected int getOffset()
/*     */   {
/* 165 */     return 0;
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     javax.enterprise.deploy.shared.ModuleType
 * JD-Core Version:    0.6.0
 */