/*     */ package com.arjuna.common.util.logging;
/*     */ 
/*     */ public class DebugLevel
/*     */ {
/*     */   public static final long NO_DEBUGGING = 0L;
/*     */   public static final long CONSTRUCTORS = 1L;
/*     */   public static final long DESTRUCTORS = 2L;
/*     */   public static final long CONSTRUCT_AND_DESTRUCT = 3L;
/*     */   public static final long FUNCTIONS = 16L;
/*     */   public static final long OPERATORS = 32L;
/*     */   public static final long FUNCS_AND_OPS = 48L;
/*     */   public static final long ALL_NON_TRIVIAL = 51L;
/*     */   public static final long TRIVIAL_FUNCS = 256L;
/*     */   public static final long TRIVIAL_OPERATORS = 512L;
/*     */   public static final long ALL_TRIVIAL = 768L;
/*     */   public static final long ERROR_MESSAGES = 1024L;
/*     */   public static final long FULL_DEBUGGING = -1L;
/*     */ 
/*     */   public long getLevel(String level)
/*     */   {
/*  69 */     if (level.equals("NO_DEBUGGING"))
/*  70 */       return 0L;
/*  71 */     if (level.equals("CONSTRUCTORS"))
/*  72 */       return 1L;
/*  73 */     if (level.equals("DESTRUCTORS"))
/*  74 */       return 2L;
/*  75 */     if (level.equals("CONSTRUCT_AND_DESTRUCT"))
/*  76 */       return 3L;
/*  77 */     if (level.equals("FUNCTIONS"))
/*  78 */       return 16L;
/*  79 */     if (level.equals("OPERATORS"))
/*  80 */       return 32L;
/*  81 */     if (level.equals("FUNCS_AND_OPS"))
/*  82 */       return 48L;
/*  83 */     if (level.equals("ALL_NON_TRIVIAL"))
/*  84 */       return 51L;
/*  85 */     if (level.equals("TRIVIAL_FUNCS"))
/*  86 */       return 256L;
/*  87 */     if (level.equals("TRIVIAL_OPERATORS"))
/*  88 */       return 512L;
/*  89 */     if (level.equals("ALL_TRIVIAL"))
/*  90 */       return 768L;
/*  91 */     if (level.equals("ERROR_MESSAGES"))
/*  92 */       return 1024L;
/*  93 */     if (level.equals("FULL_DEBUGGING")) {
/*  94 */       return -1L;
/*     */     }
/*  96 */     return 0L;
/*     */   }
/*     */ 
/*     */   public String printString(long level)
/*     */   {
/* 106 */     if (level == 0L) {
/* 107 */       return "NO_DEBUGGING";
/*     */     }
/* 109 */     if (level == -1L) {
/* 110 */       return "FULL_DEBUGGING";
/*     */     }
/* 112 */     String sLevel = null;
/*     */ 
/* 114 */     if ((level & 1L) != 0L)
/* 115 */       sLevel = sLevel == null ? "CONSTRUCTORS" : " & CONSTRUCTORS";
/* 116 */     if ((level & 0x2) != 0L) {
/* 117 */       sLevel = sLevel == null ? "DESTRUCTORS" : " & DESTRUCTORS";
/*     */     }
/* 119 */     if ((level & 0x10) != 0L) {
/* 120 */       sLevel = sLevel == null ? "FUNCTIONS" : " & FUNCTIONS";
/*     */     }
/* 122 */     if ((level & 0x20) != 0L) {
/* 123 */       sLevel = sLevel == null ? "OPERATORS" : " & OPERATORS";
/*     */     }
/* 125 */     if ((level & 0x100) != 0L)
/* 126 */       sLevel = sLevel == null ? "TRIVIAL_FUNCS" : " & TRIVIAL_FUNCS";
/* 127 */     if ((level & 0x200) != 0L)
/* 128 */       sLevel = sLevel == null ? "TRIVIAL_OPERATORS" : " & TRIVIAL_OPERATORS";
/* 129 */     if ((level & 0x400) != 0L) {
/* 130 */       sLevel = sLevel == null ? "ERROR_MESSAGES" : " & ERROR_MESSAGES";
/*     */     }
/* 132 */     return sLevel == null ? "NO_DEBUGGING" : sLevel;
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     com.arjuna.common.util.logging.DebugLevel
 * JD-Core Version:    0.6.0
 */