/*     */ package com.arjuna.common.util.concurrency;
/*     */ 
/*     */ public class Barrier
/*     */ {
/*  39 */   private int size = 0;
/*  40 */   private int counter = 0;
/*     */   private static final int COLLECTING = 0;
/*     */   private static final int OPENING = 1;
/*  45 */   private int state = 0;
/*  46 */   private Object entryLock = new Object();
/*  47 */   private Object openLock = new Object();
/*     */ 
/*     */   protected Barrier(int size)
/*     */   {
/*  56 */     if (size < 2)
/*  57 */       throw new IllegalArgumentException("size must be a minimum of 2!");
/*  58 */     this.size = size;
/*     */   }
/*     */ 
/*     */   protected synchronized void enter()
/*     */   {
/*  70 */     while (this.state != 0) {
/*     */       try {
/*  72 */         wait();
/*     */       }
/*     */       catch (InterruptedException ie)
/*     */       {
/*  76 */         ie.printStackTrace();
/*     */       }
/*     */ 
/*     */     }
/*     */ 
/*  81 */     this.counter += 1;
/*  82 */     if (this.size == this.counter)
/*     */     {
/*  84 */       this.state = 1;
/*  85 */       notifyAll();
/*     */     }
/*     */ 
/*  92 */     while (this.state != 1) {
/*     */       try {
/*  94 */         wait();
/*     */       }
/*     */       catch (InterruptedException ie)
/*     */       {
/*  98 */         ie.printStackTrace();
/*     */       }
/*     */ 
/*     */     }
/*     */ 
/* 103 */     this.counter -= 1;
/* 104 */     if (this.counter == 0)
/*     */     {
/* 106 */       this.state = 0;
/* 107 */       notifyAll();
/*     */     }
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     com.arjuna.common.util.concurrency.Barrier
 * JD-Core Version:    0.6.0
 */