/*     */ package com.arjuna.common.internal.util.logging;
/*     */ 
/*     */ import com.arjuna.common.util.logging.LogNoi18n;
/*     */ 
/*     */ public class LogNoi18nImpl
/*     */   implements LogNoi18n
/*     */ {
/*  50 */   private LogInterface m_logInterface = null;
/*     */ 
/*  60 */   protected String m_resourceBundle = "no resource bundle set";
/*     */ 
/*  67 */   protected String[] m_extraResBundles = null;
/*     */ 
/*  74 */   private long m_debugLevel = 0L;
/*     */ 
/*  81 */   private long m_visLevel = -1L;
/*     */ 
/*  88 */   private long m_facLevel = -1L;
/*     */ 
/*     */   public LogNoi18nImpl(LogInterface logInterface)
/*     */   {
/*  98 */     this.m_logInterface = logInterface;
/*     */   }
/*     */ 
/*     */   public boolean isDebugEnabled()
/*     */   {
/* 108 */     return this.m_logInterface.isDebugEnabled();
/*     */   }
/*     */ 
/*     */   public boolean isInfoEnabled()
/*     */   {
/* 117 */     return this.m_logInterface.isInfoEnabled();
/*     */   }
/*     */ 
/*     */   public boolean isWarnEnabled()
/*     */   {
/* 126 */     return this.m_logInterface.isWarnEnabled();
/*     */   }
/*     */ 
/*     */   public boolean isErrorEnabled()
/*     */   {
/* 135 */     return this.m_logInterface.isErrorEnabled();
/*     */   }
/*     */ 
/*     */   public boolean isFatalEnabled()
/*     */   {
/* 144 */     return this.m_logInterface.isFatalEnabled();
/*     */   }
/*     */ 
/*     */   public void setLevels(long dl, long vl, long fl)
/*     */   {
/* 164 */     this.m_debugLevel = dl;
/* 165 */     this.m_visLevel = vl;
/* 166 */     this.m_facLevel = fl;
/*     */   }
/*     */ 
/*     */   public long getDebugLevel()
/*     */   {
/* 177 */     return this.m_debugLevel;
/*     */   }
/*     */ 
/*     */   public void setDebugLevel(long level)
/*     */   {
/* 188 */     this.m_debugLevel = level;
/*     */   }
/*     */ 
/*     */   public void mergeDebugLevel(long level)
/*     */   {
/* 200 */     this.m_debugLevel |= level;
/*     */   }
/*     */ 
/*     */   public long getVisibilityLevel()
/*     */   {
/* 211 */     return this.m_visLevel;
/*     */   }
/*     */ 
/*     */   public void setVisibilityLevel(long level)
/*     */   {
/* 222 */     this.m_visLevel = level;
/*     */   }
/*     */ 
/*     */   public void mergeVisibilityLevel(long level)
/*     */   {
/* 233 */     this.m_visLevel |= level;
/*     */   }
/*     */ 
/*     */   public long getFacilityCode()
/*     */   {
/* 244 */     return this.m_facLevel;
/*     */   }
/*     */ 
/*     */   public void setFacilityCode(long level)
/*     */   {
/* 255 */     this.m_facLevel = level;
/*     */   }
/*     */ 
/*     */   public void mergeFacilityCode(long level)
/*     */   {
/* 266 */     this.m_facLevel |= level;
/*     */   }
/*     */ 
/*     */   public boolean debugAllowed()
/*     */   {
/* 283 */     return debugAllowed(-1L, -1L, -1L);
/*     */   }
/*     */ 
/*     */   public boolean debugAllowed(long dLevel)
/*     */   {
/* 302 */     return debugAllowed(dLevel, -1L, -1L);
/*     */   }
/*     */ 
/*     */   public boolean debugAllowed(long dLevel, long vLevel)
/*     */   {
/* 323 */     return debugAllowed(dLevel, vLevel, -1L);
/*     */   }
/*     */ 
/*     */   public boolean debugAllowed(long dLevel, long vLevel, long fLevel)
/*     */   {
/* 341 */     return ((dLevel & this.m_debugLevel) != 0L) && ((vLevel & this.m_visLevel) != 0L) && ((fLevel & this.m_facLevel) != 0L);
/*     */   }
/*     */ 
/*     */   public void debug(long dl, long vl, long fl, Object message)
/*     */   {
/* 370 */     if (debugAllowed(dl, vl, fl))
/*     */     {
/* 372 */       debug(message);
/*     */     }
/*     */   }
/*     */ 
/*     */   public void debug(long dl, long vl, long fl, String message)
/*     */   {
/* 396 */     if (debugAllowed(dl, vl, fl))
/*     */     {
/* 398 */       debug(message);
/*     */     }
/*     */   }
/*     */ 
/*     */   public void debug(Object message)
/*     */   {
/* 409 */     this.m_logInterface.debug(message);
/*     */   }
/*     */ 
/*     */   public void debug(String message)
/*     */   {
/* 419 */     this.m_logInterface.debug(message);
/*     */   }
/*     */ 
/*     */   public void info(Object message)
/*     */   {
/* 429 */     this.m_logInterface.info(message);
/*     */   }
/*     */ 
/*     */   public void info(String message)
/*     */   {
/* 439 */     this.m_logInterface.info(message);
/*     */   }
/*     */ 
/*     */   public void warn(Object message)
/*     */   {
/* 449 */     this.m_logInterface.warn(message);
/*     */   }
/*     */ 
/*     */   public void warn(String message)
/*     */   {
/* 459 */     this.m_logInterface.warn(message);
/*     */   }
/*     */ 
/*     */   public void error(Object message)
/*     */   {
/* 469 */     this.m_logInterface.error(message);
/*     */   }
/*     */ 
/*     */   public void error(String message)
/*     */   {
/* 479 */     this.m_logInterface.error(message);
/*     */   }
/*     */ 
/*     */   public void fatal(Object message)
/*     */   {
/* 490 */     this.m_logInterface.fatal(message);
/*     */   }
/*     */ 
/*     */   public void fatal(String message)
/*     */   {
/* 500 */     this.m_logInterface.fatal(message);
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     com.arjuna.common.internal.util.logging.LogNoi18nImpl
 * JD-Core Version:    0.6.0
 */