/*     */ package com.arjuna.common.internal.util.logging;
/*     */ 
/*     */ import com.arjuna.common.util.logging.Logi18n;
/*     */ import com.arjuna.common.util.propertyservice.PropertyManager;
/*     */ 
/*     */ public class LogImpl extends AbstractLogImpl
/*     */   implements Logi18n
/*     */ {
/*  49 */   private LogInterface m_logInterface = null;
/*     */ 
/*  57 */   private DefaultLog m_defaultLog = null;
/*     */ 
/*  62 */   private boolean defaultLogSet = false;
/*     */ 
/*     */   public LogImpl(LogInterface logInterface)
/*     */   {
/*  72 */     super(logInterface);
/*  73 */     this.m_logInterface = logInterface;
/*  74 */     setupDefaultLog("default");
/*     */   }
/*     */ 
/*     */   public LogImpl(LogInterface logInterface, String resBundle)
/*     */   {
/*  85 */     super(logInterface, resBundle);
/*  86 */     this.m_logInterface = logInterface;
/*  87 */     setupDefaultLog(resBundle);
/*     */   }
/*     */ 
/*     */   /** @deprecated */
/*     */   public LogImpl(LogInterface logInterface, String[] resBundles)
/*     */   {
/* 100 */     super(logInterface, resBundles);
/* 101 */     this.m_logInterface = logInterface;
/* 102 */     setupDefaultLog(resBundles[0]);
/*     */   }
/*     */ 
/*     */   private void setupDefaultLog(String name)
/*     */   {
/* 107 */     String defaultLog = "false";
/*     */     try
/*     */     {
/* 110 */       defaultLog = commonPropertyManager.propertyManager.getProperty("com.arjuna.common.util.logging.default", null);
/*     */ 
/* 113 */       if (defaultLog == null) {
/* 114 */         defaultLog = System.getProperty("com.arjuna.common.util.logging.default", "false");
/*     */       }
/*     */ 
/*     */     }
/*     */     catch (Throwable t)
/*     */     {
/*     */     }
/*     */ 
/* 124 */     if (defaultLog.equals("true"))
/*     */     {
/* 126 */       this.m_defaultLog = new DefaultLog(name);
/* 127 */       this.defaultLogSet = true;
/*     */     }
/*     */   }
/*     */ 
/*     */   public boolean isDebugEnabled()
/*     */   {
/* 138 */     if (this.defaultLogSet)
/*     */     {
/* 140 */       return (this.m_logInterface.isDebugEnabled()) || (this.m_defaultLog.isDebugEnabled());
/*     */     }
/* 142 */     return this.m_logInterface.isDebugEnabled();
/*     */   }
/*     */ 
/*     */   public boolean isInfoEnabled()
/*     */   {
/* 151 */     if (this.defaultLogSet)
/*     */     {
/* 153 */       return (this.m_logInterface.isInfoEnabled()) || (this.m_defaultLog.isInfoEnabled());
/*     */     }
/* 155 */     return this.m_logInterface.isInfoEnabled();
/*     */   }
/*     */ 
/*     */   public boolean isWarnEnabled()
/*     */   {
/* 164 */     if (this.defaultLogSet)
/*     */     {
/* 166 */       return (this.m_logInterface.isWarnEnabled()) || (this.m_defaultLog.isWarnEnabled());
/*     */     }
/* 168 */     return this.m_logInterface.isWarnEnabled();
/*     */   }
/*     */ 
/*     */   public boolean isErrorEnabled()
/*     */   {
/* 177 */     if (this.defaultLogSet)
/*     */     {
/* 179 */       return (this.m_logInterface.isErrorEnabled()) || (this.m_defaultLog.isErrorEnabled());
/*     */     }
/* 181 */     return this.m_logInterface.isErrorEnabled();
/*     */   }
/*     */ 
/*     */   public boolean isFatalEnabled()
/*     */   {
/* 190 */     if (this.defaultLogSet)
/*     */     {
/* 192 */       return (this.m_logInterface.isFatalEnabled()) || (this.m_defaultLog.isFatalEnabled());
/*     */     }
/* 194 */     return this.m_logInterface.isFatalEnabled();
/*     */   }
/*     */ 
/*     */   /** @deprecated */
/*     */   public void debug(String key)
/*     */   {
/* 207 */     if (!isDebugEnabled()) return;
/* 208 */     String message = evalResourceBundle(key);
/* 209 */     this.m_logInterface.debug(message);
/* 210 */     if (this.defaultLogSet)
/* 211 */       this.m_defaultLog.debug(message);
/*     */   }
/*     */ 
/*     */   public void debug(Throwable throwable)
/*     */   {
/* 221 */     if (!isDebugEnabled()) return;
/* 222 */     String message = throwable.getLocalizedMessage();
/* 223 */     this.m_logInterface.debug(message, throwable);
/* 224 */     if (this.defaultLogSet)
/* 225 */       this.m_defaultLog.debug(message, throwable);
/*     */   }
/*     */ 
/*     */   public void debug(String key, Throwable throwable)
/*     */   {
/* 235 */     if (!isDebugEnabled()) return;
/* 236 */     String message = evalResourceBundle(key);
/* 237 */     this.m_logInterface.debug(message, throwable);
/* 238 */     if (this.defaultLogSet)
/* 239 */       this.m_defaultLog.debug(message, throwable);
/*     */   }
/*     */ 
/*     */   public void debug(String key, Object[] params)
/*     */   {
/* 250 */     if (!isDebugEnabled()) return;
/* 251 */     String message = evalResourceBundle(key, params);
/* 252 */     this.m_logInterface.debug(message);
/* 253 */     if (this.defaultLogSet)
/* 254 */       this.m_defaultLog.debug(message);
/*     */   }
/*     */ 
/*     */   public void debug(String key, Object[] params, Throwable throwable)
/*     */   {
/* 266 */     if (!isDebugEnabled()) return;
/* 267 */     String message = evalResourceBundle(key, params);
/* 268 */     this.m_logInterface.debug(message, throwable);
/* 269 */     if (this.defaultLogSet)
/* 270 */       this.m_defaultLog.debug(message, throwable);
/*     */   }
/*     */ 
/*     */   /** @deprecated */
/*     */   public void info(String key)
/*     */   {
/* 330 */     if (!isInfoEnabled()) return;
/* 331 */     String message = evalResourceBundle(key);
/* 332 */     this.m_logInterface.info(message);
/* 333 */     if (this.defaultLogSet)
/* 334 */       this.m_defaultLog.info(message);
/*     */   }
/*     */ 
/*     */   public void info(Throwable throwable)
/*     */   {
/* 343 */     if (!isInfoEnabled()) return;
/* 344 */     String message = throwable.getLocalizedMessage();
/* 345 */     this.m_logInterface.info(message, throwable);
/* 346 */     if (this.defaultLogSet)
/* 347 */       this.m_defaultLog.info(message, throwable);
/*     */   }
/*     */ 
/*     */   public void info(String key, Throwable throwable)
/*     */   {
/* 357 */     if (!isInfoEnabled()) return;
/* 358 */     String message = evalResourceBundle(key);
/* 359 */     this.m_logInterface.info(message, throwable);
/* 360 */     if (this.defaultLogSet)
/* 361 */       this.m_defaultLog.info(message, throwable);
/*     */   }
/*     */ 
/*     */   public void info(String key, Object[] params)
/*     */   {
/* 371 */     if (!isInfoEnabled()) return;
/* 372 */     String message = evalResourceBundle(key, params);
/* 373 */     this.m_logInterface.info(message);
/* 374 */     if (this.defaultLogSet)
/* 375 */       this.m_defaultLog.info(message);
/*     */   }
/*     */ 
/*     */   public void info(String key, Object[] params, Throwable throwable)
/*     */   {
/* 386 */     if (!isInfoEnabled()) return;
/* 387 */     String message = evalResourceBundle(key, params);
/* 388 */     this.m_logInterface.info(message, throwable);
/* 389 */     if (this.defaultLogSet)
/* 390 */       this.m_defaultLog.info(message, throwable);
/*     */   }
/*     */ 
/*     */   /** @deprecated */
/*     */   public void warn(String key)
/*     */   {
/* 401 */     if (!isWarnEnabled()) return;
/* 402 */     String message = evalResourceBundle(key);
/* 403 */     this.m_logInterface.warn(message);
/* 404 */     if (this.defaultLogSet)
/* 405 */       this.m_defaultLog.warn(message);
/*     */   }
/*     */ 
/*     */   public void warn(Throwable throwable)
/*     */   {
/* 414 */     if (!isWarnEnabled()) return;
/* 415 */     String message = throwable.getLocalizedMessage();
/* 416 */     this.m_logInterface.warn(message, throwable);
/* 417 */     if (this.defaultLogSet)
/* 418 */       this.m_defaultLog.warn(message, throwable);
/*     */   }
/*     */ 
/*     */   public void warn(String key, Throwable throwable)
/*     */   {
/* 428 */     if (!isWarnEnabled()) return;
/* 429 */     String message = evalResourceBundle(key);
/* 430 */     this.m_logInterface.warn(message, throwable);
/* 431 */     if (this.defaultLogSet)
/* 432 */       this.m_defaultLog.warn(message, throwable);
/*     */   }
/*     */ 
/*     */   public void warn(String key, Object[] params)
/*     */   {
/* 442 */     if (!isWarnEnabled()) return;
/* 443 */     String message = evalResourceBundle(key, params);
/* 444 */     this.m_logInterface.warn(message);
/* 445 */     if (this.defaultLogSet)
/* 446 */       this.m_defaultLog.warn(message);
/*     */   }
/*     */ 
/*     */   public void warn(String key, Object[] params, Throwable throwable)
/*     */   {
/* 457 */     if (!isWarnEnabled()) return;
/* 458 */     String message = evalResourceBundle(key, params);
/* 459 */     this.m_logInterface.warn(message, throwable);
/* 460 */     if (this.defaultLogSet)
/* 461 */       this.m_defaultLog.warn(message, throwable);
/*     */   }
/*     */ 
/*     */   /** @deprecated */
/*     */   public void error(String key)
/*     */   {
/* 472 */     if (!isErrorEnabled()) return;
/* 473 */     String message = evalResourceBundle(key);
/* 474 */     this.m_logInterface.error(message);
/* 475 */     if (this.defaultLogSet)
/* 476 */       this.m_defaultLog.error(message);
/*     */   }
/*     */ 
/*     */   public void error(Throwable throwable)
/*     */   {
/* 485 */     if (!isErrorEnabled()) return;
/* 486 */     String message = throwable.getLocalizedMessage();
/* 487 */     this.m_logInterface.error(message, throwable);
/* 488 */     if (this.defaultLogSet)
/* 489 */       this.m_defaultLog.error(message, throwable);
/*     */   }
/*     */ 
/*     */   public void error(String key, Throwable throwable)
/*     */   {
/* 499 */     if (!isErrorEnabled()) return;
/* 500 */     String message = evalResourceBundle(key);
/* 501 */     this.m_logInterface.error(message, throwable);
/* 502 */     if (this.defaultLogSet)
/* 503 */       this.m_defaultLog.error(message, throwable);
/*     */   }
/*     */ 
/*     */   public void error(String key, Object[] params)
/*     */   {
/* 513 */     if (!isErrorEnabled()) return;
/* 514 */     String message = evalResourceBundle(key, params);
/* 515 */     this.m_logInterface.error(message);
/* 516 */     if (this.defaultLogSet)
/* 517 */       this.m_defaultLog.error(message);
/*     */   }
/*     */ 
/*     */   public void error(String key, Object[] params, Throwable throwable)
/*     */   {
/* 528 */     if (!isErrorEnabled()) return;
/* 529 */     String message = evalResourceBundle(key, params);
/* 530 */     this.m_logInterface.error(message, throwable);
/* 531 */     if (this.defaultLogSet)
/* 532 */       this.m_defaultLog.error(message, throwable);
/*     */   }
/*     */ 
/*     */   /** @deprecated */
/*     */   public void fatal(String key)
/*     */   {
/* 592 */     if (!isFatalEnabled()) return;
/* 593 */     String message = evalResourceBundle(key);
/* 594 */     this.m_logInterface.fatal(message);
/* 595 */     if (this.defaultLogSet)
/* 596 */       this.m_defaultLog.fatal(message);
/*     */   }
/*     */ 
/*     */   public void fatal(Throwable throwable)
/*     */   {
/* 605 */     if (!isFatalEnabled()) return;
/* 606 */     String message = throwable.getLocalizedMessage();
/* 607 */     this.m_logInterface.fatal(message, throwable);
/* 608 */     if (this.defaultLogSet)
/* 609 */       this.m_defaultLog.fatal(message, throwable);
/*     */   }
/*     */ 
/*     */   public void fatal(String key, Throwable throwable)
/*     */   {
/* 619 */     if (!isFatalEnabled()) return;
/* 620 */     String message = evalResourceBundle(key);
/* 621 */     this.m_logInterface.fatal(message, throwable);
/* 622 */     if (this.defaultLogSet)
/* 623 */       this.m_defaultLog.fatal(message, throwable);
/*     */   }
/*     */ 
/*     */   public void fatal(String key, Object[] params)
/*     */   {
/* 633 */     if (!isFatalEnabled()) return;
/* 634 */     String message = evalResourceBundle(key, params);
/* 635 */     this.m_logInterface.fatal(message);
/* 636 */     if (this.defaultLogSet)
/* 637 */       this.m_defaultLog.fatal(message);
/*     */   }
/*     */ 
/*     */   public void fatal(String key, Object[] params, Throwable throwable)
/*     */   {
/* 648 */     if (!isFatalEnabled()) return;
/* 649 */     String message = evalResourceBundle(key, params);
/* 650 */     this.m_logInterface.fatal(message, throwable);
/* 651 */     if (this.defaultLogSet)
/* 652 */       this.m_defaultLog.fatal(message, throwable);
/*     */   }
/*     */ 
/*     */   public void debugb(String baseName, String key)
/*     */   {
/* 663 */     if (!isDebugEnabled()) return;
/* 664 */     String message = evalResourceBundle(baseName, key);
/* 665 */     this.m_logInterface.debug(message);
/* 666 */     if (this.defaultLogSet)
/* 667 */       this.m_defaultLog.debug(message);
/*     */   }
/*     */ 
/*     */   public void debugb(String baseName, String key, Throwable throwable)
/*     */   {
/* 678 */     if (!isDebugEnabled()) return;
/* 679 */     String message = evalResourceBundle(baseName, key);
/* 680 */     this.m_logInterface.debug(message, throwable);
/* 681 */     if (this.defaultLogSet)
/* 682 */       this.m_defaultLog.debug(message, throwable);
/*     */   }
/*     */ 
/*     */   public void debugb(String baseName, String key, Object[] params)
/*     */   {
/* 693 */     if (!isDebugEnabled()) return;
/* 694 */     String message = evalResourceBundle(baseName, key, params);
/* 695 */     this.m_logInterface.debug(message);
/* 696 */     if (this.defaultLogSet)
/* 697 */       this.m_defaultLog.debug(message);
/*     */   }
/*     */ 
/*     */   public void debugb(String baseName, String key, Object[] params, Throwable throwable)
/*     */   {
/* 709 */     if (!isDebugEnabled()) return;
/* 710 */     String message = evalResourceBundle(baseName, key, params);
/* 711 */     this.m_logInterface.debug(message, throwable);
/* 712 */     if (this.defaultLogSet)
/* 713 */       this.m_defaultLog.debug(message, throwable);
/*     */   }
/*     */ 
/*     */   public void infob(String baseName, String key)
/*     */   {
/* 724 */     if (!isInfoEnabled()) return;
/* 725 */     String message = evalResourceBundle(baseName, key);
/* 726 */     this.m_logInterface.info(message);
/* 727 */     if (this.defaultLogSet)
/* 728 */       this.m_defaultLog.info(message);
/*     */   }
/*     */ 
/*     */   public void infob(String baseName, String key, Throwable throwable)
/*     */   {
/* 739 */     if (!isInfoEnabled()) return;
/* 740 */     String message = evalResourceBundle(baseName, key);
/* 741 */     this.m_logInterface.info(message, throwable);
/* 742 */     if (this.defaultLogSet)
/* 743 */       this.m_defaultLog.info(message, throwable);
/*     */   }
/*     */ 
/*     */   public void infob(String baseName, String key, Object[] params)
/*     */   {
/* 754 */     if (!isInfoEnabled()) return;
/* 755 */     String message = evalResourceBundle(baseName, key, params);
/* 756 */     this.m_logInterface.info(message);
/* 757 */     if (this.defaultLogSet)
/* 758 */       this.m_defaultLog.info(message);
/*     */   }
/*     */ 
/*     */   public void infob(String baseName, String key, Object[] params, Throwable throwable)
/*     */   {
/* 770 */     if (!isInfoEnabled()) return;
/* 771 */     String message = evalResourceBundle(baseName, key, params);
/* 772 */     this.m_logInterface.info(message, throwable);
/* 773 */     if (this.defaultLogSet)
/* 774 */       this.m_defaultLog.info(message, throwable);
/*     */   }
/*     */ 
/*     */   public void warnb(String baseName, String key)
/*     */   {
/* 784 */     if (!isWarnEnabled()) return;
/* 785 */     String message = evalResourceBundle(baseName, key);
/* 786 */     this.m_logInterface.warn(message);
/* 787 */     if (this.defaultLogSet)
/* 788 */       this.m_defaultLog.warn(message);
/*     */   }
/*     */ 
/*     */   public void warnb(String baseName, String key, Throwable throwable)
/*     */   {
/* 799 */     if (!isWarnEnabled()) return;
/* 800 */     String message = evalResourceBundle(baseName, key);
/* 801 */     this.m_logInterface.warn(message, throwable);
/* 802 */     if (this.defaultLogSet)
/* 803 */       this.m_defaultLog.warn(message, throwable);
/*     */   }
/*     */ 
/*     */   public void warnb(String baseName, String key, Object[] params)
/*     */   {
/* 814 */     if (!isWarnEnabled()) return;
/* 815 */     String message = evalResourceBundle(baseName, key, params);
/* 816 */     this.m_logInterface.warn(message);
/* 817 */     if (this.defaultLogSet)
/* 818 */       this.m_defaultLog.warn(message);
/*     */   }
/*     */ 
/*     */   public void warnb(String baseName, String key, Object[] params, Throwable throwable)
/*     */   {
/* 830 */     if (!isWarnEnabled()) return;
/* 831 */     String message = evalResourceBundle(baseName, key, params);
/* 832 */     this.m_logInterface.warn(message, throwable);
/* 833 */     if (this.defaultLogSet)
/* 834 */       this.m_defaultLog.warn(message, throwable);
/*     */   }
/*     */ 
/*     */   public void errorb(String baseName, String key)
/*     */   {
/* 844 */     if (!isErrorEnabled()) return;
/* 845 */     String message = evalResourceBundle(baseName, key);
/* 846 */     this.m_logInterface.error(message);
/* 847 */     if (this.defaultLogSet)
/* 848 */       this.m_defaultLog.error(message);
/*     */   }
/*     */ 
/*     */   public void errorb(String baseName, String key, Throwable throwable)
/*     */   {
/* 859 */     if (!isErrorEnabled()) return;
/* 860 */     String message = evalResourceBundle(baseName, key);
/* 861 */     this.m_logInterface.error(message, throwable);
/* 862 */     if (this.defaultLogSet)
/* 863 */       this.m_defaultLog.error(message, throwable);
/*     */   }
/*     */ 
/*     */   public void errorb(String baseName, String key, Object[] params)
/*     */   {
/* 874 */     if (!isErrorEnabled()) return;
/* 875 */     String message = evalResourceBundle(baseName, key, params);
/* 876 */     this.m_logInterface.error(message);
/* 877 */     if (this.defaultLogSet)
/* 878 */       this.m_defaultLog.error(message);
/*     */   }
/*     */ 
/*     */   public void errorb(String baseName, String key, Object[] params, Throwable throwable)
/*     */   {
/* 890 */     if (!isErrorEnabled()) return;
/* 891 */     String message = evalResourceBundle(baseName, key, params);
/* 892 */     this.m_logInterface.error(message, throwable);
/* 893 */     if (this.defaultLogSet)
/* 894 */       this.m_defaultLog.error(message, throwable);
/*     */   }
/*     */ 
/*     */   public void fatalb(String baseName, String key)
/*     */   {
/* 904 */     if (!isFatalEnabled()) return;
/* 905 */     String message = evalResourceBundle(baseName, key);
/* 906 */     this.m_logInterface.fatal(message);
/* 907 */     if (this.defaultLogSet)
/* 908 */       this.m_defaultLog.fatal(message);
/*     */   }
/*     */ 
/*     */   public void fatalb(String baseName, String key, Throwable throwable)
/*     */   {
/* 919 */     if (!isFatalEnabled()) return;
/* 920 */     String message = evalResourceBundle(baseName, key);
/* 921 */     this.m_logInterface.fatal(message, throwable);
/* 922 */     if (this.defaultLogSet)
/* 923 */       this.m_defaultLog.fatal(message, throwable);
/*     */   }
/*     */ 
/*     */   public void fatalb(String baseName, String key, Object[] params)
/*     */   {
/* 934 */     if (!isFatalEnabled()) return;
/* 935 */     String message = evalResourceBundle(baseName, key, params);
/* 936 */     this.m_logInterface.fatal(message);
/* 937 */     if (this.defaultLogSet)
/* 938 */       this.m_defaultLog.fatal(message);
/*     */   }
/*     */ 
/*     */   public void fatalb(String baseName, String key, Object[] params, Throwable throwable)
/*     */   {
/* 950 */     if (!isFatalEnabled()) return;
/* 951 */     String message = evalResourceBundle(baseName, key, params);
/* 952 */     this.m_logInterface.fatal(message, throwable);
/* 953 */     if (this.defaultLogSet)
/* 954 */       this.m_defaultLog.fatal(message, throwable);
/*     */   }
/*     */ 
/*     */   private String evalResourceBundle(String key)
/*     */   {
/* 967 */     return getString(key);
/*     */   }
/*     */ 
/*     */   private String evalResourceBundle(String key, Object[] params)
/*     */   {
/* 974 */     return getString(key, params);
/*     */   }
/*     */ 
/*     */   private String evalResourceBundle(String resBundle, String key)
/*     */   {
/* 981 */     return getString(resBundle, key);
/*     */   }
/*     */ 
/*     */   private String evalResourceBundle(String resBundle, String key, Object[] params)
/*     */   {
/* 988 */     return getString(resBundle, key, params);
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     com.arjuna.common.internal.util.logging.LogImpl
 * JD-Core Version:    0.6.0
 */