/*     */ package com.arjuna.common.internal.util.logging;
/*     */ 
/*     */ import com.arjuna.common.util.logging.Logi18n;
/*     */ import java.io.PrintStream;
/*     */ import java.text.MessageFormat;
/*     */ import java.util.Locale;
/*     */ import java.util.MissingResourceException;
/*     */ import java.util.PropertyResourceBundle;
/*     */ import java.util.ResourceBundle;
/*     */ 
/*     */ public abstract class AbstractLogImpl
/*     */   implements Logi18n
/*     */ {
/*  58 */   private AbstractLogInterface m_logInterface = null;
/*     */ 
/*     */   /** @deprecated */
/*  70 */   protected String m_resourceBundleName = "no resource bundle set";
/*     */ 
/*  72 */   private ResourceBundle m_defaultResourceBundle = null;
/*     */ 
/*  82 */   private ResourceBundle[] m_extraResourceBundles = null;
/*     */ 
/*  89 */   private long m_debugLevel = 0L;
/*     */ 
/*  96 */   private long m_visLevel = -1L;
/*     */ 
/* 103 */   private long m_facLevel = -1L;
/*     */ 
/*     */   public AbstractLogImpl(AbstractLogInterface logInterface)
/*     */   {
/* 113 */     this.m_logInterface = logInterface;
/*     */   }
/*     */ 
/*     */   public AbstractLogImpl(AbstractLogInterface logInterface, String resBundle)
/*     */   {
/* 124 */     this.m_logInterface = logInterface;
/*     */ 
/* 127 */     addResourceBundle(resBundle);
/*     */   }
/*     */ 
/*     */   /** @deprecated */
/*     */   public AbstractLogImpl(AbstractLogInterface logInterface, String[] resBundles)
/*     */   {
/* 140 */     this.m_logInterface = logInterface;
/* 141 */     for (int i = 0; i < resBundles.length; i++)
/*     */     {
/* 143 */       addResourceBundle(resBundles[i]);
/*     */     }
/*     */   }
/*     */ 
/*     */   public synchronized void setResourceBundleName(String baseName)
/*     */   {
/*     */     try
/*     */     {
/* 158 */       this.m_resourceBundleName = baseName;
/* 159 */       this.m_defaultResourceBundle = PropertyResourceBundle.getBundle(baseName, Locale.getDefault(), Thread.currentThread().getContextClassLoader());
/*     */     }
/*     */     catch (MissingResourceException mre)
/*     */     {
/* 163 */       System.err.println("resource bundle " + mre.getClassName() + " not found!");
/*     */     }
/*     */   }
/*     */ 
/*     */   public synchronized void addResourceBundle(String bundleName)
/*     */   {
/*     */     try
/*     */     {
/* 177 */       if (this.m_defaultResourceBundle == null)
/*     */       {
/* 179 */         this.m_defaultResourceBundle = PropertyResourceBundle.getBundle(bundleName, Locale.getDefault(), Thread.currentThread().getContextClassLoader());
/* 180 */         this.m_resourceBundleName = bundleName;
/*     */       }
/* 184 */       else if (this.m_extraResourceBundles == null)
/*     */       {
/* 186 */         this.m_extraResourceBundles = new ResourceBundle[] { PropertyResourceBundle.getBundle(bundleName, Locale.getDefault(), Thread.currentThread().getContextClassLoader()) };
/*     */       }
/*     */       else
/*     */       {
/* 190 */         ResourceBundle[] oldExtraResBundles = this.m_extraResourceBundles;
/* 191 */         this.m_extraResourceBundles = new ResourceBundle[oldExtraResBundles.length + 1];
/* 192 */         System.arraycopy(oldExtraResBundles, 0, this.m_extraResourceBundles, 0, oldExtraResBundles.length);
/* 193 */         this.m_extraResourceBundles[oldExtraResBundles.length] = PropertyResourceBundle.getBundle(bundleName, Locale.getDefault(), Thread.currentThread().getContextClassLoader());
/*     */       }
/*     */     }
/*     */     catch (MissingResourceException mre)
/*     */     {
/* 198 */       System.err.println("resource bundle " + mre.getClassName() + " not found!");
/*     */     }
/*     */   }
/*     */ 
/*     */   public boolean isDebugEnabled()
/*     */   {
/* 209 */     return this.m_logInterface.isDebugEnabled();
/*     */   }
/*     */ 
/*     */   public boolean isInfoEnabled()
/*     */   {
/* 218 */     return this.m_logInterface.isInfoEnabled();
/*     */   }
/*     */ 
/*     */   public boolean isWarnEnabled()
/*     */   {
/* 227 */     return this.m_logInterface.isWarnEnabled();
/*     */   }
/*     */ 
/*     */   public boolean isErrorEnabled()
/*     */   {
/* 236 */     return this.m_logInterface.isErrorEnabled();
/*     */   }
/*     */ 
/*     */   public boolean isFatalEnabled()
/*     */   {
/* 245 */     return this.m_logInterface.isFatalEnabled();
/*     */   }
/*     */ 
/*     */   public void setLevels(long dl, long vl, long fl)
/*     */   {
/* 265 */     this.m_debugLevel = dl;
/* 266 */     this.m_visLevel = vl;
/* 267 */     this.m_facLevel = fl;
/*     */   }
/*     */ 
/*     */   public long getDebugLevel()
/*     */   {
/* 278 */     return this.m_debugLevel;
/*     */   }
/*     */ 
/*     */   public void setDebugLevel(long level)
/*     */   {
/* 289 */     this.m_debugLevel = level;
/*     */   }
/*     */ 
/*     */   public void mergeDebugLevel(long level)
/*     */   {
/* 301 */     this.m_debugLevel |= level;
/*     */   }
/*     */ 
/*     */   public long getVisibilityLevel()
/*     */   {
/* 312 */     return this.m_visLevel;
/*     */   }
/*     */ 
/*     */   public void setVisibilityLevel(long level)
/*     */   {
/* 323 */     this.m_visLevel = level;
/*     */   }
/*     */ 
/*     */   public void mergeVisibilityLevel(long level)
/*     */   {
/* 334 */     this.m_visLevel |= level;
/*     */   }
/*     */ 
/*     */   public long getFacilityCode()
/*     */   {
/* 345 */     return this.m_facLevel;
/*     */   }
/*     */ 
/*     */   public void setFacilityCode(long level)
/*     */   {
/* 356 */     this.m_facLevel = level;
/*     */   }
/*     */ 
/*     */   public void mergeFacilityCode(long level)
/*     */   {
/* 367 */     this.m_facLevel |= level;
/*     */   }
/*     */ 
/*     */   public boolean debugAllowed()
/*     */   {
/* 384 */     return debugAllowed(-1L, -1L, -1L);
/*     */   }
/*     */ 
/*     */   public boolean debugAllowed(long dLevel)
/*     */   {
/* 403 */     return debugAllowed(dLevel, -1L, -1L);
/*     */   }
/*     */ 
/*     */   public boolean debugAllowed(long dLevel, long vLevel)
/*     */   {
/* 424 */     return debugAllowed(dLevel, vLevel, -1L);
/*     */   }
/*     */ 
/*     */   public boolean debugAllowed(long dLevel, long vLevel, long fLevel)
/*     */   {
/* 442 */     return ((dLevel & this.m_debugLevel) != 0L) && ((vLevel & this.m_visLevel) != 0L) && ((fLevel & this.m_facLevel) != 0L);
/*     */   }
/*     */ 
/*     */   public void debug(long dl, long vl, long fl, Throwable throwable)
/*     */   {
/* 473 */     if (debugAllowed(dl, vl, fl))
/*     */     {
/* 475 */       debug(null, null, throwable);
/*     */     }
/*     */   }
/*     */ 
/*     */   public void debug(long dl, long vl, long fl, String key, Object[] params)
/*     */   {
/* 497 */     if (debugAllowed(dl, vl, fl))
/*     */     {
/* 499 */       debug(key, params);
/*     */     }
/*     */   }
/*     */ 
/*     */   public void debug(long dl, long vl, long fl, String key)
/*     */   {
/* 520 */     if (debugAllowed(dl, vl, fl))
/*     */     {
/* 522 */       debug(key);
/*     */     }
/*     */   }
/*     */ 
/*     */   public void debug(long dl, long vl, long fl, String key, Throwable throwable)
/*     */   {
/* 545 */     if (debugAllowed(dl, vl, fl))
/*     */     {
/* 547 */       debug(key, throwable);
/*     */     }
/*     */   }
/*     */ 
/*     */   public void debug(long dl, long vl, long fl, String key, Object[] params, Throwable throwable)
/*     */   {
/* 570 */     if (debugAllowed(dl, vl, fl))
/*     */     {
/* 572 */       debug(key, params, throwable);
/*     */     }
/*     */   }
/*     */ 
/*     */   public String getString(String key)
/*     */     throws MissingResourceException
/*     */   {
/* 597 */     String msg = null;
/*     */     try
/*     */     {
/* 600 */       msg = getResourceBundleString(key);
/*     */     }
/*     */     catch (MissingResourceException mre)
/*     */     {
/* 604 */       return mre.getLocalizedMessage() + ": [key='" + key + "']";
/*     */     }
/* 606 */     return msg;
/*     */   }
/*     */ 
/*     */   public String getString(String key, Object[] params)
/*     */     throws MissingResourceException
/*     */   {
/* 626 */     String pattern = null;
/*     */     try
/*     */     {
/* 629 */       pattern = getResourceBundleString(key);
/*     */     }
/*     */     catch (MissingResourceException mre)
/*     */     {
/* 633 */       StringBuffer sb = new StringBuffer();
/* 634 */       for (int i = 0; i < params.length; i++)
/*     */       {
/* 636 */         sb.append(params[i] + ", ");
/*     */       }
/* 638 */       return mre.getLocalizedMessage() + ": [key='" + key + "']" + sb.toString();
/*     */     }
/*     */ 
/* 641 */     String msg = MessageFormat.format(pattern, params);
/* 642 */     return msg;
/*     */   }
/*     */ 
/*     */   public String getString(String base, String key)
/*     */     throws MissingResourceException
/*     */   {
/*     */     try
/*     */     {
/* 664 */       ResourceBundle rb = PropertyResourceBundle.getBundle(base, Locale.getDefault(), Thread.currentThread().getContextClassLoader());
/* 665 */       String msg = rb.getString(key);
/* 666 */       return msg;
/*     */     }
/*     */     catch (MissingResourceException mre) {
/*     */     }
/* 670 */     return mre.getLocalizedMessage() + ": [key='" + key + "']";
/*     */   }
/*     */ 
/*     */   public String getString(String base, String key, Object[] params)
/*     */     throws MissingResourceException
/*     */   {
/*     */     StringBuffer sb;
/*     */     try
/*     */     {
/* 693 */       ResourceBundle rb = PropertyResourceBundle.getBundle(base, Locale.getDefault(), Thread.currentThread().getContextClassLoader());
/* 694 */       String pattern = rb.getString(key);
/* 695 */       String msg = MessageFormat.format(pattern, params);
/* 696 */       return msg;
/*     */     }
/*     */     catch (MissingResourceException mre)
/*     */     {
/* 700 */       sb = new StringBuffer();
/* 701 */       for (int i = 0; i < params.length; i++)
/*     */       {
/* 703 */         sb.append(params[i] + ", ");
/*     */       }
/*     */     }
/* 705 */     return mre.getLocalizedMessage() + ": [key='" + key + "']" + sb.toString();
/*     */   }
/*     */ 
/*     */   protected synchronized String getResourceBundleString(String key)
/*     */     throws MissingResourceException
/*     */   {
/* 717 */     String resource = null;
/* 718 */     if (this.m_defaultResourceBundle == null)
/*     */     {
/* 720 */       throw new MissingResourceException("no default resource bundle set for this logger", null, null);
/*     */     }
/*     */ 
/*     */     try
/*     */     {
/* 726 */       resource = this.m_defaultResourceBundle.getString(key);
/*     */     }
/*     */     catch (MissingResourceException mre)
/*     */     {
/* 732 */       if (this.m_extraResourceBundles == null)
/*     */       {
/* 734 */         throw mre;
/*     */       }
/*     */ 
/* 738 */       for (int i = 0; i < this.m_extraResourceBundles.length; i++)
/*     */       {
/*     */         try
/*     */         {
/* 742 */           resource = this.m_extraResourceBundles[i].getString(key);
/*     */         }
/*     */         catch (MissingResourceException mre2)
/*     */         {
/* 746 */           mre = mre2;
/*     */         }
/*     */ 
/*     */       }
/*     */ 
/* 751 */       if (resource == null)
/*     */       {
/* 753 */         throw mre;
/*     */       }
/*     */ 
/*     */     }
/*     */ 
/* 758 */     return resource;
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     com.arjuna.common.internal.util.logging.AbstractLogImpl
 * JD-Core Version:    0.6.0
 */