/*     */ package com.arjuna.ats.txoj.common;
/*     */ 
/*     */ import java.io.File;
/*     */ import java.io.IOException;
/*     */ import java.io.InputStream;
/*     */ import java.io.PrintStream;
/*     */ import java.util.Properties;
/*     */ 
/*     */ public class Configuration
/*     */ {
/*     */   private static final Properties PROPS;
/*     */   private static String _lockStore;
/*     */   private static String _propFile;
/*     */ 
/*     */   public static final synchronized String propertiesFile()
/*     */   {
/*  58 */     return _propFile;
/*     */   }
/*     */ 
/*     */   public static final synchronized void setPropertiesFile(String file)
/*     */   {
/*  67 */     _propFile = file;
/*     */   }
/*     */ 
/*     */   public static final synchronized String lockStoreRoot()
/*     */   {
/*  78 */     if (_lockStore == null)
/*     */     {
/*  80 */       _lockStore = System.getProperty("user.dir") + File.separator + "LockStore";
/*     */     }
/*  82 */     System.err.println("Returning lockstore location of: " + _lockStore);
/*  83 */     return _lockStore;
/*     */   }
/*     */ 
/*     */   public static final synchronized void setLockStoreRoot(String s)
/*     */   {
/*  94 */     _lockStore = s;
/*     */   }
/*     */ 
/*     */   public static final String version()
/*     */   {
/*  99 */     return getBuildTimeProperty("TXOJ_VERSION");
/*     */   }
/*     */ 
/*     */   public static String getBuildTimeProperty(String name)
/*     */   {
/* 109 */     if (PROPS == null)
/*     */     {
/* 111 */       return "";
/*     */     }
/*     */ 
/* 115 */     return PROPS.getProperty(name, "");
/*     */   }
/*     */ 
/*     */   static
/*     */   {
/* 123 */     InputStream is = Configuration.class.getResourceAsStream("/txoj.properties");
/* 124 */     if (is != null)
/*     */     {
/* 126 */       Properties props = new Properties();
/*     */       try
/*     */       {
/* 129 */         props.load(is);
/*     */       }
/*     */       catch (IOException ioe)
/*     */       {
/* 133 */         props = null;
/*     */       }
/* 135 */       PROPS = props;
/*     */     }
/*     */     else
/*     */     {
/* 139 */       PROPS = null;
/*     */     }
/*     */ 
/* 143 */     _lockStore = null;
/* 144 */     _propFile = getBuildTimeProperty("PROPERTIES_FILE");
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     com.arjuna.ats.txoj.common.Configuration
 * JD-Core Version:    0.6.0
 */