/*     */ package com.arjuna.ats.txoj;
/*     */ 
/*     */ import com.arjuna.ats.arjuna.common.Uid;
/*     */ import com.arjuna.ats.arjuna.coordinator.AbstractRecord;
/*     */ import com.arjuna.ats.arjuna.coordinator.BasicAction;
/*     */ import com.arjuna.ats.arjuna.state.InputObjectState;
/*     */ import com.arjuna.ats.arjuna.state.OutputObjectState;
/*     */ import com.arjuna.ats.txoj.logging.txojLogger;
/*     */ import com.arjuna.common.util.logging.LogNoi18n;
/*     */ import com.arjuna.common.util.logging.Logi18n;
/*     */ import java.io.PrintWriter;
/*     */ import java.io.StringWriter;
/*     */ 
/*     */ class LockRecord extends AbstractRecord
/*     */ {
/*     */   protected BasicAction actionHandle;
/*     */   private LockManager managerAddress;
/*     */   private boolean readOnly;
/*     */   private String managerType;
/*     */ 
/*     */   public LockRecord(LockManager lm, BasicAction currAct)
/*     */   {
/*  69 */     super(lm.get_uid(), lm.type(), 1);
/*     */ 
/*  71 */     this.actionHandle = currAct;
/*     */ 
/*  73 */     this.managerAddress = lm;
/*  74 */     this.readOnly = false;
/*  75 */     this.managerType = lm.type();
/*     */   }
/*     */ 
/*     */   public LockRecord(LockManager lm, boolean rdOnly, BasicAction currAct)
/*     */   {
/*  80 */     super(lm.get_uid(), lm.type(), 1);
/*     */ 
/*  82 */     if (txojLogger.aitLogger.isDebugEnabled())
/*     */     {
/*  84 */       txojLogger.aitLogger.debug(1L, 4L, 10L, "LockRecord::LockRecord(" + lm.get_uid() + ", " + (this.readOnly ? "PREPARE_READONLY" : "WRITEABLE") + ")");
/*     */     }
/*     */ 
/*  90 */     this.actionHandle = currAct;
/*     */ 
/*  92 */     this.managerAddress = lm;
/*  93 */     this.readOnly = rdOnly;
/*  94 */     this.managerType = lm.type();
/*     */   }
/*     */ 
/*     */   public int typeIs()
/*     */   {
/*  99 */     return 121;
/*     */   }
/*     */ 
/*     */   public Object value()
/*     */   {
/* 104 */     return this.managerAddress;
/*     */   }
/*     */ 
/*     */   public void setValue(Object o)
/*     */   {
/* 109 */     if (txojLogger.aitLoggerI18N.isWarnEnabled())
/* 110 */       txojLogger.aitLoggerI18N.warn("com.arjuna.ats.txoj.LockRecord_1");
/*     */   }
/*     */ 
/*     */   public int nestedAbort()
/*     */   {
/* 115 */     if (txojLogger.aitLogger.isDebugEnabled())
/*     */     {
/* 117 */       txojLogger.aitLogger.debug(16L, 4L, 10L, "LockRecord::nestedAbort() for " + order());
/*     */     }
/*     */ 
/* 124 */     if (this.managerAddress == null) {
/* 125 */       return 8;
/*     */     }
/* 127 */     if (this.actionHandle != null)
/*     */     {
/* 129 */       Uid toRelease = this.actionHandle.get_uid();
/*     */ 
/* 131 */       this.actionHandle = this.actionHandle.parent();
/*     */ 
/* 133 */       if (!this.managerAddress.releaseAll(toRelease))
/*     */       {
/* 135 */         if (txojLogger.aitLoggerI18N.isWarnEnabled())
/*     */         {
/* 137 */           txojLogger.aitLoggerI18N.warn("com.arjuna.ats.txoj.LockRecord_2", new Object[] { toRelease });
/*     */         }
/*     */ 
/* 141 */         return 8;
/*     */       }
/*     */ 
/*     */     }
/* 145 */     else if (txojLogger.aitLoggerI18N.isWarnEnabled()) {
/* 146 */       txojLogger.aitLoggerI18N.warn("com.arjuna.ats.txoj.LockRecord_3");
/*     */     }
/* 148 */     return 7;
/*     */   }
/*     */ 
/*     */   public int nestedCommit()
/*     */   {
/* 153 */     if (txojLogger.aitLogger.isDebugEnabled())
/*     */     {
/* 155 */       txojLogger.aitLogger.debug(16L, 4L, 10L, "LockRecord::nestedCommit() for " + order());
/*     */     }
/*     */ 
/* 162 */     if (this.managerAddress == null) {
/* 163 */       return 8;
/*     */     }
/* 165 */     if (this.actionHandle != null)
/*     */     {
/* 167 */       Uid toRelease = this.actionHandle.get_uid();
/*     */ 
/* 169 */       this.actionHandle = this.actionHandle.parent();
/*     */ 
/* 171 */       return this.managerAddress.propagate(toRelease, this.actionHandle.get_uid()) ? 7 : 8;
/*     */     }
/*     */ 
/* 175 */     if (txojLogger.aitLoggerI18N.isWarnEnabled()) {
/* 176 */       txojLogger.aitLoggerI18N.warn("com.arjuna.ats.txoj.LockRecord_4");
/*     */     }
/*     */ 
/* 179 */     return 8;
/*     */   }
/*     */ 
/*     */   public int nestedPrepare()
/*     */   {
/* 184 */     if (txojLogger.aitLogger.isDebugEnabled())
/*     */     {
/* 186 */       txojLogger.aitLogger.debug(16L, 4L, 10L, "LockRecord::nestedPrepare() for " + order());
/*     */     }
/*     */ 
/* 191 */     return 0;
/*     */   }
/*     */ 
/*     */   public int topLevelAbort()
/*     */   {
/* 196 */     if (txojLogger.aitLogger.isDebugEnabled())
/*     */     {
/* 198 */       txojLogger.aitLogger.debug(16L, 4L, 10L, "LockRecord::topLevelAbort() for " + order());
/*     */     }
/*     */ 
/* 203 */     return nestedAbort();
/*     */   }
/*     */ 
/*     */   public int topLevelCommit()
/*     */   {
/* 208 */     if (txojLogger.aitLogger.isDebugEnabled())
/*     */     {
/* 210 */       txojLogger.aitLogger.debug(16L, 4L, 10L, "LockRecord::topLevelCommit() for " + order());
/*     */     }
/*     */ 
/* 217 */     if (this.managerAddress == null) {
/* 218 */       return 8;
/*     */     }
/* 220 */     if (this.actionHandle != null)
/*     */     {
/* 222 */       if (!this.managerAddress.releaseAll(this.actionHandle.get_uid()))
/*     */       {
/* 224 */         if (txojLogger.aitLoggerI18N.isWarnEnabled())
/*     */         {
/* 226 */           txojLogger.aitLoggerI18N.warn("com.arjuna.ats.txoj.LockRecord_5", new Object[] { this.actionHandle.get_uid() });
/*     */         }
/*     */ 
/* 230 */         return 8;
/*     */       }
/*     */     }
/*     */     else
/*     */     {
/* 235 */       if (txojLogger.aitLoggerI18N.isWarnEnabled()) {
/* 236 */         txojLogger.aitLoggerI18N.warn("com.arjuna.ats.txoj.LockRecord_6");
/*     */       }
/* 238 */       return 8;
/*     */     }
/*     */ 
/* 241 */     return 7;
/*     */   }
/*     */ 
/*     */   public int topLevelPrepare()
/*     */   {
/* 246 */     if (txojLogger.aitLogger.isDebugEnabled())
/*     */     {
/* 248 */       txojLogger.aitLogger.debug(16L, 4L, 10L, "LockRecord::topLevelPrepare() for " + order());
/*     */     }
/*     */ 
/* 253 */     if (this.readOnly)
/*     */     {
/* 255 */       if (topLevelCommit() == 7) {
/* 256 */         return 2;
/*     */       }
/* 258 */       return 1;
/*     */     }
/*     */ 
/* 261 */     return 0;
/*     */   }
/*     */ 
/*     */   public String toString()
/*     */   {
/* 266 */     StringWriter strm = new StringWriter();
/*     */ 
/* 268 */     print(new PrintWriter(strm));
/*     */ 
/* 270 */     return strm.toString();
/*     */   }
/*     */ 
/*     */   public void print(PrintWriter strm)
/*     */   {
/* 275 */     super.print(strm);
/* 276 */     strm.println("LockRecord");
/*     */   }
/*     */ 
/*     */   public boolean restore_state(InputObjectState o, int t)
/*     */   {
/* 286 */     if (txojLogger.aitLoggerI18N.isWarnEnabled())
/*     */     {
/* 288 */       txojLogger.aitLoggerI18N.warn("com.arjuna.ats.txoj.LockRecord_7", new Object[] { type(), order() });
/*     */     }
/*     */ 
/* 292 */     return false;
/*     */   }
/*     */ 
/*     */   public boolean save_state(OutputObjectState o, int t)
/*     */   {
/* 297 */     return true;
/*     */   }
/*     */ 
/*     */   public String type()
/*     */   {
/* 302 */     return "/StateManager/AbstractRecord/LockRecord";
/*     */   }
/*     */ 
/*     */   public final boolean isReadOnly()
/*     */   {
/* 307 */     return this.readOnly;
/*     */   }
/*     */ 
/*     */   public final String lockType()
/*     */   {
/* 312 */     return this.managerType;
/*     */   }
/*     */ 
/*     */   public void merge(AbstractRecord a)
/*     */   {
/*     */   }
/*     */ 
/*     */   public void alter(AbstractRecord a)
/*     */   {
/*     */   }
/*     */ 
/*     */   public boolean shouldAdd(AbstractRecord a)
/*     */   {
/* 325 */     return false;
/*     */   }
/*     */ 
/*     */   public boolean shouldAlter(AbstractRecord a)
/*     */   {
/* 330 */     return false;
/*     */   }
/*     */ 
/*     */   public boolean shouldMerge(AbstractRecord a)
/*     */   {
/* 335 */     return false;
/*     */   }
/*     */ 
/*     */   public boolean shouldReplace(AbstractRecord ar)
/*     */   {
/* 340 */     if ((order().equals(ar.order())) && (typeIs() == ar.typeIs()))
/*     */     {
/* 346 */       if ((((LockRecord)ar).isReadOnly()) && (!this.readOnly)) {
/* 347 */         return true;
/*     */       }
/*     */     }
/* 350 */     return false;
/*     */   }
/*     */ 
/*     */   protected LockRecord()
/*     */   {
/* 357 */     if (txojLogger.aitLogger.isDebugEnabled())
/*     */     {
/* 359 */       txojLogger.aitLogger.debug(1L, 2L, 10L, "LockRecord::LockRecord()");
/*     */     }
/*     */ 
/* 364 */     this.actionHandle = null;
/*     */ 
/* 366 */     this.managerAddress = null;
/* 367 */     this.readOnly = false;
/* 368 */     this.managerType = null;
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     com.arjuna.ats.txoj.LockRecord
 * JD-Core Version:    0.6.0
 */