/*      */ package com.arjuna.ats.txoj;
/*      */ 
/*      */ import com.arjuna.ats.arjuna.StateManager;
/*      */ import com.arjuna.ats.arjuna.StateManagerAttribute;
/*      */ import com.arjuna.ats.arjuna.common.Uid;
/*      */ import com.arjuna.ats.arjuna.coordinator.AbstractRecord;
/*      */ import com.arjuna.ats.arjuna.coordinator.ActionHierarchy;
/*      */ import com.arjuna.ats.arjuna.coordinator.BasicAction;
/*      */ import com.arjuna.ats.arjuna.gandiva.ObjectName;
/*      */ import com.arjuna.ats.arjuna.state.InputObjectState;
/*      */ import com.arjuna.ats.arjuna.state.OutputObjectState;
/*      */ import com.arjuna.ats.txoj.common.txojPropertyManager;
/*      */ import com.arjuna.ats.txoj.exceptions.LockStoreException;
/*      */ import com.arjuna.ats.txoj.lockstore.LockStore;
/*      */ import com.arjuna.ats.txoj.logging.txojLogger;
/*      */ import com.arjuna.ats.txoj.semaphore.Semaphore;
/*      */ import com.arjuna.common.util.logging.LogNoi18n;
/*      */ import com.arjuna.common.util.logging.Logi18n;
/*      */ import com.arjuna.common.util.propertyservice.PropertyManager;
/*      */ import java.io.IOException;
/*      */ import java.io.PrintWriter;
/*      */ import java.util.Enumeration;
/*      */ import java.util.Hashtable;
/*      */ 
/*      */ public class LockManager extends StateManager
/*      */ {
/*      */   public static final int defaultRetry = 100;
/*      */   public static final int defaultSleepTime = 250;
/*      */   public static final int waitTotalTimeout = -100;
/*      */   protected LockManagerAttribute lmAttributes;
/*      */   private String systemKey;
/*      */   private LockList locksHeld;
/*      */   private LockStore lockStore;
/*      */   private boolean stateLoaded;
/*      */   private boolean hasBeenLocked;
/*      */   private boolean objectLocked;
/*      */   private Semaphore mutex;
/*      */   private LockConflictManager conflictManager;
/*      */   private static final int DOZE_TIME = 1000000;
/* 1377 */   private static boolean nestedLocking = true;
/*      */ 
/*      */   public void finalize()
/*      */     throws Throwable
/*      */   {
/*  122 */     if (txojLogger.aitLogger.isDebugEnabled())
/*      */     {
/*  124 */       txojLogger.aitLogger.debug(2L, 4L, 2L, "LockManager.finalize()");
/*      */     }
/*      */ 
/*  128 */     boolean doSignal = false;
/*      */ 
/*  130 */     cleanUp();
/*      */ 
/*  132 */     if (this.mutex != null)
/*      */     {
/*  134 */       if (this.mutex.lock() == 0) {
/*  135 */         doSignal = true;
/*      */       }
/*      */     }
/*  138 */     this.lmAttributes = null;
/*  139 */     this.locksHeld = null;
/*  140 */     this.lockStore = null;
/*  141 */     this.conflictManager = null;
/*      */ 
/*  143 */     if (doSignal) {
/*  144 */       this.mutex.unlock();
/*      */     }
/*  146 */     this.mutex = null;
/*      */ 
/*  148 */     super.finalize();
/*      */   }
/*      */ 
/*      */   public final boolean propagate(Uid from, Uid to)
/*      */   {
/*  162 */     if (txojLogger.aitLogger.isDebugEnabled())
/*      */     {
/*  164 */       txojLogger.aitLogger.debug(16L, 4L, 2L, "LockManager::propagate(" + from + ", " + to + ")");
/*      */     }
/*      */ 
/*  169 */     boolean result = false;
/*  170 */     int retryCount = 10;
/*      */     do
/*      */     {
/*      */       try
/*      */       {
/*  176 */         synchronized (this.locksHeld)
/*      */         {
/*  178 */           if (loadState())
/*      */           {
/*  180 */             LockList oldlist = this.locksHeld;
/*  181 */             Lock current = null;
/*      */ 
/*  183 */             this.locksHeld = new LockList();
/*      */ 
/*  185 */             if (this.locksHeld != null)
/*      */             {
/*  192 */               while ((current = oldlist.pop()) != null)
/*      */               {
/*  194 */                 if (current.getCurrentOwner().equals(from))
/*      */                 {
/*  196 */                   current.propagate();
/*      */                 }
/*      */ 
/*  199 */                 if (this.locksHeld.insert(current))
/*      */                   continue;
/*  201 */                 current = null;
/*      */               }
/*      */ 
/*  205 */               oldlist = null;
/*      */ 
/*  207 */               result = true;
/*      */             }
/*      */             else
/*      */             {
/*  216 */               freeState();
/*      */ 
/*  218 */               throw new NullPointerException();
/*      */             }
/*      */           }
/*      */ 
/*  222 */           if (result)
/*  223 */             result = unloadState();
/*      */         }
/*      */       }
/*      */       catch (NullPointerException e)
/*      */       {
/*  228 */         result = false;
/*      */       }
/*      */ 
/*  231 */       if (!result)
/*      */       {
/*      */         try
/*      */         {
/*  235 */           Thread.sleep(1000000L);
/*      */         }
/*      */         catch (InterruptedException e)
/*      */         {
/*      */         }
/*      */       }
/*      */ 
/*  242 */       if (result) break; retryCount--; } while (retryCount > 0);
/*      */ 
/*  244 */     if (!result)
/*      */     {
/*  246 */       if (txojLogger.aitLoggerI18N.isWarnEnabled())
/*      */       {
/*  248 */         txojLogger.aitLoggerI18N.warn("com.arjuna.ats.txoj.LockManager_1");
/*      */       }
/*      */ 
/*  251 */       synchronized (this.locksHeld)
/*      */       {
/*  253 */         freeState();
/*      */       }
/*      */     }
/*      */ 
/*  257 */     return result;
/*      */   }
/*      */ 
/*      */   public final boolean releaseAll(Uid actionUid)
/*      */   {
/*  268 */     if (txojLogger.aitLogger.isDebugEnabled())
/*      */     {
/*  270 */       txojLogger.aitLogger.debug(16L, 4L, 2L, "LockManager::releaseAll(" + actionUid + ")");
/*      */     }
/*      */ 
/*  275 */     return doRelease(actionUid, true);
/*      */   }
/*      */ 
/*      */   public final boolean releaselock(Uid lockUid)
/*      */   {
/*  285 */     if (txojLogger.aitLogger.isDebugEnabled())
/*      */     {
/*  287 */       txojLogger.aitLogger.debug(16L, 4L, 2L, "LockManager::releaseLock(" + lockUid + ")");
/*      */     }
/*      */ 
/*  291 */     return doRelease(lockUid, false);
/*      */   }
/*      */ 
/*      */   public final int setlock(Lock toSet)
/*      */   {
/*  306 */     return setlock(toSet, 100, 250);
/*      */   }
/*      */ 
/*      */   public final int setlock(Lock toSet, int retry)
/*      */   {
/*  321 */     return setlock(toSet, retry, 250);
/*      */   }
/*      */ 
/*      */   public final int setlock(Lock toSet, int retry, int sleepTime)
/*      */   {
/*  335 */     if (txojLogger.aitLogger.isDebugEnabled())
/*      */     {
/*  337 */       txojLogger.aitLogger.debug(16L, 4L, 2L, "LockManager::setlock(" + toSet + ", " + retry + ", " + sleepTime + ")");
/*      */     }
/*      */ 
/*  342 */     int conflict = 0;
/*  343 */     int returnStatus = 1;
/*  344 */     LockRecord newLockR = null;
/*  345 */     boolean modifyRequired = false;
/*  346 */     BasicAction currAct = null;
/*      */ 
/*  348 */     if (toSet == null)
/*      */     {
/*  350 */       if (txojLogger.aitLoggerI18N.isWarnEnabled())
/*      */       {
/*  352 */         txojLogger.aitLoggerI18N.warn("com.arjuna.ats.txoj.LockManager_2");
/*      */       }
/*      */ 
/*  355 */       return 1;
/*      */     }
/*      */ 
/*  358 */     currAct = BasicAction.Current();
/*      */ 
/*  360 */     if (currAct != null)
/*      */     {
/*  362 */       ActionHierarchy ah = currAct.getHierarchy();
/*      */ 
/*  364 */       if (ah != null) {
/*  365 */         toSet.changeHierarchy(ah);
/*      */       }
/*      */       else {
/*  368 */         if (txojLogger.aitLoggerI18N.isWarnEnabled())
/*      */         {
/*  370 */           txojLogger.aitLoggerI18N.warn("com.arjuna.ats.txoj.LockManager_3");
/*      */         }
/*      */ 
/*  373 */         toSet = null;
/*      */ 
/*  375 */         return 1;
/*      */       }
/*      */     }
/*      */ 
/*  379 */     if (super.loadObjectState()) {
/*  380 */       super.setupStore();
/*      */     }
/*  382 */     while ((conflict == 0) && ((retry >= 0) || (retry == -100)))
/*      */     {
/*  384 */       synchronized (this.locksHeld)
/*      */       {
/*  386 */         conflict = 0;
/*      */ 
/*  388 */         if (loadState())
/*      */         {
/*  390 */           conflict = lockConflict(toSet);
/*      */         }
/*  394 */         else if (txojLogger.aitLoggerI18N.isWarnEnabled())
/*      */         {
/*  396 */           txojLogger.aitLoggerI18N.warn("com.arjuna.ats.txoj.LockManager_4");
/*      */         }
/*      */ 
/*  400 */         if (conflict != 0)
/*      */         {
/*  409 */           modifyRequired = toSet.modifiesObject();
/*      */ 
/*  413 */           if (super.activate())
/*      */           {
/*  415 */             returnStatus = 0;
/*      */ 
/*  417 */             if (conflict == 1)
/*      */             {
/*  419 */               int lrStatus = 2;
/*      */ 
/*  421 */               if (currAct != null)
/*      */               {
/*  425 */                 newLockR = new LockRecord(this, !modifyRequired, currAct);
/*      */ 
/*  427 */                 if ((lrStatus = currAct.add(newLockR)) != 2)
/*      */                 {
/*  429 */                   newLockR = null;
/*      */ 
/*  431 */                   if (lrStatus == 3) {
/*  432 */                     returnStatus = 1;
/*      */                   }
/*      */                 }
/*      */               }
/*  436 */               if (returnStatus == 0)
/*      */               {
/*  438 */                 this.locksHeld.insert(toSet);
/*      */               }
/*      */ 
/*      */             }
/*      */ 
/*      */           }
/*      */           else
/*      */           {
/*  446 */             if (txojLogger.aitLoggerI18N.isWarnEnabled())
/*      */             {
/*  448 */               txojLogger.aitLoggerI18N.warn("com.arjuna.ats.txoj.LockManager_5");
/*      */             }
/*      */ 
/*  451 */             returnStatus = 1;
/*      */           }
/*      */ 
/*      */         }
/*      */ 
/*  462 */         if ((returnStatus == 0) && (conflict == 1))
/*      */         {
/*  464 */           if (!unloadState())
/*      */           {
/*  466 */             if (txojLogger.aitLoggerI18N.isWarnEnabled())
/*      */             {
/*  468 */               txojLogger.aitLoggerI18N.warn("com.arjuna.ats.txoj.LockManager_6");
/*      */             }
/*      */ 
/*  471 */             returnStatus = 1;
/*      */           }
/*      */         }
/*      */         else {
/*  475 */           freeState();
/*      */         }
/*      */ 
/*  484 */         if (returnStatus == 0)
/*      */         {
/*  486 */           if (modifyRequired)
/*      */           {
/*  488 */             if (super.modified()) {
/*  489 */               this.hasBeenLocked = true;
/*      */             }
/*      */             else {
/*  492 */               conflict = 0;
/*      */ 
/*  494 */               returnStatus = 1;
/*      */             }
/*      */ 
/*      */           }
/*      */ 
/*      */         }
/*      */ 
/*  503 */         if (conflict == 0) {
/*  504 */           freeState();
/*      */         }
/*      */       }
/*  507 */       if (conflict != 0)
/*      */         continue;
/*  509 */       if (retry != 0)
/*      */       {
/*  511 */         if (sleepTime > 0)
/*      */         {
/*  513 */           sleepTime -= this.conflictManager.wait(retry, sleepTime);
/*      */         }
/*      */         else {
/*  516 */           retry = 0;
/*      */         }
/*      */       }
/*  519 */       if (retry != -100) {
/*  520 */         retry--;
/*      */       }
/*      */     }
/*      */ 
/*  524 */     return returnStatus;
/*      */   }
/*      */ 
/*      */   public void print(PrintWriter strm)
/*      */   {
/*  534 */     LockListIterator next = new LockListIterator(this.locksHeld);
/*      */ 
/*  537 */     strm.println("LocalLockManager for object " + get_uid());
/*      */ 
/*  539 */     if (!this.stateLoaded) {
/*  540 */       strm.println("No loaded state");
/*      */     } else {
/*  542 */       if (this.locksHeld != null)
/*      */       {
/*  544 */         strm.println("\tCurrently holding : " + this.locksHeld.entryCount() + " locks");
/*      */         Lock current;
/*  546 */         while ((current = next.iterate()) != null) {
/*  547 */           current.print(strm);
/*      */         }
/*      */       }
/*  550 */       strm.println("Currently holding : 0 locks");
/*      */     }
/*      */   }
/*      */ 
/*      */   public synchronized void printState(PrintWriter strm)
/*      */   {
/*  559 */     synchronized (this.locksHeld)
/*      */     {
/*  561 */       boolean iDeleteState = false;
/*      */ 
/*  563 */       if (!this.stateLoaded)
/*      */       {
/*  565 */         loadState();
/*  566 */         iDeleteState = true;
/*      */       }
/*      */ 
/*  569 */       print(strm);
/*      */ 
/*  571 */       if (iDeleteState)
/*  572 */         freeState();
/*      */     }
/*      */   }
/*      */ 
/*      */   public String type()
/*      */   {
/*  582 */     return "StateManager/LockManager";
/*      */   }
/*      */ 
/*      */   public Object attributes()
/*      */   {
/*  594 */     return this.lmAttributes;
/*      */   }
/*      */ 
/*      */   protected LockManager(Uid storeUid)
/*      */   {
/*  607 */     this(storeUid, 1, null);
/*      */   }
/*      */ 
/*      */   protected LockManager(Uid storeUid, ObjectName attr)
/*      */   {
/*  612 */     this(storeUid, 1, attr);
/*      */   }
/*      */ 
/*      */   protected LockManager(Uid storeUid, int ot)
/*      */   {
/*  617 */     this(storeUid, ot, null);
/*      */   }
/*      */ 
/*      */   protected LockManager(Uid storeUid, int ot, ObjectName attr)
/*      */   {
/*  622 */     super(storeUid, ot, attr);
/*      */ 
/*  624 */     if (txojLogger.aitLogger.isDebugEnabled())
/*      */     {
/*  626 */       txojLogger.aitLogger.debug(1L, 2L, 2L, "LockManager::LockManager(" + storeUid + ")");
/*      */     }
/*      */ 
/*  631 */     parseObjectName();
/*      */ 
/*  633 */     this.systemKey = null;
/*  634 */     this.locksHeld = new LockList();
/*  635 */     this.lockStore = null;
/*  636 */     this.mutex = null;
/*  637 */     this.stateLoaded = false;
/*  638 */     this.hasBeenLocked = false;
/*  639 */     this.objectLocked = false;
/*  640 */     this.conflictManager = new LockConflictManager();
/*      */   }
/*      */ 
/*      */   protected LockManager()
/*      */   {
/*  653 */     this(0, null);
/*      */   }
/*      */ 
/*      */   protected LockManager(int ot)
/*      */   {
/*  658 */     this(ot, null);
/*      */   }
/*      */ 
/*      */   protected LockManager(int ot, ObjectName attr)
/*      */   {
/*  663 */     super(ot, attr);
/*      */ 
/*  665 */     if (txojLogger.aitLogger.isDebugEnabled())
/*      */     {
/*  667 */       txojLogger.aitLogger.debug(1L, 2L, 2L, "LockManager::LockManager(" + ot + ")");
/*      */     }
/*      */ 
/*  671 */     parseObjectName();
/*      */ 
/*  673 */     this.systemKey = null;
/*  674 */     this.locksHeld = new LockList();
/*  675 */     this.lockStore = null;
/*  676 */     this.mutex = null;
/*  677 */     this.stateLoaded = false;
/*  678 */     this.hasBeenLocked = false;
/*  679 */     this.objectLocked = false;
/*  680 */     this.conflictManager = new LockConflictManager();
/*      */   }
/*      */ 
/*      */   protected void terminate()
/*      */   {
/*  691 */     if (txojLogger.aitLogger.isDebugEnabled())
/*      */     {
/*  693 */       txojLogger.aitLogger.debug(16L, 2L, 2L, "LockManager::terminate() for object-id " + get_uid());
/*      */     }
/*      */ 
/*  698 */     cleanUp();
/*  699 */     super.terminate();
/*      */   }
/*      */ 
/*      */   private final synchronized void cleanUp()
/*      */   {
/*  704 */     if (txojLogger.aitLogger.isDebugEnabled())
/*      */     {
/*  706 */       txojLogger.aitLogger.debug(16L, 1L, 2L, "LockManager::cleanUp() for object-id " + get_uid());
/*      */     }
/*      */ 
/*  711 */     if (this.hasBeenLocked)
/*      */     {
/*  713 */       if ((this.smAttributes.objectModel == 1) && (this.systemKey == null))
/*      */       {
/*  716 */         initialise();
/*      */       }
/*      */ 
/*  726 */       synchronized (this.usingActions)
/*      */       {
/*  728 */         if (this.usingActions != null)
/*      */         {
/*  730 */           Enumeration e = this.usingActions.keys();
/*      */ 
/*  732 */           while (e.hasMoreElements())
/*      */           {
/*  734 */             BasicAction action = (BasicAction)e.nextElement();
/*      */ 
/*  736 */             while (action != null)
/*      */             {
/*  752 */               AbstractRecord A = new CadaverLockRecord(this.lockStore, this, action);
/*      */ 
/*  754 */               if (action.add(A) != 2) {
/*  755 */                 A = null;
/*      */               }
/*      */             }
/*      */           }
/*      */         }
/*      */       }
/*  761 */       this.hasBeenLocked = false;
/*      */     }
/*      */   }
/*      */ 
/*      */   private final boolean doRelease(Uid u, boolean all)
/*      */   {
/*  776 */     if (txojLogger.aitLogger.isDebugEnabled())
/*      */     {
/*  778 */       txojLogger.aitLogger.debug(16L, 1L, 2L, "LockManager::doRelease(" + u + ", " + all + ")");
/*      */     }
/*      */ 
/*  783 */     Lock previous = null;
/*  784 */     Lock current = null;
/*  785 */     boolean deleted = false;
/*  786 */     boolean result = false;
/*  787 */     int retryCount = 10;
/*  788 */     boolean loaded = false;
/*      */     do
/*      */     {
/*  792 */       synchronized (this.locksHeld)
/*      */       {
/*  794 */         if (loadState())
/*      */         {
/*  796 */           loaded = true;
/*      */ 
/*  803 */           LockListIterator next = new LockListIterator(this.locksHeld);
/*      */ 
/*  812 */           previous = null;
/*      */ 
/*  814 */           while ((current = next.iterate()) != null)
/*      */           {
/*  816 */             Uid checkUid = null;
/*      */ 
/*  818 */             if (all)
/*  819 */               checkUid = current.getCurrentOwner();
/*      */             else {
/*  821 */               checkUid = current.get_uid();
/*      */             }
/*      */ 
/*  827 */             if (u.equals(checkUid))
/*      */             {
/*  829 */               this.locksHeld.forgetNext(previous);
/*  830 */               current = null;
/*  831 */               deleted = true;
/*      */ 
/*  833 */               if (!all)
/*      */               {
/*  835 */                 break;
/*      */               }
/*      */             }
/*      */             else {
/*  839 */               previous = current;
/*      */             }
/*      */           }
/*  842 */           result = true;
/*      */         }
/*      */         else
/*      */         {
/*  850 */           freeState();
/*      */ 
/*  852 */           result = false;
/*      */         }
/*      */       }
/*      */ 
/*  856 */       if (!result)
/*      */       {
/*      */         try
/*      */         {
/*  860 */           Thread.sleep(1000000L);
/*      */         }
/*      */         catch (InterruptedException e)
/*      */         {
/*      */         }
/*      */       }
/*      */ 
/*  867 */       if (result) break; retryCount--; } while (retryCount > 0);
/*      */ 
/*  869 */     boolean releasedOK = false;
/*      */ 
/*  872 */     if (!loaded)
/*      */     {
/*  874 */       if (txojLogger.aitLoggerI18N.isWarnEnabled()) {
/*  875 */         txojLogger.aitLoggerI18N.warn("com.arjuna.ats.txoj.LockManager_7");
/*      */       }
/*      */ 
/*      */     }
/*      */     else
/*      */     {
/*  882 */       if (!deleted)
/*      */       {
/*  884 */         if (txojLogger.aitLogger.isDebugEnabled())
/*      */         {
/*  886 */           txojLogger.aitLogger.debug(16L, 1L, 2L, " *** CANNOT locate locks  ***");
/*      */         }
/*      */ 
/*      */       }
/*      */ 
/*  892 */       retryCount = 10;
/*      */ 
/*  894 */       synchronized (this.locksHeld)
/*      */       {
/*      */         do
/*      */         {
/*  898 */           if (!unloadState())
/*      */           {
/*  900 */             if (txojLogger.aitLoggerI18N.isWarnEnabled())
/*  901 */               txojLogger.aitLoggerI18N.warn("com.arjuna.ats.txoj.LockManager_8");
/*      */           }
/*      */           else {
/*  904 */             releasedOK = true;
/*      */           }
/*  906 */           retryCount--; if (retryCount <= 0) break; 
/*  906 */         }while (!releasedOK);
/*      */       }
/*      */ 
/*      */     }
/*      */ 
/*  915 */     this.conflictManager.signal();
/*      */ 
/*  917 */     return releasedOK;
/*      */   }
/*      */ 
/*      */   private final void freeState()
/*      */   {
/*  930 */     if (txojLogger.aitLogger.isDebugEnabled())
/*      */     {
/*  932 */       txojLogger.aitLogger.debug(16L, 1L, 2L, "LockManager::freeState()");
/*      */     }
/*      */ 
/*  936 */     if (this.mutex != null)
/*      */     {
/*  943 */       if (this.smAttributes.objectModel != 0)
/*      */       {
/*  947 */         while (this.locksHeld.pop() != null);
/*  949 */         this.stateLoaded = false;
/*      */ 
/*  951 */         if (this.objectLocked)
/*      */         {
/*  953 */           this.objectLocked = false;
/*      */ 
/*  955 */           this.mutex.unlock();
/*      */         }
/*      */       }
/*      */       else {
/*  959 */         this.stateLoaded = false;
/*      */       }
/*      */     }
/*      */     else {
/*  963 */       this.stateLoaded = false;
/*  964 */       this.objectLocked = false;
/*      */     }
/*      */   }
/*      */ 
/*      */   private final boolean initialise()
/*      */   {
/*  977 */     if (txojLogger.aitLogger.isDebugEnabled())
/*      */     {
/*  979 */       txojLogger.aitLogger.debug(16L, 1L, 2L, "LockManager::initialise()");
/*      */     }
/*      */ 
/*  983 */     boolean result = false;
/*      */ 
/*  985 */     if (this.systemKey == null)
/*      */     {
/*  987 */       this.systemKey = type();
/*      */ 
/*  989 */       if (this.mutex == null)
/*      */       {
/*  991 */         this.mutex = new Semaphore(this.systemKey);
/*      */       }
/*      */ 
/*  994 */       if (this.mutex != null)
/*      */       {
/*  996 */         if (this.mutex.lock() == 0)
/*      */         {
/*  998 */           if (this.lockStore == null)
/*      */           {
/* 1000 */             Object[] param = new Object[3];
/*      */ 
/* 1002 */             param[0] = this.lmAttributes.lockStoreType;
/* 1003 */             param[1] = new Integer(1);
/* 1004 */             param[2] = this.systemKey;
/*      */ 
/* 1006 */             this.lockStore = new LockStore(param);
/*      */ 
/* 1008 */             param = null;
/*      */           }
/*      */         }
/*      */ 
/* 1012 */         this.mutex.unlock();
/*      */       }
/*      */     }
/*      */ 
/* 1016 */     result = this.lockStore != null;
/*      */ 
/* 1018 */     return result;
/*      */   }
/*      */ 
/*      */   private final boolean isAncestorOf(Lock heldLock)
/*      */   {
/* 1023 */     if (txojLogger.aitLogger.isDebugEnabled())
/*      */     {
/* 1025 */       txojLogger.aitLogger.debug(16L, 1L, 2L, "LockManager::isAncestorOf(" + heldLock.getCurrentOwner() + ")");
/*      */     }
/*      */ 
/* 1030 */     BasicAction action = BasicAction.Current();
/*      */ 
/* 1032 */     if (action == null) {
/* 1033 */       return false;
/*      */     }
/* 1035 */     return action.isAncestor(heldLock.getCurrentOwner());
/*      */   }
/*      */ 
/*      */   private final boolean loadState()
/*      */   {
/* 1052 */     if (txojLogger.aitLogger.isDebugEnabled())
/*      */     {
/* 1054 */       txojLogger.aitLogger.debug(16L, 1L, 2L, "LockManager::loadState()");
/*      */     }
/*      */ 
/* 1058 */     if (this.smAttributes.objectModel == 0)
/*      */     {
/* 1060 */       this.stateLoaded = true;
/*      */ 
/* 1062 */       return true;
/*      */     }
/*      */ 
/* 1066 */     InputObjectState S = null;
/*      */ 
/* 1068 */     if ((this.systemKey == null) && (!initialise()))
/*      */     {
/* 1070 */       return false;
/*      */     }
/*      */ 
/* 1073 */     if ((this.mutex == null) || (this.mutex.lock() != 0))
/*      */     {
/* 1075 */       return false;
/*      */     }
/*      */ 
/* 1078 */     this.stateLoaded = false;
/* 1079 */     this.objectLocked = true;
/*      */     try
/*      */     {
/* 1088 */       S = this.lockStore.read_state(get_uid(), type());
/*      */ 
/* 1092 */       if (S != null)
/*      */       {
/* 1094 */         Uid u = new Uid(Uid.nullUid());
/* 1095 */         Lock current = null;
/* 1096 */         int count = 0;
/*      */         try
/*      */         {
/* 1100 */           count = S.unpackInt();
/*      */ 
/* 1102 */           boolean cleanLoad = true;
/*      */ 
/* 1104 */           if (txojLogger.aitLogger.isDebugEnabled())
/*      */           {
/* 1106 */             txojLogger.aitLogger.debug(16L, 1L, 2L, "LockManager::loadState() loading " + count + " lock(s)");
/*      */           }
/*      */ 
/* 1116 */           for (int i = 0; (i < count) && (cleanLoad); i++)
/*      */           {
/*      */             try
/*      */             {
/* 1120 */               u.unpack(S);
/* 1121 */               current = new Lock(u);
/*      */ 
/* 1123 */               if (current != null)
/*      */               {
/* 1125 */                 if (current.restore_state(S, 1))
/*      */                 {
/* 1127 */                   this.locksHeld.push(current);
/*      */                 }
/*      */                 else
/*      */                 {
/* 1131 */                   current = null;
/* 1132 */                   cleanLoad = false;
/*      */                 }
/*      */               }
/*      */               else
/* 1136 */                 cleanLoad = false;
/*      */             }
/*      */             catch (IOException e)
/*      */             {
/* 1140 */               cleanLoad = false;
/*      */             }
/*      */           }
/*      */ 
/* 1144 */           if (cleanLoad) {
/* 1145 */             this.stateLoaded = true;
/*      */           }
/*      */           else {
/* 1148 */             while ((current = this.locksHeld.pop()) != null) {
/* 1149 */               current = null;
/*      */             }
/*      */           }
/*      */         }
/*      */         catch (IOException e)
/*      */         {
/*      */         }
/* 1156 */         S = null;
/*      */       }
/*      */       else {
/* 1159 */         this.stateLoaded = true;
/*      */       }
/*      */     }
/*      */     catch (LockStoreException e) {
/* 1163 */       if (txojLogger.aitLogger.isWarnEnabled()) {
/* 1164 */         txojLogger.aitLogger.warn(e.getMessage());
/*      */       }
/*      */     }
/*      */ 
/* 1168 */     return this.stateLoaded;
/*      */   }
/*      */ 
/*      */   private final int lockConflict(Lock otherLock)
/*      */   {
/* 1180 */     if (txojLogger.aitLogger.isDebugEnabled())
/*      */     {
/* 1182 */       txojLogger.aitLogger.debug(16L, 1L, 2L, "LockManager::lockConflict(" + otherLock.get_uid() + ")");
/*      */     }
/*      */ 
/* 1187 */     boolean matching = false;
/* 1188 */     Lock heldLock = null;
/* 1189 */     LockListIterator next = new LockListIterator(this.locksHeld);
/*      */ 
/* 1191 */     while ((heldLock = next.iterate()) != null)
/*      */     {
/* 1193 */       if (heldLock.conflictsWith(otherLock))
/*      */       {
/* 1195 */         if (nestedLocking)
/*      */         {
/* 1197 */           if (!isAncestorOf(heldLock))
/*      */           {
/* 1199 */             return 0;
/*      */           }
/*      */         }
/*      */ 
/* 1203 */         return 0;
/*      */       }
/*      */ 
/* 1207 */       if (heldLock.equals(otherLock)) {
/* 1208 */         matching = true;
/*      */       }
/*      */     }
/*      */ 
/* 1212 */     return matching ? 2 : 1;
/*      */   }
/*      */ 
/*      */   private final boolean unloadState()
/*      */   {
/* 1222 */     if (txojLogger.aitLogger.isDebugEnabled())
/*      */     {
/* 1224 */       txojLogger.aitLogger.debug(16L, 1L, 2L, "LockManager::unloadState()");
/*      */     }
/*      */ 
/* 1233 */     if (this.smAttributes.objectModel == 0)
/*      */     {
/* 1235 */       this.stateLoaded = false;
/*      */ 
/* 1237 */       return true;
/*      */     }
/*      */ 
/* 1241 */     boolean unloadOk = false;
/* 1242 */     Lock current = null;
/* 1243 */     String otype = type();
/* 1244 */     Uid u = get_uid();
/* 1245 */     OutputObjectState S = new OutputObjectState(u, otype);
/* 1246 */     int lockCount = this.locksHeld.entryCount();
/*      */ 
/* 1250 */     if (txojLogger.aitLogger.isDebugEnabled())
/*      */     {
/* 1252 */       txojLogger.aitLogger.debug(16L, 1L, 2L, "LockManager::unloadState() unloading " + lockCount + " lock(s)");
/*      */     }
/*      */ 
/* 1258 */     if (lockCount == 0)
/*      */     {
/* 1260 */       if (this.lockStore.remove_state(u, otype))
/*      */       {
/* 1262 */         unloadOk = true;
/*      */       }
/* 1266 */       else if (txojLogger.aitLoggerI18N.isWarnEnabled())
/*      */       {
/* 1268 */         txojLogger.aitLoggerI18N.warn("com.arjuna.ats.txoj.LockManager_10", new Object[] { u, otype });
/*      */       }
/*      */ 
/*      */     }
/*      */     else
/*      */     {
/*      */       try
/*      */       {
/* 1279 */         S.packInt(lockCount);
/*      */ 
/* 1281 */         while ((current = this.locksHeld.pop()) != null)
/*      */         {
/* 1283 */           current.get_uid().pack(S);
/*      */ 
/* 1285 */           if (!current.save_state(S, 1))
/*      */           {
/* 1287 */             if (txojLogger.aitLoggerI18N.isWarnEnabled())
/*      */             {
/* 1289 */               txojLogger.aitLoggerI18N.warn("com.arjuna.ats.txoj.LockManager_11", new Object[] { current });
/*      */             }
/*      */ 
/* 1292 */             unloadOk = false;
/*      */           }
/*      */ 
/* 1295 */           current = null;
/*      */         }
/*      */ 
/* 1298 */         if (unloadOk)
/*      */         {
/* 1302 */           if ((S.valid()) && (this.lockStore.write_committed(u, otype, S)))
/*      */           {
/* 1304 */             unloadOk = true;
/*      */           }
/* 1308 */           else if (txojLogger.aitLoggerI18N.isWarnEnabled())
/*      */           {
/* 1310 */             txojLogger.aitLoggerI18N.warn("com.arjuna.ats.txoj.LockManager_12", new Object[] { u, otype });
/*      */           }
/*      */ 
/*      */         }
/*      */ 
/*      */       }
/*      */       catch (IOException e)
/*      */       {
/* 1318 */         unloadOk = false;
/*      */ 
/* 1320 */         if (txojLogger.aitLoggerI18N.isWarnEnabled())
/*      */         {
/* 1322 */           txojLogger.aitLoggerI18N.warn("com.arjuna.ats.txoj.LockManager_13", new Object[] { u, otype });
/*      */         }
/*      */       }
/*      */ 
/*      */     }
/*      */ 
/* 1328 */     this.stateLoaded = false;
/*      */ 
/* 1330 */     if (this.objectLocked)
/*      */     {
/* 1332 */       this.objectLocked = false;
/*      */ 
/* 1334 */       if (this.mutex != null) {
/* 1335 */         this.mutex.unlock();
/*      */       }
/*      */     }
/* 1338 */     return unloadOk;
/*      */   }
/*      */ 
/*      */   private void parseObjectName()
/*      */   {
/* 1344 */     this.lmAttributes = new LockManagerAttribute();
/*      */ 
/* 1346 */     if (this.objectName != null)
/*      */     {
/*      */       try
/*      */       {
/* 1354 */         this.lmAttributes.lockStoreType = this.objectName.getClassNameAttribute("com.arjuna.ats.txoj.lockstore.lockStoreType");
/*      */       }
/*      */       catch (Exception e)
/*      */       {
/*      */       }
/*      */     }
/*      */   }
/*      */ 
/*      */   static
/*      */   {
/* 1381 */     String nl = txojPropertyManager.propertyManager.getProperty("com.arjuna.ats.txoj.lockstore.allowNestedLocking");
/*      */ 
/* 1383 */     if (nl != null)
/*      */     {
/* 1385 */       if (nl.equals("NO"))
/* 1386 */         nestedLocking = false;
/*      */     }
/*      */   }
/*      */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     com.arjuna.ats.txoj.LockManager
 * JD-Core Version:    0.6.0
 */